/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Vector$;
import breeze.linalg.squaredDistance$;
import breeze.storage.Zero;
import org.apache.spark.ml.SparkMLFunSuite;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.linalg.VectorsSuite$;
import org.apache.spark.ml.linalg.VectorsSuite$$anonfun$1$;
import org.apache.spark.ml.linalg.VectorsSuite$$anonfun$2$;
import org.apache.spark.ml.linalg.VectorsSuite$$anonfun$3$;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001b\taa+Z2u_J\u001c8+^5uK*\u00111\u0001B\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\u0011I!!\u0005\u0003\u0003\u001fM\u0003\u0018M]6N\u0019\u001a+hnU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u0005\u0019\u0011M\u001d:\u0016\u0003i\u00012a\u0007\u0010!\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"!B!se\u0006L\bCA\u000e\"\u0013\t\u0011CD\u0001\u0004E_V\u0014G.\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\u000e\u0002\t\u0005\u0014(\u000f\t\u0005\bM\u0001\u0011\r\u0011\"\u0001(\u0003\u0005qW#\u0001\u0015\u0011\u0005mI\u0013B\u0001\u0016\u001d\u0005\rIe\u000e\u001e\u0005\u0007Y\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u00059\u0004\u0003b\u0002\u0018\u0001\u0005\u0004%\taL\u0001\bS:$\u0017nY3t+\u0005\u0001\u0004cA\u000e\u001fQ!1!\u0007\u0001Q\u0001\nA\n\u0001\"\u001b8eS\u000e,7\u000f\t\u0005\bi\u0001\u0011\r\u0011\"\u0001\u001a\u0003\u00191\u0018\r\\;fg\"1a\u0007\u0001Q\u0001\ni\tqA^1mk\u0016\u001c\b\u0005")
public class VectorsSuite
extends SparkMLFunSuite {
    private final double[] arr = new double[]{0.1, 0.0, 0.3, 0.4};
    private final int n;
    private final int[] indices = new int[]{0, 2, 3};
    private final double[] values = new double[]{0.1, 0.3, 0.4};

    public double[] arr() {
        return this.arr;
    }

    public int n() {
        return this.n;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public VectorsSuite() {
        this.n = 4;
        this.test("dense vector construction with varargs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                DenseVector vec = (DenseVector)Vectors$.MODULE$.dense(this.$outer.arr());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.arr().length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
                double[] $org_scalatest_assert_macro_left2 = vec.values();
                double[] $org_scalatest_assert_macro_right2 = this.$outer.arr();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("dense vector construction from a double array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                DenseVector vec = (DenseVector)Vectors$.MODULE$.dense(this.$outer.arr());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.arr().length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
                double[] $org_scalatest_assert_macro_left2 = vec.values();
                double[] $org_scalatest_assert_macro_right2 = this.$outer.arr();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("sparse vector construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(this.$outer.n(), this.$outer.indices(), this.$outer.values());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
                int[] $org_scalatest_assert_macro_left2 = vec.indices();
                int[] $org_scalatest_assert_macro_right2 = this.$outer.indices();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
                double[] $org_scalatest_assert_macro_left3 = vec.values();
                double[] $org_scalatest_assert_macro_right3 = this.$outer.values();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("sparse vector construction with unordered elements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(this.$outer.n(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(this.$outer.indices()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.$outer.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).reverse()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(vec.indices());
                int[] $org_scalatest_assert_macro_right2 = this.$outer.indices();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(vec.values());
                double[] $org_scalatest_assert_macro_right3 = this.$outer.values();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("sparse vector construction with mismatched indices/values array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final IllegalArgumentException apply() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(4, new int[]{1, 2, 3}, new double[]{3.0, 5.0, 7.0, 9.0});
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(4, new int[]{1, 2, 3}, new double[]{3.0, 5.0});
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("sparse vector construction with too many indices vs size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final IllegalArgumentException apply() {
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(3, new int[]{1, 2, 3, 4}, new double[]{3.0, 5.0, 7.0, 9.0});
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("sparse vector construction with negative indices", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final IllegalArgumentException apply() {
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(3, new int[]{-1, 1}, new double[]{3.0, 5.0});
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("dense to array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                double[] $org_scalatest_assert_macro_right;
                double[] $org_scalatest_assert_macro_left;
                DenseVector vec = (DenseVector)Vectors$.MODULE$.dense(this.$outer.arr());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, ($org_scalatest_assert_macro_left = vec.toArray()) == ($org_scalatest_assert_macro_right = this.$outer.arr()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("dense argmax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                DenseVector vec = (DenseVector)Vectors$.MODULE$.dense((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.argmax()));
                int $org_scalatest_assert_macro_right = -1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                DenseVector vec2 = (DenseVector)Vectors$.MODULE$.dense(this.$outer.arr());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec2.argmax()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
                DenseVector vec3 = (DenseVector)Vectors$.MODULE$.dense(new double[]{-1.0, 0.0, -2.0, 1.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec3.argmax()));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("sparse to array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(this.$outer.n(), this.$outer.indices(), this.$outer.values());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(vec.toArray());
                double[] $org_scalatest_assert_macro_right = this.$outer.arr();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("sparse argmax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(0, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.argmax()));
                int $org_scalatest_assert_macro_right = -1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
                SparseVector vec2 = (SparseVector)Vectors$.MODULE$.sparse(this.$outer.n(), this.$outer.indices(), this.$outer.values());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec2.argmax()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                Vector vec3 = Vectors$.MODULE$.sparse(5, new int[]{2, 3, 4}, new double[]{1.0, 0.0, -0.7});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec3.argmax()));
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
                Vector vec4 = Vectors$.MODULE$.sparse(5, new int[]{2, 3}, new double[]{-1.0, -0.7});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec4.argmax()));
                int $org_scalatest_assert_macro_right4 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
                Vector vec5 = Vectors$.MODULE$.sparse(11, new int[]{0, 3, 10}, new double[]{-1.0, -0.7, 0.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec5.argmax()));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                Vector vec6 = Vectors$.MODULE$.sparse(11, new int[]{0, 1, 2}, new double[]{-1.0, -0.7, 0.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec6.argmax()));
                int $org_scalatest_assert_macro_right6 = 2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
                Vector vec7 = Vectors$.MODULE$.sparse(5, new int[]{0, 1, 3}, new double[]{-1.0, 0.0, -0.7});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec7.argmax()));
                int $org_scalatest_assert_macro_right7 = 1;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
                Vector vec8 = Vectors$.MODULE$.sparse(5, new int[]{1, 2}, new double[]{0.0, -1.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec8.argmax()));
                int $org_scalatest_assert_macro_right8 = 0;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
                SparseVector vec9 = (SparseVector)Vectors$.MODULE$.sparse(100, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec9.argmax()));
                int $org_scalatest_assert_macro_right9 = 0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
                SparseVector vec10 = (SparseVector)Vectors$.MODULE$.sparse(1, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec10.argmax()));
                int $org_scalatest_assert_macro_right10 = 0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("vector equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv1 = Vectors$.MODULE$.dense((double[])this.$outer.arr().clone());
                Vector dv2 = Vectors$.MODULE$.dense((double[])this.$outer.arr().clone());
                Vector sv1 = Vectors$.MODULE$.sparse(this.$outer.n(), (int[])this.$outer.indices().clone(), (double[])this.$outer.values().clone());
                Vector sv2 = Vectors$.MODULE$.sparse(this.$outer.n(), (int[])this.$outer.indices().clone(), (double[])this.$outer.values().clone());
                Seq vectors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{dv1, dv2, sv1, sv2}));
                vectors.foreach((Function1)new Serializable(this, vectors){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final Seq vectors$1;

                    public final void apply(Vector v) {
                        this.vectors$1.foreach((Function1)new Serializable(this, v){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final Vector v$1;

                            public final Assertion apply(Vector u) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(this.v$1);
                                Vector $org_scalatest_assert_macro_right = u;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.hash((Object)this.v$1)));
                                int $org_scalatest_assert_macro_right2 = ScalaRunTime$.MODULE$.hash((Object)u);
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                return this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.v$1 = v$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.vectors$1 = vectors$1;
                    }
                });
                Vector another = Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2, 0.3, 0.4}));
                vectors.foreach((Function1)new Serializable(this, another){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final Vector another$1;

                    public final Assertion apply(Vector v) {
                        Vector $org_scalatest_assert_macro_left = v;
                        Vector $org_scalatest_assert_macro_right = this.another$1;
                        Vector vector = $org_scalatest_assert_macro_left;
                        Vector vector2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, vector != null ? !vector.equals(vector2) : vector2 != null, Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                        int $org_scalatest_assert_macro_left2 = ScalaRunTime$.MODULE$.hash((Object)v);
                        int $org_scalatest_assert_macro_right2 = ScalaRunTime$.MODULE$.hash((Object)this.another$1);
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 != $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.another$1 = another$1;
                    }
                });
            }

            public /* synthetic */ VectorsSuite org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("vectors equals with explicit 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv1 = Vectors$.MODULE$.dense(new double[]{0.0, 0.9, 0.0, 0.8, 0.0});
                Vector sv1 = Vectors$.MODULE$.sparse(5, new int[]{1, 3}, new double[]{0.9, 0.8});
                Vector sv2 = Vectors$.MODULE$.sparse(5, new int[]{0, 1, 2, 3, 4}, new double[]{0.0, 0.9, 0.0, 0.8, 0.0});
                Seq vectors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{dv1, sv1, sv2}));
                vectors.foreach((Function1)new Serializable(this, vectors){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final Seq vectors$2;

                    public final void apply(Vector v) {
                        this.vectors$2.foreach((Function1)new Serializable(this, v){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$3 $outer;
                            private final Vector v$2;

                            public final Assertion apply(Vector u) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(this.v$2);
                                Vector $org_scalatest_assert_macro_right = u;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.hash((Object)this.v$2)));
                                int $org_scalatest_assert_macro_right2 = ScalaRunTime$.MODULE$.hash((Object)u);
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                return this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.v$2 = v$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$2 org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.vectors$2 = vectors$2;
                    }
                });
                Vector another = Vectors$.MODULE$.sparse(5, new int[]{0, 1, 3}, new double[]{0.0, 0.9, 0.2});
                vectors.foreach((Function1)new Serializable(this, another){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final Vector another$2;

                    public final Assertion apply(Vector v) {
                        Vector $org_scalatest_assert_macro_left = v;
                        Vector $org_scalatest_assert_macro_right = this.another$2;
                        Vector vector = $org_scalatest_assert_macro_left;
                        Vector vector2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, vector != null ? !vector.equals(vector2) : vector2 != null, Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
                        int $org_scalatest_assert_macro_left2 = ScalaRunTime$.MODULE$.hash((Object)v);
                        int $org_scalatest_assert_macro_right2 = ScalaRunTime$.MODULE$.hash((Object)this.another$2);
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 != $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.another$2 = another$2;
                    }
                });
            }

            public /* synthetic */ VectorsSuite org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("indexing dense vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                Vector vec = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(0)));
                double $org_scalatest_assert_macro_right = 1.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(3)));
                double $org_scalatest_assert_macro_right2 = 4.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("indexing sparse vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                Vector vec = Vectors$.MODULE$.sparse(7, new int[]{0, 2, 4, 6}, new double[]{1.0, 2.0, 3.0, 4.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(0)));
                double $org_scalatest_assert_macro_right = 1.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(1)));
                double $org_scalatest_assert_macro_right2 = 0.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(2)));
                double $org_scalatest_assert_macro_right3 = 2.0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(3)));
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(6)));
                double $org_scalatest_assert_macro_right5 = 4.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
                Vector vec2 = Vectors$.MODULE$.sparse(8, new int[]{0, 2, 4, 6}, new double[]{1.0, 2.0, 3.0, 4.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec2.apply(6)));
                double $org_scalatest_assert_macro_right6 = 4.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec2.apply(7)));
                double $org_scalatest_assert_macro_right7 = 0.0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("zeros", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Vectors$.MODULE$.zeros(3));
                Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("Vector.copy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                void var1_1;
                void var2_2;
                Vector svCopy;
                Vector sv = Vectors$.MODULE$.sparse(4, new int[]{0, 2}, new double[]{1.0, 2.0});
                Tuple2 tuple2 = new Tuple2((Object)sv, (Object)(svCopy = sv.copy()));
                if (tuple2 != null) {
                    Vector sv2 = (Vector)tuple2._1();
                    Vector svCopy2 = (Vector)tuple2._2();
                    if (sv2 instanceof SparseVector) {
                        SparseVector sparseVector = (SparseVector)sv2;
                        if (svCopy2 instanceof SparseVector) {
                            void var24_24;
                            void var25_25;
                            SparseVector sparseVector2 = (SparseVector)svCopy2;
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sparseVector.size()));
                            int $org_scalatest_assert_macro_right = sparseVector2.size();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(sparseVector.indices());
                            int[] $org_scalatest_assert_macro_right2 = sparseVector2.indices();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(sparseVector.values());
                            double[] $org_scalatest_assert_macro_right3 = sparseVector2.values();
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
                            int[] $org_scalatest_assert_macro_left4 = sparseVector.indices();
                            int[] $org_scalatest_assert_macro_right4 = sparseVector2.indices();
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "eq", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
                            double[] $org_scalatest_assert_macro_left5 = sparseVector.values();
                            double[] $org_scalatest_assert_macro_right5 = sparseVector2.values();
                            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "eq", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                            Assertion assertion = this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
                            Vector dv = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0}));
                            Vector dvCopy = dv.copy();
                            Tuple2 tuple22 = new Tuple2((Object)dv, (Object)dvCopy);
                            if (tuple22 != null) {
                                Vector dv2 = (Vector)tuple22._1();
                                Vector dvCopy2 = (Vector)tuple22._2();
                                if (dv2 instanceof DenseVector) {
                                    DenseVector denseVector = (DenseVector)dv2;
                                    if (dvCopy2 instanceof DenseVector) {
                                        DenseVector denseVector2 = (DenseVector)dvCopy2;
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)denseVector.size()));
                                        int $org_scalatest_assert_macro_right6 = denseVector2.size();
                                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(denseVector.values());
                                        double[] $org_scalatest_assert_macro_right7 = denseVector2.values();
                                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
                                        double[] $org_scalatest_assert_macro_left8 = denseVector.values();
                                        double[] $org_scalatest_assert_macro_right8 = denseVector2.values();
                                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "eq", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        Assertion assertion2 = this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
                                        return assertion2;
                                    }
                                }
                            }
                            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"copy returned ", " on ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var25_25.getClass(), var24_24.getClass()})));
                        }
                    }
                }
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"copy returned ", " on ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2.getClass(), var1_1.getClass()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("fromBreeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                DenseMatrix x = DenseMatrix$.MODULE$.zeros$mDc$sp(10, 10, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                Vector v = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)x.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)0), DenseMatrix$.MODULE$.canSliceCol()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)v.size()));
                int $org_scalatest_assert_macro_right = x.rows();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("sqdist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random random = new Random();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 1000).by(100).foreach((Function1)new Serializable(this, random){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    public final Random random$1;

                    public final Assertion apply(int m) {
                        int nnz = this.random$1.nextInt(m);
                        int[] indices1 = (int[])((TraversableOnce)((SeqLike)((IterableLike)this.random$1.shuffle((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), m - 1), IndexedSeq$.MODULE$.canBuildFrom())).slice(0, nnz)).sorted((Ordering)Ordering.Int$.MODULE$)).toArray(ClassTag$.MODULE$.Int());
                        double[] values1 = (double[])Array$.MODULE$.fill(nnz, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$5 $outer;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.$outer.random$1.nextDouble();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ClassTag$.MODULE$.Double());
                        Vector sparseVector1 = Vectors$.MODULE$.sparse(m, indices1, values1);
                        int[] indices2 = (int[])((TraversableOnce)((SeqLike)((IterableLike)this.random$1.shuffle((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), m - 1), IndexedSeq$.MODULE$.canBuildFrom())).slice(0, nnz)).sorted((Ordering)Ordering.Int$.MODULE$)).toArray(ClassTag$.MODULE$.Int());
                        double[] values2 = (double[])Array$.MODULE$.fill(nnz, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$5 $outer;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.$outer.random$1.nextDouble();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ClassTag$.MODULE$.Double());
                        Vector sparseVector2 = Vectors$.MODULE$.sparse(m, indices2, values2);
                        Vector denseVector1 = Vectors$.MODULE$.dense(sparseVector1.toArray());
                        Vector denseVector2 = Vectors$.MODULE$.dense(sparseVector2.toArray());
                        double squaredDist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)sparseVector1.asBreeze(), (Object)sparseVector2.asBreeze(), squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)Vector$.MODULE$.zipValuesImpl_V_V_Double())));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.sqdist(sparseVector1, sparseVector2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.sqdist(sparseVector1, sparseVector2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.sqdist(denseVector1, sparseVector2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.sqdist(denseVector1, sparseVector2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.sqdist(denseVector1, denseVector2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.sqdist(denseVector1, denseVector2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.random$1 = random$1;
                    }
                });
            }

            public /* synthetic */ VectorsSuite org$apache$spark$ml$linalg$VectorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("foreachActive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.2, 3.1, 0.0}));
                Vector sv = Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.2), new Tuple2.mcID.sp(2, 3.1), new Tuple2.mcID.sp(3, 0.0)})));
                Map dvMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                dv.foreachActive((Function2)new Serializable(this, dvMap){
                    public static final long serialVersionUID = 0L;
                    private final Map dvMap$1;

                    public final void apply(int index, double value) {
                        this.apply$mcVID$sp(index, value);
                    }

                    public void apply$mcVID$sp(int index, double value) {
                        this.dvMap$1.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value));
                    }
                    {
                        this.dvMap$1 = dvMap$1;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dvMap.size()));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(dvMap.get((Object)BoxesRunTime.boxToInteger((int)0)));
                Some $org_scalatest_assert_macro_right2 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(dvMap.get((Object)BoxesRunTime.boxToInteger((int)1)));
                Some $org_scalatest_assert_macro_right3 = new Some((Object)BoxesRunTime.boxToDouble((double)1.2));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(dvMap.get((Object)BoxesRunTime.boxToInteger((int)2)));
                Some $org_scalatest_assert_macro_right4 = new Some((Object)BoxesRunTime.boxToDouble((double)3.1));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(dvMap.get((Object)BoxesRunTime.boxToInteger((int)3)));
                Some $org_scalatest_assert_macro_right5 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
                Map svMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                sv.foreachActive((Function2)new Serializable(this, svMap){
                    public static final long serialVersionUID = 0L;
                    private final Map svMap$1;

                    public final void apply(int index, double value) {
                        this.apply$mcVID$sp(index, value);
                    }

                    public void apply$mcVID$sp(int index, double value) {
                        this.svMap$1.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value));
                    }
                    {
                        this.svMap$1 = svMap$1;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)svMap.size()));
                int $org_scalatest_assert_macro_right6 = 3;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(svMap.get((Object)BoxesRunTime.boxToInteger((int)1)));
                Some $org_scalatest_assert_macro_right7 = new Some((Object)BoxesRunTime.boxToDouble((double)1.2));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(svMap.get((Object)BoxesRunTime.boxToInteger((int)2)));
                Some $org_scalatest_assert_macro_right8 = new Some((Object)BoxesRunTime.boxToDouble((double)3.1));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(svMap.get((Object)BoxesRunTime.boxToInteger((int)3)));
                Some $org_scalatest_assert_macro_right9 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        this.test("vector p-norm", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.2, 3.1, 0.0, -4.5, 1.9}));
                Vector sv = Vectors$.MODULE$.sparse(6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, -1.2), new Tuple2.mcID.sp(2, 3.1), new Tuple2.mcID.sp(3, 0.0), new Tuple2.mcID.sp(4, -4.5), new Tuple2.mcID.sp(5, 1.9)})));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, 1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(dv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + scala.math.package$.MODULE$.abs(v);
                    }
                }))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, 1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(dv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.abs(v))))).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, 1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + scala.math.package$.MODULE$.abs(v);
                    }
                }))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, 1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(sv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.abs(v))))).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(dv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + v * v;
                    }
                })))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.sqrt(scala.this.Predef.doubleArrayOps(dv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(v.*(v)))))).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + v * v;
                    }
                })))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.sqrt(scala.this.Predef.doubleArrayOps(sv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(v.*(v)))))).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, Double.POSITIVE_INFINITY)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(dv.toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.abs(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, Infinity)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(scala.this.Predef.doubleArrayOps(dv.toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double]((ClassTag.Double: scala.reflect.ClassTag[Double])))).max[Double](math.this.Ordering.Double)).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, Double.POSITIVE_INFINITY)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(sv.toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.abs(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$))).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, Infinity)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(scala.this.Predef.doubleArrayOps(sv.toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double]((ClassTag.Double: scala.reflect.ClassTag[Double])))).max[Double](math.this.Ordering.Double)).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, 3.7)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(dv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + scala.math.package$.MODULE$.pow(scala.math.package$.MODULE$.abs(v), 3.7);
                    }
                })), 0.27027027027027023)).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, 3.7)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.pow(scala.this.Predef.doubleArrayOps(dv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.pow(scala.math.`package`.abs(v), 3.7)))), 0.27027027027027023)).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, 3.7)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + scala.math.package$.MODULE$.pow(scala.math.package$.MODULE$.abs(v), 3.7);
                    }
                })), 0.27027027027027023)).relTol(1.0E-8)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, 3.7)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.pow(scala.this.Predef.doubleArrayOps(sv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.pow(scala.math.`package`.abs(v), 3.7)))), 0.27027027027027023)).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("Vector numActive and numNonzeros", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 0.0}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv.numActives()));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv.numNonzeros()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
                Vector sv = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{0.0, 2.0, 3.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv.numActives()));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv.numNonzeros()));
                int $org_scalatest_assert_macro_right4 = 2;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        this.test("Vector toSparse and toDense", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                Vector dv0 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 0.0}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(dv0.toDense());
                Vector $org_scalatest_assert_macro_right = dv0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
                SparseVector dv0s = dv0.toSparse();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv0s.numActives()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(dv0s);
                Vector $org_scalatest_assert_macro_right3 = dv0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(dv0.toSparseWithSize(dv0.numNonzeros()));
                Vector $org_scalatest_assert_macro_right4 = dv0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
                SparseVector dv0s2 = dv0.toSparseWithSize(dv0.numNonzeros());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv0s2.numActives()));
                int $org_scalatest_assert_macro_right5 = 2;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(dv0s2);
                SparseVector $org_scalatest_assert_macro_right6 = dv0s;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
                Vector sv0 = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{0.0, 2.0, 3.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(sv0.toDense());
                Vector $org_scalatest_assert_macro_right7 = sv0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
                SparseVector sv0s = sv0.toSparse();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv0s.numActives()));
                int $org_scalatest_assert_macro_right8 = 2;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(sv0s);
                Vector $org_scalatest_assert_macro_right9 = sv0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(sv0.toSparseWithSize(sv0.numNonzeros()));
                Vector $org_scalatest_assert_macro_right10 = sv0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
                SparseVector sv0s2 = sv0.toSparseWithSize(sv0.numNonzeros());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv0s2.numActives()));
                int $org_scalatest_assert_macro_right11 = 2;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(sv0s2);
                SparseVector $org_scalatest_assert_macro_right12 = sv0s;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("Vector.compressed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                Vector dv0 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 0.0}));
                DenseVector dv0c = (DenseVector)dv0.compressed();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(dv0c);
                Vector $org_scalatest_assert_macro_right = dv0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
                Vector dv1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 0.0, 0.0}));
                SparseVector dv1c = (SparseVector)dv1.compressed();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(dv1);
                SparseVector $org_scalatest_assert_macro_right2 = dv1c;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv1c.numActives()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
                Vector sv0 = Vectors$.MODULE$.sparse(4, new int[]{1, 2}, new double[]{2.0, 0.0});
                SparseVector sv0c = (SparseVector)sv0.compressed();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(sv0);
                SparseVector $org_scalatest_assert_macro_right4 = sv0c;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv0c.numActives()));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
                Vector sv1 = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{1.0, 2.0, 3.0});
                DenseVector sv1c = (DenseVector)sv1.compressed();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(sv1);
                DenseVector $org_scalatest_assert_macro_right6 = sv1c;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
                Vector sv2 = Vectors$.MODULE$.sparse(Integer.MAX_VALUE, new int[]{0}, new double[]{3.4});
                SparseVector sv2c = (SparseVector)sv2.compressed();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(sv2c);
                Vector $org_scalatest_assert_macro_right7 = sv2;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv2c.numActives()));
                int $org_scalatest_assert_macro_right8 = 1;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        this.test("SparseVector.slice", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final Assertion apply() {
                SparseVector v = new SparseVector(5, new int[]{1, 2, 4}, new double[]{1.1, 2.2, 4.4});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(v.slice(new int[]{0, 2}));
                SparseVector $org_scalatest_assert_macro_right = new SparseVector(2, new int[]{1}, new double[]{2.2});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(v.slice(new int[]{2, 0}));
                SparseVector $org_scalatest_assert_macro_right2 = new SparseVector(2, new int[]{0}, new double[]{2.2});
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(v.slice(new int[]{2, 0, 3, 4}));
                SparseVector $org_scalatest_assert_macro_right3 = new SparseVector(4, new int[]{0, 3}, new double[]{2.2, 4.4});
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.test("sparse vector only support non-negative length", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final IllegalArgumentException apply() {
                Vector v1 = Vectors$.MODULE$.sparse(0, Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray());
                Vector v2 = Vectors$.MODULE$.sparse(0, (Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)v1.size()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)v2.size()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(-1, new int[]{1}, new double[]{2.0});
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(-1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 2.0)}));
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("VectorsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
    }
}

