/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\"\r\u0001\u0003\u0006\u0004%\tE\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003:\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000bA\u0003A\u0011A)\t\u000be\u0003A\u0011\t.\t\u000b\u0019\u0004A\u0011\t%\t\u000b\u001d\u0004A\u0011\t5\t\r%\u0004A\u0011I\u0010k\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015)\b\u0001\"\u0011w\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u00111\u0003\u0001\u0005B\u0005U\u0001BBA\f\u0001\u0011\u0005#\u0007\u0003\u0004\u0002\u001a\u0001!\tE\r\u0005\t\u00037\u0001A\u0011I\u000e\u0002\u001e!1\u00111\u0005\u0001\u0005BIB\u0001\"!\n\u0001\t\u0003y\u0012qE\u0004\b\u0003_Y\u0002\u0012AA\u0019\r\u0019Q2\u0004#\u0001\u00024!1\u0001K\u0006C\u0001\u0003wAq!!\u0010\u0017\t\u0003\ty\u0004C\u0005\u0002TY\t\t\u0011\"\u0003\u0002V\ta1\u000b]1sg\u00164Vm\u0019;pe*\u0011A$H\u0001\u0007Y&t\u0017\r\\4\u000b\u0005yy\u0012AA7m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/_5\t1$\u0003\u000217\t1a+Z2u_J\fAa]5{KV\t1\u0007\u0005\u0002)i%\u0011Q'\u000b\u0002\u0004\u0013:$\u0018!B:ju\u0016\u0004\u0013aB5oI&\u001cWm]\u000b\u0002sA\u0019\u0001FO\u001a\n\u0005mJ#!B!se\u0006L\bfA\u0002>\u0007B\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iH\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\"@\u0005\u0015\u0019\u0016N\\2fC\u0005!\u0015!\u0002\u001a/a9\u0002\u0014\u0001C5oI&\u001cWm\u001d\u0011)\u0007\u0011i4)\u0001\u0004wC2,Xm]\u000b\u0002\u0013B\u0019\u0001F\u000f&\u0011\u0005!Z\u0015B\u0001'*\u0005\u0019!u.\u001e2mK\"\u001aQ!P\"\u0002\u000fY\fG.^3tA!\u001aa!P\"\u0002\rqJg.\u001b;?)\u0011\u00116\u000b\u0016,\u0011\u00059\u0002\u0001\"B\u0019\b\u0001\u0004\u0019\u0004\"B\u001c\b\u0001\u0004I\u0004f\u0001+>\u0007\")qi\u0002a\u0001\u0013\"\u001aa+P\")\u0007\u001di4)\u0001\u0005u_N#(/\u001b8h)\u0005Y\u0006C\u0001/d\u001d\ti\u0016\r\u0005\u0002_S5\tqL\u0003\u0002aK\u00051AH]8pizJ!AY\u0015\u0002\rA\u0013X\rZ3g\u0013\t!WM\u0001\u0004TiJLgn\u001a\u0006\u0003E&\nq\u0001^8BeJ\f\u00170\u0001\u0003d_BLX#\u0001*\u0002\u0011\u0005\u001c(I]3fu\u0016,\u0012a\u001b\t\u0004YBTU\"A7\u000b\u0005qq'\"A8\u0002\r\t\u0014X-\u001a>f\u0013\t\u0001T.A\u0003baBd\u0017\u0010\u0006\u0002Kg\")A\u000f\u0004a\u0001g\u0005\t\u0011.A\u0007g_J,\u0017m\u00195BGRLg/\u001a\u000b\u0003oj\u0004\"\u0001\u000b=\n\u0005eL#\u0001B+oSRDQa_\u0007A\u0002q\f\u0011A\u001a\t\u0006Qu\u001c$j^\u0005\u0003}&\u0012\u0011BR;oGRLwN\u001c\u001a\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019!!\u0003\u0011\u0007!\n)!C\u0002\u0002\b%\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\f9\u0001\r!!\u0004\u0002\u000b=$\b.\u001a:\u0011\u0007!\ny!C\u0002\u0002\u0012%\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#A\u001a\u0002\u00159,X.Q2uSZ,7/A\u0006ok6tuN\u001c>fe>\u001c\u0018\u0001\u0005;p'B\f'o]3XSRD7+\u001b>f)\r\u0011\u0016q\u0004\u0005\u0007\u0003C\u0011\u0002\u0019A\u001a\u0002\u00079t'0\u0001\u0004be\u001el\u0017\r_\u0001\u0006g2L7-\u001a\u000b\u0004%\u0006%\u0002BBA\u0016)\u0001\u0007\u0011(A\btK2,7\r^3e\u0013:$\u0017nY3tQ\r\u0001QhQ\u0001\r'B\f'o]3WK\u000e$xN\u001d\t\u0003]Y\u0019BAF\u0014\u00026A\u0019\u0001&a\u000e\n\u0007\u0005e\u0012F\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u00022\u00059QO\\1qa2LH\u0003BA!\u0003\u001b\u0002R\u0001KA\"\u0003\u000fJ1!!\u0012*\u0005\u0019y\u0005\u000f^5p]B1\u0001&!\u00134s%K1!a\u0013*\u0005\u0019!V\u000f\u001d7fg!1\u0011q\n\rA\u0002I\u000b!a\u001d<)\u0007ai4)A\u0006sK\u0006$'+Z:pYZ,GCAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\nA\u0001\\1oO*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002f\u0005m#AB(cU\u0016\u001cG\u000fK\u0002\u0017{\rC3!F\u001fD\u0001")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public SparseVector toSparse() {
        return Vector.toSparse$(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector.toDense$(this);
    }

    @Override
    public Vector compressed() {
        return Vector.compressed$(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringBuilder(4).append("(").append(this.size()).append(",").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).mkString("[", ",", "]")).append(",").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).mkString("[", ",", "]")).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public double apply(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException(new StringBuilder(26).append("Index ").append(i).append(" out of bounds [0, ").append(this.size()).append(")").toString());
        }
        int j = Arrays.binarySearch(this.indices(), i);
        return j < 0 ? 0.0 : this.values()[j];
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        return Vector.equals$(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> {
            block0: {
                if (v == 0.0) break block0;
                ++nnz$3.elem;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        SparseVector sparseVector;
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(i, v) -> {
                block0: {
                    if (v == 0.0) break block0;
                    ii$2[k$2.elem] = i;
                    vv$2[k$2.elem] = v;
                    ++k$2.elem;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else if (this.numActives() == 0) {
            n = 0;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedIndices)).flatMap((Function1 & Serializable & scala.Serializable)origIdx -> SparseVector.$anonfun$slice$1(this, currentIdx, BoxesRunTime.unboxToInt((Object)origIdx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] sliceInds = (int[])tuple2._1();
        double[] sliceVals = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
        Tuple2 tuple23 = tuple22;
        int[] sliceInds2 = (int[])tuple23._1();
        double[] sliceVals2 = (double[])tuple23._2();
        return new SparseVector(selectedIndices.length, (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sliceInds2)).toArray(ClassTag$.MODULE$.Int()), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sliceVals2)).toArray(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ Iterator $anonfun$slice$1(SparseVector $this, IntRef currentIdx$1, int origIdx) {
        int iIdx = Arrays.binarySearch($this.indices(), origIdx);
        Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(currentIdx$1.elem, $this.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        ++currentIdx$1.elem;
        return i_v;
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0 & Serializable & scala.Serializable)() -> "The size of the requested sparse vector must be no less than 0.");
        Predef$.MODULE$.require(indices.length == values.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Sparse vectors require that the dimension of the").append(new StringBuilder(70).append(" indices match the dimension of the values. You provided ").append(this.indices().length).append(" indices and ").toString()).append(new StringBuilder(9).append(" ").append(this.values().length).append(" values.").toString()).toString());
        Predef$.MODULE$.require(indices.length <= size, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("You provided ").append(this.indices().length).append(" indices and values, ").append(new StringBuilder(41).append("which exceeds the specified vector size ").append(this.size()).append(".").toString()).toString());
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).nonEmpty()) {
            Predef$.MODULE$.require(indices[0] >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Found negative index: ").append(this.indices()[0]).append(".").toString());
        }
        IntRef prev = IntRef.create((int)-1);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Predef$.MODULE$.require(prev$1.elem < i, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Index ").append(i).append(" follows ").append(prev$1.elem).append(" and is not strictly increasing").toString());
            prev$1.elem = i;
        });
        Predef$.MODULE$.require(prev.elem < size, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Index ").append(prev$1.elem).append(" out of bounds for vector of size ").append(this.size()).toString());
    }
}

