/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD$;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMWithSGD$;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LassoWithSGD$;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001=\u0011a\u0002U=uQ>tW\n\u0014'jE\u0006\u0003\u0016J\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)Q\u000e\u001c7jE*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003#]I!\u0001\u0007\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"B\u0010\u0001\t\u0013\u0001\u0013a\u00063fg\u0016\u0014\u0018.\u00197ju\u0016$u.\u001e2mKZ+7\r^8s)\t\ts\u0005E\u0002\u0012E\u0011J!a\t\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0005E)\u0013B\u0001\u0014\u0013\u0005\u0019!u.\u001e2mK\")\u0001F\ba\u0001S\u0005)!-\u001f;fgB\u0019\u0011C\t\u0016\u0011\u0005EY\u0013B\u0001\u0017\u0013\u0005\u0011\u0011\u0015\u0010^3\t\u000b9\u0002A\u0011B\u0018\u0002+M,'/[1mSj,Gi\\;cY\u00164Vm\u0019;peR\u0011\u0011\u0006\r\u0005\u0006c5\u0002\r!I\u0001\bI>,(\r\\3t\u0011\u0015\u0019\u0004\u0001\"\u00035\u0003]!Wm]3sS\u0006d\u0017N_3E_V\u0014G.Z'biJL\u0007\u0010\u0006\u00026mA\u0019\u0011CI\u0011\t\u000b!\u0012\u0004\u0019A\u0015\t\u000ba\u0002A\u0011B\u001d\u0002+M,'/[1mSj,Gi\\;cY\u0016l\u0015\r\u001e:jqR\u0011\u0011F\u000f\u0005\u0006c]\u0002\r!\u000e\u0005\u0006y\u0001!I!P\u0001\u0015iJ\f\u0017N\u001c*fOJ,7o]5p]6{G-\u001a7\u0015\tyb\u0005\r\u001b\t\u0004\u007f\u00113U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001B;uS2T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\nQA*\u001b8lK\u0012d\u0015n\u001d;\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%\u0013\u0015\u0001\u00027b]\u001eL!a\u0013%\u0003\r=\u0013'.Z2u\u0011\u0015i5\b1\u0001O\u0003%!(/Y5o\rVt7\rE\u0003\u0012\u001fF\u000bS,\u0003\u0002Q%\tIa)\u001e8di&|gN\r\t\u0004%V;V\"A*\u000b\u0005QC\u0011a\u0001:eI&\u0011ak\u0015\u0002\u0004%\u0012#\u0005C\u0001-\\\u001b\u0005I&B\u0001.\u0007\u0003)\u0011Xm\u001a:fgNLwN\\\u0005\u00039f\u0013A\u0002T1cK2,G\rU8j]R\u0004\"\u0001\u00170\n\u0005}K&AF$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be6{G-\u001a7\t\u000b\u0005\\\u0004\u0019\u00012\u0002\u001b\u0011\fG/\u0019\"zi\u0016\u001c(J\u0015#E!\r\u0019g-K\u0007\u0002I*\u00111)\u001a\u0006\u0003\u000b!I!a\u001a3\u0003\u000f)\u000bg/\u0019*E\t\")\u0011n\u000fa\u0001S\u0005\u0001\u0012N\\5uS\u0006dw+Z5hQR\u001c()\u0011\u0005\u0006W\u0002!\t\u0001\\\u0001\"iJ\f\u0017N\u001c'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\\,ji\"\u001cv\t\u0012\u000b\u0007[B\fh\u000f\u001f>\u0011\u0007}rg)\u0003\u0002p\u0001\n!A*[:u\u0011\u0015\t'\u000e1\u0001c\u0011\u0015\u0011(\u000e1\u0001t\u00035qW/\\%uKJ\fG/[8ogB\u0011\u0011\u0003^\u0005\u0003kJ\u00111!\u00138u\u0011\u00159(\u000e1\u0001%\u0003!\u0019H/\u001a9TSj,\u0007\"B=k\u0001\u0004!\u0013!E7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\")\u0011N\u001ba\u0001S!)A\u0010\u0001C\u0001{\u00061BO]1j]2\u000b7o]8N_\u0012,GnV5uQN;E\tF\u0006n}~\f\t!a\u0001\u0002\b\u0005%\u0001\"B1|\u0001\u0004\u0011\u0007\"\u0002:|\u0001\u0004\u0019\b\"B<|\u0001\u0004!\u0003BBA\u0003w\u0002\u0007A%\u0001\u0005sK\u001e\u0004\u0016M]1n\u0011\u0015I8\u00101\u0001%\u0011\u0015I7\u00101\u0001*\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\ta\u0003\u001e:bS:\u0014\u0016\u000eZ4f\u001b>$W\r\\,ji\"\u001cv\t\u0012\u000b\u000e[\u0006E\u00111CA\u000b\u0003/\tI\"a\u0007\t\r\u0005\fY\u00011\u0001c\u0011\u0019\u0011\u00181\u0002a\u0001g\"1q/a\u0003A\u0002\u0011Bq!!\u0002\u0002\f\u0001\u0007A\u0005\u0003\u0004z\u0003\u0017\u0001\r\u0001\n\u0005\u0007S\u0006-\u0001\u0019A\u0015\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u0005!BO]1j]N3V*T8eK2<\u0016\u000e\u001e5T\u000f\u0012#R\"\\A\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0002BB1\u0002\u001e\u0001\u0007!\r\u0003\u0004s\u0003;\u0001\ra\u001d\u0005\u0007o\u0006u\u0001\u0019\u0001\u0013\t\u000f\u0005\u0015\u0011Q\u0004a\u0001I!1\u00110!\bA\u0002\u0011Ba![A\u000f\u0001\u0004I\u0003bBA\u0019\u0001\u0011\u0005\u00111G\u0001$iJ\f\u0017N\u001c'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m/&$\bnU$E)-i\u0017QGA\u001c\u0003s\tY$!\u0010\t\r\u0005\fy\u00031\u0001c\u0011\u0019\u0011\u0018q\u0006a\u0001g\"1q/a\fA\u0002\u0011Ba!_A\u0018\u0001\u0004!\u0003BB5\u00020\u0001\u0007\u0011\u0006C\u0004\u0002B\u0001!\t!a\u0011\u0002\u001fQ\u0014\u0018-\u001b8OC&4XMQ1zKN$R!\\A#\u0003\u000fBa!YA \u0001\u0004\u0011\u0007bBA%\u0003\u007f\u0001\r\u0001J\u0001\u0007Y\u0006l'\rZ1\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u0005\u0001BO]1j].kU-\u00198t\u001b>$W\r\u001c\u000b\f[\u0006E\u00131KA,\u00037\ny\u0006\u0003\u0004b\u0003\u0017\u0002\rA\u0019\u0005\b\u0003+\nY\u00051\u0001t\u0003\u0005Y\u0007bBA-\u0003\u0017\u0002\ra]\u0001\u000e[\u0006D\u0018\n^3sCRLwN\\:\t\u000f\u0005u\u00131\na\u0001g\u0006!!/\u001e8t\u0011!\t\t'a\u0013A\u0002\u0005\r\u0014AE5oSRL\u0017\r\\5{CRLwN\\'pI\u0016\u0004B!!\u001a\u0002l9\u0019\u0011#a\u001a\n\u0007\u0005%$#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\nyG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S\u0012\u0002bBA:\u0001\u0011%\u0011QO\u0001\rk:\u0004\u0018mY6SCRLgn\u001a\u000b\u0005\u0003o\n\u0019\t\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tiHB\u0001\u000fe\u0016\u001cw.\\7f]\u0012\fG/[8o\u0013\u0011\t\t)a\u001f\u0003\rI\u000bG/\u001b8h\u0011\u001d\t))!\u001dA\u0002%\n1B]1uS:<')\u001f;fg\"A\u0011\u0011\u0012\u0001\u0005\u0002!\tY)A\u0006v]B\f7m\u001b+va2,G\u0003BAG\u0003'\u0003R!EAHgNL1!!%\u0013\u0005\u0019!V\u000f\u001d7fe!9\u0011QSAD\u0001\u0004I\u0013A\u0003;va2,')\u001f;fg\"A\u0011\u0011\u0014\u0001\u0005\u0002!\tY*A\btKJL\u0017\r\\5{KJ\u000bG/\u001b8h)\rI\u0013Q\u0014\u0005\t\u0003?\u000b9\n1\u0001\u0002x\u0005!!/\u0019;f\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003K\u000bQ\u0002\u001e:bS:\fEjU'pI\u0016dG\u0003DAT\u0003[\u000b\t,!.\u0002:\u0006m\u0006\u0003BA=\u0003SKA!a+\u0002|\tAR*\u0019;sSb4\u0015m\u0019;pe&T\u0018\r^5p]6{G-\u001a7\t\u000f\u0005=\u0016\u0011\u0015a\u0001E\u0006\u0001\"/\u0019;j]\u001e\u001c()\u001f;fg*\u0013F\t\u0012\u0005\b\u0003g\u000b\t\u000b1\u0001t\u0003\u0011\u0011\u0018M\\6\t\u000f\u0005]\u0016\u0011\u0015a\u0001g\u0006Q\u0011\u000e^3sCRLwN\\:\t\u000f\u0005%\u0013\u0011\u0015a\u0001I!9\u0011QXAQ\u0001\u0004\u0019\u0018A\u00022m_\u000e\\7\u000fC\u0004\u0002B\u0002!\t!a1\u0002+Q\u0014\u0018-\u001b8J[Bd\u0017nY5u\u00032\u001bVj\u001c3fYRq\u0011qUAc\u0003\u000f\fI-a3\u0002N\u0006=\u0007bBAX\u0003\u007f\u0003\rA\u0019\u0005\b\u0003g\u000by\f1\u0001t\u0011\u001d\t9,a0A\u0002MDq!!\u0013\u0002@\u0002\u0007A\u0005C\u0004\u0002>\u0006}\u0006\u0019A:\t\u000f\u0005E\u0017q\u0018a\u0001I\u0005)\u0011\r\u001c9iC\u0002")
public class PythonMLLibAPI
implements Serializable {
    public double[] org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector(byte[] bytes) {
        int packetLength = bytes.length;
        if (packetLength < 16) {
            throw new IllegalArgumentException("Byte array too short.");
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        long magic = bb.getLong();
        if (magic != 1L) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Magic ").append((Object)BoxesRunTime.boxToLong((long)magic)).append((Object)" is wrong.").toString());
        }
        long length = bb.getLong();
        if ((long)packetLength != 16L + 8L * length) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Length ").append((Object)BoxesRunTime.boxToLong((long)length)).append((Object)" is wrong.").toString());
        }
        DoubleBuffer db = bb.asDoubleBuffer();
        double[] ans = new double[(int)length];
        db.get(ans);
        return ans;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] serializeDoubleVector(double[] doubles) {
        void var3_3;
        int len = doubles.length;
        byte[] bytes = new byte[16 + 8 * len];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.putLong(1L);
        bb.putLong(len);
        DoubleBuffer db = bb.asDoubleBuffer();
        db.put(doubles);
        return var3_3;
    }

    private double[][] deserializeDoubleMatrix(byte[] bytes) {
        long cols;
        int packetLength = bytes.length;
        if (packetLength < 24) {
            throw new IllegalArgumentException("Byte array too short.");
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        long magic = bb.getLong();
        if (magic != 2L) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Magic ").append((Object)BoxesRunTime.boxToLong((long)magic)).append((Object)" is wrong.").toString());
        }
        long rows = bb.getLong();
        if ((long)packetLength != 24L + 8L * rows * (cols = bb.getLong())) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Size ").append((Object)BoxesRunTime.boxToLong((long)rows)).append((Object)"x").append((Object)BoxesRunTime.boxToLong((long)cols)).append((Object)" is wrong.").toString());
        }
        DoubleBuffer db = bb.asDoubleBuffer();
        double[][] ans = new double[(int)rows][];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)rows).foreach((Function1)new Serializable(this, cols, db, ans){
            public static final long serialVersionUID = 0L;
            private final long cols$1;
            private final DoubleBuffer db$1;
            private final double[][] ans$1;

            public final DoubleBuffer apply(int i) {
                this.ans$1[i] = new double[(int)this.cols$1];
                return this.db$1.get(this.ans$1[i]);
            }
            {
                this.cols$1 = cols$1;
                this.db$1 = db$1;
                this.ans$1 = ans$1;
            }
        });
        return ans;
    }

    private byte[] serializeDoubleMatrix(double[][] doubles) {
        int rows = doubles.length;
        int cols = 0;
        if (rows > 0) {
            cols = doubles[0].length;
        }
        byte[] bytes = new byte[24 + 8 * rows * cols];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.putLong(2L);
        bb.putLong(rows);
        bb.putLong(cols);
        DoubleBuffer db = bb.asDoubleBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rows).foreach((Function1)new Serializable(this, doubles, db){
            public static final long serialVersionUID = 0L;
            private final double[][] doubles$1;
            private final DoubleBuffer db$2;

            public final DoubleBuffer apply(int i) {
                return this.db$2.put(this.doubles$1[i]);
            }
            {
                this.doubles$1 = doubles$1;
                this.db$2 = db$2;
            }
        });
        return bytes;
    }

    private LinkedList<Object> trainRegressionModel(Function2<RDD<LabeledPoint>, double[], GeneralizedLinearModel> trainFunc, JavaRDD<byte[]> dataBytesJRDD, byte[] initialWeightsBA) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final LabeledPoint apply(byte[] xBytes) {
                double[] x = this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector(xBytes);
                return new LabeledPoint(x[0], (double[])Predef$.MODULE$.doubleArrayOps(x).slice(1, x.length));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        double[] initialWeights = this.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector(initialWeightsBA);
        GeneralizedLinearModel model = (GeneralizedLinearModel)trainFunc.apply((Object)data, (Object)initialWeights);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(this.serializeDoubleVector(model.weights()));
        ret.add(Predef$.MODULE$.double2Double(model.intercept()));
        return ret;
    }

    public List<Object> trainLinearRegressionModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, double[], GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$1;
            private final double stepSize$1;
            private final double miniBatchFraction$1;

            public final LinearRegressionModel apply(RDD<LabeledPoint> data, double[] initialWeights) {
                return LinearRegressionWithSGD$.MODULE$.train(data, this.numIterations$1, this.stepSize$1, this.miniBatchFraction$1, initialWeights);
            }
            {
                this.numIterations$1 = numIterations$1;
                this.stepSize$1 = stepSize$1;
                this.miniBatchFraction$1 = miniBatchFraction$1;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainLassoModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double regParam, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, double[], GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, regParam, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$2;
            private final double stepSize$2;
            private final double regParam$1;
            private final double miniBatchFraction$2;

            public final LassoModel apply(RDD<LabeledPoint> data, double[] initialWeights) {
                return LassoWithSGD$.MODULE$.train(data, this.numIterations$2, this.stepSize$2, this.regParam$1, this.miniBatchFraction$2, initialWeights);
            }
            {
                this.numIterations$2 = numIterations$2;
                this.stepSize$2 = stepSize$2;
                this.regParam$1 = regParam$1;
                this.miniBatchFraction$2 = miniBatchFraction$2;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainRidgeModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double regParam, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, double[], GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, regParam, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$3;
            private final double stepSize$3;
            private final double regParam$2;
            private final double miniBatchFraction$3;

            public final RidgeRegressionModel apply(RDD<LabeledPoint> data, double[] initialWeights) {
                return RidgeRegressionWithSGD$.MODULE$.train(data, this.numIterations$3, this.stepSize$3, this.regParam$2, this.miniBatchFraction$3, initialWeights);
            }
            {
                this.numIterations$3 = numIterations$3;
                this.stepSize$3 = stepSize$3;
                this.regParam$2 = regParam$2;
                this.miniBatchFraction$3 = miniBatchFraction$3;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainSVMModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double regParam, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, double[], GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, regParam, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$4;
            private final double stepSize$4;
            private final double regParam$3;
            private final double miniBatchFraction$4;

            public final SVMModel apply(RDD<LabeledPoint> data, double[] initialWeights) {
                return SVMWithSGD$.MODULE$.train(data, this.numIterations$4, this.stepSize$4, this.regParam$3, this.miniBatchFraction$4, initialWeights);
            }
            {
                this.numIterations$4 = numIterations$4;
                this.stepSize$4 = stepSize$4;
                this.regParam$3 = regParam$3;
                this.miniBatchFraction$4 = miniBatchFraction$4;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainLogisticRegressionModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, double[], GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$5;
            private final double stepSize$5;
            private final double miniBatchFraction$5;

            public final LogisticRegressionModel apply(RDD<LabeledPoint> data, double[] initialWeights) {
                return LogisticRegressionWithSGD$.MODULE$.train(data, this.numIterations$5, this.stepSize$5, this.miniBatchFraction$5, initialWeights);
            }
            {
                this.numIterations$5 = numIterations$5;
                this.stepSize$5 = stepSize$5;
                this.miniBatchFraction$5 = miniBatchFraction$5;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainNaiveBayes(JavaRDD<byte[]> dataBytesJRDD, double lambda) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final LabeledPoint apply(byte[] xBytes) {
                double[] x = this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector(xBytes);
                return new LabeledPoint(x[0], (double[])Predef$.MODULE$.doubleArrayOps(x).slice(1, x.length));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        NaiveBayesModel model = NaiveBayes$.MODULE$.train((RDD<LabeledPoint>)data, lambda);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(this.serializeDoubleVector(model.pi()));
        ret.add(this.serializeDoubleMatrix(model.theta()));
        return ret;
    }

    public List<Object> trainKMeansModel(JavaRDD<byte[]> dataBytesJRDD, int k, int maxIterations, int runs, String initializationMode) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final double[] apply(byte[] xBytes) {
                return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector(xBytes);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        KMeansModel model = KMeans$.MODULE$.train((RDD<double[]>)data, k, maxIterations, runs, initializationMode);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(this.serializeDoubleMatrix(model.clusterCenters()));
        return ret;
    }

    public Rating org$apache$spark$mllib$api$python$PythonMLLibAPI$$unpackRating(byte[] ratingBytes) {
        ByteBuffer bb = ByteBuffer.wrap(ratingBytes);
        bb.order(ByteOrder.nativeOrder());
        int user = bb.getInt();
        int product = bb.getInt();
        double rating = bb.getDouble();
        return new Rating(user, product, rating);
    }

    public Tuple2<Object, Object> unpackTuple(byte[] tupleBytes) {
        ByteBuffer bb = ByteBuffer.wrap(tupleBytes);
        bb.order(ByteOrder.nativeOrder());
        int v1 = bb.getInt();
        int v2 = bb.getInt();
        return new Tuple2.mcII.sp(v1, v2);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serializeRating(Rating rate) {
        void var3_3;
        int len = 3;
        byte[] bytes = new byte[4 + 8 * len];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.putInt(len);
        DoubleBuffer db = bb.asDoubleBuffer();
        db.put(rate.user());
        db.put(rate.product());
        db.put(rate.rating());
        return var3_3;
    }

    public MatrixFactorizationModel trainALSModel(JavaRDD<byte[]> ratingsBytesJRDD, int rank, int iterations, double lambda, int blocks) {
        RDD ratings = ratingsBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final Rating apply(byte[] ratingBytes) {
                return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$unpackRating(ratingBytes);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
        return ALS$.MODULE$.train((RDD<Rating>)ratings, rank, iterations, lambda, blocks);
    }

    public MatrixFactorizationModel trainImplicitALSModel(JavaRDD<byte[]> ratingsBytesJRDD, int rank, int iterations, double lambda, int blocks, double alpha) {
        RDD ratings = ratingsBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final Rating apply(byte[] ratingBytes) {
                return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$unpackRating(ratingBytes);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
        return ALS$.MODULE$.trainImplicit((RDD<Rating>)ratings, rank, iterations, lambda, blocks, alpha);
    }
}

