/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class LogisticRegressionWithSGD$
implements Serializable {
    public static final LogisticRegressionWithSGD$ MODULE$;

    static {
        new LogisticRegressionWithSGD$();
    }

    public LogisticRegressionModel train(RDD<LabeledPoint> input, int numIterations, double stepSize, double miniBatchFraction, double[] initialWeights) {
        return (LogisticRegressionModel)new LogisticRegressionWithSGD(stepSize, numIterations, 0.0, miniBatchFraction).run(input, initialWeights);
    }

    public LogisticRegressionModel train(RDD<LabeledPoint> input, int numIterations, double stepSize, double miniBatchFraction) {
        return (LogisticRegressionModel)new LogisticRegressionWithSGD(stepSize, numIterations, 0.0, miniBatchFraction).run(input);
    }

    public LogisticRegressionModel train(RDD<LabeledPoint> input, int numIterations, double stepSize) {
        return this.train(input, numIterations, stepSize, 1.0);
    }

    public LogisticRegressionModel train(RDD<LabeledPoint> input, int numIterations) {
        return this.train(input, numIterations, 1.0, 1.0);
    }

    public void main(String[] args) {
        if (args.length != 4) {
            Predef$.MODULE$.println((Object)"Usage: LogisticRegression <master> <input_dir> <step_size> <niters>");
            System.exit(1);
        }
        SparkContext sc = new SparkContext(args[0], "LogisticRegression", SparkContext$.MODULE$.$lessinit$greater$default$3(), SparkContext$.MODULE$.$lessinit$greater$default$4(), SparkContext$.MODULE$.$lessinit$greater$default$5(), SparkContext$.MODULE$.$lessinit$greater$default$6());
        RDD<LabeledPoint> data = MLUtils$.MODULE$.loadLabeledData(sc, args[1]);
        LogisticRegressionModel model = this.train(data, new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt(), new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Weights: ").append((Object)Predef$.MODULE$.doubleArrayOps(model.weights()).mkString("[", ", ", "]")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Intercept: ").append((Object)BoxesRunTime.boxToDouble((double)model.intercept())).toString());
        sc.stop();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LogisticRegressionWithSGD$() {
        MODULE$ = this;
    }
}

