/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.classification.NaiveBayes;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class NaiveBayes$
implements Serializable {
    public static final NaiveBayes$ MODULE$;

    static {
        new NaiveBayes$();
    }

    public NaiveBayesModel train(RDD<LabeledPoint> input) {
        return new NaiveBayes().run(input);
    }

    public NaiveBayesModel train(RDD<LabeledPoint> input, double lambda) {
        return new NaiveBayes(lambda).run(input);
    }

    public void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            Predef$.MODULE$.println((Object)"Usage: NaiveBayes <master> <input_dir> [<lambda>]");
            System.exit(1);
        }
        SparkContext sc = new SparkContext(args[0], "NaiveBayes", SparkContext$.MODULE$.$lessinit$greater$default$3(), SparkContext$.MODULE$.$lessinit$greater$default$4(), SparkContext$.MODULE$.$lessinit$greater$default$5(), SparkContext$.MODULE$.$lessinit$greater$default$6());
        RDD<LabeledPoint> data = MLUtils$.MODULE$.loadLabeledData(sc, args[1]);
        NaiveBayesModel model = args.length == 2 ? this.train(data) : this.train(data, new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Pi: ").append((Object)Predef$.MODULE$.doubleArrayOps(model.pi()).mkString("[", ", ", "]")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Theta:\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.theta()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(double[] x$6) {
                return Predef$.MODULE$.doubleArrayOps(x$6).mkString("[", ", ", "]");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("[", "\n ", "]")).toString());
        sc.stop();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private NaiveBayes$() {
        MODULE$ = this;
    }
}

