/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u001b\tya*Y5wK\n\u000b\u00170Z:N_\u0012,GN\u0003\u0002\u0004\t\u0005q1\r\\1tg&4\u0017nY1uS>t'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!\u0002\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u00111c\u00117bgNLg-[2bi&|g.T8eK2\u0004\"aD\r\n\u0005i\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002\u0005ALW#\u0001\u0010\u0011\u0007=y\u0012%\u0003\u0002!!\t)\u0011I\u001d:bsB\u0011qBI\u0005\u0003GA\u0011a\u0001R8vE2,\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0007AL\u0007\u0005\u0003\u0005(\u0001\t\u0015\r\u0011\"\u0001)\u0003\u0015!\b.\u001a;b+\u0005I\u0003cA\b =!A1\u0006\u0001B\u0001B\u0003%\u0011&\u0001\u0004uQ\u0016$\u0018\r\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0016\u0001!)A\u0004\fa\u0001=!)q\u0005\fa\u0001S!91\u0007\u0001b\u0001\n\u0013!\u0014aA0qSV\tQ\u0007\u0005\u00027s5\tqG\u0003\u00029\u0015\u0005)!N\u00197bg&\u0011!h\u000e\u0002\r\t>,(\r\\3NCR\u0014\u0018\u000e\u001f\u0005\u0007y\u0001\u0001\u000b\u0011B\u001b\u0002\t}\u0003\u0018\u000e\t\u0005\b}\u0001\u0011\r\u0011\"\u00035\u0003\u0019yF\u000f[3uC\"1\u0001\t\u0001Q\u0001\nU\nqa\u0018;iKR\f\u0007\u0005C\u0003C\u0001\u0011\u00051)A\u0004qe\u0016$\u0017n\u0019;\u0015\u0005\u0011S\u0005cA#IC5\taI\u0003\u0002H\r\u0005\u0019!\u000f\u001a3\n\u0005%3%a\u0001*E\t\")1*\u0011a\u0001\u0019\u0006AA/Z:u\t\u0006$\u0018\rE\u0002F\u0011zAQA\u0011\u0001\u0005\u00029#\"!I(\t\u000b-k\u0005\u0019\u0001\u0010")
public class NaiveBayesModel
implements ClassificationModel {
    private final double[] pi;
    private final double[][] theta;
    private final DoubleMatrix _pi;
    private final DoubleMatrix _theta;

    public double[] pi() {
        return this.pi;
    }

    public double[][] theta() {
        return this.theta;
    }

    private DoubleMatrix _pi() {
        return this._pi;
    }

    private DoubleMatrix _theta() {
        return this._theta;
    }

    @Override
    public RDD<Object> predict(RDD<double[]> testData) {
        return testData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesModel $outer;

            public final double apply(double[] testData) {
                return this.$outer.predict(testData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.Double());
    }

    @Override
    public double predict(double[] testData) {
        DoubleMatrix dataMatrix = new DoubleMatrix(testData.length, 1, testData);
        DoubleMatrix result = this._pi().add(this._theta().mmul(dataMatrix));
        return result.argmax();
    }

    public NaiveBayesModel(double[] pi, double[][] theta) {
        this.pi = pi;
        this.theta = theta;
        this._pi = new DoubleMatrix(pi.length, 1, pi);
        this._theta = new DoubleMatrix(theta);
    }
}

