/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class KMeans$
implements Serializable {
    public static final KMeans$ MODULE$;
    private final String RANDOM;
    private final String K_MEANS_PARALLEL;

    static {
        new KMeans$();
    }

    public String RANDOM() {
        return this.RANDOM;
    }

    public String K_MEANS_PARALLEL() {
        return this.K_MEANS_PARALLEL;
    }

    public KMeansModel train(RDD<double[]> data, int k, int maxIterations, int runs, String initializationMode) {
        return new KMeans().setK(k).setMaxIterations(maxIterations).setRuns(runs).setInitializationMode(initializationMode).run(data);
    }

    public KMeansModel train(RDD<double[]> data, int k, int maxIterations, int runs) {
        return this.train(data, k, maxIterations, runs, this.K_MEANS_PARALLEL());
    }

    public KMeansModel train(RDD<double[]> data, int k, int maxIterations) {
        return this.train(data, k, maxIterations, 1, this.K_MEANS_PARALLEL());
    }

    public Tuple2<Object, Object> findClosest(double[][] centers, double[] point) {
        DoubleRef bestDistance = new DoubleRef(Double.POSITIVE_INFINITY);
        IntRef bestIndex = new IntRef(0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), centers.length).foreach$mVc$sp((Function1)new Serializable(centers, point, bestDistance, bestIndex){
            public static final long serialVersionUID = 0L;
            private final double[][] centers$2;
            private final double[] point$2;
            private final DoubleRef bestDistance$1;
            private final IntRef bestIndex$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                double distance = MLUtils$.MODULE$.squaredDistance(this.point$2, this.centers$2[i]);
                if (distance < this.bestDistance$1.elem) {
                    this.bestDistance$1.elem = distance;
                    this.bestIndex$1.elem = i;
                }
            }
            {
                this.centers$2 = centers$2;
                this.point$2 = point$2;
                this.bestDistance$1 = bestDistance$1;
                this.bestIndex$1 = bestIndex$1;
            }
        });
        return new Tuple2.mcID.sp(bestIndex.elem, bestDistance.elem);
    }

    public double pointCost(double[][] centers, double[] point) {
        DoubleRef bestDistance = new DoubleRef(Double.POSITIVE_INFINITY);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), centers.length).foreach$mVc$sp((Function1)new Serializable(centers, point, bestDistance){
            public static final long serialVersionUID = 0L;
            private final double[][] centers$4;
            private final double[] point$4;
            private final DoubleRef bestDistance$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                double distance = MLUtils$.MODULE$.squaredDistance(this.point$4, this.centers$4[i]);
                if (distance < this.bestDistance$2.elem) {
                    this.bestDistance$2.elem = distance;
                }
            }
            {
                this.centers$4 = centers$4;
                this.point$4 = point$4;
                this.bestDistance$2 = bestDistance$2;
            }
        });
        return bestDistance.elem;
    }

    public void main(String[] args) {
        Tuple4 tuple4;
        if (args.length < 4) {
            Predef$.MODULE$.println((Object)"Usage: KMeans <master> <input_file> <k> <max_iterations> [<runs>]");
            System.exit(1);
        }
        if ((tuple4 = new Tuple4((Object)args[0], (Object)args[1], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt()))) != null) {
            Tuple4 tuple42;
            String master = (String)tuple4._1();
            String inputFile = (String)tuple4._2();
            int k = BoxesRunTime.unboxToInt((Object)tuple4._3());
            int iters = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)master, (Object)inputFile, (Object)BoxesRunTime.boxToInteger((int)k), (Object)BoxesRunTime.boxToInteger((int)iters));
            String master2 = (String)tuple43._1();
            String inputFile2 = (String)tuple43._2();
            int k2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
            int iters2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
            int runs = args.length >= 5 ? new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt() : 1;
            SparkContext sc = new SparkContext(master2, "KMeans", SparkContext$.MODULE$.$lessinit$greater$default$3(), SparkContext$.MODULE$.$lessinit$greater$default$4(), SparkContext$.MODULE$.$lessinit$greater$default$5(), SparkContext$.MODULE$.$lessinit$greater$default$6());
            RDD data = sc.textFile(inputFile2, sc.textFile$default$2()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double[] apply(String line) {
                    return (double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line)).split(' ')).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(String x$15) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$15)).toDouble();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).cache();
            KMeansModel model = this.train((RDD<double[]>)data, k2, iters2, runs);
            double cost = model.computeCost((RDD<double[]>)data);
            Predef$.MODULE$.println((Object)"Cluster centers:");
            Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(double[] c) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"  ").append((Object)Predef$.MODULE$.doubleArrayOps(c).mkString(" ")).toString());
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Cost: ").append((Object)BoxesRunTime.boxToDouble((double)cost)).toString());
            System.exit(0);
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KMeans$() {
        MODULE$ = this;
        this.RANDOM = "random";
        this.K_MEANS_PARALLEL = "k-means||";
    }
}

