/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.KMeans$;
import org.jblas.DoubleMatrix;
import org.jblas.SimpleBlas;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

public final class LocalKMeans$ {
    public static final LocalKMeans$ MODULE$;

    static {
        new LocalKMeans$();
    }

    public double[][] kMeansPlusPlus(int seed, double[][] points, double[] weights, int k, int maxIterations) {
        Random rand = new Random(seed);
        int dimensions = points[0].length;
        double[][] centers = new double[k][];
        centers[0] = (double[])this.pickWeighted(rand, points, weights);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), k).foreach$mVc$sp((Function1)new Serializable(points, weights, rand, centers){
            public static final long serialVersionUID = 0L;
            private final double[][] points$1;
            private final double[] weights$1;
            private final Random rand$1;
            private final double[][] centers$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int j;
                double[][] curCenters = (double[][])Predef$.MODULE$.refArrayOps((Object[])this.centers$1).slice(0, i);
                double sum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.points$1).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.weights$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, curCenters){
                    public static final long serialVersionUID = 0L;
                    private final double[][] curCenters$1;

                    public final double apply(Tuple2<double[], Object> x0$1) {
                        Tuple2<double[], Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            double[] p = (double[])tuple2._1();
                            double w = tuple2._2$mcD$sp();
                            double d = w * KMeans$.MODULE$.pointCost(this.curCenters$1, p);
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.curCenters$1 = curCenters$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double r = this.rand$1.nextDouble() * sum;
                double cumulativeScore = 0.0;
                for (j = 0; j < this.points$1.length && cumulativeScore < r; cumulativeScore += this.weights$1[j] * KMeans$.MODULE$.pointCost(curCenters, this.points$1[j]), ++j) {
                }
                this.centers$1[i] = this.points$1[j - 1];
            }
            {
                this.points$1 = points$1;
                this.weights$1 = weights$1;
                this.rand$1 = rand$1;
                this.centers$1 = centers$1;
            }
        });
        int[] oldClosest = (int[])Array$.MODULE$.fill(points.length, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }, ClassTag$.MODULE$.Int());
        BooleanRef moved = new BooleanRef(true);
        for (int iteration = 0; moved.elem && iteration < maxIterations; ++iteration) {
            moved.elem = false;
            DoubleMatrix[] sums = (DoubleMatrix[])Array$.MODULE$.fill(k, (Function0)new Serializable(dimensions){
                public static final long serialVersionUID = 0L;
                private final int dimensions$1;

                public final DoubleMatrix apply() {
                    return new DoubleMatrix(this.dimensions$1);
                }
                {
                    this.dimensions$1 = dimensions$1;
                }
            }, ClassTag$.MODULE$.apply(DoubleMatrix.class));
            double[] counts = (double[])Array$.MODULE$.fill(k, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return 0.0;
                }
            }, ClassTag$.MODULE$.Double());
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])points).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<double[], Object> check$ifrefutable$1) {
                    Tuple2<double[], Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(weights, centers, oldClosest, moved, sums, counts){
                public static final long serialVersionUID = 0L;
                private final double[] weights$1;
                private final double[][] centers$1;
                private final int[] oldClosest$1;
                private final BooleanRef moved$1;
                private final DoubleMatrix[] sums$1;
                private final double[] counts$1;

                public final void apply(Tuple2<double[], Object> x$1) {
                    Tuple2<double[], Object> tuple2 = x$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        double[] p = (double[])tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        int index = KMeans$.MODULE$.findClosest(this.centers$1, p)._1$mcI$sp();
                        SimpleBlas.axpy((double)this.weights$1[i], (DoubleMatrix)new DoubleMatrix(p), (DoubleMatrix)this.sums$1[index]);
                        this.counts$1[index] = this.counts$1[index] + this.weights$1[i];
                        if (index != this.oldClosest$1[i]) {
                            this.moved$1.elem = true;
                            this.oldClosest$1[i] = index;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.weights$1 = weights$1;
                    this.centers$1 = centers$1;
                    this.oldClosest$1 = oldClosest$1;
                    this.moved$1 = moved$1;
                    this.sums$1 = sums$1;
                    this.counts$1 = counts$1;
                }
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k).foreach$mVc$sp((Function1)new Serializable(points, rand, centers, sums, counts){
                public static final long serialVersionUID = 0L;
                private final double[][] points$1;
                private final Random rand$1;
                private final double[][] centers$1;
                private final DoubleMatrix[] sums$1;
                private final double[] counts$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.centers$1[i] = this.counts$1[i] == 0.0 ? this.points$1[this.rand$1.nextInt(this.points$1.length)] : this.sums$1[i].divi((double)this.counts$1[i]).data;
                }
                {
                    this.points$1 = points$1;
                    this.rand$1 = rand$1;
                    this.centers$1 = centers$1;
                    this.sums$1 = sums$1;
                    this.counts$1 = counts$1;
                }
            });
        }
        return centers;
    }

    private <T> T pickWeighted(Random rand, Object data, double[] weights) {
        double r = rand.nextDouble() * BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(weights).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        int i = 0;
        for (double curWeight = 0.0; i < ScalaRunTime$.MODULE$.array_length(data) && curWeight < r; curWeight += weights[i], ++i) {
        }
        return (T)ScalaRunTime$.MODULE$.array_apply(data, i - 1);
    }

    private LocalKMeans$() {
        MODULE$ = this;
    }
}

