/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ALS$
implements Serializable {
    public static final ALS$ MODULE$;

    static {
        new ALS$();
    }

    public MatrixFactorizationModel train(RDD<Rating> ratings, int rank, int iterations, double lambda, int blocks, long seed) {
        return new ALS(blocks, rank, iterations, lambda, false, 1.0, seed).run(ratings);
    }

    public MatrixFactorizationModel train(RDD<Rating> ratings, int rank, int iterations, double lambda, int blocks) {
        return new ALS(blocks, rank, iterations, lambda, false, 1.0, this.org$apache$spark$mllib$recommendation$ALS$$$lessinit$greater$default$7()).run(ratings);
    }

    public MatrixFactorizationModel train(RDD<Rating> ratings, int rank, int iterations, double lambda) {
        return this.train(ratings, rank, iterations, lambda, -1);
    }

    public MatrixFactorizationModel train(RDD<Rating> ratings, int rank, int iterations) {
        return this.train(ratings, rank, iterations, 0.01, -1);
    }

    public MatrixFactorizationModel trainImplicit(RDD<Rating> ratings, int rank, int iterations, double lambda, int blocks, double alpha, long seed) {
        return new ALS(blocks, rank, iterations, lambda, true, alpha, seed).run(ratings);
    }

    public MatrixFactorizationModel trainImplicit(RDD<Rating> ratings, int rank, int iterations, double lambda, int blocks, double alpha) {
        return new ALS(blocks, rank, iterations, lambda, true, alpha, this.org$apache$spark$mllib$recommendation$ALS$$$lessinit$greater$default$7()).run(ratings);
    }

    public MatrixFactorizationModel trainImplicit(RDD<Rating> ratings, int rank, int iterations, double lambda, double alpha) {
        return this.trainImplicit(ratings, rank, iterations, lambda, -1, alpha);
    }

    public MatrixFactorizationModel trainImplicit(RDD<Rating> ratings, int rank, int iterations) {
        return this.trainImplicit(ratings, rank, iterations, 0.01, -1, 1.0);
    }

    public void main(String[] args) {
        Tuple5 tuple5;
        if (args.length < 5 || args.length > 9) {
            Predef$.MODULE$.println((Object)"Usage: ALS <master> <ratings_file> <rank> <iterations> <output_dir> [<lambda>] [<implicitPrefs>] [<alpha>] [<blocks>]");
            System.exit(1);
        }
        if ((tuple5 = new Tuple5((Object)args[0], (Object)args[1], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt()), (Object)args[4])) != null) {
            Tuple5 tuple52;
            String master = (String)tuple5._1();
            String ratingsFile = (String)tuple5._2();
            int rank = BoxesRunTime.unboxToInt((Object)tuple5._3());
            int iters = BoxesRunTime.unboxToInt((Object)tuple5._4());
            String outputDir = (String)tuple5._5();
            Tuple5 tuple53 = tuple52 = new Tuple5((Object)master, (Object)ratingsFile, (Object)BoxesRunTime.boxToInteger((int)rank), (Object)BoxesRunTime.boxToInteger((int)iters), (Object)outputDir);
            String master2 = (String)tuple53._1();
            String ratingsFile2 = (String)tuple53._2();
            int rank2 = BoxesRunTime.unboxToInt((Object)tuple53._3());
            int iters2 = BoxesRunTime.unboxToInt((Object)tuple53._4());
            String outputDir2 = (String)tuple53._5();
            double lambda = args.length >= 6 ? new StringOps(Predef$.MODULE$.augmentString(args[5])).toDouble() : 0.01;
            boolean implicitPrefs = args.length >= 7 ? new StringOps(Predef$.MODULE$.augmentString(args[6])).toBoolean() : false;
            double alpha = args.length >= 8 ? new StringOps(Predef$.MODULE$.augmentString(args[7])).toDouble() : 1.0;
            int blocks = args.length == 9 ? new StringOps(Predef$.MODULE$.augmentString(args[8])).toInt() : -1;
            SparkConf conf = new SparkConf().set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").set("spark.kryo.registrator", ALS.ALSRegistrator.class.getName()).set("spark.kryo.referenceTracking", "false").set("spark.kryoserializer.buffer.mb", "8").set("spark.locality.wait", "10000");
            SparkContext sc = new SparkContext(master2, "ALS", conf);
            RDD ratings = sc.textFile(ratingsFile2, sc.textFile$default$2()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Rating apply(String line) {
                    String[] fields = new StringOps(Predef$.MODULE$.augmentString(line)).split(',');
                    return new Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble());
                }
            }, ClassTag$.MODULE$.apply(Rating.class));
            int x$16 = rank2;
            int x$17 = iters2;
            double x$18 = lambda;
            int x$19 = blocks;
            boolean x$20 = implicitPrefs;
            double x$21 = alpha;
            long x$22 = this.org$apache$spark$mllib$recommendation$ALS$$$lessinit$greater$default$7();
            MatrixFactorizationModel model = new ALS(x$19, x$16, x$17, x$18, x$20, x$21, x$22).run((RDD<Rating>)ratings);
            model.userFeatures().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Object, double[]> x0$8) {
                    Tuple2<Object, double[]> tuple2 = x0$8;
                    if (tuple2 != null) {
                        int id = tuple2._1$mcI$sp();
                        double[] vec = (double[])tuple2._2();
                        String string = new StringBuilder().append(id).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps(vec).mkString(" ")).toString();
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(new StringBuilder().append((Object)outputDir2).append((Object)"/userFeatures").toString());
            model.productFeatures().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Object, double[]> x0$9) {
                    Tuple2<Object, double[]> tuple2 = x0$9;
                    if (tuple2 != null) {
                        int id = tuple2._1$mcI$sp();
                        double[] vec = (double[])tuple2._2();
                        String string = new StringBuilder().append(id).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps(vec).mkString(" ")).toString();
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(new StringBuilder().append((Object)outputDir2).append((Object)"/productFeatures").toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Final user/product features written to ").append((Object)outputDir2).toString());
            sc.stop();
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    public long org$apache$spark$mllib$recommendation$ALS$$$lessinit$greater$default$7() {
        return System.nanoTime();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ALS$() {
        MODULE$ = this;
    }
}

