/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0001\u0003\u0003\u0003i!AG$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be\u0006cwm\u001c:ji\"l'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\tq1e\u0005\u0003\u0001\u001fUI\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\ta!\u0003\u0002\u0019\r\t9Aj\\4hS:<\u0007C\u0001\t\u001b\u0013\tY\u0012C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0019\u0001\u0005A\u0011\u000e\u0003\t\u0001\"AI\u0012\r\u0001\u0011)A\u0005\u0001b\u0001K\t\tQ*\u0005\u0002'SA\u0011\u0001cJ\u0005\u0003QE\u0011qAT8uQ&tw\r\u0005\u0002!U%\u00111F\u0001\u0002\u0017\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014Xj\u001c3fY\"9Q\u0006\u0001b\u0001\n#q\u0013A\u0003<bY&$\u0017\r^8sgV\tq\u0006E\u00021qmr!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Qb\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t9\u0014#A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$aA*fc*\u0011q'\u0005\t\u0005!qrt)\u0003\u0002>#\tIa)\u001e8di&|g.\r\t\u0004\u007f\t#U\"\u0001!\u000b\u0005\u00053\u0011a\u0001:eI&\u00111\t\u0011\u0002\u0004%\u0012#\u0005C\u0001\u0011F\u0013\t1%A\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u0005\u0002\u0011\u0011&\u0011\u0011*\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019Y\u0005\u0001)A\u0005_\u0005Ya/\u00197jI\u0006$xN]:!\u0011\u001di\u0005A1A\u0007\u00029\u000b\u0011b\u001c9uS6L'0\u001a:\u0016\u0003=\u0003\"\u0001U*\u000e\u0003ES!A\u0015\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\n\u0005Q\u000b&!C(qi&l\u0017N_3s\u0011\u001d1\u0006\u00011A\u0005\u0012]\u000bA\"\u00193e\u0013:$XM]2faR,\u0012a\u0012\u0005\b3\u0002\u0001\r\u0011\"\u0005[\u0003A\tG\rZ%oi\u0016\u00148-\u001a9u?\u0012*\u0017\u000f\u0006\u0002\\=B\u0011\u0001\u0003X\u0005\u0003;F\u0011A!\u00168ji\"9q\fWA\u0001\u0002\u00049\u0015a\u0001=%c!1\u0011\r\u0001Q!\n\u001d\u000bQ\"\u00193e\u0013:$XM]2faR\u0004\u0003bB2\u0001\u0001\u0004%\tbV\u0001\rm\u0006d\u0017\u000eZ1uK\u0012\u000bG/\u0019\u0005\bK\u0002\u0001\r\u0011\"\u0005g\u0003A1\u0018\r\\5eCR,G)\u0019;b?\u0012*\u0017\u000f\u0006\u0002\\O\"9q\fZA\u0001\u0002\u00049\u0005BB5\u0001A\u0003&q)A\u0007wC2LG-\u0019;f\t\u0006$\u0018\r\t\u0005\u0006W\u00021\t\u0002\\\u0001\fGJ,\u0017\r^3N_\u0012,G\u000eF\u0002\"[VDQA\u001c6A\u0002=\fqa^3jO\"$8\u000fE\u0002\u0011aJL!!]\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005A\u0019\u0018B\u0001;\u0012\u0005\u0019!u.\u001e2mK\")aO\u001ba\u0001e\u0006I\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\u0005\u0006q\u0002!\t!_\u0001\rg\u0016$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u000b\u0003unl\u0011\u0001\u0001\u0005\u0006-^\u0004\ra\u0012\u0005\u0006{\u0002!\tA`\u0001\u0010g\u0016$h+\u00197jI\u0006$X\rR1uCR\u0011!p \u0005\u0006Gr\u0004\ra\u0012\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003\r\u0011XO\u001c\u000b\u0004C\u0005\u001d\u0001bBA\u0005\u0003\u0003\u0001\rAP\u0001\u0006S:\u0004X\u000f\u001e\u0005\b\u0003\u0007\u0001A\u0011AA\u0007)\u0015\t\u0013qBA\t\u0011\u001d\tI!a\u0003A\u0002yBq!a\u0005\u0002\f\u0001\u0007q.\u0001\bj]&$\u0018.\u00197XK&<\u0007\u000e^:")
public abstract class GeneralizedLinearAlgorithm<M extends GeneralizedLinearModel>
implements Logging,
Serializable {
    private final Seq<Function1<RDD<LabeledPoint>, Object>> validators;
    private boolean addIntercept;
    private boolean validateData;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Seq<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    public abstract Optimizer optimizer();

    public boolean addIntercept() {
        return this.addIntercept;
    }

    public void addIntercept_$eq(boolean x$1) {
        this.addIntercept = x$1;
    }

    public boolean validateData() {
        return this.validateData;
    }

    public void validateData_$eq(boolean x$1) {
        this.validateData = x$1;
    }

    public abstract M createModel(double[] var1, double var2);

    public GeneralizedLinearAlgorithm<M> setIntercept(boolean addIntercept) {
        this.addIntercept_$eq(addIntercept);
        return this;
    }

    public GeneralizedLinearAlgorithm<M> setValidateData(boolean validateData) {
        this.validateData_$eq(validateData);
        return this;
    }

    public M run(RDD<LabeledPoint> input) {
        int nfeatures = ((LabeledPoint)input.first()).features().length;
        double[] initialWeights = new double[nfeatures];
        return this.run(input, initialWeights);
    }

    public M run(RDD<LabeledPoint> input, double[] initialWeights) {
        Tuple2 tuple2;
        double[] dArray;
        RDD data;
        if (this.validateData() && !this.validators().forall((Function1)new Serializable(this, input){
            public static final long serialVersionUID = 0L;
            private final RDD input$1;

            public final boolean apply(Function1<RDD<LabeledPoint>, Object> func) {
                return BoxesRunTime.unboxToBoolean((Object)func.apply((Object)this.input$1));
            }
            {
                this.input$1 = input$1;
            }
        })) {
            throw new SparkException("Input validation failed.");
        }
        RDD rDD = data = this.addIntercept() ? input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, double[]> apply(LabeledPoint labeledPoint) {
                double d = 1.0;
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), Predef$.MODULE$.doubleArrayOps(labeledPoint.features()).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)) : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, double[]> apply(LabeledPoint labeledPoint) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)labeledPoint.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        if (this.addIntercept()) {
            double d = 0.0;
            dArray = (double[])Predef$.MODULE$.doubleArrayOps(initialWeights).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        } else {
            dArray = initialWeights;
        }
        double[] initialWeightsWithIntercept = dArray;
        double[] weightsWithIntercept = this.optimizer().optimize((RDD<Tuple2<Object, double[]>>)data, initialWeightsWithIntercept);
        Tuple2 tuple22 = tuple2 = this.addIntercept() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)weightsWithIntercept[0]), Predef$.MODULE$.doubleArrayOps(weightsWithIntercept).tail()) : new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)weightsWithIntercept);
        if (tuple2 != null) {
            Tuple2 tuple23;
            double intercept = tuple2._1$mcD$sp();
            double[] weights = (double[])tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)intercept), (Object)weights);
            double intercept2 = tuple24._1$mcD$sp();
            double[] weights2 = (double[])tuple24._2();
            this.logInfo((Function0<String>)new Serializable(this, weights2){
                public static final long serialVersionUID = 0L;
                private final double[] weights$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Final weights ").append((Object)Predef$.MODULE$.doubleArrayOps(this.weights$1).mkString(",")).toString();
                }
                {
                    this.weights$1 = (double[])weights$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(this, intercept2){
                public static final long serialVersionUID = 0L;
                private final double intercept$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Final intercept ").append((Object)BoxesRunTime.boxToDouble((double)this.intercept$1)).toString();
                }
                {
                    this.intercept$1 = intercept$1;
                }
            });
            return this.createModel(weights2, intercept2);
        }
        throw new MatchError((Object)tuple2);
    }

    public GeneralizedLinearAlgorithm() {
        Logging.class.$init$((Logging)this);
        this.validators = Nil$.MODULE$;
        this.addIntercept = true;
        this.validateData = true;
    }
}

