/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LassoWithSGD;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class LassoWithSGD$
implements Serializable {
    public static final LassoWithSGD$ MODULE$;

    static {
        new LassoWithSGD$();
    }

    public LassoModel train(RDD<LabeledPoint> input, int numIterations, double stepSize, double regParam, double miniBatchFraction, double[] initialWeights) {
        return new LassoWithSGD(stepSize, numIterations, regParam, miniBatchFraction).run((RDD)input, initialWeights);
    }

    public LassoModel train(RDD<LabeledPoint> input, int numIterations, double stepSize, double regParam, double miniBatchFraction) {
        return (LassoModel)new LassoWithSGD(stepSize, numIterations, regParam, miniBatchFraction).run(input);
    }

    public LassoModel train(RDD<LabeledPoint> input, int numIterations, double stepSize, double regParam) {
        return this.train(input, numIterations, stepSize, regParam, 1.0);
    }

    public LassoModel train(RDD<LabeledPoint> input, int numIterations) {
        return this.train(input, numIterations, 1.0, 1.0, 1.0);
    }

    public void main(String[] args) {
        if (args.length != 5) {
            Predef$.MODULE$.println((Object)"Usage: Lasso <master> <input_dir> <step_size> <regularization_parameter> <niters>");
            System.exit(1);
        }
        SparkContext sc = new SparkContext(args[0], "Lasso", SparkContext$.MODULE$.$lessinit$greater$default$3(), SparkContext$.MODULE$.$lessinit$greater$default$4(), SparkContext$.MODULE$.$lessinit$greater$default$5(), SparkContext$.MODULE$.$lessinit$greater$default$6());
        RDD<LabeledPoint> data = MLUtils$.MODULE$.loadLabeledData(sc, args[1]);
        LassoModel model = this.train(data, new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt(), new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble(), new StringOps(Predef$.MODULE$.augmentString(args[3])).toDouble());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Weights: ").append((Object)Predef$.MODULE$.doubleArrayOps(model.weights()).mkString("[", ", ", "]")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Intercept: ").append((Object)BoxesRunTime.boxToDouble((double)model.intercept())).toString());
        sc.stop();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LassoWithSGD$() {
        MODULE$ = this;
    }
}

