/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.SquaredGradient;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LassoWithSGD$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Function1;
import scala.Serializable;
import scala.Tuple3;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u00015\u0011A\u0002T1tg><\u0016\u000e\u001e5T\u000f\u0012S!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qQ\u0003E\u0002\u0010!Ii\u0011AA\u0005\u0003#\t\u0011!dR3oKJ\fG.\u001b>fI2Kg.Z1s\u00032<wN]5uQ6\u0004\"aD\n\n\u0005Q\u0011!A\u0003'bgN|Wj\u001c3fYB\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\ta1+\u001a:jC2L'0\u00192mK\"AA\u0004\u0001BA\u0002\u0013\u0005Q$\u0001\u0005ti\u0016\u00048+\u001b>f+\u0005q\u0002C\u0001\f \u0013\t\u0001sC\u0001\u0004E_V\u0014G.\u001a\u0005\tE\u0001\u0011\t\u0019!C\u0001G\u0005a1\u000f^3q'&TXm\u0018\u0013fcR\u0011Ae\n\t\u0003-\u0015J!AJ\f\u0003\tUs\u0017\u000e\u001e\u0005\bQ\u0005\n\t\u00111\u0001\u001f\u0003\rAH%\r\u0005\tU\u0001\u0011\t\u0011)Q\u0005=\u0005I1\u000f^3q'&TX\r\t\u0005\tY\u0001\u0011\t\u0019!C\u0001[\u0005ia.^7Ji\u0016\u0014\u0018\r^5p]N,\u0012A\f\t\u0003-=J!\u0001M\f\u0003\u0007%sG\u000f\u0003\u00053\u0001\t\u0005\r\u0011\"\u00014\u0003EqW/\\%uKJ\fG/[8og~#S-\u001d\u000b\u0003IQBq\u0001K\u0019\u0002\u0002\u0003\u0007a\u0006\u0003\u00057\u0001\t\u0005\t\u0015)\u0003/\u00039qW/\\%uKJ\fG/[8og\u0002B\u0001\u0002\u000f\u0001\u0003\u0002\u0004%\t!H\u0001\te\u0016<\u0007+\u0019:b[\"A!\b\u0001BA\u0002\u0013\u00051(\u0001\u0007sK\u001e\u0004\u0016M]1n?\u0012*\u0017\u000f\u0006\u0002%y!9\u0001&OA\u0001\u0002\u0004q\u0002\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0010\u0002\u0013I,w\rU1sC6\u0004\u0003\u0002\u0003!\u0001\u0005\u0003\u0007I\u0011A\u000f\u0002#5Lg.\u001b\"bi\u000eDgI]1di&|g\u000e\u0003\u0005C\u0001\t\u0005\r\u0011\"\u0001D\u0003Ui\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\\0%KF$\"\u0001\n#\t\u000f!\n\u0015\u0011!a\u0001=!Aa\t\u0001B\u0001B\u0003&a$\u0001\nnS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:\u0004\u0003\"\u0002%\u0001\t\u0013I\u0015A\u0002\u001fj]&$h\bF\u0003K\u00172ke\n\u0005\u0002\u0010\u0001!)Ad\u0012a\u0001=!)Af\u0012a\u0001]!)\u0001h\u0012a\u0001=!)\u0001i\u0012a\u0001=!9\u0001\u000b\u0001b\u0001\n\u0003\t\u0016\u0001C4sC\u0012LWM\u001c;\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\n\u0005]#&aD*rk\u0006\u0014X\rZ$sC\u0012LWM\u001c;\t\re\u0003\u0001\u0015!\u0003S\u0003%9'/\u00193jK:$\b\u0005C\u0004\\\u0001\t\u0007I\u0011\u0001/\u0002\u000fU\u0004H-\u0019;feV\tQ\f\u0005\u0002T=&\u0011q\f\u0016\u0002\n\u0019F*\u0006\u000fZ1uKJDa!\u0019\u0001!\u0002\u0013i\u0016\u0001C;qI\u0006$XM\u001d\u0011\t\u000f\r\u0004!\u0019!C\u0001I\u0006Iq\u000e\u001d;j[&TXM]\u000b\u0002KB\u00111KZ\u0005\u0003OR\u0013qb\u0012:bI&,g\u000e\u001e#fg\u000e,g\u000e\u001e\u0005\u0007S\u0002\u0001\u000b\u0011B3\u0002\u0015=\u0004H/[7ju\u0016\u0014\b\u0005\u000b\u0002iWB\u0011a\u0003\\\u0005\u0003[^\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000f=\u0004\u0001\u0019!C\u0001;\u0005)\u00110T3b]\"9\u0011\u000f\u0001a\u0001\n\u0003\u0011\u0018!C=NK\u0006tw\fJ3r)\t!3\u000fC\u0004)a\u0006\u0005\t\u0019\u0001\u0010\t\rU\u0004\u0001\u0015)\u0003\u001f\u0003\u0019IX*Z1oA!Iq\u000f\u0001a\u0001\u0002\u0004%\t\u0001_\u0001\tq\u000e{G.T3b]V\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}\u0015\u0005)!N\u00197bg&\u0011ap\u001f\u0002\r\t>,(\r\\3NCR\u0014\u0018\u000e\u001f\u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019!\u0001\u0007y\u0007>dW*Z1o?\u0012*\u0017\u000fF\u0002%\u0003\u000bAq\u0001K@\u0002\u0002\u0003\u0007\u0011\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0015B=\u0002\u0013a\u001cu\u000e\\'fC:\u0004\u0003BCA\u0007\u0001\u0001\u0007\t\u0019!C\u0001q\u00061\u0001pQ8m'\u0012D1\"!\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0014\u0005Q\u0001pQ8m'\u0012|F%Z9\u0015\u0007\u0011\n)\u0002\u0003\u0005)\u0003\u001f\t\t\u00111\u0001z\u0011\u001d\tI\u0002\u0001Q!\ne\fq\u0001_\"pYN#\u0007\u0005\u0003\u0004I\u0001\u0011\u0005\u0011Q\u0004\u000b\u0002\u0015\"9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012\u0001D:fi&sG/\u001a:dKB$H\u0003BA\u0013\u0003Oi\u0011\u0001\u0001\u0005\t\u0003S\ty\u00021\u0001\u0002,\u0005a\u0011\r\u001a3J]R,'oY3qiB\u0019a#!\f\n\u0007\u0005=rCA\u0004C_>dW-\u00198\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005Y1M]3bi\u0016lu\u000eZ3m)\u0015\u0011\u0012qGA!\u0011!\tI$!\rA\u0002\u0005m\u0012aB<fS\u001eDGo\u001d\t\u0005-\u0005ub$C\u0002\u0002@]\u0011Q!\u0011:sCfDq!a\u0011\u00022\u0001\u0007a$A\u0005j]R,'oY3qi\"9\u0011q\t\u0001\u0005B\u0005%\u0013a\u0001:v]R)!#a\u0013\u0002b!A\u0011QJA#\u0001\u0004\ty%A\u0003j]B,H\u000f\u0005\u0004\u0002R\u0005]\u00131L\u0007\u0003\u0003'R1!!\u0016\u0007\u0003\r\u0011H\rZ\u0005\u0005\u00033\n\u0019FA\u0002S\t\u0012\u00032aDA/\u0013\r\tyF\u0001\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\t\u0003G\n)\u00051\u0001\u0002<\u0005q\u0011N\\5uS\u0006dw+Z5hQR\u001cxaBA4\u0005!\u0005\u0011\u0011N\u0001\r\u0019\u0006\u001c8o\\,ji\"\u001cv\t\u0012\t\u0004\u001f\u0005-dAB\u0001\u0003\u0011\u0003\tigE\u0003\u0002l\u0005=T\u0003E\u0002\u0017\u0003cJ1!a\u001d\u0018\u0005\u0019\te.\u001f*fM\"9\u0001*a\u001b\u0005\u0002\u0005]DCAA5\u0011!\tY(a\u001b\u0005\u0002\u0005u\u0014!\u0002;sC&tG#\u0004\n\u0002\u0000\u0005\u0005\u00151QAC\u0003\u000f\u000bI\t\u0003\u0005\u0002N\u0005e\u0004\u0019AA(\u0011\u0019a\u0013\u0011\u0010a\u0001]!1A$!\u001fA\u0002yAa\u0001OA=\u0001\u0004q\u0002B\u0002!\u0002z\u0001\u0007a\u0004\u0003\u0005\u0002d\u0005e\u0004\u0019AA\u001e\u0011!\tY(a\u001b\u0005\u0002\u00055Ec\u0003\n\u0002\u0010\u0006E\u00151SAK\u0003/C\u0001\"!\u0014\u0002\f\u0002\u0007\u0011q\n\u0005\u0007Y\u0005-\u0005\u0019\u0001\u0018\t\rq\tY\t1\u0001\u001f\u0011\u0019A\u00141\u0012a\u0001=!1\u0001)a#A\u0002yA\u0001\"a\u001f\u0002l\u0011\u0005\u00111\u0014\u000b\n%\u0005u\u0015qTAQ\u0003GC\u0001\"!\u0014\u0002\u001a\u0002\u0007\u0011q\n\u0005\u0007Y\u0005e\u0005\u0019\u0001\u0018\t\rq\tI\n1\u0001\u001f\u0011\u0019A\u0014\u0011\u0014a\u0001=!A\u00111PA6\t\u0003\t9\u000bF\u0003\u0013\u0003S\u000bY\u000b\u0003\u0005\u0002N\u0005\u0015\u0006\u0019AA(\u0011\u0019a\u0013Q\u0015a\u0001]!A\u0011qVA6\t\u0003\t\t,\u0001\u0003nC&tGc\u0001\u0013\u00024\"A\u0011QWAW\u0001\u0004\t9,\u0001\u0003be\u001e\u001c\b#\u0002\f\u0002>\u0005e\u0006\u0003BA^\u0003\u0003t1AFA_\u0013\r\tylF\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0017Q\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}v\u0003\u0003\u0006\u0002J\u0006-\u0014\u0011!C\u0005\u0003\u0017\f1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u001a\t\u0005\u0003\u001f\fI.\u0004\u0002\u0002R*!\u00111[Ak\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0017\u0001\u00026bm\u0006LA!a7\u0002R\n1qJ\u00196fGR\u0004")
public class LassoWithSGD
extends GeneralizedLinearAlgorithm<LassoModel>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final SquaredGradient gradient;
    private final L1Updater updater;
    private final transient GradientDescent optimizer;
    private double yMean;
    private DoubleMatrix xColMean;
    private DoubleMatrix xColSd;

    public static void main(String[] stringArray) {
        LassoWithSGD$.MODULE$.main(stringArray);
    }

    public static LassoModel train(RDD<LabeledPoint> rDD, int n) {
        return LassoWithSGD$.MODULE$.train(rDD, n);
    }

    public static LassoModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return LassoWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static LassoModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3) {
        return LassoWithSGD$.MODULE$.train(rDD, n, d, d2, d3);
    }

    public static LassoModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3, double[] dArray) {
        return LassoWithSGD$.MODULE$.train(rDD, n, d, d2, d3, dArray);
    }

    public double stepSize() {
        return this.stepSize;
    }

    public void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    public int numIterations() {
        return this.numIterations;
    }

    public void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    public double regParam() {
        return this.regParam;
    }

    public void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    public double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    public void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    public SquaredGradient gradient() {
        return this.gradient;
    }

    public L1Updater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    public double yMean() {
        return this.yMean;
    }

    public void yMean_$eq(double x$1) {
        this.yMean = x$1;
    }

    public DoubleMatrix xColMean() {
        return this.xColMean;
    }

    public void xColMean_$eq(DoubleMatrix x$1) {
        this.xColMean = x$1;
    }

    public DoubleMatrix xColSd() {
        return this.xColSd;
    }

    public void xColSd_$eq(DoubleMatrix x$1) {
        this.xColSd = x$1;
    }

    public LassoWithSGD setIntercept(boolean addIntercept) {
        if (addIntercept) {
            throw new UnsupportedOperationException("Adding intercept is not supported.");
        }
        return this;
    }

    @Override
    public LassoModel createModel(double[] weights, double intercept) {
        DoubleMatrix weightsMat = new DoubleMatrix(weights.length, 1, weights);
        DoubleMatrix weightsScaled = weightsMat.div(this.xColSd());
        double interceptScaled = this.yMean() - weightsMat.transpose().mmul(this.xColMean().div(this.xColSd())).get(0);
        return new LassoModel(weightsScaled.data, interceptScaled);
    }

    @Override
    public LassoModel run(RDD<LabeledPoint> input, double[] initialWeights) {
        int nfeatures = ((LabeledPoint)input.first()).features().length;
        long nexamples = input.count();
        Tuple3<Object, DoubleMatrix, DoubleMatrix> stats = MLUtils$.MODULE$.computeStats(input, nfeatures, nexamples);
        this.yMean_$eq(BoxesRunTime.unboxToDouble((Object)stats._1()));
        this.xColMean_$eq((DoubleMatrix)stats._2());
        this.xColSd_$eq((DoubleMatrix)stats._3());
        RDD normalizedData = input.map((Function1)new Serializable(this, nfeatures){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LassoWithSGD $outer;
            private final int nfeatures$1;

            public final LabeledPoint apply(LabeledPoint point) {
                double yNormalized = point.label() - this.$outer.yMean();
                DoubleMatrix featuresMat = new DoubleMatrix(this.nfeatures$1, 1, point.features());
                DoubleMatrix featuresNormalized = featuresMat.sub(this.$outer.xColMean()).divi(this.$outer.xColSd());
                return new LabeledPoint(yNormalized, featuresNormalized.toArray());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nfeatures$1 = nfeatures$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        return (LassoModel)super.run((RDD<LabeledPoint>)normalizedData, initialWeights);
    }

    public LassoWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new SquaredGradient();
        this.updater = new L1Updater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
        super.setIntercept(false);
        this.yMean = 0.0;
    }

    public LassoWithSGD() {
        this(1.0, 100, 1.0, 1.0);
    }
}

