/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class LinearRegressionWithSGD$
implements Serializable {
    public static final LinearRegressionWithSGD$ MODULE$;

    static {
        new LinearRegressionWithSGD$();
    }

    public LinearRegressionModel train(RDD<LabeledPoint> input, int numIterations, double stepSize, double miniBatchFraction, double[] initialWeights) {
        return (LinearRegressionModel)new LinearRegressionWithSGD(stepSize, numIterations, miniBatchFraction).run(input, initialWeights);
    }

    public LinearRegressionModel train(RDD<LabeledPoint> input, int numIterations, double stepSize, double miniBatchFraction) {
        return (LinearRegressionModel)new LinearRegressionWithSGD(stepSize, numIterations, miniBatchFraction).run(input);
    }

    public LinearRegressionModel train(RDD<LabeledPoint> input, int numIterations, double stepSize) {
        return this.train(input, numIterations, stepSize, 1.0);
    }

    public LinearRegressionModel train(RDD<LabeledPoint> input, int numIterations) {
        return this.train(input, numIterations, 1.0, 1.0);
    }

    public void main(String[] args) {
        if (args.length != 5) {
            Predef$.MODULE$.println((Object)"Usage: LinearRegression <master> <input_dir> <step_size> <niters>");
            System.exit(1);
        }
        SparkContext sc = new SparkContext(args[0], "LinearRegression", SparkContext$.MODULE$.$lessinit$greater$default$3(), SparkContext$.MODULE$.$lessinit$greater$default$4(), SparkContext$.MODULE$.$lessinit$greater$default$5(), SparkContext$.MODULE$.$lessinit$greater$default$6());
        RDD<LabeledPoint> data = MLUtils$.MODULE$.loadLabeledData(sc, args[1]);
        LinearRegressionModel model = this.train(data, new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt(), new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Weights: ").append((Object)Predef$.MODULE$.doubleArrayOps(model.weights()).mkString("[", ", ", "]")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Intercept: ").append((Object)BoxesRunTime.boxToDouble((double)model.intercept())).toString());
        sc.stop();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LinearRegressionWithSGD$() {
        MODULE$ = this;
    }
}

