/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.SquaredGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Function1;
import scala.Serializable;
import scala.Tuple3;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u00015\u0011aCU5eO\u0016\u0014Vm\u001a:fgNLwN\\,ji\"\u001cv\t\u0012\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0016!\ry\u0001CE\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u001b\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014\u0018\t\\4pe&$\b.\u001c\t\u0003\u001fMI!\u0001\u0006\u0002\u0003)IKGmZ3SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!a\u0002A!a\u0001\n\u0003i\u0012\u0001C:uKB\u001c\u0016N_3\u0016\u0003y\u0001\"AF\u0010\n\u0005\u0001:\"A\u0002#pk\ndW\r\u0003\u0005#\u0001\t\u0005\r\u0011\"\u0001$\u00031\u0019H/\u001a9TSj,w\fJ3r)\t!s\u0005\u0005\u0002\u0017K%\u0011ae\u0006\u0002\u0005+:LG\u000fC\u0004)C\u0005\u0005\t\u0019\u0001\u0010\u0002\u0007a$\u0013\u0007\u0003\u0005+\u0001\t\u0005\t\u0015)\u0003\u001f\u0003%\u0019H/\u001a9TSj,\u0007\u0005\u0003\u0005-\u0001\t\u0005\r\u0011\"\u0001.\u00035qW/\\%uKJ\fG/[8ogV\ta\u0006\u0005\u0002\u0017_%\u0011\u0001g\u0006\u0002\u0004\u0013:$\b\u0002\u0003\u001a\u0001\u0005\u0003\u0007I\u0011A\u001a\u0002#9,X.\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002%i!9\u0001&MA\u0001\u0002\u0004q\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0018\u0002\u001d9,X.\u0013;fe\u0006$\u0018n\u001c8tA!A\u0001\b\u0001BA\u0002\u0013\u0005Q$\u0001\u0005sK\u001e\u0004\u0016M]1n\u0011!Q\u0004A!a\u0001\n\u0003Y\u0014\u0001\u0004:fOB\u000b'/Y7`I\u0015\fHC\u0001\u0013=\u0011\u001dA\u0013(!AA\u0002yA\u0001B\u0010\u0001\u0003\u0002\u0003\u0006KAH\u0001\ne\u0016<\u0007+\u0019:b[\u0002B\u0001\u0002\u0011\u0001\u0003\u0002\u0004%\t!H\u0001\u0012[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\u0002\u0003\"\u0001\u0005\u0003\u0007I\u0011A\"\u0002+5Lg.\u001b\"bi\u000eDgI]1di&|gn\u0018\u0013fcR\u0011A\u0005\u0012\u0005\bQ\u0005\u000b\t\u00111\u0001\u001f\u0011!1\u0005A!A!B\u0013q\u0012AE7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\u0002BQ\u0001\u0013\u0001\u0005\n%\u000ba\u0001P5oSRtD#\u0002&L\u00196s\u0005CA\b\u0001\u0011\u0015ar\t1\u0001\u001f\u0011\u0015as\t1\u0001/\u0011\u0015At\t1\u0001\u001f\u0011\u0015\u0001u\t1\u0001\u001f\u0011\u001d\u0001\u0006A1A\u0005\u0002E\u000b\u0001b\u001a:bI&,g\u000e^\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011Q\u000bB\u0001\r_B$\u0018.\\5{CRLwN\\\u0005\u0003/R\u0013qbU9vCJ,Gm\u0012:bI&,g\u000e\u001e\u0005\u00073\u0002\u0001\u000b\u0011\u0002*\u0002\u0013\u001d\u0014\u0018\rZ5f]R\u0004\u0003bB.\u0001\u0005\u0004%\t\u0001X\u0001\bkB$\u0017\r^3s+\u0005i\u0006CA*_\u0013\tyFK\u0001\tTcV\f'/\u001a3MeU\u0003H-\u0019;fe\"1\u0011\r\u0001Q\u0001\nu\u000b\u0001\"\u001e9eCR,'\u000f\t\u0005\bG\u0002\u0011\r\u0011\"\u0001e\u0003%y\u0007\u000f^5nSj,'/F\u0001f!\t\u0019f-\u0003\u0002h)\nyqI]1eS\u0016tG\u000fR3tG\u0016tG\u000f\u0003\u0004j\u0001\u0001\u0006I!Z\u0001\u000b_B$\u0018.\\5{KJ\u0004\u0003F\u00015l!\t1B.\u0003\u0002n/\tIAO]1og&,g\u000e\u001e\u0005\b_\u0002\u0001\r\u0011\"\u0001\u001e\u0003\u0015IX*Z1o\u0011\u001d\t\b\u00011A\u0005\u0002I\f\u0011\"_'fC:|F%Z9\u0015\u0005\u0011\u001a\bb\u0002\u0015q\u0003\u0003\u0005\rA\b\u0005\u0007k\u0002\u0001\u000b\u0015\u0002\u0010\u0002\relU-\u00198!\u0011%9\b\u00011AA\u0002\u0013\u0005\u00010\u0001\u0005y\u0007>dW*Z1o+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?\u000b\u0003\u0015Q'\r\\1t\u0013\tq8P\u0001\u0007E_V\u0014G.Z'biJL\u0007\u0010C\u0006\u0002\u0002\u0001\u0001\r\u00111A\u0005\u0002\u0005\r\u0011\u0001\u0004=D_2lU-\u00198`I\u0015\fHc\u0001\u0013\u0002\u0006!9\u0001f`A\u0001\u0002\u0004I\bbBA\u0005\u0001\u0001\u0006K!_\u0001\nq\u000e{G.T3b]\u0002B!\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0001y\u0003\u0019A8i\u001c7TI\"Y\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011AA\n\u0003)A8i\u001c7TI~#S-\u001d\u000b\u0004I\u0005U\u0001\u0002\u0003\u0015\u0002\u0010\u0005\u0005\t\u0019A=\t\u000f\u0005e\u0001\u0001)Q\u0005s\u00069\u0001pQ8m'\u0012\u0004\u0003B\u0002%\u0001\t\u0003\ti\u0002F\u0001K\u0011\u001d\t\t\u0003\u0001C!\u0003G\tAb]3u\u0013:$XM]2faR$B!!\n\u0002(5\t\u0001\u0001\u0003\u0005\u0002*\u0005}\u0001\u0019AA\u0016\u00031\tG\rZ%oi\u0016\u00148-\u001a9u!\r1\u0012QF\u0005\u0004\u0003_9\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003g\u0001A\u0011IA\u001b\u0003-\u0019'/Z1uK6{G-\u001a7\u0015\u000bI\t9$!\u0011\t\u0011\u0005e\u0012\u0011\u0007a\u0001\u0003w\tqa^3jO\"$8\u000f\u0005\u0003\u0017\u0003{q\u0012bAA /\t)\u0011I\u001d:bs\"9\u00111IA\u0019\u0001\u0004q\u0012!C5oi\u0016\u00148-\u001a9u\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\n1A];o)\u0015\u0011\u00121JA1\u0011!\ti%!\u0012A\u0002\u0005=\u0013!B5oaV$\bCBA)\u0003/\nY&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u0004\u0002\u0007I$G-\u0003\u0003\u0002Z\u0005M#a\u0001*E\tB\u0019q\"!\u0018\n\u0007\u0005}#A\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u0003\u0005\u0002d\u0005\u0015\u0003\u0019AA\u001e\u00039Ig.\u001b;jC2<V-[4iiN<q!a\u001a\u0003\u0011\u0003\tI'\u0001\fSS\u0012<WMU3he\u0016\u001c8/[8o/&$\bnU$E!\ry\u00111\u000e\u0004\u0007\u0003\tA\t!!\u001c\u0014\u000b\u0005-\u0014qN\u000b\u0011\u0007Y\t\t(C\u0002\u0002t]\u0011a!\u00118z%\u00164\u0007b\u0002%\u0002l\u0011\u0005\u0011q\u000f\u000b\u0003\u0003SB\u0001\"a\u001f\u0002l\u0011\u0005\u0011QP\u0001\u0006iJ\f\u0017N\u001c\u000b\u000e%\u0005}\u0014\u0011QAB\u0003\u000b\u000b9)!#\t\u0011\u00055\u0013\u0011\u0010a\u0001\u0003\u001fBa\u0001LA=\u0001\u0004q\u0003B\u0002\u000f\u0002z\u0001\u0007a\u0004\u0003\u00049\u0003s\u0002\rA\b\u0005\u0007\u0001\u0006e\u0004\u0019\u0001\u0010\t\u0011\u0005\r\u0014\u0011\u0010a\u0001\u0003wA\u0001\"a\u001f\u0002l\u0011\u0005\u0011Q\u0012\u000b\f%\u0005=\u0015\u0011SAJ\u0003+\u000b9\n\u0003\u0005\u0002N\u0005-\u0005\u0019AA(\u0011\u0019a\u00131\u0012a\u0001]!1A$a#A\u0002yAa\u0001OAF\u0001\u0004q\u0002B\u0002!\u0002\f\u0002\u0007a\u0004\u0003\u0005\u0002|\u0005-D\u0011AAN)%\u0011\u0012QTAP\u0003C\u000b\u0019\u000b\u0003\u0005\u0002N\u0005e\u0005\u0019AA(\u0011\u0019a\u0013\u0011\u0014a\u0001]!1A$!'A\u0002yAa\u0001OAM\u0001\u0004q\u0002\u0002CA>\u0003W\"\t!a*\u0015\u000bI\tI+a+\t\u0011\u00055\u0013Q\u0015a\u0001\u0003\u001fBa\u0001LAS\u0001\u0004q\u0003\u0002CAX\u0003W\"\t!!-\u0002\t5\f\u0017N\u001c\u000b\u0004I\u0005M\u0006\u0002CA[\u0003[\u0003\r!a.\u0002\t\u0005\u0014xm\u001d\t\u0006-\u0005u\u0012\u0011\u0018\t\u0005\u0003w\u000b\tMD\u0002\u0017\u0003{K1!a0\u0018\u0003\u0019\u0001&/\u001a3fM&!\u00111YAc\u0005\u0019\u0019FO]5oO*\u0019\u0011qX\f\t\u0015\u0005%\u00171NA\u0001\n\u0013\tY-A\u0006sK\u0006$'+Z:pYZ,GCAAg!\u0011\ty-!7\u000e\u0005\u0005E'\u0002BAj\u0003+\fA\u0001\\1oO*\u0011\u0011q[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\\\u0006E'AB(cU\u0016\u001cG\u000f")
public class RidgeRegressionWithSGD
extends GeneralizedLinearAlgorithm<RidgeRegressionModel>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final SquaredGradient gradient;
    private final SquaredL2Updater updater;
    private final transient GradientDescent optimizer;
    private double yMean;
    private DoubleMatrix xColMean;
    private DoubleMatrix xColSd;

    public static void main(String[] stringArray) {
        RidgeRegressionWithSGD$.MODULE$.main(stringArray);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3, double[] dArray) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3, dArray);
    }

    public double stepSize() {
        return this.stepSize;
    }

    public void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    public int numIterations() {
        return this.numIterations;
    }

    public void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    public double regParam() {
        return this.regParam;
    }

    public void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    public double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    public void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    public SquaredGradient gradient() {
        return this.gradient;
    }

    public SquaredL2Updater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    public double yMean() {
        return this.yMean;
    }

    public void yMean_$eq(double x$1) {
        this.yMean = x$1;
    }

    public DoubleMatrix xColMean() {
        return this.xColMean;
    }

    public void xColMean_$eq(DoubleMatrix x$1) {
        this.xColMean = x$1;
    }

    public DoubleMatrix xColSd() {
        return this.xColSd;
    }

    public void xColSd_$eq(DoubleMatrix x$1) {
        this.xColSd = x$1;
    }

    public RidgeRegressionWithSGD setIntercept(boolean addIntercept) {
        if (addIntercept) {
            throw new UnsupportedOperationException("Adding intercept is not supported.");
        }
        return this;
    }

    @Override
    public RidgeRegressionModel createModel(double[] weights, double intercept) {
        DoubleMatrix weightsMat = new DoubleMatrix(weights.length, 1, weights);
        DoubleMatrix weightsScaled = weightsMat.div(this.xColSd());
        double interceptScaled = this.yMean() - weightsMat.transpose().mmul(this.xColMean().div(this.xColSd())).get(0);
        return new RidgeRegressionModel(weightsScaled.data, interceptScaled);
    }

    @Override
    public RidgeRegressionModel run(RDD<LabeledPoint> input, double[] initialWeights) {
        int nfeatures = ((LabeledPoint)input.first()).features().length;
        long nexamples = input.count();
        Tuple3<Object, DoubleMatrix, DoubleMatrix> stats = MLUtils$.MODULE$.computeStats(input, nfeatures, nexamples);
        this.yMean_$eq(BoxesRunTime.unboxToDouble((Object)stats._1()));
        this.xColMean_$eq((DoubleMatrix)stats._2());
        this.xColSd_$eq((DoubleMatrix)stats._3());
        RDD normalizedData = input.map((Function1)new Serializable(this, nfeatures){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RidgeRegressionWithSGD $outer;
            private final int nfeatures$1;

            public final LabeledPoint apply(LabeledPoint point) {
                double yNormalized = point.label() - this.$outer.yMean();
                DoubleMatrix featuresMat = new DoubleMatrix(this.nfeatures$1, 1, point.features());
                DoubleMatrix featuresNormalized = featuresMat.sub(this.$outer.xColMean()).divi(this.$outer.xColSd());
                return new LabeledPoint(yNormalized, featuresNormalized.toArray());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nfeatures$1 = nfeatures$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        return (RidgeRegressionModel)super.run((RDD<LabeledPoint>)normalizedData, initialWeights);
    }

    public RidgeRegressionWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new SquaredGradient();
        this.updater = new SquaredL2Updater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
        super.setIntercept(false);
        this.yMean = 0.0;
    }

    public RidgeRegressionWithSGD() {
        this(1.0, 100, 1.0, 1.0);
    }
}

