/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MLUtils$ {
    public static final MLUtils$ MODULE$;

    static {
        new MLUtils$();
    }

    public RDD<LabeledPoint> loadLabeledData(SparkContext sc, String dir) {
        return sc.textFile(dir, sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String line) {
                String[] parts = new StringOps(Predef$.MODULE$.augmentString(line)).split(',');
                double label = new StringOps(Predef$.MODULE$.augmentString(parts[0])).toDouble();
                double[] features = (double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(parts[1].trim())).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                return new LabeledPoint(label, features);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public void saveLabeledData(RDD<LabeledPoint> data, String dir) {
        RDD dataStr = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(LabeledPoint x) {
                return new StringBuilder().append(x.label()).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps(x.features()).mkString(" ")).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        dataStr.saveAsTextFile(dir);
    }

    public Tuple3<Object, DoubleMatrix, DoubleMatrix> computeStats(RDD<LabeledPoint> data, int nfeatures, long nexamples) {
        double yMean = BoxesRunTime.unboxToDouble((Object)data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(LabeledPoint labeledPoint) {
                return labeledPoint.label();
            }
        }, ClassTag$.MODULE$.Double()).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$2, double x$3) {
                return this.apply$mcDDD$sp(x$2, x$3);
            }

            public double apply$mcDDD$sp(double x$2, double x$3) {
                return x$2 + x$3;
            }
        })) / (double)nexamples;
        RDD xColSumSq = SparkContext$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple2<Object, Tuple2<Object, Object>>> apply(LabeledPoint labeledPoint) {
                int nCols = labeledPoint.features().length;
                return scala.package$.MODULE$.Iterator().tabulate(nCols, (Function1)new Serializable(this, labeledPoint){
                    public static final long serialVersionUID = 0L;
                    private final LabeledPoint labeledPoint$1;

                    public final Tuple2<Object, Tuple2<Object, Object>> apply(int i) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new Tuple2.mcDD.sp(this.labeledPoint$1.features()[i], this.labeledPoint$1.features()[i] * this.labeledPoint$1.features()[i]));
                    }
                    {
                        this.labeledPoint$1 = labeledPoint$1;
                    }
                });
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class)).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1, Tuple2<Object, Object> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Tuple2 x1 = (Tuple2)tuple2._1();
                    Tuple2 x2 = (Tuple2)tuple2._2();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x1._1$mcD$sp() + x2._1$mcD$sp(), x1._2$mcD$sp() + x2._2$mcD$sp());
                    return sp2;
                }
                throw new MatchError((Object)tuple2);
            }
        });
        Map xColSumsMap = SparkContext$.MODULE$.rddToPairRDDFunctions(xColSumSq, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class)).collectAsMap();
        DoubleMatrix xColMean = DoubleMatrix.zeros((int)nfeatures, (int)1);
        DoubleMatrix xColSd = DoubleMatrix.zeros((int)nfeatures, (int)1);
        for (int col = 0; col < nfeatures; ++col) {
            xColMean.put(col, ((Tuple2)xColSumsMap.apply((Object)BoxesRunTime.boxToInteger((int)col)))._1$mcD$sp() / (double)nexamples);
            double variance = (((Tuple2)xColSumsMap.apply((Object)BoxesRunTime.boxToInteger((int)col)))._2$mcD$sp() - package$.MODULE$.pow(((Tuple2)xColSumsMap.apply((Object)BoxesRunTime.boxToInteger((int)col)))._1$mcD$sp(), 2.0) / (double)nexamples) / (double)nexamples;
            xColSd.put(col, package$.MODULE$.sqrt(variance));
        }
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)yMean), (Object)xColMean, (Object)xColSd);
    }

    public double squaredDistance(double[] v1, double[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vector sizes don't match");
        }
        double sum = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            sum += (v1[i] - v2[i]) * (v1[i] - v2[i]);
        }
        return sum;
    }

    private MLUtils$() {
        MODULE$ = this;
    }
}

