/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD$;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMWithSGD$;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LassoWithSGD$;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001B\u0001\u0003\u0001=\u0011a\u0002U=uQ>tW\n\u0014'jE\u0006\u0003\u0016J\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)Q\u000e\u001c7jE*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003#]I!\u0001\u0007\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001bB\u0010\u0001\u0005\u0004%I\u0001I\u0001\u0013\t\u0016s5+R0W\u000b\u000e#vJU0N\u0003\u001eK5)F\u0001\"!\t\t\"%\u0003\u0002$%\t!!)\u001f;f\u0011\u0019)\u0003\u0001)A\u0005C\u0005\u0019B)\u0012(T\u000b~3Vi\u0011+P%~k\u0015iR%DA!9q\u0005\u0001b\u0001\n\u0013\u0001\u0013aE*Q\u0003J\u001bVi\u0018,F\u0007R{%kX'B\u000f&\u001b\u0005BB\u0015\u0001A\u0003%\u0011%\u0001\u000bT!\u0006\u00136+R0W\u000b\u000e#vJU0N\u0003\u001eK5\t\t\u0005\bW\u0001\u0011\r\u0011\"\u0003!\u0003I!UIT*F?6\u000bEKU%Y?6\u000bu)S\"\t\r5\u0002\u0001\u0015!\u0003\"\u0003M!UIT*F?6\u000bEKU%Y?6\u000bu)S\"!\u0011\u001dy\u0003A1A\u0005\n\u0001\n1\u0003T!C\u000b2+Ei\u0018)P\u0013:#v,T!H\u0013\u000eCa!\r\u0001!\u0002\u0013\t\u0013\u0001\u0006'B\u0005\u0016cU\tR0Q\u001f&sEkX'B\u000f&\u001b\u0005\u0005C\u00034\u0001\u0011%A'A\feKN,'/[1mSj,Gi\\;cY\u00164Vm\u0019;peR\u0019Qg\u000f!\u0011\u0005YJT\"A\u001c\u000b\u0005a2\u0011A\u00027j]\u0006dw-\u0003\u0002;o\t1a+Z2u_JDQ\u0001\u0010\u001aA\u0002u\nQAY=uKN\u00042!\u0005 \"\u0013\ty$CA\u0003BeJ\f\u0017\u0010C\u0004BeA\u0005\t\u0019\u0001\"\u0002\r=4gm]3u!\t\t2)\u0003\u0002E%\t\u0019\u0011J\u001c;\t\u000b\u0019\u0003A\u0011B$\u0002-\u0011,7/\u001a:jC2L'0\u001a#f]N,g+Z2u_J$2!\u000e%J\u0011\u0015aT\t1\u0001>\u0011\u001d\tU\t%AA\u0002\tCQa\u0013\u0001\u0005\n1\u000bq\u0003Z3tKJL\u0017\r\\5{KN\u0003\u0018M]:f-\u0016\u001cGo\u001c:\u0015\u0007Uje\nC\u0003=\u0015\u0002\u0007Q\bC\u0004B\u0015B\u0005\t\u0019\u0001\"\t\u000bA\u0003A\u0011B)\u0002)M,'/[1mSj,G)\u001a8tKZ+7\r^8s)\ti$\u000bC\u0003T\u001f\u0002\u0007A+A\u0004e_V\u0014G.Z:\u0011\u0007EqT\u000b\u0005\u0002\u0012-&\u0011qK\u0005\u0002\u0007\t>,(\r\\3\t\u000be\u0003A\u0011\u0002.\u0002+M,'/[1mSj,7\u000b]1sg\u00164Vm\u0019;peR\u0011Qh\u0017\u0005\u00069b\u0003\r!X\u0001\u0007m\u0016\u001cGo\u001c:\u0011\u0005Yr\u0016BA08\u00051\u0019\u0006/\u0019:tKZ+7\r^8s\u0011\u0015\t\u0007\u0001\"\u0003c\u0003U\u0019XM]5bY&TX\rR8vE2,g+Z2u_J$\"!P2\t\u000bq\u0003\u0007\u0019A\u001b\t\u000b\u0015\u0004A\u0011\u00024\u0002/\u0011,7/\u001a:jC2L'0\u001a#pk\ndW-T1ue&DHCA4i!\r\tb\b\u0016\u0005\u0006y\u0011\u0004\r!\u0010\u0005\u0006U\u0002!Ia[\u0001\u0016g\u0016\u0014\u0018.\u00197ju\u0016$u.\u001e2mK6\u000bGO]5y)\tiD\u000eC\u0003TS\u0002\u0007q\rC\u0003o\u0001\u0011%q.A\feKN,'/[1mSj,G*\u00192fY\u0016$\u0007k\\5oiR\u0011\u0001O\u001e\t\u0003cRl\u0011A\u001d\u0006\u0003g\u001a\t!B]3he\u0016\u001c8/[8o\u0013\t)(O\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fC\u0003=[\u0002\u0007Q\bC\u0003y\u0001\u0011%\u00110\u0001\u000bue\u0006LgNU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u000b\bu\u0006E\u0011QFA\u001f!\u0015Y\u0018\u0011AA\u0003\u001b\u0005a(BA?\u007f\u0003\u0011)H/\u001b7\u000b\u0003}\fAA[1wC&\u0019\u00111\u0001?\u0003\u00151Kgn[3e\u0019&\u001cH\u000f\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tYA`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0010\u0005%!AB(cU\u0016\u001cG\u000fC\u0004\u0002\u0014]\u0004\r!!\u0006\u0002\u0013Q\u0014\u0018-\u001b8Gk:\u001c\u0007\u0003C\t\u0002\u0018\u0005mQ'a\n\n\u0007\u0005e!CA\u0005Gk:\u001cG/[8oeA)\u0011QDA\u0012a6\u0011\u0011q\u0004\u0006\u0004\u0003CA\u0011a\u0001:eI&!\u0011QEA\u0010\u0005\r\u0011F\t\u0012\t\u0004c\u0006%\u0012bAA\u0016e\n1r)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:N_\u0012,G\u000eC\u0004\u00020]\u0004\r!!\r\u0002\u001b\u0011\fG/\u0019\"zi\u0016\u001c(J\u0015#E!\u0015\t\u0019$!\u000f>\u001b\t\t)DC\u0002\u0000\u0003oQ!!\u0002\u0005\n\t\u0005m\u0012Q\u0007\u0002\b\u0015\u00064\u0018M\u0015#E\u0011\u0019\tyd\u001ea\u0001{\u0005\u0001\u0012N\\5uS\u0006dw+Z5hQR\u001c()\u0011\u0005\b\u0003\u0007\u0002A\u0011AA#\u0003\u0005\"(/Y5o\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:lu\u000eZ3m/&$\bnU$E)1\t9%!\u0014\u0002P\u0005M\u0013qKA.!\u0015Y\u0018\u0011JA\u0003\u0013\r\tY\u0005 \u0002\u0005\u0019&\u001cH\u000f\u0003\u0005\u00020\u0005\u0005\u0003\u0019AA\u0019\u0011\u001d\t\t&!\u0011A\u0002\t\u000bQB\\;n\u0013R,'/\u0019;j_:\u001c\bbBA+\u0003\u0003\u0002\r!V\u0001\tgR,\u0007oU5{K\"9\u0011\u0011LA!\u0001\u0004)\u0016!E7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\"9\u0011qHA!\u0001\u0004i\u0004bBA0\u0001\u0011\u0005\u0011\u0011M\u0001\u0017iJ\f\u0017N\u001c'bgN|Wj\u001c3fY^KG\u000f[*H\tRq\u0011qIA2\u0003K\n9'!\u001b\u0002n\u0005=\u0004\u0002CA\u0018\u0003;\u0002\r!!\r\t\u000f\u0005E\u0013Q\fa\u0001\u0005\"9\u0011QKA/\u0001\u0004)\u0006bBA6\u0003;\u0002\r!V\u0001\te\u0016<\u0007+\u0019:b[\"9\u0011\u0011LA/\u0001\u0004)\u0006bBA \u0003;\u0002\r!\u0010\u0005\b\u0003g\u0002A\u0011AA;\u0003Y!(/Y5o%&$w-Z'pI\u0016dw+\u001b;i'\u001e#ECDA$\u0003o\nI(a\u001f\u0002~\u0005}\u0014\u0011\u0011\u0005\t\u0003_\t\t\b1\u0001\u00022!9\u0011\u0011KA9\u0001\u0004\u0011\u0005bBA+\u0003c\u0002\r!\u0016\u0005\b\u0003W\n\t\b1\u0001V\u0011\u001d\tI&!\u001dA\u0002UCq!a\u0010\u0002r\u0001\u0007Q\bC\u0004\u0002\u0006\u0002!\t!a\"\u0002)Q\u0014\u0018-\u001b8T-6ku\u000eZ3m/&$\bnU$E)9\t9%!#\u0002\f\u00065\u0015qRAI\u0003'C\u0001\"a\f\u0002\u0004\u0002\u0007\u0011\u0011\u0007\u0005\b\u0003#\n\u0019\t1\u0001C\u0011\u001d\t)&a!A\u0002UCq!a\u001b\u0002\u0004\u0002\u0007Q\u000bC\u0004\u0002Z\u0005\r\u0005\u0019A+\t\u000f\u0005}\u00121\u0011a\u0001{!9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0015a\t;sC&tGj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\\,ji\"\u001cv\t\u0012\u000b\r\u0003\u000f\nY*!(\u0002 \u0006\u0005\u00161\u0015\u0005\t\u0003_\t)\n1\u0001\u00022!9\u0011\u0011KAK\u0001\u0004\u0011\u0005bBA+\u0003+\u0003\r!\u0016\u0005\b\u00033\n)\n1\u0001V\u0011\u001d\ty$!&A\u0002uBq!a*\u0001\t\u0003\tI+A\bue\u0006LgNT1jm\u0016\u0014\u0015-_3t)\u0019\t9%a+\u0002.\"A\u0011qFAS\u0001\u0004\t\t\u0004C\u0004\u00020\u0006\u0015\u0006\u0019A+\u0002\r1\fWN\u00193b\u0011\u001d\t\u0019\f\u0001C\u0001\u0003k\u000b\u0001\u0003\u001e:bS:\\U*Z1og6{G-\u001a7\u0015\u0019\u0005\u001d\u0013qWA]\u0003{\u000b\t-!2\t\u0011\u0005=\u0012\u0011\u0017a\u0001\u0003cAq!a/\u00022\u0002\u0007!)A\u0001l\u0011\u001d\ty,!-A\u0002\t\u000bQ\"\\1y\u0013R,'/\u0019;j_:\u001c\bbBAb\u0003c\u0003\rAQ\u0001\u0005eVt7\u000f\u0003\u0005\u0002H\u0006E\u0006\u0019AAe\u0003IIg.\u001b;jC2L'0\u0019;j_:lu\u000eZ3\u0011\t\u0005-\u0017\u0011\u001b\b\u0004#\u00055\u0017bAAh%\u00051\u0001K]3eK\u001aLA!a5\u0002V\n11\u000b\u001e:j]\u001eT1!a4\u0013\u0011\u001d\tI\u000e\u0001C\u0005\u00037\fA\"\u001e8qC\u000e\\'+\u0019;j]\u001e$B!!8\u0002jB!\u0011q\\As\u001b\t\t\tOC\u0002\u0002d\u001a\taB]3d_6lWM\u001c3bi&|g.\u0003\u0003\u0002h\u0006\u0005(A\u0002*bi&tw\rC\u0004\u0002l\u0006]\u0007\u0019A\u001f\u0002\u0017I\fG/\u001b8h\u0005f$Xm\u001d\u0005\t\u0003_\u0004A\u0011\u0001\u0005\u0002r\u0006YQO\u001c9bG.$V\u000f\u001d7f)\u0011\t\u00190!?\u0011\u000bE\t)P\u0011\"\n\u0007\u0005](C\u0001\u0004UkBdWM\r\u0005\b\u0003w\fi\u000f1\u0001>\u0003)!X\u000f\u001d7f\u0005f$Xm\u001d\u0005\t\u0003\u007f\u0004A\u0011\u0001\u0005\u0003\u0002\u0005y1/\u001a:jC2L'0\u001a*bi&tw\rF\u0002>\u0005\u0007A\u0001B!\u0002\u0002~\u0002\u0007\u0011Q\\\u0001\u0005e\u0006$X\rC\u0004\u0003\n\u0001!\tAa\u0003\u0002\u001bQ\u0014\u0018-\u001b8B\u0019Nku\u000eZ3m)1\u0011iAa\u0005\u0003\u0018\tm!q\u0004B\u0011!\u0011\tyNa\u0004\n\t\tE\u0011\u0011\u001d\u0002\u0019\u001b\u0006$(/\u001b=GC\u000e$xN]5{CRLwN\\'pI\u0016d\u0007\u0002\u0003B\u000b\u0005\u000f\u0001\r!!\r\u0002!I\fG/\u001b8hg\nKH/Z:K%\u0012#\u0005b\u0002B\r\u0005\u000f\u0001\rAQ\u0001\u0005e\u0006t7\u000eC\u0004\u0003\u001e\t\u001d\u0001\u0019\u0001\"\u0002\u0015%$XM]1uS>t7\u000fC\u0004\u00020\n\u001d\u0001\u0019A+\t\u000f\t\r\"q\u0001a\u0001\u0005\u00061!\r\\8dWNDqAa\n\u0001\t\u0003\u0011I#A\u000bue\u0006Lg.S7qY&\u001c\u0017\u000e^!M'6{G-\u001a7\u0015\u001d\t5!1\u0006B\u0017\u0005_\u0011\tDa\r\u00036!A!Q\u0003B\u0013\u0001\u0004\t\t\u0004C\u0004\u0003\u001a\t\u0015\u0002\u0019\u0001\"\t\u000f\tu!Q\u0005a\u0001\u0005\"9\u0011q\u0016B\u0013\u0001\u0004)\u0006b\u0002B\u0012\u0005K\u0001\rA\u0011\u0005\b\u0005o\u0011)\u00031\u0001V\u0003\u0015\tG\u000e\u001d5b\u0011%\u0011Y\u0004AI\u0001\n\u0013\u0011i$A\u0011eKN,'/[1mSj,Gi\\;cY\u00164Vm\u0019;pe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003@)\u001a!I!\u0011,\u0005\t\r\u0003\u0003\u0002B#\u0005\u001fj!Aa\u0012\u000b\t\t%#1J\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0014\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005#\u00129EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011B!\u0016\u0001#\u0003%IA!\u0010\u0002A\u0011,7/\u001a:jC2L'0\u001a#f]N,g+Z2u_J$C-\u001a4bk2$HE\r\u0005\n\u00053\u0002\u0011\u0013!C\u0005\u0005{\t\u0011\u0005Z3tKJL\u0017\r\\5{KN\u0003\u0018M]:f-\u0016\u001cGo\u001c:%I\u00164\u0017-\u001e7uIIB3\u0001\u0001B/!\u0011\u0011yFa\u0019\u000e\u0005\t\u0005$b\u0001B'\u0011%!!Q\rB1\u00051!UM^3m_B,'/\u00119j\u0001")
public class PythonMLLibAPI
implements Serializable {
    private final byte DENSE_VECTOR_MAGIC;
    private final byte SPARSE_VECTOR_MAGIC = (byte)2;
    private final byte DENSE_MATRIX_MAGIC = (byte)3;
    private final byte LABELED_POINT_MAGIC = (byte)4;

    private byte DENSE_VECTOR_MAGIC() {
        return this.DENSE_VECTOR_MAGIC;
    }

    private byte SPARSE_VECTOR_MAGIC() {
        return this.SPARSE_VECTOR_MAGIC;
    }

    private byte DENSE_MATRIX_MAGIC() {
        return this.DENSE_MATRIX_MAGIC;
    }

    private byte LABELED_POINT_MAGIC() {
        return this.LABELED_POINT_MAGIC;
    }

    public Vector org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector(byte[] bytes, int offset) {
        byte magic;
        block4: {
            Vector vector;
            block3: {
                block2: {
                    Predef$.MODULE$.require(bytes.length - offset >= 5, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Byte array too short";
                        }
                    });
                    magic = bytes[offset];
                    if (magic != this.DENSE_VECTOR_MAGIC()) break block2;
                    vector = this.deserializeDenseVector(bytes, offset);
                    break block3;
                }
                if (magic != this.SPARSE_VECTOR_MAGIC()) break block4;
                vector = this.deserializeSparseVector(bytes, offset);
            }
            return vector;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Magic ").append((Object)BoxesRunTime.boxToByte((byte)magic)).append((Object)" is wrong.").toString());
    }

    public int org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector$default$2() {
        return 0;
    }

    private Vector deserializeDenseVector(byte[] bytes, int offset) {
        int packetLength = bytes.length - offset;
        Predef$.MODULE$.require(packetLength >= 5, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Byte array too short";
            }
        });
        ByteBuffer bb = ByteBuffer.wrap(bytes, offset, bytes.length - offset);
        bb.order(ByteOrder.nativeOrder());
        byte magic = bb.get();
        Predef$.MODULE$.require(magic == this.DENSE_VECTOR_MAGIC(), (Function0)new Serializable(this, magic){
            public static final long serialVersionUID = 0L;
            private final byte magic$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid magic: ").append((Object)BoxesRunTime.boxToByte((byte)this.magic$1)).toString();
            }
            {
                this.magic$1 = magic$1;
            }
        });
        int length = bb.getInt();
        Predef$.MODULE$.require(packetLength == 5 + 8 * length, (Function0)new Serializable(this, packetLength){
            public static final long serialVersionUID = 0L;
            private final int packetLength$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid packet length: ").append((Object)BoxesRunTime.boxToInteger((int)this.packetLength$1)).toString();
            }
            {
                this.packetLength$1 = packetLength$1;
            }
        });
        DoubleBuffer db = bb.asDoubleBuffer();
        double[] ans = new double[length];
        db.get(ans);
        return Vectors$.MODULE$.dense(ans);
    }

    private int deserializeDenseVector$default$2() {
        return 0;
    }

    private Vector deserializeSparseVector(byte[] bytes, int offset) {
        int packetLength = bytes.length - offset;
        Predef$.MODULE$.require(packetLength >= 9, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Byte array too short";
            }
        });
        ByteBuffer bb = ByteBuffer.wrap(bytes, offset, bytes.length - offset);
        bb.order(ByteOrder.nativeOrder());
        byte magic = bb.get();
        Predef$.MODULE$.require(magic == this.SPARSE_VECTOR_MAGIC(), (Function0)new Serializable(this, magic){
            public static final long serialVersionUID = 0L;
            private final byte magic$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid magic: ").append((Object)BoxesRunTime.boxToByte((byte)this.magic$2)).toString();
            }
            {
                this.magic$2 = magic$2;
            }
        });
        int size = bb.getInt();
        int nonZeros = bb.getInt();
        Predef$.MODULE$.require(packetLength == 9 + 12 * nonZeros, (Function0)new Serializable(this, packetLength){
            public static final long serialVersionUID = 0L;
            private final int packetLength$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid packet length: ").append((Object)BoxesRunTime.boxToInteger((int)this.packetLength$2)).toString();
            }
            {
                this.packetLength$2 = packetLength$2;
            }
        });
        IntBuffer ib = bb.asIntBuffer();
        int[] indices = new int[nonZeros];
        ib.get(indices);
        bb.position(bb.position() + 4 * nonZeros);
        DoubleBuffer db = bb.asDoubleBuffer();
        double[] values = new double[nonZeros];
        db.get(values);
        return Vectors$.MODULE$.sparse(size, indices, values);
    }

    private int deserializeSparseVector$default$2() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] serializeDenseVector(double[] doubles) {
        void var3_3;
        int len = doubles.length;
        byte[] bytes = new byte[5 + 8 * len];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.put(this.DENSE_VECTOR_MAGIC());
        bb.putInt(len);
        DoubleBuffer db = bb.asDoubleBuffer();
        db.put(doubles);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] serializeSparseVector(SparseVector vector) {
        void var3_3;
        int nonZeros = vector.indices().length;
        byte[] bytes = new byte[9 + 12 * nonZeros];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.put(this.SPARSE_VECTOR_MAGIC());
        bb.putInt(vector.size());
        bb.putInt(nonZeros);
        IntBuffer ib = bb.asIntBuffer();
        ib.put(vector.indices());
        bb.position(bb.position() + 4 * nonZeros);
        DoubleBuffer db = bb.asDoubleBuffer();
        db.put(vector.values());
        return var3_3;
    }

    private byte[] serializeDoubleVector(Vector vector) {
        byte[] byArray;
        Vector vector2 = vector;
        if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            byArray = this.serializeSparseVector(sparseVector);
        } else {
            byArray = this.serializeDenseVector(vector.toArray());
        }
        return byArray;
    }

    private double[][] deserializeDoubleMatrix(byte[] bytes) {
        int cols;
        int packetLength = bytes.length;
        if (packetLength < 9) {
            throw new IllegalArgumentException("Byte array too short.");
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        byte magic = bb.get();
        if (magic != this.DENSE_MATRIX_MAGIC()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Magic ").append((Object)BoxesRunTime.boxToByte((byte)magic)).append((Object)" is wrong.").toString());
        }
        int rows = bb.getInt();
        if (packetLength != 9 + 8 * rows * (cols = bb.getInt())) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Size ").append((Object)BoxesRunTime.boxToInteger((int)rows)).append((Object)"x").append((Object)BoxesRunTime.boxToInteger((int)cols)).append((Object)" is wrong.").toString());
        }
        DoubleBuffer db = bb.asDoubleBuffer();
        double[][] ans = new double[rows][];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rows).foreach((Function1)new Serializable(this, cols, db, ans){
            public static final long serialVersionUID = 0L;
            private final int cols$1;
            private final DoubleBuffer db$1;
            private final double[][] ans$1;

            public final DoubleBuffer apply(int i) {
                this.ans$1[i] = new double[this.cols$1];
                return this.db$1.get(this.ans$1[i]);
            }
            {
                this.cols$1 = cols$1;
                this.db$1 = db$1;
                this.ans$1 = ans$1;
            }
        });
        return ans;
    }

    private byte[] serializeDoubleMatrix(double[][] doubles) {
        int rows = doubles.length;
        int cols = 0;
        if (rows > 0) {
            cols = doubles[0].length;
        }
        byte[] bytes = new byte[9 + 8 * rows * cols];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.put(this.DENSE_MATRIX_MAGIC());
        bb.putInt(rows);
        bb.putInt(cols);
        DoubleBuffer db = bb.asDoubleBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rows).foreach((Function1)new Serializable(this, doubles, db){
            public static final long serialVersionUID = 0L;
            private final double[][] doubles$1;
            private final DoubleBuffer db$2;

            public final DoubleBuffer apply(int i) {
                return this.db$2.put(this.doubles$1[i]);
            }
            {
                this.doubles$1 = doubles$1;
                this.db$2 = db$2;
            }
        });
        return bytes;
    }

    public LabeledPoint org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeLabeledPoint(byte[] bytes) {
        Predef$.MODULE$.require(bytes.length >= 9, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Byte array too short";
            }
        });
        byte magic = bytes[0];
        if (magic != this.LABELED_POINT_MAGIC()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Magic ").append((Object)BoxesRunTime.boxToByte((byte)magic)).append((Object)" is wrong.").toString());
        }
        ByteBuffer labelBytes = ByteBuffer.wrap(bytes, 1, 8);
        labelBytes.order(ByteOrder.nativeOrder());
        double label = labelBytes.asDoubleBuffer().get(0);
        return new LabeledPoint(label, this.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector(bytes, 9));
    }

    private LinkedList<Object> trainRegressionModel(Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel> trainFunc, JavaRDD<byte[]> dataBytesJRDD, byte[] initialWeightsBA) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final LabeledPoint apply(byte[] bytes) {
                return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeLabeledPoint(bytes);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        Vector initialWeights = this.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector(initialWeightsBA, this.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector$default$2());
        GeneralizedLinearModel model = (GeneralizedLinearModel)trainFunc.apply((Object)data, (Object)initialWeights);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(this.serializeDoubleVector(model.weights()));
        ret.add(Predef$.MODULE$.double2Double(model.intercept()));
        return ret;
    }

    public List<Object> trainLinearRegressionModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$1;
            private final double stepSize$1;
            private final double miniBatchFraction$1;

            public final LinearRegressionModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                return LinearRegressionWithSGD$.MODULE$.train(data, this.numIterations$1, this.stepSize$1, this.miniBatchFraction$1, initialWeights);
            }
            {
                this.numIterations$1 = numIterations$1;
                this.stepSize$1 = stepSize$1;
                this.miniBatchFraction$1 = miniBatchFraction$1;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainLassoModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double regParam, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, regParam, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$2;
            private final double stepSize$2;
            private final double regParam$1;
            private final double miniBatchFraction$2;

            public final LassoModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                return LassoWithSGD$.MODULE$.train(data, this.numIterations$2, this.stepSize$2, this.regParam$1, this.miniBatchFraction$2, initialWeights);
            }
            {
                this.numIterations$2 = numIterations$2;
                this.stepSize$2 = stepSize$2;
                this.regParam$1 = regParam$1;
                this.miniBatchFraction$2 = miniBatchFraction$2;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainRidgeModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double regParam, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, regParam, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$3;
            private final double stepSize$3;
            private final double regParam$2;
            private final double miniBatchFraction$3;

            public final RidgeRegressionModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                return RidgeRegressionWithSGD$.MODULE$.train(data, this.numIterations$3, this.stepSize$3, this.regParam$2, this.miniBatchFraction$3, initialWeights);
            }
            {
                this.numIterations$3 = numIterations$3;
                this.stepSize$3 = stepSize$3;
                this.regParam$2 = regParam$2;
                this.miniBatchFraction$3 = miniBatchFraction$3;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainSVMModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double regParam, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, regParam, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$4;
            private final double stepSize$4;
            private final double regParam$3;
            private final double miniBatchFraction$4;

            public final SVMModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                return SVMWithSGD$.MODULE$.train(data, this.numIterations$4, this.stepSize$4, this.regParam$3, this.miniBatchFraction$4, initialWeights);
            }
            {
                this.numIterations$4 = numIterations$4;
                this.stepSize$4 = stepSize$4;
                this.regParam$3 = regParam$3;
                this.miniBatchFraction$4 = miniBatchFraction$4;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainLogisticRegressionModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$5;
            private final double stepSize$5;
            private final double miniBatchFraction$5;

            public final LogisticRegressionModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                return LogisticRegressionWithSGD$.MODULE$.train(data, this.numIterations$5, this.stepSize$5, this.miniBatchFraction$5, initialWeights);
            }
            {
                this.numIterations$5 = numIterations$5;
                this.stepSize$5 = stepSize$5;
                this.miniBatchFraction$5 = miniBatchFraction$5;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainNaiveBayes(JavaRDD<byte[]> dataBytesJRDD, double lambda) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final LabeledPoint apply(byte[] bytes) {
                return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeLabeledPoint(bytes);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        NaiveBayesModel model = NaiveBayes$.MODULE$.train((RDD<LabeledPoint>)data, lambda);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(this.serializeDoubleVector(Vectors$.MODULE$.dense(model.labels())));
        ret.add(this.serializeDoubleVector(Vectors$.MODULE$.dense(model.pi())));
        ret.add(this.serializeDoubleMatrix(model.theta()));
        return ret;
    }

    public List<Object> trainKMeansModel(JavaRDD<byte[]> dataBytesJRDD, int k, int maxIterations, int runs, String initializationMode) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final Vector apply(byte[] bytes) {
                return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector(bytes, this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$deserializeDoubleVector$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        KMeansModel model = KMeans$.MODULE$.train((RDD<Vector>)data, k, maxIterations, runs, initializationMode);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(this.serializeDoubleMatrix((double[][])Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double[] apply(Vector x$1) {
                return x$1.toArray();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))))));
        return ret;
    }

    public Rating org$apache$spark$mllib$api$python$PythonMLLibAPI$$unpackRating(byte[] ratingBytes) {
        ByteBuffer bb = ByteBuffer.wrap(ratingBytes);
        bb.order(ByteOrder.nativeOrder());
        int user = bb.getInt();
        int product = bb.getInt();
        double rating = bb.getDouble();
        return new Rating(user, product, rating);
    }

    public Tuple2<Object, Object> unpackTuple(byte[] tupleBytes) {
        ByteBuffer bb = ByteBuffer.wrap(tupleBytes);
        bb.order(ByteOrder.nativeOrder());
        int v1 = bb.getInt();
        int v2 = bb.getInt();
        return new Tuple2.mcII.sp(v1, v2);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serializeRating(Rating rate) {
        void var3_3;
        int len = 3;
        byte[] bytes = new byte[4 + 8 * len];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.putInt(len);
        DoubleBuffer db = bb.asDoubleBuffer();
        db.put(rate.user());
        db.put(rate.product());
        db.put(rate.rating());
        return var3_3;
    }

    public MatrixFactorizationModel trainALSModel(JavaRDD<byte[]> ratingsBytesJRDD, int rank, int iterations, double lambda, int blocks) {
        RDD ratings = ratingsBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final Rating apply(byte[] ratingBytes) {
                return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$unpackRating(ratingBytes);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
        return ALS$.MODULE$.train((RDD<Rating>)ratings, rank, iterations, lambda, blocks);
    }

    public MatrixFactorizationModel trainImplicitALSModel(JavaRDD<byte[]> ratingsBytesJRDD, int rank, int iterations, double lambda, int blocks, double alpha) {
        RDD ratings = ratingsBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PythonMLLibAPI $outer;

            public final Rating apply(byte[] ratingBytes) {
                return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$$unpackRating(ratingBytes);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
        return ALS$.MODULE$.trainImplicit((RDD<Rating>)ratings, rank, iterations, lambda, blocks, alpha);
    }

    public PythonMLLibAPI() {
        this.DENSE_VECTOR_MAGIC = 1;
    }
}

