/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.NumericOps;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.DefaultArrayValue;
import java.util.Arrays;
import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.ColumnStatisticsAggregator;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.sys.package$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001=\u0011\u0011BU8x\u001b\u0006$(/\u001b=\u000b\u0005\r!\u0011a\u00033jgR\u0014\u0018NY;uK\u0012T!!\u0002\u0004\u0002\r1Lg.\u00197h\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00175A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003#\u0011K7\u000f\u001e:jEV$X\rZ'biJL\u0007\u0010\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\t9Aj\\4hS:<\u0007\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\tI|wo]\u000b\u0002CA\u0019!%J\u0014\u000e\u0003\rR!\u0001\n\u0005\u0002\u0007I$G-\u0003\u0002'G\t\u0019!\u000b\u0012#\u0011\u0005!JS\"\u0001\u0003\n\u0005)\"!A\u0002,fGR|'\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003\"\u0003\u0015\u0011xn^:!\u0011!q\u0003A!a\u0001\n\u0013y\u0013!\u00028S_^\u001cX#\u0001\u0019\u0011\u0005E\t\u0014B\u0001\u001a\u0013\u0005\u0011auN\\4\t\u0011Q\u0002!\u00111A\u0005\nU\n\u0011B\u001c*poN|F%Z9\u0015\u0005YJ\u0004CA\t8\u0013\tA$C\u0001\u0003V]&$\bb\u0002\u001e4\u0003\u0003\u0005\r\u0001M\u0001\u0004q\u0012\n\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0019\u0002\r9\u0014vn^:!\u0011!q\u0004A!a\u0001\n\u0013y\u0014!\u00028D_2\u001cX#\u0001!\u0011\u0005E\t\u0015B\u0001\"\u0013\u0005\rIe\u000e\u001e\u0005\t\t\u0002\u0011\t\u0019!C\u0005\u000b\u0006IanQ8mg~#S-\u001d\u000b\u0003m\u0019CqAO\"\u0002\u0002\u0003\u0007\u0001\t\u0003\u0005I\u0001\t\u0005\t\u0015)\u0003A\u0003\u0019q7i\u001c7tA!)!\n\u0001C\u0001\u0017\u00061A(\u001b8jiz\"B\u0001T'O\u001fB\u0011q\u0003\u0001\u0005\u0006?%\u0003\r!\t\u0005\u0006]%\u0003\r\u0001\r\u0005\u0006}%\u0003\r\u0001\u0011\u0005\u0006\u0015\u0002!\t!\u0015\u000b\u0003\u0019JCQa\b)A\u0002\u0005BQ\u0001\u0016\u0001\u0005BU\u000bqA\\;n\u0007>d7\u000fF\u00011\u0011\u00159\u0006\u0001\"\u0011V\u0003\u001dqW/\u001c*poNDQ!\u0017\u0001\u0005\u0002i\u000bAcY8naV$Xm\u0012:b[&\fg.T1ue&DH#A.\u0011\u0005!b\u0016BA/\u0005\u0005\u0019i\u0015\r\u001e:jq\")q\f\u0001C\u0001A\u0006Q1m\\7qkR,7K\u0016#\u0015\t\u0005$gm\u001b\t\u0005Q\td5,\u0003\u0002d\t\tQ2+\u001b8hk2\f'OV1mk\u0016$UmY8na>\u001c\u0018\u000e^5p]\")QM\u0018a\u0001\u0001\u0006\t1\u000eC\u0004h=B\u0005\t\u0019\u00015\u0002\u0011\r|W\u000e];uKV\u0003\"!E5\n\u0005)\u0014\"a\u0002\"p_2,\u0017M\u001c\u0005\bYz\u0003\n\u00111\u0001n\u0003\u0015\u00118i\u001c8e!\t\tb.\u0003\u0002p%\t1Ai\\;cY\u0016DQ!\u001d\u0001\u0005\u0002i\u000b\u0011cY8naV$XmQ8wCJL\u0017M\\2f\u0011\u0015\u0019\b\u0001\"\u0001u\u0003i\u0019w.\u001c9vi\u0016\u0004&/\u001b8dSB\fGnQ8na>tWM\u001c;t)\tYV\u000fC\u0003fe\u0002\u0007\u0001\tC\u0003x\u0001\u0011\u0005\u00010\u0001\u0010d_6\u0004X\u000f^3D_2,XN\\*v[6\f'/_*uCRL7\u000f^5dgR\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}\r\u0005!1\u000f^1u\u0013\tq8P\u0001\u0010Nk2$\u0018N^1sS\u0006$Xm\u0015;bi&\u001cH/[2bYN+X.\\1ss\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0011\u0001C7vYRL\u0007\u000f\\=\u0015\u00071\u000b)\u0001\u0003\u0004\u0002\b}\u0004\raW\u0001\u0002\u0005\"A\u00111\u0002\u0001\u0005B\u0019\ti!\u0001\u0005u_\n\u0013X-\u001a>f)\t\ty\u0001E\u0003\u0002\u0012\u0005eQ.\u0004\u0002\u0002\u0014)\u0019Q!!\u0006\u000b\u0005\u0005]\u0011A\u00022sK\u0016TX-\u0003\u0003\u0002\u001c\u0005M!a\u0003#f]N,W*\u0019;sSbDq!a\b\u0001\t\u0013\t\t#A\u0007va\u0012\fG/\u001a(v[J{wo\u001d\u000b\u0004m\u0005\r\u0002bBA\u0013\u0003;\u0001\r\u0001M\u0001\u0002[\"I\u0011\u0011\u0006\u0001\u0012\u0002\u0013\u0005\u00111F\u0001\u0015G>l\u0007/\u001e;f'Z#E\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055\"f\u00015\u00020-\u0012\u0011\u0011\u0007\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003%)hn\u00195fG.,GMC\u0002\u0002<I\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty$!\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002D\u0001\t\n\u0011\"\u0001\u0002F\u0005!2m\\7qkR,7K\u0016#%I\u00164\u0017-\u001e7uIM*\"!a\u0012+\u00075\fy\u0003K\u0002\u0001\u0003\u0017\u0002B!!\u0014\u0002R5\u0011\u0011q\n\u0006\u0004\u0003wA\u0011\u0002BA*\u0003\u001f\u0012A\"\u0012=qKJLW.\u001a8uC2<q!a\u0016\u0003\u0011\u0003\tI&A\u0005S_^l\u0015\r\u001e:jqB\u0019q#a\u0017\u0007\r\u0005\u0011\u0001\u0012AA/'\u0015\tY\u0006EA0!\r\t\u0012\u0011M\u0005\u0004\u0003G\u0012\"\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002&\u0002\\\u0011\u0005\u0011q\r\u000b\u0003\u00033B\u0001\"a\u001b\u0002\\\u0011%\u0011QN\u0001\u0005IN\u0004(\u000fF\u00047\u0003_\n\u0019(a\u001e\t\u000f\u0005E\u0014\u0011\u000ea\u0001[\u0006)\u0011\r\u001c9iC\"9\u0011QOA5\u0001\u00049\u0013!\u0001<\t\u0011\u0005e\u0014\u0011\u000ea\u0001\u0003w\n\u0011!\u0016\t\u0005#\u0005uT.C\u0002\u0002\u0000I\u0011Q!\u0011:sCfD\u0001\"a!\u0002\\\u0011%\u0011QQ\u0001\u000biJLW\u000fV8Gk2dG#B.\u0002\b\u0006-\u0005bBAE\u0003\u0003\u0003\r\u0001Q\u0001\u0002]\"A\u0011\u0011PAA\u0001\u0004\tY\b\u0003\u0006\u0002\u0010\u0006m\u0013\u0011!C\u0005\u0003#\u000b1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0013\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0015\u0001\u00026bm\u0006LA!!)\u0002\u0018\n1qJ\u00196fGRDC!a\u0017\u0002L!\"\u0011QKA&\u0001")
public class RowMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Vector> rows;
    private long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    private int nCols;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Vector> rows() {
        return this.rows;
    }

    public long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() {
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    }

    private void org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(long x$1) {
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        if (this.nCols() <= 0) {
            this.nCols_$eq(((Vector)this.rows().first()).size());
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(this.rows().count());
            if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == 0L) {
                throw package$.MODULE$.error("Cannot determine the number of rows because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows();
    }

    public Matrix computeGramianMatrix() {
        int n = (int)this.numCols();
        int nt = n * (n + 1) / 2;
        DenseVector GU = (DenseVector)this.rows().aggregate((Object)new DenseVector.mcD.sp(new double[nt]), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(DenseVector<Object> U, Vector v) {
                RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$dspr(1.0, v, U.data$mcD$sp());
                return U;
            }
        }, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(DenseVector<Object> U1, DenseVector<Object> U2) {
                return (DenseVector)U1.$plus$eq(U2, DenseVector$.MODULE$.canAddIntoD());
            }
        }, ClassTag$.MODULE$.apply(DenseVector.class));
        return RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, GU.data$mcD$sp());
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        int n = (int)this.numCols();
        Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
            public static final long serialVersionUID = 0L;
            private final int k$1;
            private final int n$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request up to n singular values k=", " n=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.n$1)}));
            }
            {
                this.k$1 = k$1;
                this.n$1 = n$1;
            }
        });
        Matrix G = this.computeGramianMatrix();
        Tuple3 tuple3 = (Tuple3)svd$.MODULE$.apply((Object)((breeze.linalg.DenseMatrix)G.toBreeze()), (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
        if (tuple3 != null) {
            breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)tuple3._1();
            DenseVector sigmaSquares = (DenseVector)tuple3._2();
            breeze.linalg.DenseMatrix v = (breeze.linalg.DenseMatrix)tuple3._3();
            if (u != null) {
                breeze.linalg.DenseMatrix denseMatrix = u;
                if (sigmaSquares != null) {
                    DenseVector denseVector = sigmaSquares;
                    if (v != null) {
                        SingularValueDecomposition<RowMatrix, Matrix> singularValueDecomposition;
                        int i;
                        Tuple3 tuple32;
                        breeze.linalg.DenseMatrix denseMatrix2 = v;
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)denseMatrix, (Object)denseVector, (Object)denseMatrix2);
                        breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple33._1();
                        DenseVector sigmaSquares2 = (DenseVector)tuple33._2();
                        breeze.linalg.DenseMatrix v2 = (breeze.linalg.DenseMatrix)tuple33._3();
                        DenseVector sigmas = (DenseVector)package.sqrt$.MODULE$.apply((Object)sigmaSquares2, package.sqrt$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())));
                        double sigma0 = sigmas.apply$mcD$sp(0);
                        double threshold = rCond * sigma0;
                        for (i = 0; i < k && sigmas.apply$mcD$sp(i) >= threshold; ++i) {
                        }
                        int sk = i;
                        if (sk < k) {
                            this.logWarning((Function0<String>)new Serializable(this, k, sk){
                                public static final long serialVersionUID = 0L;
                                private final int k$1;
                                private final int sk$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular values but only found ", " nonzeros."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.sk$1)}));
                                }
                                {
                                    this.k$1 = k$1;
                                    this.sk$1 = sk$1;
                                }
                            });
                        }
                        Vector s = Vectors$.MODULE$.dense(Arrays.copyOfRange(sigmas.data$mcD$sp(), 0, sk));
                        Matrix V = Matrices$.MODULE$.dense(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
                        if (computeU) {
                            DenseMatrix.mcD.sp N = new DenseMatrix.mcD.sp(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk), DenseMatrix$.MODULE$.$lessinit$greater$default$4());
                            int i2 = 0;
                            for (int j = 0; j < sk; ++j) {
                                i2 = 0;
                                double sigma = sigmas.apply$mcD$sp(j);
                                while (i2 < n) {
                                    int n2 = i2++;
                                    int n3 = j;
                                    N.update$mcD$sp(n2, n3, N.apply$mcD$sp(n2, n3) / sigma);
                                }
                            }
                            RowMatrix U = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)N));
                            singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(U, s, V);
                        } else {
                            singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(null, s, V);
                        }
                        return singularValueDecomposition;
                    }
                }
            }
        }
        throw new MatchError((Object)tuple3);
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    public Matrix computeCovariance() {
        Tuple2 tuple2;
        int n = (int)this.numCols();
        if (n > 10000) {
            int mem = n * n * 64 / 8;
            this.logWarning((Function0<String>)new Serializable(this, n, mem){
                public static final long serialVersionUID = 0L;
                private final int n$2;
                private final int mem$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of columns ", " is greater than 10000! "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We need at least ", " bytes of memory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mem$1)}))).toString();
                }
                {
                    this.n$2 = n$2;
                    this.mem$1 = mem$1;
                }
            });
        }
        if ((tuple2 = (Tuple2)this.rows().aggregate((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$)), (Function2)new $anonfun$5(this), (Function2)new $anonfun$6(this), ClassTag$.MODULE$.apply(Tuple2.class))) != null) {
            Tuple2 tuple22;
            long m = tuple2._1$mcJ$sp();
            DenseVector mean = (DenseVector)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)m), (Object)mean);
            long m2 = tuple23._1$mcJ$sp();
            DenseVector mean2 = (DenseVector)tuple23._2();
            this.updateNumRows(m2);
            mean2.$colon$div$eq((Object)BoxesRunTime.boxToDouble((double)m2), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpDiv());
            breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
            int j = 0;
            double m1 = (double)m2 - 1.0;
            double alpha = 0.0;
            for (int i = 0; i < n; ++i) {
                alpha = (double)m2 / m1 * mean2.apply$mcD$sp(i);
                for (j = 0; j < n; ++j) {
                    G.update$mcD$sp(i, j, G.apply$mcD$sp(i, j) / m1 - alpha * mean2.apply$mcD$sp(j));
                }
            }
            return Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)G);
        }
        throw new MatchError((Object)tuple2);
    }

    public Matrix computePrincipalComponents(int k) {
        breeze.linalg.DenseMatrix u;
        int n = (int)this.numCols();
        Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
            public static final long serialVersionUID = 0L;
            private final int k$2;
            private final int n$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k = ", " out of range (0, n = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.n$3)}));
            }
            {
                this.k$2 = k$2;
                this.n$3 = n$3;
            }
        });
        breeze.linalg.DenseMatrix Cov = (breeze.linalg.DenseMatrix)this.computeCovariance().toBreeze();
        Tuple3 tuple3 = (Tuple3)svd$.MODULE$.apply((Object)Cov, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
        if (tuple3 != null && (u = (breeze.linalg.DenseMatrix)tuple3._1()) != null) {
            breeze.linalg.DenseMatrix denseMatrix;
            breeze.linalg.DenseMatrix denseMatrix2;
            breeze.linalg.DenseMatrix u2 = denseMatrix2 = (denseMatrix = u);
            return k == n ? Matrices$.MODULE$.dense(n, k, u2.data$mcD$sp()) : Matrices$.MODULE$.dense(n, k, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * k));
        }
        throw new MatchError((Object)tuple3);
    }

    /*
     * WARNING - void declaration
     */
    public MultivariateStatisticalSummary computeColumnSummaryStatistics() {
        void var2_2;
        ColumnStatisticsAggregator zeroValue = new ColumnStatisticsAggregator((int)this.numCols());
        ColumnStatisticsAggregator summary = (ColumnStatisticsAggregator)this.rows().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.Vector<Object> apply(Vector x$3) {
                return x$3.toBreeze();
            }
        }, ClassTag$.MODULE$.apply(breeze.linalg.Vector.class)).aggregate((Object)zeroValue, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnStatisticsAggregator apply(ColumnStatisticsAggregator aggregator, breeze.linalg.Vector<Object> data) {
                return aggregator.add(data);
            }
        }, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnStatisticsAggregator apply(ColumnStatisticsAggregator aggregator1, ColumnStatisticsAggregator aggregator2) {
                return aggregator1.merge(aggregator2);
            }
        }, ClassTag$.MODULE$.apply(ColumnStatisticsAggregator.class));
        this.updateNumRows(summary.count());
        return var2_2;
    }

    public RowMatrix multiply(Matrix B) {
        int n = (int)this.numCols();
        Predef$.MODULE$.require(n == B.numRows(), (Function0)new Serializable(this, B, n){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;
            private final int n$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch: ", " vs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$4), BoxesRunTime.boxToInteger((int)this.B$1.numRows())}));
            }
            {
                this.B$1 = B$1;
                this.n$4 = n$4;
            }
        });
        Predef$.MODULE$.require(B instanceof DenseMatrix, (Function0)new Serializable(this, B){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only support dense matrix at this time but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.B$1.getClass().getName()}));
            }
            {
                this.B$1 = B$1;
            }
        });
        Broadcast Bb = this.rows().context().broadcast((Object)B, ClassTag$.MODULE$.apply(Matrix.class));
        RDD AB = this.rows().mapPartitions((Function1)new Serializable(this, Bb){
            public static final long serialVersionUID = 0L;
            private final Broadcast Bb$1;

            public final Iterator<Vector> apply(Iterator<Vector> iter) {
                breeze.linalg.DenseMatrix Bi = (breeze.linalg.DenseMatrix)((Matrix)this.Bb$1.value()).toBreeze();
                return iter.map((Function1)new Serializable(this, Bi){
                    public static final long serialVersionUID = 0L;
                    private final breeze.linalg.DenseMatrix Bi$1;

                    public final Vector apply(Vector v) {
                        return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)((breeze.linalg.Vector)((NumericOps)this.Bi$1.t(DenseMatrix$.MODULE$.canTranspose())).$times(v.toBreeze(), (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double())));
                    }
                    {
                        this.Bi$1 = Bi$1;
                    }
                });
            }
            {
                this.Bb$1 = Bb$1;
            }
        }, true, ClassTag$.MODULE$.apply(Vector.class));
        return new RowMatrix((RDD<Vector>)AB, this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows(), B.numCols());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        breeze.linalg.DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        IntRef i = new IntRef(0);
        Predef$.MODULE$.refArrayOps((Object[])this.rows().collect()).foreach((Function1)new Serializable(this, mat, i){
            public static final long serialVersionUID = 0L;
            public final breeze.linalg.DenseMatrix mat$1;
            public final IntRef i$1;

            public final void apply(Vector v) {
                v.toBreeze().activeIterator().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$toBreeze$1 $outer;

                    public final void apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int j = tuple2._1$mcI$sp();
                            double v = tuple2._2$mcD$sp();
                            this.$outer.mat$1.update$mcD$sp(this.$outer.i$1.elem, j, v);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                ++this.i$1.elem;
            }
            {
                this.mat$1 = mat$1;
                this.i$1 = i$1;
            }
        });
        return var3_3;
    }

    private void updateNumRows(long m) {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(m);
        } else {
            Predef$.MODULE$.require(this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == m, (Function0)new Serializable(this, m){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RowMatrix $outer;
                private final long m$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of rows ", " is different from what specified or previously computed: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.m$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                }
            });
        }
    }

    public RowMatrix(RDD<Vector> rows, long nRows, int nCols) {
        this.rows = rows;
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = nRows;
        this.nCols = nCols;
        Logging.class.$init$((Logging)this);
    }

    public RowMatrix(RDD<Vector> rows) {
        this(rows, 0L, 0);
    }
}

