/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.LeastSquaresGradient;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u00015\u0011q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8XSRD7k\u0012#\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f+A\u0019q\u0002\u0005\n\u000e\u0003\tI!!\u0005\u0002\u00035\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'/\u00117h_JLG\u000f[7\u0011\u0005=\u0019\u0012B\u0001\u000b\u0003\u0005Ua\u0015N\\3beJ+wM]3tg&|g.T8eK2\u0004\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\b\u0001\u0003\u0002\u0004%I!H\u0001\tgR,\u0007oU5{KV\ta\u0004\u0005\u0002\u0017?%\u0011\u0001e\u0006\u0002\u0007\t>,(\r\\3\t\u0011\t\u0002!\u00111A\u0005\n\r\nAb\u001d;faNK'0Z0%KF$\"\u0001J\u0014\u0011\u0005Y)\u0013B\u0001\u0014\u0018\u0005\u0011)f.\u001b;\t\u000f!\n\u0013\u0011!a\u0001=\u0005\u0019\u0001\u0010J\u0019\t\u0011)\u0002!\u0011!Q!\ny\t\u0011b\u001d;faNK'0\u001a\u0011\t\u00111\u0002!\u00111A\u0005\n5\nQB\\;n\u0013R,'/\u0019;j_:\u001cX#\u0001\u0018\u0011\u0005Yy\u0013B\u0001\u0019\u0018\u0005\rIe\u000e\u001e\u0005\te\u0001\u0011\t\u0019!C\u0005g\u0005\tb.^7Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0011\"\u0004b\u0002\u00152\u0003\u0003\u0005\rA\f\u0005\tm\u0001\u0011\t\u0011)Q\u0005]\u0005qa.^7Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0007I\u0011B\u000f\u0002#5Lg.\u001b\"bi\u000eDgI]1di&|g\u000e\u0003\u0005;\u0001\t\u0005\r\u0011\"\u0003<\u0003Ui\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\\0%KF$\"\u0001\n\u001f\t\u000f!J\u0014\u0011!a\u0001=!Aa\b\u0001B\u0001B\u0003&a$\u0001\nnS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:\u0004\u0003\"\u0002!\u0001\t\u0013\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0012+\u0005CA\b\u0001\u0011\u0015ar\b1\u0001\u001f\u0011\u0015as\b1\u0001/\u0011\u0015At\b1\u0001\u001f\u0011\u001d9\u0005A1A\u0005\n!\u000b\u0001b\u001a:bI&,g\u000e^\u000b\u0002\u0013B\u0011!*T\u0007\u0002\u0017*\u0011A\nB\u0001\r_B$\u0018.\\5{CRLwN\\\u0005\u0003\u001d.\u0013A\u0003T3bgR\u001c\u0016/^1sKN<%/\u00193jK:$\bB\u0002)\u0001A\u0003%\u0011*A\u0005he\u0006$\u0017.\u001a8uA!9!\u000b\u0001b\u0001\n\u0013\u0019\u0016aB;qI\u0006$XM]\u000b\u0002)B\u0011!*V\u0005\u0003-.\u0013QbU5na2,W\u000b\u001d3bi\u0016\u0014\bB\u0002-\u0001A\u0003%A+\u0001\u0005va\u0012\fG/\u001a:!\u0011\u001dQ\u0006A1A\u0005Bm\u000b\u0011b\u001c9uS6L'0\u001a:\u0016\u0003q\u0003\"AS/\n\u0005y[%aD$sC\u0012LWM\u001c;EKN\u001cWM\u001c;\t\r\u0001\u0004\u0001\u0015!\u0003]\u0003)y\u0007\u000f^5nSj,'\u000f\t\u0005\u0006\u0001\u0002!\tA\u0019\u000b\u0002\u0005\")A\r\u0001C)K\u0006Y1M]3bi\u0016lu\u000eZ3m)\r\u0011bM\u001c\u0005\u0006O\u000e\u0004\r\u0001[\u0001\bo\u0016Lw\r\u001b;t!\tIG.D\u0001k\u0015\tYG!\u0001\u0004mS:\fGnZ\u0005\u0003[*\u0014aAV3di>\u0014\b\"B8d\u0001\u0004q\u0012!C5oi\u0016\u00148-\u001a9u\u000f\u0015\t(\u0001#\u0001s\u0003]a\u0015N\\3beJ+wM]3tg&|gnV5uQN;E\t\u0005\u0002\u0010g\u001a)\u0011A\u0001E\u0001iN\u00191/^\u000b\u0011\u0005Y1\u0018BA<\u0018\u0005\u0019\te.\u001f*fM\")\u0001i\u001dC\u0001sR\t!\u000fC\u0003|g\u0012\u0005A0A\u0003ue\u0006Lg\u000e\u0006\u0006\u0013{\u0006E\u00111CA\u000b\u0003/AQA >A\u0002}\fQ!\u001b8qkR\u0004b!!\u0001\u0002\b\u0005-QBAA\u0002\u0015\r\t)AB\u0001\u0004e\u0012$\u0017\u0002BA\u0005\u0003\u0007\u00111A\u0015#E!\ry\u0011QB\u0005\u0004\u0003\u001f\u0011!\u0001\u0004'bE\u0016dW\r\u001a)pS:$\b\"\u0002\u0017{\u0001\u0004q\u0003\"\u0002\u000f{\u0001\u0004q\u0002\"\u0002\u001d{\u0001\u0004q\u0002BBA\ru\u0002\u0007\u0001.\u0001\bj]&$\u0018.\u00197XK&<\u0007\u000e^:\t\rm\u001cH\u0011AA\u000f)%\u0011\u0012qDA\u0011\u0003G\t)\u0003\u0003\u0004\u007f\u00037\u0001\ra \u0005\u0007Y\u0005m\u0001\u0019\u0001\u0018\t\rq\tY\u00021\u0001\u001f\u0011\u0019A\u00141\u0004a\u0001=!11p\u001dC\u0001\u0003S!rAEA\u0016\u0003[\ty\u0003\u0003\u0004\u007f\u0003O\u0001\ra \u0005\u0007Y\u0005\u001d\u0002\u0019\u0001\u0018\t\rq\t9\u00031\u0001\u001f\u0011\u0019Y8\u000f\"\u0001\u00024Q)!#!\u000e\u00028!1a0!\rA\u0002}Da\u0001LA\u0019\u0001\u0004q\u0003\"CA\u001eg\u0006\u0005I\u0011BA\u001f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\u0002\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005Y\u0006twM\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0011\u0003\r=\u0013'.Z2u\u0001")
public class LinearRegressionWithSGD
extends GeneralizedLinearAlgorithm<LinearRegressionModel>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double miniBatchFraction;
    private final LeastSquaresGradient gradient;
    private final SimpleUpdater updater;
    private final GradientDescent optimizer;

    public static LinearRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static LinearRegressionModel train(RDD<LabeledPoint> rDD, int n, double d) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n, d);
    }

    public static LinearRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static LinearRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, Vector vector) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, vector);
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private LeastSquaresGradient gradient() {
        return this.gradient;
    }

    private SimpleUpdater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    @Override
    public LinearRegressionModel createModel(Vector weights, double intercept) {
        return new LinearRegressionModel(weights, intercept);
    }

    public LinearRegressionWithSGD(double stepSize, int numIterations, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new LeastSquaresGradient();
        this.updater = new SimpleUpdater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setMiniBatchFraction(this.miniBatchFraction());
    }

    public LinearRegressionWithSGD() {
        this(1.0, 100, 1.0);
    }
}

