/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.Logging;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.DummyCategoricalSplit;
import org.apache.spark.mllib.tree.model.DummyHighSplit;
import org.apache.spark.mllib.tree.model.DummyLowSplit;
import org.apache.spark.mllib.tree.model.Filter;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Double$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class DecisionTree$
implements Serializable,
Logging {
    public static final DecisionTree$ MODULE$;
    private final int InvalidBinIndex;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new DecisionTree$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Strategy strategy) {
        return new DecisionTree(strategy).train(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, Strategy$.MODULE$.$lessinit$greater$default$4(), Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7());
        return new DecisionTree(strategy).train(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth, int maxBins, Enumeration.Value quantileCalculationStrategy, Map<Object, Object> categoricalFeaturesInfo) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, maxBins, quantileCalculationStrategy, categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$7());
        return new DecisionTree(strategy).train(input);
    }

    private int InvalidBinIndex() {
        return this.InvalidBinIndex;
    }

    public Tuple2<Split, InformationGainStats>[] findBestSplits(RDD<LabeledPoint> input, double[] parentImpurities, Strategy strategy, int level, List<Filter>[] filters, Split[][] splits, Bin[][] bins, int maxLevelForSingleGroup) {
        Tuple2<Split, InformationGainStats>[] tuple2Array;
        if (level > maxLevelForSingleGroup) {
            int numGroups = (int)package$.MODULE$.pow(2.0, (double)(level - maxLevelForSingleGroup));
            this.logDebug((Function0<String>)new Serializable(numGroups){
                public static final long serialVersionUID = 0L;
                private final int numGroups$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"numGroups = ").append((Object)BoxesRunTime.boxToInteger((int)this.numGroups$1)).toString();
                }
                {
                    this.numGroups$1 = numGroups$1;
                }
            });
            Tuple2[] bestSplits = new Tuple2[]{};
            for (int groupIndex = 0; groupIndex < numGroups; ++groupIndex) {
                Tuple2<Split, InformationGainStats>[] bestSplitsForGroup = this.findBestSplitsPerGroup(input, parentImpurities, strategy, level, filters, splits, bins, numGroups, groupIndex);
                bestSplits = (Tuple2[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[][]{bestSplits, bestSplitsForGroup}), ClassTag$.MODULE$.apply(Tuple2.class));
            }
            tuple2Array = bestSplits;
        } else {
            tuple2Array = this.findBestSplitsPerGroup(input, parentImpurities, strategy, level, filters, splits, bins, this.findBestSplitsPerGroup$default$8(), this.findBestSplitsPerGroup$default$9());
        }
        return tuple2Array;
    }

    private Tuple2<Split, InformationGainStats>[] findBestSplitsPerGroup(RDD<LabeledPoint> input, double[] parentImpurities, Strategy strategy, int level, List<Filter>[] filters, Split[][] splits, Bin[][] bins, int numGroups, int groupIndex) {
        Enumeration.Value value;
        block5: {
            int n;
            int groupShift;
            int numBins;
            int numFeatures;
            int numNodes;
            block4: {
                block3: {
                    numNodes = (int)package$.MODULE$.pow(2.0, (double)level) / numGroups;
                    this.logDebug((Function0<String>)new Serializable(numNodes){
                        public static final long serialVersionUID = 0L;
                        private final int numNodes$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"numNodes = ").append((Object)BoxesRunTime.boxToInteger((int)this.numNodes$1)).toString();
                        }
                        {
                            this.numNodes$1 = numNodes$1;
                        }
                    });
                    numFeatures = ((LabeledPoint)input.first()).features().size();
                    this.logDebug((Function0<String>)new Serializable(numFeatures){
                        public static final long serialVersionUID = 0L;
                        private final int numFeatures$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"numFeatures = ").append((Object)BoxesRunTime.boxToInteger((int)this.numFeatures$1)).toString();
                        }
                        {
                            this.numFeatures$1 = numFeatures$1;
                        }
                    });
                    numBins = bins[0].length;
                    this.logDebug((Function0<String>)new Serializable(numBins){
                        public static final long serialVersionUID = 0L;
                        private final int numBins$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"numBins = ").append((Object)BoxesRunTime.boxToInteger((int)this.numBins$2)).toString();
                        }
                        {
                            this.numBins$2 = numBins$2;
                        }
                    });
                    groupShift = numNodes * groupIndex;
                    value = strategy.algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Classification();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block3;
                    n = 2 * numBins * numFeatures * numNodes;
                    break block4;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Regression();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block5;
                n = 3 * numBins * numFeatures * numNodes;
            }
            int binAggregateLength = n;
            this.logDebug((Function0<String>)new Serializable(binAggregateLength){
                public static final long serialVersionUID = 0L;
                private final int binAggregateLength$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"binAggregateLength = ").append((Object)BoxesRunTime.boxToInteger((int)this.binAggregateLength$1)).toString();
                }
                {
                    this.binAggregateLength$1 = binAggregateLength$1;
                }
            });
            RDD binMappedRDD = input.map((Function1)new Serializable(strategy, level, filters, bins, numNodes, numFeatures, groupShift){
                public static final long serialVersionUID = 0L;
                private final Strategy strategy$1;
                private final int level$2;
                private final List[] filters$2;
                private final Bin[][] bins$1;
                private final int numNodes$1;
                private final int numFeatures$1;
                private final int groupShift$1;

                public final double[] apply(LabeledPoint x) {
                    return DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$findBinsForLevel$1(x, this.strategy$1, this.level$2, this.filters$2, this.bins$1, this.numNodes$1, this.numFeatures$1, this.groupShift$1);
                }
                {
                    this.strategy$1 = strategy$1;
                    this.level$2 = level$2;
                    this.filters$2 = filters$2;
                    this.bins$1 = bins$1;
                    this.numNodes$1 = numNodes$1;
                    this.numFeatures$1 = numFeatures$1;
                    this.groupShift$1 = groupShift$1;
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            double[] binAggregates = (double[])binMappedRDD.aggregate(Array$.MODULE$.fill(binAggregateLength, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return 0.0;
                }
            }, ClassTag$.MODULE$.Double()), (Function2)new Serializable(strategy, numNodes, numFeatures, numBins){
                public static final long serialVersionUID = 0L;
                private final Strategy strategy$1;
                private final int numNodes$1;
                private final int numFeatures$1;
                private final int numBins$2;

                public final double[] apply(double[] agg, double[] arr) {
                    return DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$binSeqOp$1(agg, arr, this.strategy$1, this.numNodes$1, this.numFeatures$1, this.numBins$2);
                }
                {
                    this.strategy$1 = strategy$1;
                    this.numNodes$1 = numNodes$1;
                    this.numFeatures$1 = numFeatures$1;
                    this.numBins$2 = numBins$2;
                }
            }, (Function2)new Serializable(binAggregateLength){
                public static final long serialVersionUID = 0L;
                private final int binAggregateLength$1;

                public final double[] apply(double[] agg1, double[] agg2) {
                    return DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$binCombOp$1(agg1, agg2, this.binAggregateLength$1);
                }
                {
                    this.binAggregateLength$1 = binAggregateLength$1;
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            this.logDebug((Function0<String>)new Serializable(binAggregates){
                public static final long serialVersionUID = 0L;
                private final double[] binAggregates$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"binAggregates.length = ").append((Object)BoxesRunTime.boxToInteger((int)this.binAggregates$1.length)).toString();
                }
                {
                    this.binAggregates$1 = binAggregates$1;
                }
            });
            Tuple2[] bestSplits = new Tuple2[numNodes];
            for (int node = 0; node < numNodes; ++node) {
                int nodeImpurityIndex = (int)package$.MODULE$.pow(2.0, (double)level) - 1 + node + groupShift;
                double[] binsForNode = this.getBinDataForNode$1(node, strategy, numFeatures, numBins, binAggregates);
                this.logDebug((Function0<String>)new Serializable(nodeImpurityIndex){
                    public static final long serialVersionUID = 0L;
                    private final int nodeImpurityIndex$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"nodeImpurityIndex = ").append((Object)BoxesRunTime.boxToInteger((int)this.nodeImpurityIndex$1)).toString();
                    }
                    {
                        this.nodeImpurityIndex$1 = nodeImpurityIndex$1;
                    }
                });
                double parentNodeImpurity = parentImpurities[nodeImpurityIndex];
                this.logDebug((Function0<String>)new Serializable(parentNodeImpurity){
                    public static final long serialVersionUID = 0L;
                    private final double parentNodeImpurity$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"node impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.parentNodeImpurity$1)).toString();
                    }
                    {
                        this.parentNodeImpurity$1 = parentNodeImpurity$1;
                    }
                });
                bestSplits[node] = this.binsToBestSplit$1(binsForNode, parentNodeImpurity, strategy, level, splits, bins, numFeatures, numBins);
            }
            return bestSplits;
        }
        throw new MatchError((Object)value);
    }

    private int findBestSplitsPerGroup$default$8() {
        return 1;
    }

    private int findBestSplitsPerGroup$default$9() {
        return 0;
    }

    public Tuple2<Split[][], Bin[][]> findSplitsBins(RDD<LabeledPoint> input, Strategy strategy) {
        int requiredSamples;
        long count = input.count();
        int numFeatures = ((LabeledPoint[])input.take(1))[0].features().size();
        int maxBins = strategy.maxBins();
        int numBins = (long)maxBins <= count ? maxBins : (int)count;
        this.logDebug((Function0<String>)new Serializable(numBins){
            public static final long serialVersionUID = 0L;
            private final int numBins$3;

            public final String apply() {
                return new StringBuilder().append((Object)"numBins = ").append((Object)BoxesRunTime.boxToInteger((int)this.numBins$3)).toString();
            }
            {
                this.numBins$3 = numBins$3;
            }
        });
        if (strategy.categoricalFeaturesInfo().size() > 0) {
            int maxCategoriesForFeatures = ((Tuple2)strategy.categoricalFeaturesInfo().maxBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x$7) {
                    return x$7._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$))._2$mcI$sp();
            Predef$.MODULE$.require(numBins >= maxCategoriesForFeatures);
        }
        double fraction = (long)(requiredSamples = numBins * numBins) < count ? (double)requiredSamples / (double)count : 1.0;
        this.logDebug((Function0<String>)new Serializable(fraction){
            public static final long serialVersionUID = 0L;
            private final double fraction$1;

            public final String apply() {
                return new StringBuilder().append((Object)"fraction of data used for calculating quantiles = ").append((Object)BoxesRunTime.boxToDouble((double)this.fraction$1)).toString();
            }
            {
                this.fraction$1 = fraction$1;
            }
        });
        LabeledPoint[] sampledInput = (LabeledPoint[])input.sample(false, fraction, (long)new XORShiftRandom().nextInt()).collect();
        int numSamples = sampledInput.length;
        double stride = (double)numSamples / (double)numBins;
        this.logDebug((Function0<String>)new Serializable(stride){
            public static final long serialVersionUID = 0L;
            private final double stride$1;

            public final String apply() {
                return new StringBuilder().append((Object)"stride = ").append((Object)BoxesRunTime.boxToDouble((double)this.stride$1)).toString();
            }
            {
                this.stride$1 = stride$1;
            }
        });
        Enumeration.Value value = strategy.quantileCalculationStrategy();
        Enumeration.Value value2 = QuantileStrategy$.MODULE$.Sort();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Split[][] splits = (Split[][])Array$.MODULE$.ofDim(numFeatures, numBins - 1, ClassTag$.MODULE$.apply(Split.class));
            Bin[][] bins = (Bin[][])Array$.MODULE$.ofDim(numFeatures, numBins, ClassTag$.MODULE$.apply(Bin.class));
            IntRef featureIndex = new IntRef(0);
            while (featureIndex.elem < numFeatures) {
                boolean isFeatureContinuous = strategy.categoricalFeaturesInfo().get((Object)BoxesRunTime.boxToInteger((int)featureIndex.elem)).isEmpty();
                if (isFeatureContinuous) {
                    double[] featureSamples = (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])sampledInput).map((Function1)new Serializable(featureIndex){
                        public static final long serialVersionUID = 0L;
                        private final IntRef featureIndex$2;

                        public final double apply(LabeledPoint lp) {
                            return lp.features().apply(this.featureIndex$2.elem);
                        }
                        {
                            this.featureIndex$2 = featureIndex$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sorted((Ordering)Ordering.Double$.MODULE$);
                    double stride2 = (double)numSamples / (double)numBins;
                    this.logDebug((Function0<String>)new Serializable(stride2){
                        public static final long serialVersionUID = 0L;
                        private final double stride$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"stride = ").append((Object)BoxesRunTime.boxToDouble((double)this.stride$2)).toString();
                        }
                        {
                            this.stride$2 = stride$2;
                        }
                    });
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBins - 1).foreach$mVc$sp((Function1)new Serializable(splits, featureIndex, featureSamples, stride2){
                        public static final long serialVersionUID = 0L;
                        private final Split[][] splits$2;
                        private final IntRef featureIndex$2;
                        private final double[] featureSamples$1;
                        private final double stride$2;

                        public final void apply(int index) {
                            this.apply$mcVI$sp(index);
                        }

                        public void apply$mcVI$sp(int index) {
                            Split split;
                            int sampleIndex = (index + 1) * (int)this.stride$2;
                            this.splits$2[this.featureIndex$2.elem][index] = split = new Split(this.featureIndex$2.elem, this.featureSamples$1[sampleIndex], FeatureType$.MODULE$.Continuous(), (List<Object>)Nil$.MODULE$);
                        }
                        {
                            this.splits$2 = splits$2;
                            this.featureIndex$2 = featureIndex$2;
                            this.featureSamples$1 = featureSamples$1;
                            this.stride$2 = stride$2;
                        }
                    });
                } else {
                    int maxFeatureValue = BoxesRunTime.unboxToInt((Object)strategy.categoricalFeaturesInfo().apply((Object)BoxesRunTime.boxToInteger((int)featureIndex.elem)));
                    Predef$.MODULE$.require(maxFeatureValue < numBins, (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "number of categories should be less than number of bins";
                        }
                    });
                    Map centroidForCategories = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sampledInput).map((Function1)new Serializable(featureIndex){
                        public static final long serialVersionUID = 0L;
                        private final IntRef featureIndex$2;

                        public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                            return new Tuple2.mcDD.sp(lp.features().apply(this.featureIndex$2.elem), lp.label());
                        }
                        {
                            this.featureIndex$2 = featureIndex$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).groupBy((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Tuple2<Object, Object> x$8) {
                            return x$8._1$mcD$sp();
                        }
                    }).mapValues((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Tuple2<Object, Object>[] x) {
                            return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])x).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply(Tuple2<Object, Object> x$9) {
                                    return x$9._2$mcD$sp();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)((double[])Predef$.MODULE$.refArrayOps((Object[])x).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply(Tuple2<Object, Object> x$10) {
                                    return x$10._1$mcD$sp();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).length;
                        }
                    });
                    scala.collection.mutable.Map fullCentroidForCategories = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxFeatureValue).foreach$mVc$sp((Function1)new Serializable(centroidForCategories, fullCentroidForCategories){
                        public static final long serialVersionUID = 0L;
                        private final Map centroidForCategories$1;
                        private final scala.collection.mutable.Map fullCentroidForCategories$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            if (this.centroidForCategories$1.contains((Object)BoxesRunTime.boxToDouble((double)i))) {
                                this.fullCentroidForCategories$1.update((Object)BoxesRunTime.boxToDouble((double)i), this.centroidForCategories$1.apply((Object)BoxesRunTime.boxToDouble((double)i)));
                            } else {
                                this.fullCentroidForCategories$1.update((Object)BoxesRunTime.boxToDouble((double)i), (Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE));
                            }
                        }
                        {
                            this.centroidForCategories$1 = centroidForCategories$1;
                            this.fullCentroidForCategories$1 = fullCentroidForCategories$1;
                        }
                    });
                    List categoriesSortedByCentroid = (List)fullCentroidForCategories.toList().sortBy((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Tuple2<Object, Object> x$11) {
                            return x$11._2$mcD$sp();
                        }
                    }, (Ordering)Ordering.Double$.MODULE$);
                    this.logDebug((Function0<String>)new Serializable(categoriesSortedByCentroid){
                        public static final long serialVersionUID = 0L;
                        private final List categoriesSortedByCentroid$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"centriod for categorical variable = ").append((Object)this.categoriesSortedByCentroid$1).toString();
                        }
                        {
                            this.categoriesSortedByCentroid$1 = categoriesSortedByCentroid$1;
                        }
                    });
                    ObjectRef categoriesForSplit = new ObjectRef((Object)Nil$.MODULE$);
                    categoriesSortedByCentroid.iterator().zipWithIndex().foreach((Function1)new Serializable(splits, bins, featureIndex, categoriesForSplit){
                        public static final long serialVersionUID = 0L;
                        private final Split[][] splits$2;
                        private final Bin[][] bins$2;
                        private final IntRef featureIndex$2;
                        private final ObjectRef categoriesForSplit$1;

                        public final void apply(Tuple2<Tuple2<Object, Object>, Object> x0$1) {
                            Tuple2<Tuple2<Object, Object>, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._1();
                                int index = tuple2._2$mcI$sp();
                                if (tuple22 != null) {
                                    double key;
                                    double d = key = tuple22._1$mcD$sp();
                                    this.categoriesForSplit$1.elem = ((List)this.categoriesForSplit$1.elem).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d));
                                    this.splits$2[this.featureIndex$2.elem][index] = new Split(this.featureIndex$2.elem, Double$.MODULE$.MinValue(), FeatureType$.MODULE$.Categorical(), (List<Object>)((List)this.categoriesForSplit$1.elem));
                                    this.bins$2[this.featureIndex$2.elem][index] = index == 0 ? new Bin(new DummyCategoricalSplit(this.featureIndex$2.elem, FeatureType$.MODULE$.Categorical()), this.splits$2[this.featureIndex$2.elem][0], FeatureType$.MODULE$.Categorical(), key) : new Bin(this.splits$2[this.featureIndex$2.elem][index - 1], this.splits$2[this.featureIndex$2.elem][index], FeatureType$.MODULE$.Categorical(), key);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.splits$2 = splits$2;
                            this.bins$2 = bins$2;
                            this.featureIndex$2 = featureIndex$2;
                            this.categoriesForSplit$1 = categoriesForSplit$1;
                        }
                    });
                }
                ++featureIndex.elem;
            }
            featureIndex.elem = 0;
            while (featureIndex.elem < numFeatures) {
                boolean isFeatureContinuous = strategy.categoricalFeaturesInfo().get((Object)BoxesRunTime.boxToInteger((int)featureIndex.elem)).isEmpty();
                if (isFeatureContinuous) {
                    bins[featureIndex.elem][0] = new Bin(new DummyLowSplit(featureIndex.elem, FeatureType$.MODULE$.Continuous()), splits[featureIndex.elem][0], FeatureType$.MODULE$.Continuous(), Double$.MODULE$.MinValue());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), numBins - 1).foreach$mVc$sp((Function1)new Serializable(splits, bins, featureIndex){
                        public static final long serialVersionUID = 0L;
                        private final Split[][] splits$2;
                        private final Bin[][] bins$2;
                        private final IntRef featureIndex$2;

                        public final void apply(int index) {
                            this.apply$mcVI$sp(index);
                        }

                        public void apply$mcVI$sp(int index) {
                            Bin bin;
                            this.bins$2[this.featureIndex$2.elem][index] = bin = new Bin(this.splits$2[this.featureIndex$2.elem][index - 1], this.splits$2[this.featureIndex$2.elem][index], FeatureType$.MODULE$.Continuous(), Double$.MODULE$.MinValue());
                        }
                        {
                            this.splits$2 = splits$2;
                            this.bins$2 = bins$2;
                            this.featureIndex$2 = featureIndex$2;
                        }
                    });
                    bins[featureIndex.elem][numBins - 1] = new Bin(splits[featureIndex.elem][numBins - 2], new DummyHighSplit(featureIndex.elem, FeatureType$.MODULE$.Continuous()), FeatureType$.MODULE$.Continuous(), Double$.MODULE$.MinValue());
                }
                ++featureIndex.elem;
            }
            Tuple2 tuple2 = new Tuple2((Object)splits, (Object)bins);
            return tuple2;
        }
        Enumeration.Value value4 = QuantileStrategy$.MODULE$.MinMax();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            throw new UnsupportedOperationException("minmax not supported yet.");
        }
        Enumeration.Value value6 = QuantileStrategy$.MODULE$.ApproxHist();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            throw new UnsupportedOperationException("approximate histogram not supported yet.");
        }
        throw new MatchError((Object)value);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final List findParentFilters$1(int nodeIndex, int level$2, List[] filters$2, int groupShift$1) {
        Nil$ nil$;
        if (level$2 == 0) {
            nil$ = Nil$.MODULE$;
        } else {
            int nodeFilterIndex = (int)package$.MODULE$.pow(2.0, (double)level$2) - 1 + nodeIndex + groupShift$1;
            nil$ = filters$2[nodeFilterIndex];
        }
        return nil$;
    }

    private final boolean isSampleValid$1(List parentFilters, LabeledPoint labeledPoint, int level$2) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            boolean bl;
            Object object = new Object();
            try {
                if (level$2 > 0 && parentFilters.length() == 0) {
                    return false;
                }
                parentFilters.foreach((Function1)new Serializable(labeledPoint, object){
                    public static final long serialVersionUID = 0L;
                    private final LabeledPoint labeledPoint$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Filter filter) {
                        block12: {
                            block11: {
                                double feature;
                                List<Object> categories;
                                int comparison;
                                block10: {
                                    Vector features = this.labeledPoint$1.features();
                                    int featureIndex = filter.split().feature();
                                    double threshold = filter.split().threshold();
                                    comparison = filter.comparison();
                                    categories = filter.split().categories();
                                    Enumeration.Value value = filter.split().featureType();
                                    Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
                                    boolean isFeatureContinuous = !(value != null ? !value.equals(value2) : value2 != null);
                                    feature = features.apply(featureIndex);
                                    if (!isFeatureContinuous) break block10;
                                    int n = comparison;
                                    switch (n) {
                                        default: {
                                            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                                        }
                                        case 1: {
                                            if (feature <= threshold) {
                                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                                            }
                                            break block11;
                                        }
                                        case -1: {
                                            if (feature > threshold) {
                                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                                            }
                                            break block11;
                                        }
                                    }
                                }
                                boolean containsFeature = categories.contains((Object)BoxesRunTime.boxToDouble((double)feature));
                                int n = comparison;
                                switch (n) {
                                    default: {
                                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                                    }
                                    case 1: {
                                        if (!containsFeature) break;
                                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                                    }
                                    case -1: {
                                        if (!containsFeature) break block12;
                                    }
                                }
                            }
                            return;
                        }
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                    }
                    {
                        this.labeledPoint$1 = labeledPoint$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    private final int binarySearchForBins$1(Bin[] binForFeatures$1, double feature$1) {
        int left = 0;
        int right = binForFeatures$1.length - 1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            Bin bin = binForFeatures$1[mid];
            double lowThreshold = bin.lowSplit().threshold();
            double highThreshold = bin.highSplit().threshold();
            if (lowThreshold < feature$1 && highThreshold >= feature$1) {
                return mid;
            }
            if (lowThreshold >= feature$1) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return -1;
    }

    private final int sequentialBinSearchForCategoricalFeature$1(Strategy strategy$1, Bin[][] bins$1, int featureIndex$1, LabeledPoint labeledPoint$2) {
        int numCategoricalBins = BoxesRunTime.unboxToInt((Object)strategy$1.categoricalFeaturesInfo().apply((Object)BoxesRunTime.boxToInteger((int)featureIndex$1)));
        for (int binIndex = 0; binIndex < numCategoricalBins; ++binIndex) {
            Vector features;
            Bin bin = bins$1[featureIndex$1][binIndex];
            double category = bin.category();
            if (category != (features = labeledPoint$2.features()).apply(featureIndex$1)) continue;
            return binIndex;
        }
        return -1;
    }

    private final int findBin$1(int featureIndex, LabeledPoint labeledPoint, boolean isFeatureContinuous, Strategy strategy$1, Bin[][] bins$1) {
        int n;
        Bin[] binForFeatures = bins$1[featureIndex];
        double feature = labeledPoint.features().apply(featureIndex);
        if (isFeatureContinuous) {
            int binIndex = this.binarySearchForBins$1(binForFeatures, feature);
            if (binIndex == -1) {
                throw new UnknownError("no bin was found for continuous variable.");
            }
            n = binIndex;
        } else {
            int binIndex = this.sequentialBinSearchForCategoricalFeature$1(strategy$1, bins$1, featureIndex, labeledPoint);
            if (binIndex == -1) {
                throw new UnknownError("no bin was found for categorical variable.");
            }
            n = binIndex;
        }
        return n;
    }

    public final double[] org$apache$spark$mllib$tree$DecisionTree$$findBinsForLevel$1(LabeledPoint labeledPoint, Strategy strategy$1, int level$2, List[] filters$2, Bin[][] bins$1, int numNodes$1, int numFeatures$1, int groupShift$1) {
        double[] arr = new double[1 + numFeatures$1 * numNodes$1];
        arr[0] = labeledPoint.label();
        for (int nodeIndex = 0; nodeIndex < numNodes$1; ++nodeIndex) {
            List parentFilters = this.findParentFilters$1(nodeIndex, level$2, filters$2, groupShift$1);
            boolean sampleValid = this.isSampleValid$1(parentFilters, labeledPoint, level$2);
            int shift = 1 + numFeatures$1 * nodeIndex;
            if (sampleValid) {
                for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
                    boolean isFeatureContinuous = strategy$1.categoricalFeaturesInfo().get((Object)BoxesRunTime.boxToInteger((int)featureIndex)).isEmpty();
                    arr[shift + featureIndex] = this.findBin$1(featureIndex, labeledPoint, isFeatureContinuous, strategy$1, bins$1);
                }
                continue;
            }
            arr[shift] = this.InvalidBinIndex();
        }
        return arr;
    }

    private final void classificationBinSeqOp$1(double[] arr, double[] agg, int numNodes$1, int numFeatures$1, int numBins$2) {
        for (int nodeIndex = 0; nodeIndex < numNodes$1; ++nodeIndex) {
            boolean isSampleValidForNode;
            int validSignalIndex = 1 + numFeatures$1 * nodeIndex;
            boolean bl = isSampleValidForNode = arr[validSignalIndex] != (double)this.InvalidBinIndex();
            if (!isSampleValidForNode) continue;
            double label = arr[0];
            for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
                BoxedUnit boxedUnit;
                int arrShift = 1 + numFeatures$1 * nodeIndex;
                int arrIndex = arrShift + featureIndex;
                int aggShift = 2 * numBins$2 * numFeatures$1 * nodeIndex;
                int aggIndex = aggShift + 2 * featureIndex * numBins$2 + (int)arr[arrIndex] * 2;
                double d = label;
                if (0.0 == d) {
                    agg[aggIndex] = agg[aggIndex] + 1.0;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (1.0 == d) {
                    agg[aggIndex + 1] = agg[aggIndex + 1] + 1.0;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)BoxesRunTime.boxToDouble((double)d));
            }
        }
    }

    private final void regressionBinSeqOp$1(double[] arr, double[] agg, int numNodes$1, int numFeatures$1, int numBins$2) {
        for (int nodeIndex = 0; nodeIndex < numNodes$1; ++nodeIndex) {
            boolean isSampleValidForNode;
            int validSignalIndex = 1 + numFeatures$1 * nodeIndex;
            boolean bl = isSampleValidForNode = arr[validSignalIndex] != (double)this.InvalidBinIndex();
            if (!isSampleValidForNode) continue;
            double label = arr[0];
            for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
                int arrShift = 1 + numFeatures$1 * nodeIndex;
                int arrIndex = arrShift + featureIndex;
                int aggShift = 3 * numBins$2 * numFeatures$1 * nodeIndex;
                int aggIndex = aggShift + 3 * featureIndex * numBins$2 + (int)arr[arrIndex] * 3;
                agg[aggIndex] = agg[aggIndex] + 1.0;
                agg[aggIndex + 1] = agg[aggIndex + 1] + label;
                agg[aggIndex + 2] = agg[aggIndex + 2] + label * label;
            }
        }
    }

    public final double[] org$apache$spark$mllib$tree$DecisionTree$$binSeqOp$1(double[] agg, double[] arr, Strategy strategy$1, int numNodes$1, int numFeatures$1, int numBins$2) {
        Enumeration.Value value;
        block4: {
            block3: {
                block2: {
                    value = strategy$1.algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Classification();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    this.classificationBinSeqOp$1(arr, agg, numNodes$1, numFeatures$1, numBins$2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Regression();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                this.regressionBinSeqOp$1(arr, agg, numNodes$1, numFeatures$1, numBins$2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return agg;
        }
        throw new MatchError((Object)value);
    }

    public final double[] org$apache$spark$mllib$tree$DecisionTree$$binCombOp$1(double[] agg1, double[] agg2, int binAggregateLength$1) {
        double[] combinedAggregate = new double[binAggregateLength$1];
        for (int index = 0; index < binAggregateLength$1; ++index) {
            combinedAggregate[index] = agg1[index] + agg2[index];
        }
        return combinedAggregate;
    }

    public final InformationGainStats org$apache$spark$mllib$tree$DecisionTree$$calculateGainForSplit$1(double[][] leftNodeAgg, int featureIndex, int splitIndex, double[][] rightNodeAgg, double topImpurity, Strategy strategy$1, int level$2) {
        Enumeration.Value value;
        block11: {
            InformationGainStats informationGainStats;
            block10: {
                double impurity;
                double d;
                block9: {
                    double impurity2;
                    value = strategy$1.algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Classification();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block9;
                    double left0Count = leftNodeAgg[featureIndex][2 * splitIndex];
                    double left1Count = leftNodeAgg[featureIndex][2 * splitIndex + 1];
                    double leftCount = left0Count + left1Count;
                    double right0Count = rightNodeAgg[featureIndex][2 * splitIndex];
                    double right1Count = rightNodeAgg[featureIndex][2 * splitIndex + 1];
                    double rightCount = right0Count + right1Count;
                    double d2 = impurity2 = level$2 > 0 ? topImpurity : strategy$1.impurity().calculate(left0Count + right0Count, left1Count + right1Count);
                    if (leftCount == 0.0) {
                        return new InformationGainStats(0.0, topImpurity, Double$.MODULE$.MinValue(), topImpurity, 1.0);
                    }
                    if (rightCount == 0.0) {
                        return new InformationGainStats(0.0, topImpurity, topImpurity, Double$.MODULE$.MinValue(), 0.0);
                    }
                    double leftImpurity = strategy$1.impurity().calculate(left0Count, left1Count);
                    double rightImpurity = strategy$1.impurity().calculate(right0Count, right1Count);
                    double leftWeight = leftCount / (leftCount + rightCount);
                    double rightWeight = rightCount / (leftCount + rightCount);
                    double gain = level$2 > 0 ? impurity2 - leftWeight * leftImpurity - rightWeight * rightImpurity : impurity2 - leftWeight * leftImpurity - rightWeight * rightImpurity;
                    double predict2 = (left1Count + right1Count) / (leftCount + rightCount);
                    informationGainStats = new InformationGainStats(gain, impurity2, leftImpurity, rightImpurity, predict2);
                    break block10;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Regression();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block11;
                double leftCount = leftNodeAgg[featureIndex][3 * splitIndex];
                double leftSum = leftNodeAgg[featureIndex][3 * splitIndex + 1];
                double leftSumSquares = leftNodeAgg[featureIndex][3 * splitIndex + 2];
                double rightCount = rightNodeAgg[featureIndex][3 * splitIndex];
                double rightSum = rightNodeAgg[featureIndex][3 * splitIndex + 1];
                double rightSumSquares = rightNodeAgg[featureIndex][3 * splitIndex + 2];
                if (level$2 > 0) {
                    d = topImpurity;
                } else {
                    double count = leftCount + rightCount;
                    double sum = leftSum + rightSum;
                    double sumSquares = leftSumSquares + rightSumSquares;
                    d = impurity = strategy$1.impurity().calculate(count, sum, sumSquares);
                }
                if (leftCount == 0.0) {
                    return new InformationGainStats(0.0, topImpurity, Double$.MODULE$.MinValue(), topImpurity, rightSum / rightCount);
                }
                if (rightCount == 0.0) {
                    return new InformationGainStats(0.0, topImpurity, topImpurity, Double$.MODULE$.MinValue(), leftSum / leftCount);
                }
                double leftImpurity = strategy$1.impurity().calculate(leftCount, leftSum, leftSumSquares);
                double rightImpurity = strategy$1.impurity().calculate(rightCount, rightSum, rightSumSquares);
                double leftWeight = leftCount / (leftCount + rightCount);
                double rightWeight = rightCount / (leftCount + rightCount);
                double gain = level$2 > 0 ? impurity - leftWeight * leftImpurity - rightWeight * rightImpurity : impurity - leftWeight * leftImpurity - rightWeight * rightImpurity;
                double predict3 = (leftSum + rightSum) / (leftCount + rightCount);
                informationGainStats = new InformationGainStats(gain, impurity, leftImpurity, rightImpurity, predict3);
            }
            return informationGainStats;
        }
        throw new MatchError((Object)value);
    }

    private final Tuple2 extractLeftRightNodeAggregates$1(double[] binData, Strategy strategy$1, int numFeatures$1, int numBins$2) {
        Enumeration.Value value;
        block8: {
            Tuple2 tuple2;
            block7: {
                block6: {
                    value = strategy$1.algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Classification();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block6;
                    double[][] leftNodeAgg = (double[][])Array$.MODULE$.ofDim(numFeatures$1, 2 * (numBins$2 - 1), ClassTag$.MODULE$.Double());
                    double[][] rightNodeAgg = (double[][])Array$.MODULE$.ofDim(numFeatures$1, 2 * (numBins$2 - 1), ClassTag$.MODULE$.Double());
                    for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
                        int shift = 2 * featureIndex * numBins$2;
                        leftNodeAgg[featureIndex][0] = binData[shift + 0];
                        leftNodeAgg[featureIndex][1] = binData[shift + 1];
                        rightNodeAgg[featureIndex][2 * (numBins$2 - 2)] = binData[shift + 2 * (numBins$2 - 1)];
                        rightNodeAgg[featureIndex][2 * (numBins$2 - 2) + 1] = binData[shift + 2 * (numBins$2 - 1) + 1];
                        for (int splitIndex = 1; splitIndex < numBins$2 - 1; ++splitIndex) {
                            leftNodeAgg[featureIndex][2 * splitIndex] = binData[shift + 2 * splitIndex] + leftNodeAgg[featureIndex][2 * splitIndex - 2];
                            leftNodeAgg[featureIndex][2 * splitIndex + 1] = binData[shift + 2 * splitIndex + 1] + leftNodeAgg[featureIndex][2 * splitIndex - 2 + 1];
                            rightNodeAgg[featureIndex][2 * (numBins$2 - 2 - splitIndex)] = binData[shift + 2 * (numBins$2 - 2 - splitIndex)] + rightNodeAgg[featureIndex][2 * (numBins$2 - 1 - splitIndex)];
                            rightNodeAgg[featureIndex][2 * (numBins$2 - 2 - splitIndex) + 1] = binData[shift + (2 * (numBins$2 - 2 - splitIndex) + 1)] + rightNodeAgg[featureIndex][2 * (numBins$2 - 1 - splitIndex) + 1];
                        }
                    }
                    tuple2 = new Tuple2((Object)leftNodeAgg, (Object)rightNodeAgg);
                    break block7;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Regression();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block8;
                double[][] leftNodeAgg = (double[][])Array$.MODULE$.ofDim(numFeatures$1, 3 * (numBins$2 - 1), ClassTag$.MODULE$.Double());
                double[][] rightNodeAgg = (double[][])Array$.MODULE$.ofDim(numFeatures$1, 3 * (numBins$2 - 1), ClassTag$.MODULE$.Double());
                for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
                    int shift = 3 * featureIndex * numBins$2;
                    leftNodeAgg[featureIndex][0] = binData[shift + 0];
                    leftNodeAgg[featureIndex][1] = binData[shift + 1];
                    leftNodeAgg[featureIndex][2] = binData[shift + 2];
                    rightNodeAgg[featureIndex][3 * (numBins$2 - 2)] = binData[shift + 3 * (numBins$2 - 1)];
                    rightNodeAgg[featureIndex][3 * (numBins$2 - 2) + 1] = binData[shift + 3 * (numBins$2 - 1) + 1];
                    rightNodeAgg[featureIndex][3 * (numBins$2 - 2) + 2] = binData[shift + 3 * (numBins$2 - 1) + 2];
                    for (int splitIndex = 1; splitIndex < numBins$2 - 1; ++splitIndex) {
                        leftNodeAgg[featureIndex][3 * splitIndex] = binData[shift + 3 * splitIndex] + leftNodeAgg[featureIndex][3 * splitIndex - 3];
                        leftNodeAgg[featureIndex][3 * splitIndex + 1] = binData[shift + 3 * splitIndex + 1] + leftNodeAgg[featureIndex][3 * splitIndex - 3 + 1];
                        leftNodeAgg[featureIndex][3 * splitIndex + 2] = binData[shift + 3 * splitIndex + 2] + leftNodeAgg[featureIndex][3 * splitIndex - 3 + 2];
                        rightNodeAgg[featureIndex][3 * (numBins$2 - 2 - splitIndex)] = binData[shift + 3 * (numBins$2 - 2 - splitIndex)] + rightNodeAgg[featureIndex][3 * (numBins$2 - 1 - splitIndex)];
                        rightNodeAgg[featureIndex][3 * (numBins$2 - 2 - splitIndex) + 1] = binData[shift + (3 * (numBins$2 - 2 - splitIndex) + 1)] + rightNodeAgg[featureIndex][3 * (numBins$2 - 1 - splitIndex) + 1];
                        rightNodeAgg[featureIndex][3 * (numBins$2 - 2 - splitIndex) + 2] = binData[shift + (3 * (numBins$2 - 2 - splitIndex) + 2)] + rightNodeAgg[featureIndex][3 * (numBins$2 - 1 - splitIndex) + 2];
                    }
                }
                tuple2 = new Tuple2((Object)leftNodeAgg, (Object)rightNodeAgg);
            }
            return tuple2;
        }
        throw new MatchError((Object)value);
    }

    private final InformationGainStats[][] calculateGainsForAllNodeSplits$1(double[][] leftNodeAgg, double[][] rightNodeAgg, double nodeImpurity, Strategy strategy$1, int level$2, int numFeatures$1, int numBins$2) {
        InformationGainStats[][] gains = (InformationGainStats[][])Array$.MODULE$.ofDim(numFeatures$1, numBins$2 - 1, ClassTag$.MODULE$.apply(InformationGainStats.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures$1).foreach$mVc$sp((Function1)new Serializable(strategy$1, level$2, numBins$2, leftNodeAgg, rightNodeAgg, nodeImpurity, gains){
            public static final long serialVersionUID = 0L;
            public final Strategy strategy$1;
            public final int level$2;
            private final int numBins$2;
            public final double[][] leftNodeAgg$1;
            public final double[][] rightNodeAgg$1;
            public final double nodeImpurity$1;
            public final InformationGainStats[][] gains$1;

            public final void apply(int featureIndex) {
                this.apply$mcVI$sp(featureIndex);
            }

            public void apply$mcVI$sp(int featureIndex) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numBins$2 - 1).foreach$mVc$sp((Function1)new Serializable(this, featureIndex){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.calculateGainsForAllNodeSplits.1.1 $outer;
                    private final int featureIndex$3;

                    public final void apply(int splitIndex) {
                        this.apply$mcVI$sp(splitIndex);
                    }

                    public void apply$mcVI$sp(int splitIndex) {
                        this.$outer.gains$1[this.featureIndex$3][splitIndex] = DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$calculateGainForSplit$1(this.$outer.leftNodeAgg$1, this.featureIndex$3, splitIndex, this.$outer.rightNodeAgg$1, this.$outer.nodeImpurity$1, this.$outer.strategy$1, this.$outer.level$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.featureIndex$3 = featureIndex$3;
                    }
                });
            }
            {
                this.strategy$1 = strategy$1;
                this.level$2 = level$2;
                this.numBins$2 = numBins$2;
                this.leftNodeAgg$1 = leftNodeAgg$1;
                this.rightNodeAgg$1 = rightNodeAgg$1;
                this.nodeImpurity$1 = nodeImpurity$1;
                this.gains$1 = gains$1;
            }
        });
        return gains;
    }

    private final Tuple2 binsToBestSplit$1(double[] binData, double nodeImpurity, Strategy strategy$1, int level$2, Split[][] splits$1, Bin[][] bins$1, int numFeatures$1, int numBins$2) {
        this.logDebug((Function0<String>)new Serializable(nodeImpurity){
            public static final long serialVersionUID = 0L;
            private final double nodeImpurity$2;

            public final String apply() {
                return new StringBuilder().append((Object)"node impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.nodeImpurity$2)).toString();
            }
            {
                this.nodeImpurity$2 = nodeImpurity$2;
            }
        });
        Tuple2 tuple2 = this.extractLeftRightNodeAggregates$1(binData, strategy$1, numFeatures$1, numBins$2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            double[][] leftNodeAgg = (double[][])tuple2._1();
            double[][] rightNodeAgg = (double[][])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftNodeAgg, (Object)rightNodeAgg);
            double[][] leftNodeAgg2 = (double[][])tuple23._1();
            double[][] rightNodeAgg2 = (double[][])tuple23._2();
            InformationGainStats[][] gains = this.calculateGainsForAllNodeSplits$1(leftNodeAgg2, rightNodeAgg2, nodeImpurity, strategy$1, level$2, numFeatures$1, numBins$2);
            int bestFeatureIndex = Integer.MIN_VALUE;
            int bestSplitIndex = Integer.MIN_VALUE;
            InformationGainStats bestGainStats = new InformationGainStats(Double$.MODULE$.MinValue(), -1.0, -1.0, -1.0, -1.0);
            for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
                for (int splitIndex = 0; splitIndex < numBins$2 - 1; ++splitIndex) {
                    InformationGainStats gainStats = gains[featureIndex][splitIndex];
                    if (!(gainStats.gain() > bestGainStats.gain())) continue;
                    bestGainStats = gainStats;
                    bestFeatureIndex = featureIndex;
                    bestSplitIndex = splitIndex;
                }
            }
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)bestFeatureIndex), (Object)BoxesRunTime.boxToInteger((int)bestSplitIndex), (Object)bestGainStats);
            if (tuple3 != null) {
                Tuple3 tuple32;
                int bestFeatureIndex2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int bestSplitIndex2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                InformationGainStats gainStats = (InformationGainStats)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)bestFeatureIndex2), (Object)BoxesRunTime.boxToInteger((int)bestSplitIndex2), (Object)gainStats);
                int bestFeatureIndex3 = BoxesRunTime.unboxToInt((Object)tuple33._1());
                int bestSplitIndex3 = BoxesRunTime.unboxToInt((Object)tuple33._2());
                InformationGainStats gainStats2 = (InformationGainStats)tuple33._3();
                this.logDebug((Function0<String>)new Serializable(bins$1, bestFeatureIndex3, bestSplitIndex3){
                    public static final long serialVersionUID = 0L;
                    private final Bin[][] bins$1;
                    private final int bestFeatureIndex$1;
                    private final int bestSplitIndex$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"best split bin = ").append((Object)this.bins$1[this.bestFeatureIndex$1][this.bestSplitIndex$1]).toString();
                    }
                    {
                        this.bins$1 = bins$1;
                        this.bestFeatureIndex$1 = bestFeatureIndex$1;
                        this.bestSplitIndex$1 = bestSplitIndex$1;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(splits$1, bestFeatureIndex3, bestSplitIndex3){
                    public static final long serialVersionUID = 0L;
                    private final Split[][] splits$1;
                    private final int bestFeatureIndex$1;
                    private final int bestSplitIndex$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"best split bin = ").append((Object)this.splits$1[this.bestFeatureIndex$1][this.bestSplitIndex$1]).toString();
                    }
                    {
                        this.splits$1 = splits$1;
                        this.bestFeatureIndex$1 = bestFeatureIndex$1;
                        this.bestSplitIndex$1 = bestSplitIndex$1;
                    }
                });
                return new Tuple2((Object)splits$1[bestFeatureIndex3][bestSplitIndex3], (Object)gainStats2);
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    private final double[] getBinDataForNode$1(int node, Strategy strategy$1, int numFeatures$1, int numBins$2, double[] binAggregates$1) {
        Enumeration.Value value;
        block4: {
            double[] dArray;
            block3: {
                double[] binsForNode;
                block2: {
                    double[] binsForNode2;
                    value = strategy$1.algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Classification();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    int shift = 2 * node * numBins$2 * numFeatures$1;
                    dArray = binsForNode2 = (double[])Predef$.MODULE$.doubleArrayOps(binAggregates$1).slice(shift, shift + 2 * numBins$2 * numFeatures$1);
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Regression();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                int shift = 3 * node * numBins$2 * numFeatures$1;
                dArray = binsForNode = (double[])Predef$.MODULE$.doubleArrayOps(binAggregates$1).slice(shift, shift + 3 * numBins$2 * numFeatures$1);
            }
            return dArray;
        }
        throw new MatchError((Object)value);
    }

    private DecisionTree$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.InvalidBinIndex = -1;
    }
}

