/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.Filter;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.IndexedSeqView$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u0001\u0003\u00015\u0011A\u0002R3dSNLwN\u001c+sK\u0016T!a\u0001\u0003\u0002\tQ\u0014X-\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001$G\u0007\u0002\r%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!b\u0001\n\u0013i\u0012\u0001C:ue\u0006$XmZ=\u0016\u0003y\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0002\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\t\u0019\u0003E\u0001\u0005TiJ\fG/Z4z\u0011!)\u0003A!A!\u0002\u0013q\u0012!C:ue\u0006$XmZ=!\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0011\u0011f\u000b\t\u0003U\u0001i\u0011A\u0001\u0005\u00069\u0019\u0002\rA\b\u0005\u0006[\u0001!\tAL\u0001\u0006iJ\f\u0017N\u001c\u000b\u0003_U\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0002\u0002\u000b5|G-\u001a7\n\u0005Q\n$!\u0005#fG&\u001c\u0018n\u001c8Ue\u0016,Wj\u001c3fY\")a\u0007\fa\u0001o\u0005)\u0011N\u001c9viB\u0019\u0001hO\u001f\u000e\u0003eR!A\u000f\u0004\u0002\u0007I$G-\u0003\u0002=s\t\u0019!\u000b\u0012#\u0011\u0005y\nU\"A \u000b\u0005\u0001#\u0011A\u0003:fOJ,7o]5p]&\u0011!i\u0010\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\u0006\t\u0002!I!R\u0001\u0010Kb$(/Y2u\u001d>$W-\u00138g_R)a)\u0013+Z7B\u0011qbR\u0005\u0003\u0011B\u0011A!\u00168ji\")!j\u0011a\u0001\u0017\u0006qan\u001c3f'Bd\u0017\u000e^*uCR\u001c\b\u0003B\bM\u001dFK!!\u0014\t\u0003\rQ+\b\u000f\\33!\t\u0001t*\u0003\u0002Qc\t)1\u000b\u001d7jiB\u0011\u0001GU\u0005\u0003'F\u0012A#\u00138g_Jl\u0017\r^5p]\u001e\u000b\u0017N\\*uCR\u001c\b\"B+D\u0001\u00041\u0016!\u00027fm\u0016d\u0007CA\bX\u0013\tA\u0006CA\u0002J]RDQAW\"A\u0002Y\u000bQ!\u001b8eKbDQ\u0001X\"A\u0002u\u000bQA\\8eKN\u00042a\u00040a\u0013\ty\u0006CA\u0003BeJ\f\u0017\u0010\u0005\u00021C&\u0011!-\r\u0002\u0005\u001d>$W\rC\u0003e\u0001\u0011%Q-A\rfqR\u0014\u0018m\u0019;J]\u001a|gi\u001c:M_^,'\u000fT3wK2\u001cHc\u0002$gO\"T7.\u001d\u0005\u0006+\u000e\u0004\rA\u0016\u0005\u00065\u000e\u0004\rA\u0016\u0005\u0006S\u000e\u0004\rAV\u0001\t[\u0006DH)\u001a9uQ\")!j\u0019a\u0001\u0017\")An\u0019a\u0001[\u0006\u0001\u0002/\u0019:f]RLU\u000e];sSRLWm\u001d\t\u0004\u001fys\u0007CA\bp\u0013\t\u0001\bC\u0001\u0004E_V\u0014G.\u001a\u0005\u0006e\u000e\u0004\ra]\u0001\bM&dG/\u001a:t!\rya\f\u001e\t\u0005kv\f\tA\u0004\u0002ww:\u0011qO_\u0007\u0002q*\u0011\u0011\u0010D\u0001\u0007yI|w\u000e\u001e \n\u0003EI!\u0001 \t\u0002\u000fA\f7m[1hK&\u0011ap \u0002\u0005\u0019&\u001cHO\u0003\u0002}!A\u0019\u0001'a\u0001\n\u0007\u0005\u0015\u0011G\u0001\u0004GS2$XM\u001d\u0015\u0004\u0001\u0005%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=a!\u0001\u0006b]:|G/\u0019;j_:LA!a\u0005\u0002\u000e\taQ\t\u001f9fe&lWM\u001c;bY\u001e9\u0011q\u0003\u0002\t\u0002\u0005e\u0011\u0001\u0004#fG&\u001c\u0018n\u001c8Ue\u0016,\u0007c\u0001\u0016\u0002\u001c\u00191\u0011A\u0001E\u0001\u0003;\u0019R!a\u0007\u000f)]AqaJA\u000e\t\u0003\t\t\u0003\u0006\u0002\u0002\u001a!9Q&a\u0007\u0005\u0002\u0005\u0015B#B\u0018\u0002(\u0005%\u0002B\u0002\u001c\u0002$\u0001\u0007q\u0007\u0003\u0004\u001d\u0003G\u0001\rA\b\u0005\b[\u0005mA\u0011AA\u0017)%y\u0013qFA\u0019\u00037\nI\u0007\u0003\u00047\u0003W\u0001\ra\u000e\u0005\t\u0003g\tY\u00031\u0001\u00026\u0005!\u0011\r\\4p!\u0011\t9$!\u0016\u000f\t\u0005e\u0012\u0011\u000b\b\u0005\u0003w\tyE\u0004\u0003\u0002>\u00055c\u0002BA \u0003\u0017rA!!\u0011\u0002J9!\u00111IA$\u001d\r9\u0018QI\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011BA\u0011\u0003\u0013\r\t\u0019\u0006I\u0001\u0005\u00032<w.\u0003\u0003\u0002X\u0005e#\u0001B!mO>T1!a\u0015!\u0011!\ti&a\u000bA\u0002\u0005}\u0013\u0001C5naV\u0014\u0018\u000e^=\u0011\t\u0005\u0005\u0014QM\u0007\u0003\u0003GR1!!\u0018\u0003\u0013\u0011\t9'a\u0019\u0003\u0011%k\u0007/\u001e:jifDa![A\u0016\u0001\u00041\u0006bB\u0017\u0002\u001c\u0011\u0005\u0011Q\u000e\u000b\u0010_\u0005=\u0014\u0011OA:\u0003k\n9(a\u001f\u0002\u000e\"1a'a\u001bA\u0002]B\u0001\"a\r\u0002l\u0001\u0007\u0011Q\u0007\u0005\t\u0003;\nY\u00071\u0001\u0002`!1\u0011.a\u001bA\u0002YCq!!\u001f\u0002l\u0001\u0007a+A\u0004nCb\u0014\u0015N\\:\t\u0011\u0005u\u00141\u000ea\u0001\u0003\u007f\n1$];b]RLG.Z\"bY\u000e,H.\u0019;j_:\u001cFO]1uK\u001eL\b\u0003BAA\u0003\u000fsA!!\u000f\u0002\u0004&\u0019\u0011Q\u0011\u0011\u0002!E+\u0018M\u001c;jY\u0016\u001cFO]1uK\u001eL\u0018\u0002BAE\u0003\u0017\u0013\u0001#U;b]RLG.Z*ue\u0006$XmZ=\u000b\u0007\u0005\u0015\u0005\u0005\u0003\u0005\u0002\u0010\u0006-\u0004\u0019AAI\u0003]\u0019\u0017\r^3h_JL7-\u00197GK\u0006$XO]3t\u0013:4w\u000e\u0005\u0004\u0002\u0014\u0006eeK\u0016\b\u0004\u001f\u0005U\u0015bAAL!\u00051\u0001K]3eK\u001aLA!a'\u0002\u001e\n\u0019Q*\u00199\u000b\u0007\u0005]\u0005\u0003\u0003\u0006\u0002\"\u0006m!\u0019!C\u0005\u0003G\u000bq\"\u00138wC2LGMQ5o\u0013:$W\r_\u000b\u0002-\"A\u0011qUA\u000eA\u0003%a+\u0001\tJ]Z\fG.\u001b3CS:Le\u000eZ3yA!I\u00111VA\u000e\t#\u0011\u0011QV\u0001\u000fM&tGMQ3tiN\u0003H.\u001b;t)I\ty+!-\u00024\u0006U\u0016qWA]\u0003w\u000b\u0019-!5\u0011\u0007=q6\n\u0003\u00047\u0003S\u0003\ra\u000e\u0005\u0007Y\u0006%\u0006\u0019A7\t\rq\tI\u000b1\u0001\u001f\u0011\u0019)\u0016\u0011\u0016a\u0001-\"1!/!+A\u0002MD\u0001\"!0\u0002*\u0002\u0007\u0011qX\u0001\u0007gBd\u0017\u000e^:\u0011\t=q\u0016\u0011\u0019\t\u0004\u001fys\u0005\u0002CAc\u0003S\u0003\r!a2\u0002\t\tLgn\u001d\t\u0005\u001fy\u000bI\r\u0005\u0003\u0010=\u0006-\u0007c\u0001\u0019\u0002N&\u0019\u0011qZ\u0019\u0003\u0007\tKg\u000eC\u0004\u0002T\u0006%\u0006\u0019\u0001,\u0002-5\f\u0007\u0010T3wK24uN]*j]\u001edWm\u0012:pkBD\u0001\"a6\u0002\u001c\u0011%\u0011\u0011\\\u0001\u0017M&tGMQ3tiN\u0003H.\u001b;t!\u0016\u0014xI]8vaR!\u0012qVAn\u0003;\fy.!9\u0002d\u0006\u0015\u0018q]Au\u0003[DaANAk\u0001\u00049\u0004B\u00027\u0002V\u0002\u0007Q\u000e\u0003\u0004\u001d\u0003+\u0004\rA\b\u0005\u0007+\u0006U\u0007\u0019\u0001,\t\rI\f)\u000e1\u0001t\u0011!\ti,!6A\u0002\u0005}\u0006\u0002CAc\u0003+\u0004\r!a2\t\u0013\u0005-\u0018Q\u001bI\u0001\u0002\u00041\u0016!\u00038v[\u001e\u0013x.\u001e9t\u0011%\ty/!6\u0011\u0002\u0003\u0007a+\u0001\u0006he>,\b/\u00138eKbD\u0011\"a=\u0002\u001c\u0011E!!!>\u0002\u001d\u0019Lg\u000eZ*qY&$8OQ5ogR1\u0011q_A}\u0003w\u0004ba\u0004'\u0002@\u0006\u001d\u0007B\u0002\u001c\u0002r\u0002\u0007q\u0007\u0003\u0004\u001d\u0003c\u0004\rA\b\u0005\u000b\u0003\u007f\fY\"%A\u0005\n\t\u0005\u0011\u0001\t4j]\u0012\u0014Um\u001d;Ta2LGo\u001d)fe\u001e\u0013x.\u001e9%I\u00164\u0017-\u001e7uIa*\"Aa\u0001+\u0007Y\u0013)a\u000b\u0002\u0003\bA!!\u0011\u0002B\t\u001b\t\u0011YA\u0003\u0003\u0003\u000e\t=\u0011!C;oG\",7m[3e\u0015\r\ty\u0001E\u0005\u0005\u0005'\u0011YAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!Ba\u0006\u0002\u001cE\u0005I\u0011\u0002B\u0001\u0003\u00012\u0017N\u001c3CKN$8\u000b\u001d7jiN\u0004VM]$s_V\u0004H\u0005Z3gCVdG\u000fJ\u001d\t\u0015\tm\u00111DA\u0001\n\u0013\u0011i\"A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0010!\u0011\u0011\tCa\u000b\u000e\u0005\t\r\"\u0002\u0002B\u0013\u0005O\tA\u0001\\1oO*\u0011!\u0011F\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003.\t\r\"AB(cU\u0016\u001cG\u000f")
public class DecisionTree
implements Serializable,
Logging {
    private final Strategy org$apache$spark$mllib$tree$DecisionTree$$strategy;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Strategy org$apache$spark$mllib$tree$DecisionTree$$strategy() {
        return this.org$apache$spark$mllib$tree$DecisionTree$$strategy;
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input) {
        Tuple2<Split[][], Bin[][]> tuple2;
        block5: {
            Enumeration.Value value;
            block8: {
                int n;
                int maxMemoryUsage;
                Node[] nodes;
                double[] parentImpurities;
                List[] filters;
                int maxDepth;
                Bin[][] bins;
                Split[][] splits;
                block7: {
                    int numFeatures;
                    int numBins;
                    block6: {
                        Tuple2 tuple22;
                        input.cache();
                        this.logDebug((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DecisionTree $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"algo = ").append((Object)this.$outer.org$apache$spark$mllib$tree$DecisionTree$$strategy().algo()).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        tuple2 = DecisionTree$.MODULE$.findSplitsBins(input, this.org$apache$spark$mllib$tree$DecisionTree$$strategy());
                        if (tuple2 == null) break block5;
                        Split[][] splits2 = (Split[][])tuple2._1();
                        Bin[][] bins2 = (Bin[][])tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits2, (Object)bins2);
                        splits = (Split[][])tuple23._1();
                        bins = (Bin[][])tuple23._2();
                        numBins = bins[0].length;
                        this.logDebug((Function0<String>)new Serializable(this, numBins){
                            public static final long serialVersionUID = 0L;
                            private final int numBins$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"numBins = ").append((Object)BoxesRunTime.boxToInteger((int)this.numBins$1)).toString();
                            }
                            {
                                this.numBins$1 = numBins$1;
                            }
                        });
                        maxDepth = this.org$apache$spark$mllib$tree$DecisionTree$$strategy().maxDepth();
                        int maxNumNodes = (int)package$.MODULE$.pow(2.0, (double)maxDepth) - 1;
                        filters = new List[maxNumNodes];
                        filters[0] = Nil$.MODULE$;
                        parentImpurities = new double[maxNumNodes];
                        nodes = new Node[maxNumNodes];
                        numFeatures = ((LabeledPoint[])input.take(1))[0].features().size();
                        maxMemoryUsage = this.org$apache$spark$mllib$tree$DecisionTree$$strategy().maxMemoryInMB() * 1024 * 1024;
                        this.logDebug((Function0<String>)new Serializable(this, maxMemoryUsage){
                            public static final long serialVersionUID = 0L;
                            private final int maxMemoryUsage$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"max memory usage for aggregates = ").append((Object)BoxesRunTime.boxToInteger((int)this.maxMemoryUsage$1)).append((Object)" bytes.").toString();
                            }
                            {
                                this.maxMemoryUsage$1 = maxMemoryUsage$1;
                            }
                        });
                        value = this.org$apache$spark$mllib$tree$DecisionTree$$strategy().algo();
                        Enumeration.Value value2 = Algo$.MODULE$.Classification();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block6;
                        n = 2 * numBins * numFeatures;
                        break block7;
                    }
                    Enumeration.Value value4 = Algo$.MODULE$.Regression();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block8;
                    n = 3 * numBins * numFeatures;
                }
                int numElementsPerNode = n;
                this.logDebug((Function0<String>)new Serializable(this, numElementsPerNode){
                    public static final long serialVersionUID = 0L;
                    private final int numElementsPerNode$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"numElementsPerNode = ").append((Object)BoxesRunTime.boxToInteger((int)this.numElementsPerNode$1)).toString();
                    }
                    {
                        this.numElementsPerNode$1 = numElementsPerNode$1;
                    }
                });
                int arraySizePerNode = 8 * numElementsPerNode;
                int maxNumberOfNodesPerGroup = package$.MODULE$.max(maxMemoryUsage / arraySizePerNode, 1);
                this.logDebug((Function0<String>)new Serializable(this, maxNumberOfNodesPerGroup){
                    public static final long serialVersionUID = 0L;
                    private final int maxNumberOfNodesPerGroup$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"maxNumberOfNodesPerGroup = ").append((Object)BoxesRunTime.boxToInteger((int)this.maxNumberOfNodesPerGroup$1)).toString();
                    }
                    {
                        this.maxNumberOfNodesPerGroup$1 = maxNumberOfNodesPerGroup$1;
                    }
                });
                int maxLevelForSingleGroup = package$.MODULE$.max((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)maxNumberOfNodesPerGroup) / package$.MODULE$.log(2.0))), 0);
                this.logDebug((Function0<String>)new Serializable(this, maxLevelForSingleGroup){
                    public static final long serialVersionUID = 0L;
                    private final int maxLevelForSingleGroup$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"max level for single group = ").append((Object)BoxesRunTime.boxToInteger((int)this.maxLevelForSingleGroup$1)).toString();
                    }
                    {
                        this.maxLevelForSingleGroup$1 = maxLevelForSingleGroup$1;
                    }
                });
                IntRef level = new IntRef(0);
                boolean bl = false;
                while (level.elem < maxDepth && !bl) {
                    this.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "#####################################";
                        }
                    });
                    this.logDebug((Function0<String>)new Serializable(this, level){
                        public static final long serialVersionUID = 0L;
                        private final IntRef level$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"level = ").append((Object)BoxesRunTime.boxToInteger((int)this.level$1.elem)).toString();
                        }
                        {
                            this.level$1 = level$1;
                        }
                    });
                    this.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "#####################################";
                        }
                    });
                    Tuple2<Split, InformationGainStats>[] splitsStatsForLevel = DecisionTree$.MODULE$.findBestSplits(input, parentImpurities, this.org$apache$spark$mllib$tree$DecisionTree$$strategy(), level.elem, filters, splits, bins, maxLevelForSingleGroup);
                    ((IterableLike)((TraversableViewLike)Predef$.MODULE$.refArrayOps((Object[])splitsStatsForLevel).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Tuple2<Split, InformationGainStats>, Object> check$ifrefutable$1) {
                            Tuple2<Tuple2<Split, InformationGainStats>, Object> tuple2 = check$ifrefutable$1;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    })).foreach((Function1)new Serializable(this, maxDepth, filters, parentImpurities, nodes, level){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DecisionTree $outer;
                        private final int maxDepth$1;
                        private final List[] filters$1;
                        private final double[] parentImpurities$1;
                        private final Node[] nodes$1;
                        private final IntRef level$1;

                        public final void apply(Tuple2<Tuple2<Split, InformationGainStats>, Object> x$2) {
                            Tuple2<Tuple2<Split, InformationGainStats>, Object> tuple2 = x$2;
                            if (tuple2 != null) {
                                Tuple2 nodeSplitStats = (Tuple2)tuple2._1();
                                int index = tuple2._2$mcI$sp();
                                this.$outer.org$apache$spark$mllib$tree$DecisionTree$$extractNodeInfo((Tuple2<Split, InformationGainStats>)nodeSplitStats, this.level$1.elem, index, this.nodes$1);
                                this.$outer.org$apache$spark$mllib$tree$DecisionTree$$extractInfoForLowerLevels(this.level$1.elem, index, this.maxDepth$1, (Tuple2<Split, InformationGainStats>)nodeSplitStats, this.parentImpurities$1, this.filters$1);
                                this.$outer.logDebug((Function0<String>)new Serializable(this, nodeSplitStats){
                                    public static final long serialVersionUID = 0L;
                                    private final Tuple2 nodeSplitStats$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"final best split = ").append(this.nodeSplitStats$1._1()).toString();
                                    }
                                    {
                                        this.nodeSplitStats$1 = nodeSplitStats$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.maxDepth$1 = maxDepth$1;
                            this.filters$1 = filters$1;
                            this.parentImpurities$1 = parentImpurities$1;
                            this.nodes$1 = nodes$1;
                            this.level$1 = level$1;
                        }
                    });
                    Predef$.MODULE$.require(package$.MODULE$.pow(2.0, (double)level.elem) == (double)splitsStatsForLevel.length);
                    boolean allLeaf = Predef$.MODULE$.refArrayOps((Object[])splitsStatsForLevel).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Split, InformationGainStats> x$3) {
                            return ((InformationGainStats)x$3._2()).gain() <= 0.0;
                        }
                    });
                    this.logDebug((Function0<String>)new Serializable(this, allLeaf){
                        public static final long serialVersionUID = 0L;
                        private final boolean allLeaf$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"all leaf = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.allLeaf$1)).toString();
                        }
                        {
                            this.allLeaf$1 = allLeaf$1;
                        }
                    });
                    if (allLeaf) {
                        bl = true;
                        continue;
                    }
                    ++level.elem;
                }
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "#####################################";
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Extracting tree model";
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "#####################################";
                    }
                });
                Node topNode = nodes[0];
                topNode.build(nodes);
                return new DecisionTreeModel(topNode, this.org$apache$spark$mllib$tree$DecisionTree$$strategy().algo());
            }
            throw new MatchError((Object)value);
        }
        throw new MatchError(tuple2);
    }

    public void org$apache$spark$mllib$tree$DecisionTree$$extractNodeInfo(Tuple2<Split, InformationGainStats> nodeSplitStats, int level, int index, Node[] nodes) {
        Split split = (Split)nodeSplitStats._1();
        InformationGainStats stats = (InformationGainStats)nodeSplitStats._2();
        int nodeIndex = (int)package$.MODULE$.pow(2.0, (double)level) - 1 + index;
        boolean isLeaf = stats.gain() <= 0.0 || level == this.org$apache$spark$mllib$tree$DecisionTree$$strategy().maxDepth() - 1;
        Node node = new Node(nodeIndex, stats.predict(), isLeaf, (Option<Split>)new Some((Object)split), (Option<Node>)None$.MODULE$, (Option<Node>)None$.MODULE$, (Option<InformationGainStats>)new Some((Object)stats));
        this.logDebug((Function0<String>)new Serializable(this, node){
            public static final long serialVersionUID = 0L;
            private final Node node$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Node = ").append((Object)this.node$1).toString();
            }
            {
                this.node$1 = node$1;
            }
        });
        nodes[nodeIndex] = node;
    }

    public void org$apache$spark$mllib$tree$DecisionTree$$extractInfoForLowerLevels(int level, int index, int maxDepth, Tuple2<Split, InformationGainStats> nodeSplitStats, double[] parentImpurities, List<Filter>[] filters) {
        for (int i = 0; i <= 1; ++i) {
            Filter childFilter;
            int nodeIndex = (int)package$.MODULE$.pow(2.0, (double)(level + 1)) - 1 + 2 * index + i;
            if (level >= maxDepth - 1) continue;
            double impurity = i == 0 ? ((InformationGainStats)nodeSplitStats._2()).leftImpurity() : ((InformationGainStats)nodeSplitStats._2()).rightImpurity();
            this.logDebug((Function0<String>)new Serializable(this, nodeIndex, impurity){
                public static final long serialVersionUID = 0L;
                private final int nodeIndex$1;
                private final double impurity$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"nodeIndex = ").append((Object)BoxesRunTime.boxToInteger((int)this.nodeIndex$1)).append((Object)", impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.impurity$1)).toString();
                }
                {
                    this.nodeIndex$1 = nodeIndex$1;
                    this.impurity$1 = impurity$1;
                }
            });
            parentImpurities[nodeIndex] = impurity;
            Filter filter = childFilter = new Filter((Split)nodeSplitStats._1(), i == 0 ? -1 : 1);
            filters[nodeIndex] = filters[(nodeIndex - 1) / 2].$colon$colon((Object)filter);
            filters[nodeIndex].foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DecisionTree $outer;

                public final void apply(Filter filter) {
                    this.$outer.logDebug((Function0<String>)new Serializable(this, filter){
                        public static final long serialVersionUID = 0L;
                        private final Filter filter$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Filter = ").append((Object)this.filter$1).toString();
                        }
                        {
                            this.filter$1 = filter$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public DecisionTree(Strategy strategy) {
        this.org$apache$spark$mllib$tree$DecisionTree$$strategy = strategy;
        Logging.class.$init$((Logging)this);
    }
}

