/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.model;

import org.apache.spark.Logging;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Split;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001=\u0011AAT8eK*\u00111\u0001B\u0001\u0006[>$W\r\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001e:fK*\u0011q\u0001C\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011-e\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002\u001b75\t\u0001\"\u0003\u0002\u001d\u0011\t9Aj\\4hS:<\u0007\u0002\u0003\u0010\u0001\u0005\u000b\u0007I\u0011A\u0010\u0002\u0005%$W#\u0001\u0011\u0011\u0005E\t\u0013B\u0001\u0012\u0013\u0005\rIe\u000e\u001e\u0005\tI\u0001\u0011\t\u0011)A\u0005A\u0005\u0019\u0011\u000e\u001a\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\nq\u0001\u001d:fI&\u001cG/F\u0001)!\t\t\u0012&\u0003\u0002+%\t1Ai\\;cY\u0016D\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\taJ,G-[2uA!Aa\u0006\u0001BC\u0002\u0013\u0005q&\u0001\u0004jg2+\u0017MZ\u000b\u0002aA\u0011\u0011#M\u0005\u0003eI\u0011qAQ8pY\u0016\fg\u000e\u0003\u00055\u0001\t\u0005\t\u0015!\u00031\u0003\u001dI7\u000fT3bM\u0002B\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\u0006gBd\u0017\u000e^\u000b\u0002qA\u0019\u0011#O\u001e\n\u0005i\u0012\"AB(qi&|g\u000e\u0005\u0002={5\t!!\u0003\u0002?\u0005\t)1\u000b\u001d7ji\"A\u0001\t\u0001B\u0001B\u0003%\u0001(\u0001\u0004ta2LG\u000f\t\u0005\t\u0005\u0002\u0011\t\u0019!C\u0001\u0007\u0006AA.\u001a4u\u001d>$W-F\u0001E!\r\t\u0012(\u0012\t\u0003y\u0001A\u0001b\u0012\u0001\u0003\u0002\u0004%\t\u0001S\u0001\rY\u00164GOT8eK~#S-\u001d\u000b\u0003\u00132\u0003\"!\u0005&\n\u0005-\u0013\"\u0001B+oSRDq!\u0014$\u0002\u0002\u0003\u0007A)A\u0002yIEB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006K\u0001R\u0001\nY\u00164GOT8eK\u0002B\u0001\"\u0015\u0001\u0003\u0002\u0004%\taQ\u0001\ne&<\u0007\u000e\u001e(pI\u0016D\u0001b\u0015\u0001\u0003\u0002\u0004%\t\u0001V\u0001\u000ee&<\u0007\u000e\u001e(pI\u0016|F%Z9\u0015\u0005%+\u0006bB'S\u0003\u0003\u0005\r\u0001\u0012\u0005\t/\u0002\u0011\t\u0011)Q\u0005\t\u0006Q!/[4ii:{G-\u001a\u0011\t\u0011e\u0003!Q1A\u0005\u0002i\u000bQa\u001d;biN,\u0012a\u0017\t\u0004#eb\u0006C\u0001\u001f^\u0013\tq&A\u0001\u000bJ]\u001a|'/\\1uS>tw)Y5o'R\fGo\u001d\u0005\tA\u0002\u0011\t\u0011)A\u00057\u000611\u000f^1ug\u0002BQA\u0019\u0001\u0005\u0002\r\fa\u0001P5oSRtD\u0003C#eK\u001a<\u0007.\u001b6\t\u000by\t\u0007\u0019\u0001\u0011\t\u000b\u0019\n\u0007\u0019\u0001\u0015\t\u000b9\n\u0007\u0019\u0001\u0019\t\u000bY\n\u0007\u0019\u0001\u001d\t\u000b\t\u000b\u0007\u0019\u0001#\t\u000bE\u000b\u0007\u0019\u0001#\t\u000be\u000b\u0007\u0019A.\t\u000b1\u0004A\u0011I7\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u0019\u0019FO]5oO\")q\u000f\u0001C\u0001q\u0006)!-^5mIR\u0011\u0011*\u001f\u0005\u0006uZ\u0004\ra_\u0001\u0006]>$Wm\u001d\t\u0004#q,\u0015BA?\u0013\u0005\u0015\t%O]1z\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u0005i\u0001O]3eS\u000e$\u0018J\u001a'fC\u001a$2\u0001KA\u0002\u0011\u001d\t)A a\u0001\u0003\u000f\tqAZ3biV\u0014X\r\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAB\u0001\u0007Y&t\u0017\r\\4\n\t\u0005E\u00111\u0002\u0002\u0007-\u0016\u001cGo\u001c:)\u0007\u0001\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\u0002C\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0010\u00033\u0011A\u0002R3wK2|\u0007/\u001a:Ba&\u0004")
public class Node
implements Serializable,
Logging {
    private final int id;
    private final double predict;
    private final boolean isLeaf;
    private final Option<Split> split;
    private Option<Node> leftNode;
    private Option<Node> rightNode;
    private final Option<InformationGainStats> stats;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int id() {
        return this.id;
    }

    public double predict() {
        return this.predict;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public Option<Split> split() {
        return this.split;
    }

    public Option<Node> leftNode() {
        return this.leftNode;
    }

    public void leftNode_$eq(Option<Node> x$1) {
        this.leftNode = x$1;
    }

    public Option<Node> rightNode() {
        return this.rightNode;
    }

    public void rightNode_$eq(Option<Node> x$1) {
        this.rightNode = x$1;
    }

    public Option<InformationGainStats> stats() {
        return this.stats;
    }

    public String toString() {
        return new StringBuilder().append((Object)"id = ").append((Object)BoxesRunTime.boxToInteger((int)this.id())).append((Object)", isLeaf = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isLeaf())).append((Object)", predict = ").append((Object)BoxesRunTime.boxToDouble((double)this.predict())).append((Object)", ").append((Object)"split = ").append(this.split()).append((Object)", stats = ").append(this.stats()).toString();
    }

    public void build(Node[] nodes) {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Node $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"building node ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.id())).append((Object)" at level ").append((Object)BoxesRunTime.boxToInteger((int)((int)(package$.MODULE$.log((double)(this.$outer.id() + 1)) / package$.MODULE$.log(2.0))))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Node $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"id = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.id())).append((Object)", split = ").append(this.$outer.split()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Node $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"stats = ").append(this.$outer.stats()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Node $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"predict = ").append((Object)BoxesRunTime.boxToDouble((double)this.$outer.predict())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (!this.isLeaf()) {
            int leftNodeIndex = this.id() * 2 + 1;
            int rightNodeIndex = this.id() * 2 + 2;
            this.leftNode_$eq((Option<Node>)new Some((Object)nodes[leftNodeIndex]));
            this.rightNode_$eq((Option<Node>)new Some((Object)nodes[rightNodeIndex]));
            ((Node)this.leftNode().get()).build(nodes);
            ((Node)this.rightNode().get()).build(nodes);
        }
    }

    public double predictIfLeaf(Vector feature) {
        double d;
        if (this.isLeaf()) {
            d = this.predict();
        } else {
            Enumeration.Value value = ((Split)this.split().get()).featureType();
            Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
            d = !(value != null ? !value.equals(value2) : value2 != null) ? (feature.apply(((Split)this.split().get()).feature()) <= ((Split)this.split().get()).threshold() ? ((Node)this.leftNode().get()).predictIfLeaf(feature) : ((Node)this.rightNode().get()).predictIfLeaf(feature)) : (((Split)this.split().get()).categories().contains((Object)BoxesRunTime.boxToDouble((double)feature.apply(((Split)this.split().get()).feature()))) ? ((Node)this.leftNode().get()).predictIfLeaf(feature) : ((Node)this.rightNode().get()).predictIfLeaf(feature));
        }
        return d;
    }

    public Node(int id, double predict2, boolean isLeaf, Option<Split> split, Option<Node> leftNode, Option<Node> rightNode, Option<InformationGainStats> stats) {
        this.id = id;
        this.predict = predict2;
        this.isLeaf = isLeaf;
        this.split = split;
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.stats = stats;
        Logging.class.$init$((Logging)this);
    }
}

