/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector$;
import breeze.linalg.NumericOps;
import breeze.linalg.Vector$;
import breeze.linalg.norm$;
import breeze.storage.DefaultArrayValue;
import org.apache.spark.Accumulable;
import org.apache.spark.Accumulator;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.clustering.BreezeVectorWithNorm;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeans$$anonfun$12$;
import org.apache.spark.mllib.clustering.KMeans$$anonfun$18$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0001\u0003\u00015\u0011aaS'fC:\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001$G\u0007\u0002\r%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!a\u0001\n\u0013i\u0012!A6\u0016\u0003y\u0001\"aD\u0010\n\u0005\u0001\u0002\"aA%oi\"A!\u0005\u0001BA\u0002\u0013%1%A\u0003l?\u0012*\u0017\u000f\u0006\u0002%OA\u0011q\"J\u0005\u0003MA\u0011A!\u00168ji\"9\u0001&IA\u0001\u0002\u0004q\u0012a\u0001=%c!A!\u0006\u0001B\u0001B\u0003&a$\u0001\u0002lA!AA\u0006\u0001BA\u0002\u0013%Q$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\t]\u0001\u0011\t\u0019!C\u0005_\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0011\u0002\u0004b\u0002\u0015.\u0003\u0003\u0005\rA\b\u0005\te\u0001\u0011\t\u0011)Q\u0005=\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0007I\u0011B\u000f\u0002\tI,hn\u001d\u0005\tm\u0001\u0011\t\u0019!C\u0005o\u0005A!/\u001e8t?\u0012*\u0017\u000f\u0006\u0002%q!9\u0001&NA\u0001\u0002\u0004q\u0002\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0010\u0002\u000bI,hn\u001d\u0011\t\u0011q\u0002!\u00111A\u0005\nu\n!#\u001b8ji&\fG.\u001b>bi&|g.T8eKV\ta\b\u0005\u0002@\u0005:\u0011q\u0002Q\u0005\u0003\u0003B\ta\u0001\u0015:fI\u00164\u0017BA\"E\u0005\u0019\u0019FO]5oO*\u0011\u0011\t\u0005\u0005\t\r\u0002\u0011\t\u0019!C\u0005\u000f\u00061\u0012N\\5uS\u0006d\u0017N_1uS>tWj\u001c3f?\u0012*\u0017\u000f\u0006\u0002%\u0011\"9\u0001&RA\u0001\u0002\u0004q\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0015\u0002 \u0002'%t\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u0011\t\u00111\u0003!\u00111A\u0005\nu\t1#\u001b8ji&\fG.\u001b>bi&|gn\u0015;faND\u0001B\u0014\u0001\u0003\u0002\u0004%IaT\u0001\u0018S:LG/[1mSj\fG/[8o'R,\u0007o]0%KF$\"\u0001\n)\t\u000f!j\u0015\u0011!a\u0001=!A!\u000b\u0001B\u0001B\u0003&a$\u0001\u000bj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000f\t\u0005\t)\u0002\u0011\t\u0019!C\u0005+\u00069Q\r]:jY>tW#\u0001,\u0011\u0005=9\u0016B\u0001-\u0011\u0005\u0019!u.\u001e2mK\"A!\f\u0001BA\u0002\u0013%1,A\u0006faNLGn\u001c8`I\u0015\fHC\u0001\u0013]\u0011\u001dA\u0013,!AA\u0002YC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006KAV\u0001\tKB\u001c\u0018\u000e\\8oA!)\u0001\r\u0001C\u0005C\u00061A(\u001b8jiz\"rA\u00193fM\u001eD\u0017\u000e\u0005\u0002d\u00015\t!\u0001C\u0003\u001d?\u0002\u0007a\u0004C\u0003-?\u0002\u0007a\u0004C\u00035?\u0002\u0007a\u0004C\u0003=?\u0002\u0007a\bC\u0003M?\u0002\u0007a\u0004C\u0003U?\u0002\u0007a\u000bC\u0003a\u0001\u0011\u00051\u000eF\u0001c\u0011\u0015i\u0007\u0001\"\u0001o\u0003\u0011\u0019X\r^&\u0015\u0005\t|\u0007\"\u0002\u000fm\u0001\u0004q\u0002\"B9\u0001\t\u0003\u0011\u0018\u0001E:fi6\u000b\u00070\u0013;fe\u0006$\u0018n\u001c8t)\t\u00117\u000fC\u0003-a\u0002\u0007a\u0004C\u0003v\u0001\u0011\u0005a/A\u000btKRLe.\u001b;jC2L'0\u0019;j_:lu\u000eZ3\u0015\u0005\t<\b\"\u0002\u001fu\u0001\u0004q\u0004\"B=\u0001\t\u0003Q\u0018aB:fiJ+hn\u001d\u000b\u0003EnDQ\u0001\u000e=A\u0002yA#\u0001_?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\tAB\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0003\u007f\naQ\t\u001f9fe&lWM\u001c;bY\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011AF:fi&s\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:\u0015\u0007\t\fi\u0001\u0003\u0004M\u0003\u000f\u0001\rA\b\u0005\b\u0003#\u0001A\u0011AA\n\u0003)\u0019X\r^#qg&dwN\u001c\u000b\u0004E\u0006U\u0001B\u0002+\u0002\u0010\u0001\u0007a\u000bC\u0004\u0002\u001a\u0001!\t!a\u0007\u0002\u0007I,h\u000e\u0006\u0003\u0002\u001e\u0005\r\u0002cA2\u0002 %\u0019\u0011\u0011\u0005\u0002\u0003\u0017-kU-\u00198t\u001b>$W\r\u001c\u0005\t\u0003K\t9\u00021\u0001\u0002(\u0005!A-\u0019;b!\u0019\tI#a\f\u000245\u0011\u00111\u0006\u0006\u0004\u0003[1\u0011a\u0001:eI&!\u0011\u0011GA\u0016\u0005\r\u0011F\t\u0012\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u0003\u0002\r1Lg.\u00197h\u0013\u0011\ti$a\u000e\u0003\rY+7\r^8s\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007\n\u0011B];o\u0005J,WM_3\u0015\t\u0005u\u0011Q\t\u0005\t\u0003K\ty\u00041\u0001\u0002HA1\u0011\u0011FA\u0018\u0003\u0013\u00022aYA&\u0013\r\tiE\u0001\u0002\u0015\u0005J,WM_3WK\u000e$xN],ji\"tuN]7\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T\u0005Q\u0011N\\5u%\u0006tGm\\7\u0015\t\u0005U\u0013Q\f\t\u0006\u001f\u0005]\u00131L\u0005\u0004\u00033\u0002\"!B!se\u0006L\b#B\b\u0002X\u0005%\u0003\u0002CA\u0013\u0003\u001f\u0002\r!a\u0012\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d\u0005\u0011\u0012N\\5u\u00176+\u0017M\\:QCJ\fG\u000e\\3m)\u0011\t)&!\u001a\t\u0011\u0005\u0015\u0012q\fa\u0001\u0003\u000f:q!!\u001b\u0003\u0011\u0003\tY'\u0001\u0004L\u001b\u0016\fgn\u001d\t\u0004G\u00065dAB\u0001\u0003\u0011\u0003\tyg\u0005\u0003\u0002n9!\u0002b\u00021\u0002n\u0011\u0005\u00111\u000f\u000b\u0003\u0003WB!\"a\u001e\u0002n\t\u0007I\u0011AA=\u0003\u0019\u0011\u0016I\u0014#P\u001bV\u0011\u00111\u0010\t\u0005\u0003{\n9)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0015\u0001\u00026bm\u0006L1aQA@\u0011%\tY)!\u001c!\u0002\u0013\tY(A\u0004S\u0003:#u*\u0014\u0011\t\u0015\u0005=\u0015Q\u000eb\u0001\n\u0003\tI(\u0001\tL?6+\u0015IT*`!\u0006\u0013\u0016\t\u0014'F\u0019\"I\u00111SA7A\u0003%\u00111P\u0001\u0012\u0017~kU)\u0011(T?B\u000b%+\u0011'M\u000b2\u0003\u0003\u0002CAL\u0003[\"\t!!'\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0019\u0005u\u00111TAO\u0003?\u000b\t+a)\t\u0011\u0005\u0015\u0012Q\u0013a\u0001\u0003OAa\u0001HAK\u0001\u0004q\u0002B\u0002\u0017\u0002\u0016\u0002\u0007a\u0004\u0003\u00045\u0003+\u0003\rA\b\u0005\u0007y\u0005U\u0005\u0019\u0001 \t\u0011\u0005]\u0015Q\u000eC\u0001\u0003O#\u0002\"!\b\u0002*\u0006-\u0016Q\u0016\u0005\t\u0003K\t)\u000b1\u0001\u0002(!1A$!*A\u0002yAa\u0001LAS\u0001\u0004q\u0002\u0002CAL\u0003[\"\t!!-\u0015\u0015\u0005u\u00111WA[\u0003o\u000bI\f\u0003\u0005\u0002&\u0005=\u0006\u0019AA\u0014\u0011\u0019a\u0012q\u0016a\u0001=!1A&a,A\u0002yAa\u0001NAX\u0001\u0004q\u0002\"CA_\u0003[\"\t\u0001BA`\u0003-1\u0017N\u001c3DY>\u001cXm\u001d;\u0015\r\u0005\u0005\u0017qYAr!\u0015y\u00111\u0019\u0010W\u0013\r\t)\r\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005%\u00171\u0018a\u0001\u0003\u0017\fqaY3oi\u0016\u00148\u000f\u0005\u0004\u0002N\u0006u\u0017\u0011\n\b\u0005\u0003\u001f\fIN\u0004\u0003\u0002R\u0006]WBAAj\u0015\r\t)\u000eD\u0001\u0007yI|w\u000e\u001e \n\u0003EI1!a7\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LA!a8\u0002b\nyAK]1wKJ\u001c\u0018M\u00197f\u001f:\u001cWMC\u0002\u0002\\BA\u0001\"!:\u0002<\u0002\u0007\u0011\u0011J\u0001\u0006a>Lg\u000e\u001e\u0005\n\u0003S\fi\u0007\"\u0001\u0005\u0003W\f\u0011\u0002]8j]R\u001cun\u001d;\u0015\u000bY\u000bi/a<\t\u0011\u0005%\u0017q\u001da\u0001\u0003\u0017D\u0001\"!:\u0002h\u0002\u0007\u0011\u0011\n\u0005\n\u0003g\fi\u0007\"\u0001\u0003\u0003k\f1CZ1tiN\u000bX/\u0019:fI\u0012K7\u000f^1oG\u0016$RAVA|\u0003wD\u0001\"!?\u0002r\u0002\u0007\u0011\u0011J\u0001\u0003mFB\u0001\"!@\u0002r\u0002\u0007\u0011\u0011J\u0001\u0003mJB!B!\u0001\u0002n\u0005\u0005I\u0011\u0002B\u0002\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0001\u0003BA?\u0005\u000fIAA!\u0003\u0002\u0000\t1qJ\u00196fGR\u0004")
public class KMeans
implements Serializable,
Logging {
    private int org$apache$spark$mllib$clustering$KMeans$$k;
    private int org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    private int org$apache$spark$mllib$clustering$KMeans$$runs;
    private String org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    private int initializationSteps;
    private double org$apache$spark$mllib$clustering$KMeans$$epsilon;
    private transient Logger org$apache$spark$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int org$apache$spark$mllib$clustering$KMeans$$k() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$maxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$runs() {
        return this.org$apache$spark$mllib$clustering$KMeans$$runs;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$runs_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$runs = x$1;
    }

    public String org$apache$spark$mllib$clustering$KMeans$$initializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(String x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    public double org$apache$spark$mllib$clustering$KMeans$$epsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(double x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = x$1;
    }

    public KMeans setK(int k) {
        this.org$apache$spark$mllib$clustering$KMeans$$k_$eq(k);
        return this;
    }

    public KMeans setMaxIterations(int maxIterations) {
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(maxIterations);
        return this;
    }

    public KMeans setInitializationMode(String initializationMode) {
        block3: {
            block2: {
                String string = initializationMode;
                String string2 = KMeans$.MODULE$.RANDOM();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = initializationMode;
                String string4 = KMeans$.MODULE$.K_MEANS_PARALLEL();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            this.org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(initializationMode);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid initialization mode: ").append((Object)initializationMode).toString());
    }

    @Experimental
    public KMeans setRuns(int runs) {
        if (runs <= 0) {
            throw new IllegalArgumentException("Number of runs must be positive");
        }
        this.org$apache$spark$mllib$clustering$KMeans$$runs_$eq(runs);
        return this;
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        if (initializationSteps <= 0) {
            throw new IllegalArgumentException("Number of initialization steps must be positive");
        }
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public KMeans setEpsilon(double epsilon) {
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(epsilon);
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        RDD norms = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Vector v) {
                return BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(v.toBreeze(), (Object)BoxesRunTime.boxToDouble((double)2.0), Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double())));
            }
        }, ClassTag$.MODULE$.Double());
        norms.persist();
        RDD breezeData = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.Vector<Object> apply(Vector x$1) {
                return x$1.toBreeze();
            }
        }, ClassTag$.MODULE$.apply(breeze.linalg.Vector.class)).zip(norms, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BreezeVectorWithNorm apply(Tuple2<breeze.linalg.Vector<Object>, Object> x0$1) {
                Tuple2<breeze.linalg.Vector<Object>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    breeze.linalg.Vector v = (breeze.linalg.Vector)tuple2._1();
                    double norm = tuple2._2$mcD$sp();
                    BreezeVectorWithNorm breezeVectorWithNorm = new BreezeVectorWithNorm((breeze.linalg.Vector<Object>)v, norm);
                    return breezeVectorWithNorm;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(BreezeVectorWithNorm.class));
        KMeansModel model = this.runBreeze((RDD<BreezeVectorWithNorm>)breezeData);
        norms.unpersist(norms.unpersist$default$1());
        return model;
    }

    private KMeansModel runBreeze(RDD<BreezeVectorWithNorm> data) {
        SparkContext sc = data.sparkContext();
        long initStartTime = System.nanoTime();
        String string = this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
        String string2 = KMeans$.MODULE$.RANDOM();
        BreezeVectorWithNorm[][] centers = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data);
        double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
        this.logInfo((Function0<String>)new Serializable(this, initTimeInSeconds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final double initTimeInSeconds$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialization with ", " took "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$clustering$KMeans$$initializationMode()}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("%.3f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.initTimeInSeconds$1)}))).append((Object)" seconds.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.initTimeInSeconds$1 = initTimeInSeconds$1;
            }
        });
        boolean[] active = (boolean[])Array$.MODULE$.fill(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }, ClassTag$.MODULE$.Boolean());
        double[] costs = (double[])Array$.MODULE$.fill(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        ArrayBuffer activeRuns = (ArrayBuffer)new ArrayBuffer().$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.org$apache$spark$mllib$clustering$KMeans$$runs()));
        IntRef iteration = new IntRef(0);
        long iterationStartTime = System.nanoTime();
        while (iteration.elem < this.org$apache$spark$mllib$clustering$KMeans$$maxIterations() && !activeRuns.isEmpty()) {
            BreezeVectorWithNorm[][] activeCenters = (BreezeVectorWithNorm[][])((TraversableOnce)activeRuns.map((Function1)new Serializable(this, centers){
                public static final long serialVersionUID = 0L;
                private final BreezeVectorWithNorm[][] centers$1;

                public final BreezeVectorWithNorm[] apply(int r) {
                    return this.centers$1[r];
                }
                {
                    this.centers$1 = centers$1;
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(BreezeVectorWithNorm.class)));
            ArrayBuffer costAccums = (ArrayBuffer)activeRuns.map((Function1)new Serializable(this, sc){
                public static final long serialVersionUID = 0L;
                private final SparkContext sc$1;

                public final Accumulator<Object> apply(int x$2) {
                    return this.sc$1.accumulator((Object)BoxesRunTime.boxToDouble((double)0.0), (AccumulatorParam)SparkContext.DoubleAccumulatorParam$.MODULE$);
                }
                {
                    this.sc$1 = sc$1;
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom());
            Map totalContribs = SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1)new Serializable(this, activeCenters, costAccums){
                public static final long serialVersionUID = 0L;
                public final BreezeVectorWithNorm[][] activeCenters$1;
                public final ArrayBuffer costAccums$1;

                public final Iterator<Tuple2<Tuple2<Object, Object>, Tuple2<breeze.linalg.Vector<Object>, Object>>> apply(Iterator<BreezeVectorWithNorm> points) {
                    int runs = this.activeCenters$1.length;
                    int k = this.activeCenters$1[0].length;
                    int dims = this.activeCenters$1[0][0].vector().length();
                    breeze.linalg.Vector[][] sums = (breeze.linalg.Vector[][])Array$.MODULE$.fill(runs, k, (Function0)new Serializable(this, dims){
                        public static final long serialVersionUID = 0L;
                        private final int dims$1;

                        public final breeze.linalg.Vector<Object> apply() {
                            return DenseVector$.MODULE$.zeros$mDc$sp(this.dims$1, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
                        }
                        {
                            this.dims$1 = dims$1;
                        }
                    }, ClassTag$.MODULE$.apply(breeze.linalg.Vector.class));
                    long[][] counts = (long[][])Array$.MODULE$.fill(runs, k, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }, ClassTag$.MODULE$.Long());
                    points.foreach((Function1)new Serializable(this, runs, sums, counts){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$12 $outer;
                        private final int runs$1;
                        public final breeze.linalg.Vector[][] sums$1;
                        public final long[][] counts$1;

                        public final void apply(BreezeVectorWithNorm point) {
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.runs$1).foreach$mVc$sp((Function1)new Serializable(this, point){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$12$$anonfun$apply$3 $outer;
                                private final BreezeVectorWithNorm point$1;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    Tuple2<Object, Object> tuple2 = KMeans$.MODULE$.findClosest((TraversableOnce<BreezeVectorWithNorm>)Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().activeCenters$1[i]), this.point$1);
                                    if (tuple2 != null) {
                                        Tuple2.mcID.sp sp2;
                                        int bestCenter = tuple2._1$mcI$sp();
                                        double cost = tuple2._2$mcD$sp();
                                        Tuple2.mcID.sp sp3 = sp2 = new Tuple2.mcID.sp(bestCenter, cost);
                                        int bestCenter2 = sp3._1$mcI$sp();
                                        double cost2 = sp3._2$mcD$sp();
                                        ((Accumulable)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().costAccums$1.apply(i)).$plus$eq((Object)BoxesRunTime.boxToDouble((double)cost2));
                                        this.$outer.sums$1[i][bestCenter2].$plus$eq(this.point$1.vector(), (UFunc.InPlaceImpl2)Vector$.MODULE$.v_v_Idempotent_UpdateOp_Double_OpAdd());
                                        long[] lArray = this.$outer.counts$1[i];
                                        lArray[bestCenter2] = lArray[bestCenter2] + 1L;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.point$1 = point$1;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$12 org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.runs$1 = runs$1;
                            this.sums$1 = sums$1;
                            this.counts$1 = counts$1;
                        }
                    });
                    IndexedSeq contribs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), runs).flatMap((Function1)new Serializable(this, k, sums, counts){
                        public static final long serialVersionUID = 0L;
                        private final int k$1;
                        public final breeze.linalg.Vector[][] sums$1;
                        public final long[][] counts$1;

                        public final IndexedSeq<Tuple2<Tuple2<Object, Object>, Tuple2<breeze.linalg.Vector<Object>, Object>>> apply(int i) {
                            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.k$1).map((Function1)new Serializable(this, i){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$12$$anonfun$14 $outer;
                                private final int i$1;

                                public final Tuple2<Tuple2<Object, Object>, Tuple2<breeze.linalg.Vector<Object>, Object>> apply(int j) {
                                    return new Tuple2((Object)new Tuple2.mcII.sp(this.i$1, j), (Object)new Tuple2((Object)this.$outer.sums$1[this.i$1][j], (Object)BoxesRunTime.boxToLong((long)this.$outer.counts$1[this.i$1][j])));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.i$1 = i$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                        }
                        {
                            this.k$1 = k$1;
                            this.sums$1 = sums$1;
                            this.counts$1 = counts$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return contribs.iterator();
                }
                {
                    this.activeCenters$1 = activeCenters$1;
                    this.costAccums$1 = costAccums$1;
                }
            }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;

                public final Tuple2<breeze.linalg.Vector<Object>, Object> apply(Tuple2<breeze.linalg.Vector<Object>, Object> p1, Tuple2<breeze.linalg.Vector<Object>, Object> p2) {
                    return this.$outer.org$apache$spark$mllib$clustering$KMeans$$mergeContribs$1(p1, p2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).collectAsMap();
            ((TraversableLike)activeRuns.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, centers, active, costs, iteration, costAccums, totalContribs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final BreezeVectorWithNorm[][] centers$1;
                private final boolean[] active$1;
                private final double[] costs$1;
                public final IntRef iteration$1;
                private final ArrayBuffer costAccums$1;
                private final Map totalContribs$1;

                public final void apply(Tuple2<Object, Object> x$5) {
                    Tuple2<Object, Object> tuple2 = x$5;
                    if (tuple2 != null) {
                        int run2 = tuple2._1$mcI$sp();
                        int i = tuple2._2$mcI$sp();
                        boolean changed = false;
                        for (int j = 0; j < this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(); ++j) {
                            Tuple2 tuple22 = (Tuple2)this.totalContribs$1.apply((Object)new Tuple2.mcII.sp(i, j));
                            if (tuple22 != null) {
                                Tuple2 tuple23;
                                breeze.linalg.Vector sum = (breeze.linalg.Vector)tuple22._1();
                                long count = tuple22._2$mcJ$sp();
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)sum, (Object)BoxesRunTime.boxToLong((long)count));
                                breeze.linalg.Vector sum2 = (breeze.linalg.Vector)tuple24._1();
                                long count2 = tuple24._2$mcJ$sp();
                                if (count2 == 0L) continue;
                                sum2.$div$eq((Object)BoxesRunTime.boxToDouble((double)count2), (UFunc.InPlaceImpl2)Vector$.MODULE$.v_s_UpdateOp_Double_OpDiv());
                                BreezeVectorWithNorm newCenter = new BreezeVectorWithNorm((breeze.linalg.Vector<Object>)sum2);
                                if (KMeans$.MODULE$.fastSquaredDistance(newCenter, this.centers$1[run2][j]) > this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon() * this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon()) {
                                    changed = true;
                                }
                                this.centers$1[run2][j] = newCenter;
                                continue;
                            }
                            throw new MatchError((Object)tuple22);
                        }
                        if (!changed) {
                            this.active$1[run2] = false;
                            this.$outer.logInfo((Function0<String>)new Serializable(this, run2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$runBreeze$4 $outer;
                                private final int run$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Run ").append((Object)BoxesRunTime.boxToInteger((int)this.run$1)).append((Object)" finished in ").append((Object)BoxesRunTime.boxToInteger((int)(this.$outer.iteration$1.elem + 1))).append((Object)" iterations").toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.run$1 = run$1;
                                }
                            });
                        }
                        this.costs$1[run2] = BoxesRunTime.unboxToDouble((Object)((Accumulable)this.costAccums$1.apply(i)).value());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.centers$1 = centers$1;
                    this.active$1 = active$1;
                    this.costs$1 = costs$1;
                    this.iteration$1 = iteration$1;
                    this.costAccums$1 = costAccums$1;
                    this.totalContribs$1 = totalContribs$1;
                }
            });
            activeRuns = (ArrayBuffer)activeRuns.filter((Function1)new Serializable(this, active){
                public static final long serialVersionUID = 0L;
                private final boolean[] active$1;

                public final boolean apply(int x$6) {
                    return this.apply$mcZI$sp(x$6);
                }

                public boolean apply$mcZI$sp(int x$6) {
                    return this.active$1[x$6];
                }
                {
                    this.active$1 = active$1;
                }
            });
            ++iteration.elem;
        }
        double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
        this.logInfo((Function0<String>)new Serializable(this, iterationTimeInSeconds){
            public static final long serialVersionUID = 0L;
            private final double iterationTimeInSeconds$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iterations took "})).s((Seq)Nil$.MODULE$)).append((Object)new StringOps(Predef$.MODULE$.augmentString("%.3f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.iterationTimeInSeconds$1)}))).append((Object)" seconds.").toString();
            }
            {
                this.iterationTimeInSeconds$1 = iterationTimeInSeconds$1;
            }
        });
        if (iteration.elem == this.org$apache$spark$mllib$clustering$KMeans$$maxIterations()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans reached the max number of iterations: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$clustering$KMeans$$maxIterations())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(this, iteration){
                public static final long serialVersionUID = 0L;
                private final IntRef iteration$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem)}));
                }
                {
                    this.iteration$1 = iteration$1;
                }
            });
        }
        Tuple2 tuple2 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(costs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).min(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        if (tuple2 != null) {
            Tuple2.mcDI.sp sp2;
            double minCost = tuple2._1$mcD$sp();
            int bestRun = tuple2._2$mcI$sp();
            Tuple2.mcDI.sp sp3 = sp2 = new Tuple2.mcDI.sp(minCost, bestRun);
            double minCost2 = sp3._1$mcD$sp();
            int bestRun2 = sp3._2$mcI$sp();
            this.logInfo((Function0<String>)new Serializable(this, minCost2){
                public static final long serialVersionUID = 0L;
                private final double minCost$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cost for the best run is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minCost$1)}));
                }
                {
                    this.minCost$1 = minCost$1;
                }
            });
            return new KMeansModel((Vector[])Predef$.MODULE$.refArrayOps((Object[])centers[bestRun2]).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Vector apply(BreezeVectorWithNorm c) {
                    return Vectors$.MODULE$.fromBreeze(c.vector());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))));
        }
        throw new MatchError((Object)tuple2);
    }

    private BreezeVectorWithNorm[][] initRandom(RDD<BreezeVectorWithNorm> data) {
        Seq sample = Predef$.MODULE$.refArrayOps((Object[])data.takeSample(true, this.org$apache$spark$mllib$clustering$KMeans$$runs() * this.org$apache$spark$mllib$clustering$KMeans$$k(), (long)new XORShiftRandom().nextInt())).toSeq();
        return (BreezeVectorWithNorm[][])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final Seq sample$1;

            public final BreezeVectorWithNorm[] apply(int r) {
                return (BreezeVectorWithNorm[])((TraversableOnce)((TraversableLike)this.sample$1.slice(r * this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(), (r + 1) * this.$outer.org$apache$spark$mllib$clustering$KMeans$$k())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BreezeVectorWithNorm apply(BreezeVectorWithNorm v) {
                        return new BreezeVectorWithNorm((breeze.linalg.Vector<Object>)v.vector().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), v.norm());
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BreezeVectorWithNorm.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sample$1 = sample$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(BreezeVectorWithNorm.class)));
    }

    private BreezeVectorWithNorm[][] initKMeansParallel(RDD<BreezeVectorWithNorm> data) {
        int seed = new XORShiftRandom().nextInt();
        Seq sample = Predef$.MODULE$.refArrayOps((Object[])data.takeSample(true, this.org$apache$spark$mllib$clustering$KMeans$$runs(), (long)seed)).toSeq();
        ArrayBuffer[] centers = (ArrayBuffer[])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final Seq sample$2;

            public final ArrayBuffer<BreezeVectorWithNorm> apply(int r) {
                return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BreezeVectorWithNorm[]{((BreezeVectorWithNorm)this.sample$2.apply(r)).toDense()}));
            }
            {
                this.sample$2 = sample$2;
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class));
        IntRef step = new IntRef(0);
        while (step.elem < this.initializationSteps()) {
            Map sumCosts = SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(this, centers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                public final ArrayBuffer[] centers$2;

                public final IndexedSeq<Tuple2<Object, Object>> apply(BreezeVectorWithNorm point) {
                    return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs()).map((Function1)new Serializable(this, point){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$17 $outer;
                        private final BreezeVectorWithNorm point$3;

                        public final Tuple2<Object, Object> apply(int r) {
                            return new Tuple2.mcID.sp(r, KMeans$.MODULE$.pointCost((TraversableOnce<BreezeVectorWithNorm>)this.$outer.centers$2[r], this.point$3));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.point$3 = point$3;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.centers$2 = centers$2;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x$8, double x$9) {
                    return this.apply$mcDDD$sp(x$8, x$9);
                }

                public double apply$mcDDD$sp(double x$8, double x$9) {
                    return x$8 + x$9;
                }
            }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            Tuple2[] chosen = (Tuple2[])data.mapPartitionsWithIndex((Function2)new Serializable(this, seed, centers, step, sumCosts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final int seed$1;
                public final ArrayBuffer[] centers$2;
                private final IntRef step$1;
                public final Map sumCosts$1;

                public final Iterator<Tuple2<Object, BreezeVectorWithNorm>> apply(int index, Iterator<BreezeVectorWithNorm> points) {
                    XORShiftRandom rand = new XORShiftRandom((long)(this.seed$1 ^ this.step$1.elem << 16 ^ index));
                    return points.flatMap((Function1)new Serializable(this, rand){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$18 $outer;
                        public final XORShiftRandom rand$1;

                        public final IndexedSeq<Tuple2<Object, BreezeVectorWithNorm>> apply(BreezeVectorWithNorm p) {
                            return (IndexedSeq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$runs()).filter((Function1)new Serializable(this, p){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$18$$anonfun$apply$8 $outer;
                                private final BreezeVectorWithNorm p$1;

                                public final boolean apply(int r) {
                                    return this.apply$mcZI$sp(r);
                                }

                                public boolean apply$mcZI$sp(int r) {
                                    return this.$outer.rand$1.nextDouble() < 2.0 * KMeans$.MODULE$.pointCost((TraversableOnce<BreezeVectorWithNorm>)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().centers$2[r], this.p$1) * (double)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$k() / BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().sumCosts$1.apply((Object)BoxesRunTime.boxToInteger((int)r)));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.p$1 = p$1;
                                }
                            })).map((Function1)new Serializable(this, p){
                                public static final long serialVersionUID = 0L;
                                private final BreezeVectorWithNorm p$1;

                                public final Tuple2<Object, BreezeVectorWithNorm> apply(int x$10) {
                                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)x$10), (Object)this.p$1);
                                }
                                {
                                    this.p$1 = p$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                        }

                        public /* synthetic */ $anonfun$18 org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.rand$1 = rand$1;
                        }
                    });
                }

                public /* synthetic */ KMeans org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.seed$1 = seed$1;
                    this.centers$2 = centers$2;
                    this.step$1 = step$1;
                    this.sumCosts$1 = sumCosts$1;
                }
            }, data.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
            Predef$.MODULE$.refArrayOps((Object[])chosen).foreach((Function1)new Serializable(this, centers){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer[] centers$2;

                public final ArrayBuffer<BreezeVectorWithNorm> apply(Tuple2<Object, BreezeVectorWithNorm> x0$2) {
                    Tuple2<Object, BreezeVectorWithNorm> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int r = tuple2._1$mcI$sp();
                        BreezeVectorWithNorm p = (BreezeVectorWithNorm)tuple2._2();
                        ArrayBuffer arrayBuffer = this.centers$2[r].$plus$eq((Object)p.toDense());
                        return arrayBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.centers$2 = centers$2;
                }
            });
            ++step.elem;
        }
        Map weightMap = SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(this, centers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            public final ArrayBuffer[] centers$2;

            public final IndexedSeq<Tuple2<Tuple2<Object, Object>, Object>> apply(BreezeVectorWithNorm p) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs()).map((Function1)new Serializable(this, p){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;
                    private final BreezeVectorWithNorm p$2;

                    public final Tuple2<Tuple2<Object, Object>, Object> apply(int r) {
                        return new Tuple2((Object)new Tuple2.mcII.sp(r, KMeans$.MODULE$.findClosest((TraversableOnce<BreezeVectorWithNorm>)this.$outer.centers$2[r], this.p$2)._1$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)1.0));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.p$2 = p$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.centers$2 = centers$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$11, double x$12) {
                return this.apply$mcDDD$sp(x$11, x$12);
            }

            public double apply$mcDDD$sp(double x$11, double x$12) {
                return x$11 + x$12;
            }
        }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).collectAsMap();
        IndexedSeq finalCenters = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.org$apache$spark$mllib$clustering$KMeans$$runs()).map((Function1)new Serializable(this, centers, weightMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final ArrayBuffer[] centers$2;
            public final Map weightMap$1;

            public final BreezeVectorWithNorm[] apply(int r) {
                BreezeVectorWithNorm[] myCenters = (BreezeVectorWithNorm[])this.centers$2[r].toArray(ClassTag$.MODULE$.apply(BreezeVectorWithNorm.class));
                double[] myWeights = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), myCenters.length).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;
                    private final int r$1;

                    public final double apply(int i) {
                        return this.apply$mcDI$sp(i);
                    }

                    public double apply$mcDI$sp(int i) {
                        return BoxesRunTime.unboxToDouble((Object)this.$outer.weightMap$1.getOrElse((Object)new Tuple2.mcII.sp(this.r$1, i), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 0.0;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                return LocalKMeans$.MODULE$.kMeansPlusPlus(r, myCenters, myWeights, this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(), 30);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.centers$2 = centers$2;
                this.weightMap$1 = weightMap$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return (BreezeVectorWithNorm[][])finalCenters.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(BreezeVectorWithNorm.class)));
    }

    public final Tuple2 org$apache$spark$mllib$clustering$KMeans$$mergeContribs$1(Tuple2 p1, Tuple2 p2) {
        return new Tuple2(((NumericOps)p1._1()).$plus$eq(p2._1(), (UFunc.InPlaceImpl2)Vector$.MODULE$.v_v_Idempotent_UpdateOp_Double_OpAdd()), (Object)BoxesRunTime.boxToLong((long)(p1._2$mcJ$sp() + p2._2$mcJ$sp())));
    }

    private KMeans(int k, int maxIterations, int runs, String initializationMode, int initializationSteps, double epsilon) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = k;
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = maxIterations;
        this.org$apache$spark$mllib$clustering$KMeans$$runs = runs;
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = epsilon;
        Logging.class.$init$((Logging)this);
    }

    public KMeans() {
        this(2, 20, 1, KMeans$.MODULE$.K_MEANS_PARALLEL(), 5, 1.0E-4);
    }
}

