/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkContext$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.clustering.BreezeVectorWithNorm;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u001b\tY1*T3b]Nlu\u000eZ3m\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001a\u00039\u0019G.^:uKJ\u001cUM\u001c;feN,\u0012A\u0007\t\u0004\u001fmi\u0012B\u0001\u000f\u0011\u0005\u0015\t%O]1z!\tq\u0012%D\u0001 \u0015\t\u0001C!\u0001\u0004mS:\fGnZ\u0005\u0003E}\u0011aAV3di>\u0014\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u001f\rdWo\u001d;fe\u000e+g\u000e^3sg\u0002BaA\n\u0001\u0005\u0002\u00119\u0013A\u0002\u001fj]&$h\b\u0006\u0002)UA\u0011\u0011\u0006A\u0007\u0002\u0005!)\u0001$\na\u00015!)A\u0006\u0001C\u0001[\u0005\t1.F\u0001/!\tyq&\u0003\u00021!\t\u0019\u0011J\u001c;\t\u000bI\u0002A\u0011A\u001a\u0002\u000fA\u0014X\rZ5diR\u0011a\u0006\u000e\u0005\u0006kE\u0002\r!H\u0001\u0006a>Lg\u000e\u001e\u0005\u0006e\u0001!\ta\u000e\u000b\u0003qy\u00022!\u000f\u001f/\u001b\u0005Q$BA\u001e\u0007\u0003\r\u0011H\rZ\u0005\u0003{i\u00121A\u0015#E\u0011\u0015yd\u00071\u0001A\u0003\u0019\u0001x.\u001b8ugB\u0019\u0011\bP\u000f\t\u000bI\u0002A\u0011\u0001\"\u0015\u0005\r\u0013\u0006c\u0001#J\u00176\tQI\u0003\u0002G\u000f\u0006!!.\u0019<b\u0015\tAe!A\u0002ba&L!AS#\u0003\u000f)\u000bg/\u0019*E\tB\u0011A\nU\u0007\u0002\u001b*\u0011ajT\u0001\u0005Y\u0006twMC\u0001G\u0013\t\tVJA\u0004J]R,w-\u001a:\t\u000b}\n\u0005\u0019A*\u0011\u0007\u0011KU\u0004C\u0003V\u0001\u0011\u0005a+A\u0006d_6\u0004X\u000f^3D_N$HCA,[!\ty\u0001,\u0003\u0002Z!\t1Ai\\;cY\u0016DQa\u0017+A\u0002\u0001\u000bA\u0001Z1uC\")Q\f\u0001C\u0005=\u000612\r\\;ti\u0016\u00148)\u001a8uKJ\u001cx+\u001b;i\u001d>\u0014X.F\u0001`!\r\u0001\u0007n\u001b\b\u0003C\u001at!AY3\u000e\u0003\rT!\u0001\u001a\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA4\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001b6\u0003\u0011%#XM]1cY\u0016T!a\u001a\t\u0011\u0005%b\u0017BA7\u0003\u0005Q\u0011%/Z3{KZ+7\r^8s/&$\bNT8s[\u0002")
public class KMeansModel
implements Serializable {
    private final Vector[] clusterCenters;

    public Vector[] clusterCenters() {
        return this.clusterCenters;
    }

    public int k() {
        return this.clusterCenters().length;
    }

    public int predict(Vector point) {
        return KMeans$.MODULE$.findClosest((TraversableOnce<BreezeVectorWithNorm>)this.clusterCentersWithNorm(), new BreezeVectorWithNorm(point))._1$mcI$sp();
    }

    public RDD<Object> predict(RDD<Vector> points) {
        Iterable<BreezeVectorWithNorm> centersWithNorm = this.clusterCentersWithNorm();
        return points.map((Function1)new Serializable(this, centersWithNorm){
            public static final long serialVersionUID = 0L;
            private final Iterable centersWithNorm$1;

            public final int apply(Vector p) {
                return KMeans$.MODULE$.findClosest((TraversableOnce<BreezeVectorWithNorm>)this.centersWithNorm$1, new BreezeVectorWithNorm(p))._1$mcI$sp();
            }
            {
                this.centersWithNorm$1 = centersWithNorm$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    public JavaRDD<Integer> predict(JavaRDD<Vector> points) {
        return this.predict((RDD<Vector>)points.rdd()).toJavaRDD();
    }

    public double computeCost(RDD<Vector> data) {
        Iterable<BreezeVectorWithNorm> centersWithNorm = this.clusterCentersWithNorm();
        return SparkContext$.MODULE$.doubleRDDToDoubleRDDFunctions(data.map((Function1)new Serializable(this, centersWithNorm){
            public static final long serialVersionUID = 0L;
            private final Iterable centersWithNorm$2;

            public final double apply(Vector p) {
                return KMeans$.MODULE$.pointCost((TraversableOnce<BreezeVectorWithNorm>)this.centersWithNorm$2, new BreezeVectorWithNorm(p));
            }
            {
                this.centersWithNorm$2 = centersWithNorm$2;
            }
        }, ClassTag$.MODULE$.Double())).sum();
    }

    private Iterable<BreezeVectorWithNorm> clusterCentersWithNorm() {
        return (Iterable)Predef$.MODULE$.refArrayOps((Object[])this.clusterCenters()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BreezeVectorWithNorm apply(Vector x$1) {
                return new BreezeVectorWithNorm(x$1);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public KMeansModel(Vector[] clusterCenters) {
        this.clusterCenters = clusterCenters;
    }
}

