/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.evaluation.AreaUnderCurve$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics$;
import org.apache.spark.mllib.evaluation.binary.BinaryClassificationMetricComputer;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrix;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter$;
import org.apache.spark.mllib.evaluation.binary.FMeasure;
import org.apache.spark.mllib.evaluation.binary.FalsePositiveRate$;
import org.apache.spark.mllib.evaluation.binary.Precision$;
import org.apache.spark.mllib.evaluation.binary.Recall$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.UnionRDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001b\tY\")\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:lU\r\u001e:jGNT!a\u0001\u0003\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AB\u0005\u0003/\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u00039\u00198m\u001c:f\u0003:$G*\u00192fYN\u00042a\u0007\u0010!\u001b\u0005a\"BA\u000f\u0007\u0003\r\u0011H\rZ\u0005\u0003?q\u00111A\u0015#E!\u0011y\u0011eI\u0012\n\u0005\t\u0002\"A\u0002+va2,'\u0007\u0005\u0002\u0010I%\u0011Q\u0005\u0005\u0002\u0007\t>,(\r\\3\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\tI3\u0006\u0005\u0002+\u00015\t!\u0001C\u0003\u001aM\u0001\u0007!\u0004C\u0003.\u0001\u0011\u0005a&A\u0005v]B,'o]5tiR\tq\u0006\u0005\u0002\u0010a%\u0011\u0011\u0007\u0005\u0002\u0005+:LG\u000fC\u00034\u0001\u0011\u0005A'\u0001\u0006uQJ,7\u000f[8mIN$\u0012!\u000e\t\u00047y\u0019\u0003\"B\u001c\u0001\t\u0003A\u0014a\u0001:pGR\t!\u0004C\u0003;\u0001\u0011\u00051(\u0001\u0007be\u0016\fWK\u001c3feJ{5\tF\u0001$\u0011\u0015i\u0004\u0001\"\u00019\u0003\t\u0001(\u000fC\u0003@\u0001\u0011\u00051(A\u0006be\u0016\fWK\u001c3feB\u0013\u0006\"B!\u0001\t\u0003\u0011\u0015a\u00054NK\u0006\u001cXO]3CsRC'/Z:i_2$GC\u0001\u000eD\u0011\u0015!\u0005\t1\u0001$\u0003\u0011\u0011W\r^1\t\u000b\u0005\u0003A\u0011\u0001\u001d\t\u000b\u001d\u0003A\u0011\u0001\u001d\u0002)A\u0014XmY5tS>t')\u001f+ie\u0016\u001c\bn\u001c7e\u0011\u0015I\u0005\u0001\"\u00019\u0003E\u0011XmY1mY\nKH\u000b\u001b:fg\"|G\u000e\u001a\u0005\t\u0017\u0002A9\u0019)C\u0005\u0019\u0006\u0019\u0001\u0010J\u001a\u0016\u00035\u0003BaD\u0011O-B\u00191DH(\u0011\t=\t3\u0005\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'\n\taAY5oCJL\u0018BA+S\u0005I\u0011\u0015N\\1ss2\u000b'-\u001a7D_VtG/\u001a:\u0011\u0007mqr\u000b\u0005\u0003\u0010C\rB\u0006CA)Z\u0013\tQ&KA\u000bCS:\f'/_\"p]\u001a,8/[8o\u001b\u0006$(/\u001b=\t\u0011q\u0003\u0001\u0012!Q!\n5\u000bA\u0001\u001f\u00134A!Aa\f\u0001EC\u0002\u0013%q,\u0001\tdk6,H.\u0019;jm\u0016\u001cu.\u001e8ugV\ta\n\u0003\u0005b\u0001!\u0005\t\u0015)\u0003O\u0003E\u0019W/\\;mCRLg/Z\"pk:$8\u000f\t\u0005\tG\u0002A)\u0019!C\u0005I\u0006Q1m\u001c8gkNLwN\\:\u0016\u0003YC\u0001B\u001a\u0001\t\u0002\u0003\u0006KAV\u0001\fG>tg-^:j_:\u001c\b\u0005C\u0003i\u0001\u0011%\u0011.A\u0006de\u0016\fG/Z\"veZ,GC\u0001\u000ek\u0011\u0015Yw\r1\u0001m\u0003\u0005I\bCA)n\u0013\tq'K\u0001\u0012CS:\f'/_\"mCN\u001c\u0018NZ5dCRLwN\\'fiJL7mQ8naV$XM\u001d\u0005\u0006Q\u0002!I\u0001\u001d\u000b\u00045E\u001c\b\"\u0002:p\u0001\u0004a\u0017!\u0001=\t\u000b-|\u0007\u0019\u00017)\u0005\u0001)\bC\u0001<z\u001b\u00059(B\u0001=\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003u^\u0014A\"\u0012=qKJLW.\u001a8uC2\u0004")
public class BinaryClassificationMetrics
implements Logging {
    private final RDD<Tuple2<Object, Object>> scoreAndLabels;
    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$3;
    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts;
    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$3$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2 tuple2;
                OrderedRDDFunctions qual$1 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(this.scoreAndLabels, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).combineByKey((Function1)new $anonfun$1(this), (Function2)new $anonfun$2(this), (Function2)new $anonfun$3(this)), (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class));
                boolean x$4 = false;
                int x$5 = qual$1.sortByKey$default$2();
                RDD counts = qual$1.sortByKey(x$4, x$5);
                BinaryLabelCounter[] agg = (BinaryLabelCounter[])SparkContext$.MODULE$.rddToPairRDDFunctions(counts, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class), (Ordering)Ordering.Double$.MODULE$).values().mapPartitions((Function1)new $anonfun$4(this), true, ClassTag$.MODULE$.apply(BinaryLabelCounter.class)).collect();
                BinaryLabelCounter[] partitionwiseCumulativeCounts = (BinaryLabelCounter[])Predef$.MODULE$.refArrayOps((Object[])agg).scanLeft((Object)new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2()), (Function2)new $anonfun$5(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryLabelCounter.class)));
                BinaryLabelCounter totalCount = (BinaryLabelCounter)Predef$.MODULE$.refArrayOps((Object[])partitionwiseCumulativeCounts).last();
                this.logInfo((Function0<String>)new $anonfun$6(this, totalCount));
                RDD cumulativeCounts = counts.mapPartitionsWithIndex((Function2)new $anonfun$7(this, partitionwiseCumulativeCounts), true, ClassTag$.MODULE$.apply(Tuple2.class));
                cumulativeCounts.persist();
                RDD confusions = cumulativeCounts.map((Function1)new $anonfun$8(this, totalCount), ClassTag$.MODULE$.apply(Tuple2.class));
                Tuple2 tuple22 = new Tuple2((Object)cumulativeCounts, (Object)confusions);
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                RDD cumulativeCounts2 = (RDD)tuple22._1();
                RDD confusions2 = (RDD)tuple22._2();
                if (cumulativeCounts2 == null) throw new MatchError((Object)tuple22);
                RDD rDD = cumulativeCounts2;
                if (confusions2 == null) throw new MatchError((Object)tuple22);
                RDD rDD2 = confusions2;
                this.x$3 = tuple2 = new Tuple2((Object)rDD, (Object)rDD2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.x$3;
        }
    }

    private RDD cumulativeCounts$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cumulativeCounts = (RDD)this.x$3()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.cumulativeCounts;
        }
    }

    private RDD confusions$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.confusions = (RDD)this.x$3()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.confusions;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void unpersist() {
        this.cumulativeCounts().unpersist(this.cumulativeCounts().unpersist$default$1());
    }

    public RDD<Object> thresholds() {
        return this.cumulativeCounts().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, BinaryLabelCounter> x$1) {
                return x$1._1$mcD$sp();
            }
        }, ClassTag$.MODULE$.Double());
    }

    public RDD<Tuple2<Object, Object>> roc() {
        RDD<Tuple2<Object, Object>> rocCurve = this.createCurve(FalsePositiveRate$.MODULE$, Recall$.MODULE$);
        SparkContext sc = this.confusions().context();
        RDD first = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD last = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        return new UnionRDD(sc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{first, rocCurve, last})), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double areaUnderROC() {
        return AreaUnderCurve$.MODULE$.of(this.roc());
    }

    public RDD<Tuple2<Object, Object>> pr() {
        RDD<Tuple2<Object, Object>> prCurve = this.createCurve(Recall$.MODULE$, Precision$.MODULE$);
        SparkContext sc = this.confusions().context();
        RDD first = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        return first.union(prCurve);
    }

    public double areaUnderPR() {
        return AreaUnderCurve$.MODULE$.of(this.pr());
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold(double beta) {
        return this.createCurve(new FMeasure(beta));
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold() {
        return this.fMeasureByThreshold(1.0);
    }

    public RDD<Tuple2<Object, Object>> precisionByThreshold() {
        return this.createCurve(Precision$.MODULE$);
    }

    public RDD<Tuple2<Object, Object>> recallByThreshold() {
        return this.createCurve(Recall$.MODULE$);
    }

    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$3() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$3$lzycompute() : this.x$3;
    }

    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.cumulativeCounts$lzycompute() : this.cumulativeCounts;
    }

    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.confusions$lzycompute() : this.confusions;
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1)new Serializable(this, y){
            public static final long serialVersionUID = 0L;
            private final BinaryClassificationMetricComputer y$2;

            public final Tuple2<Object, Object> apply(Tuple2<Object, BinaryConfusionMatrix> x0$3) {
                Tuple2<Object, BinaryConfusionMatrix> tuple2 = x0$3;
                if (tuple2 != null) {
                    double s = tuple2._1$mcD$sp();
                    BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(s, this.y$2.apply(c));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.y$2 = y$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer x, BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1)new Serializable(this, x, y){
            public static final long serialVersionUID = 0L;
            private final BinaryClassificationMetricComputer x$6;
            private final BinaryClassificationMetricComputer y$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, BinaryConfusionMatrix> x0$4) {
                Tuple2<Object, BinaryConfusionMatrix> tuple2 = x0$4;
                if (tuple2 != null) {
                    BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(this.x$6.apply(c), this.y$1.apply(c));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.x$6 = x$6;
                this.y$1 = y$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public BinaryClassificationMetrics(RDD<Tuple2<Object, Object>> scoreAndLabels) {
        this.scoreAndLabels = scoreAndLabels;
        Logging.class.$init$((Logging)this);
    }
}

