/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.storage.DefaultArrayValue;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix$;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001f\t\u00012i\\8sI&t\u0017\r^3NCR\u0014\u0018\u000e\u001f\u0006\u0003\u0007\u0011\t1\u0002Z5tiJL'-\u001e;fI*\u0011QAB\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u001dA\u0011!B7mY&\u0014'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0003\u0013\tI\"AA\tESN$(/\u001b2vi\u0016$W*\u0019;sSbD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\bK:$(/[3t+\u0005i\u0002c\u0001\u0010\"G5\tqD\u0003\u0002!\u0011\u0005\u0019!\u000f\u001a3\n\u0005\tz\"a\u0001*E\tB\u0011q\u0003J\u0005\u0003K\t\u00111\"T1ue&DXI\u001c;ss\"Aq\u0005\u0001B\u0001B\u0003%Q$\u0001\u0005f]R\u0014\u0018.Z:!\u0011!I\u0003A!a\u0001\n\u0013Q\u0013!\u00028S_^\u001cX#A\u0016\u0011\u0005Ea\u0013BA\u0017\u0013\u0005\u0011auN\\4\t\u0011=\u0002!\u00111A\u0005\nA\n\u0011B\u001c*poN|F%Z9\u0015\u0005E\"\u0004CA\t3\u0013\t\u0019$C\u0001\u0003V]&$\bbB\u001b/\u0003\u0003\u0005\raK\u0001\u0004q\u0012\n\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0015B\u0016\u0002\r9\u0014vn^:!\u0011!I\u0004A!a\u0001\n\u0013Q\u0013!\u00028D_2\u001c\b\u0002C\u001e\u0001\u0005\u0003\u0007I\u0011\u0002\u001f\u0002\u00139\u001cu\u000e\\:`I\u0015\fHCA\u0019>\u0011\u001d)$(!AA\u0002-B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006KaK\u0001\u0007]\u000e{Gn\u001d\u0011\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\u0011\u0019E)\u0012$\u0011\u0005]\u0001\u0001\"B\u000eA\u0001\u0004i\u0002\"B\u0015A\u0001\u0004Y\u0003\"B\u001dA\u0001\u0004Y\u0003\"B!\u0001\t\u0003AECA\"J\u0011\u0015Yr\t1\u0001\u001e\u0011\u0015Y\u0005\u0001\"\u0011M\u0003\u001dqW/\\\"pYN$\u0012a\u000b\u0005\u0006\u001d\u0002!\t\u0005T\u0001\b]Vl'k\\<t\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003I!x.\u00138eKb,GMU8x\u001b\u0006$(/\u001b=\u0015\u0003I\u0003\"aF*\n\u0005Q\u0013!\u0001E%oI\u0016DX\r\u001a*po6\u000bGO]5y\u0011\u00151\u0006\u0001\"\u0001X\u0003-!xNU8x\u001b\u0006$(/\u001b=\u0015\u0003a\u0003\"aF-\n\u0005i\u0013!!\u0003*po6\u000bGO]5y\u0011\u0015a\u0006\u0001\"\u0003^\u0003-\u0019w.\u001c9vi\u0016\u001c\u0016N_3\u0015\u0003EBaa\u0018\u0001\u0005B\u0019\u0001\u0017\u0001\u0003;p\u0005J,WM_3\u0015\u0003\u0005\u00042A\u00194i\u001b\u0005\u0019'BA\u0003e\u0015\u0005)\u0017A\u00022sK\u0016TX-\u0003\u0002hG\nYA)\u001a8tK6\u000bGO]5y!\t\t\u0012.\u0003\u0002k%\t1Ai\\;cY\u0016D#\u0001\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=D\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011O\u001c\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public class CoordinateMatrix
implements DistributedMatrix {
    private final RDD<MatrixEntry> entries;
    private long nRows;
    private long nCols;

    public RDD<MatrixEntry> entries() {
        return this.entries;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private long nCols() {
        return this.nCols;
    }

    private void nCols_$eq(long x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        if (this.nCols() <= 0L) {
            this.computeSize();
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.nRows() <= 0L) {
            this.computeSize();
        }
        return this.nRows();
    }

    public IndexedRowMatrix toIndexedRowMatrix() {
        long nl = this.numCols();
        if (nl > Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot convert to a row-oriented format because the number of columns ", " is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)nl)}))).append((Object)"too large.").toString());
        }
        int n = (int)nl;
        RDD indexedRows = SparkContext$.MODULE$.rddToPairRDDFunctions(this.entries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, Object>> apply(MatrixEntry entry) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)entry.i()), (Object)new Tuple2.mcID.sp((int)entry.j(), entry.value()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).groupByKey().map((Function1)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            public final IndexedRow apply(Tuple2<Object, Iterable<Tuple2<Object, Object>>> x0$1) {
                Tuple2<Object, Iterable<Tuple2<Object, Object>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    long i = tuple2._1$mcJ$sp();
                    Iterable vectorEntries = (Iterable)tuple2._2();
                    IndexedRow indexedRow = new IndexedRow(i, Vectors$.MODULE$.sparse(this.n$1, (Seq<Tuple2<Object, Object>>)vectorEntries.toSeq()));
                    return indexedRow;
                }
                throw new MatchError(tuple2);
            }
            {
                this.n$1 = n$1;
            }
        }, ClassTag$.MODULE$.apply(IndexedRow.class));
        return new IndexedRowMatrix((RDD<IndexedRow>)indexedRows, this.numRows(), n);
    }

    public RowMatrix toRowMatrix() {
        return this.toIndexedRowMatrix().toRowMatrix();
    }

    private void computeSize() {
        Tuple2 tuple2 = (Tuple2)this.entries().map((Function1)new $anonfun$3(this), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2)new $anonfun$4(this));
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long m1 = tuple2._1$mcJ$sp();
            long n1 = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(m1, n1);
            long m12 = sp3._1$mcJ$sp();
            long n12 = sp3._2$mcJ$sp();
            this.nRows_$eq(package$.MODULE$.max(this.nRows(), m12 + 1L));
            this.nCols_$eq(package$.MODULE$.max(this.nCols(), n12 + 1L));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])this.entries().collect()).foreach((Function1)new Serializable(this, mat){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix mat$1;

            public final void apply(MatrixEntry x0$3) {
                MatrixEntry matrixEntry = x0$3;
                if (matrixEntry != null) {
                    long i = matrixEntry.i();
                    long j = matrixEntry.j();
                    double value = matrixEntry.value();
                    this.mat$1.update$mcD$sp((int)i, (int)j, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)matrixEntry);
            }
            {
                this.mat$1 = mat$1;
            }
        });
        return var3_3;
    }

    public CoordinateMatrix(RDD<MatrixEntry> entries, long nRows, long nCols) {
        this.entries = entries;
        this.nRows = nRows;
        this.nCols = nCols;
    }

    public CoordinateMatrix(RDD<MatrixEntry> entries) {
        this(entries, 0L, 0L);
    }
}

