/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import breeze.linalg.DenseVector$;
import breeze.math.MutableInnerProductSpace;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.StochasticDiffFunction;
import org.apache.spark.Logging;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;

@DeveloperApi
public final class LBFGS$
implements Logging,
Serializable {
    public static final LBFGS$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new LBFGS$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Tuple2<Vector, double[]> runLBFGS(RDD<Tuple2<Object, Vector>> data, Gradient gradient, Updater updater, int numCorrections, double convergenceTol, int maxNumIterations, double regParam, Vector initialWeights) {
        ArrayBuffer lossHistory = new ArrayBuffer(maxNumIterations);
        long numExamples = data.count();
        LBFGS.CostFun costFun = new LBFGS.CostFun(data, gradient, updater, regParam, numExamples);
        LBFGS lbfgs = new LBFGS(maxNumIterations, numCorrections, convergenceTol, (MutableInnerProductSpace)DenseVector$.MODULE$.space_d());
        Iterator states = lbfgs.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialWeights.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
        FirstOrderMinimizer.State state = (FirstOrderMinimizer.State)states.next();
        while (states.hasNext()) {
            lossHistory.append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{state.value()}));
            state = (FirstOrderMinimizer.State)states.next();
        }
        lossHistory.append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{state.value()}));
        Vector weights = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)((breeze.linalg.Vector)state.x()));
        this.logInfo((Function0<String>)new Serializable(lossHistory){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer lossHistory$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("LBFGS.runLBFGS finished. Last 10 losses %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.lossHistory$1.takeRight(10)).mkString(", ")}));
            }
            {
                this.lossHistory$1 = lossHistory$1;
            }
        });
        return new Tuple2((Object)weights, lossHistory.toArray(ClassTag$.MODULE$.Double()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LBFGS$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

