/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.math.Semiring$;
import breeze.storage.DefaultArrayValue;
import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\u0001\u0003\u0003\u0003i!AG$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be\u0006cwm\u001c:ji\"l'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\tq1e\u0005\u0003\u0001\u001fUI\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\ta!\u0003\u0002\u0019\r\t9Aj\\4hS:<\u0007C\u0001\t\u001b\u0013\tY\u0012C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0019\u0001\u0005A\u0011\u000e\u0003\t\u0001\"AI\u0012\r\u0001\u0011)A\u0005\u0001b\u0001K\t\tQ*\u0005\u0002'SA\u0011\u0001cJ\u0005\u0003QE\u0011qAT8uQ&tw\r\u0005\u0002!U%\u00111F\u0001\u0002\u0017\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014Xj\u001c3fY\"9Q\u0006\u0001b\u0001\n#q\u0013A\u0003<bY&$\u0017\r^8sgV\tq\u0006E\u00021qmr!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Qb\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t9\u0014#A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$aA*fc*\u0011q'\u0005\t\u0005!qrt)\u0003\u0002>#\tIa)\u001e8di&|g.\r\t\u0004\u007f\t#U\"\u0001!\u000b\u0005\u00053\u0011a\u0001:eI&\u00111\t\u0011\u0002\u0004%\u0012#\u0005C\u0001\u0011F\u0013\t1%A\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u0005\u0002\u0011\u0011&\u0011\u0011*\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019Y\u0005\u0001)A\u0005_\u0005Ya/\u00197jI\u0006$xN]:!\u0011\u0015i\u0005A\"\u0001O\u0003%y\u0007\u000f^5nSj,'/F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011F!\u0001\u0007paRLW.\u001b>bi&|g.\u0003\u0002U#\nIq\n\u001d;j[&TXM\u001d\u0005\b-\u0002\u0001\r\u0011\"\u0005X\u00031\tG\rZ%oi\u0016\u00148-\u001a9u+\u00059\u0005bB-\u0001\u0001\u0004%\tBW\u0001\u0011C\u0012$\u0017J\u001c;fe\u000e,\u0007\u000f^0%KF$\"a\u00170\u0011\u0005Aa\u0016BA/\u0012\u0005\u0011)f.\u001b;\t\u000f}C\u0016\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\t\r\u0005\u0004\u0001\u0015)\u0003H\u00035\tG\rZ%oi\u0016\u00148-\u001a9uA!91\r\u0001a\u0001\n#9\u0016\u0001\u0004<bY&$\u0017\r^3ECR\f\u0007bB3\u0001\u0001\u0004%\tBZ\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0012\u000bG/Y0%KF$\"aW4\t\u000f}#\u0017\u0011!a\u0001\u000f\"1\u0011\u000e\u0001Q!\n\u001d\u000bQB^1mS\u0012\fG/\u001a#bi\u0006\u0004\u0003\"B6\u0001\r#a\u0017aC2sK\u0006$X-T8eK2$2!I7v\u0011\u0015q'\u000e1\u0001p\u0003\u001d9X-[4iiN\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0003\u0002\r1Lg.\u00197h\u0013\t!\u0018O\u0001\u0004WK\u000e$xN\u001d\u0005\u0006m*\u0004\ra^\u0001\nS:$XM]2faR\u0004\"\u0001\u0005=\n\u0005e\f\"A\u0002#pk\ndW\rC\u0003|\u0001\u0011\u0005A0\u0001\u0007tKRLe\u000e^3sG\u0016\u0004H\u000f\u0006\u0002~}6\t\u0001\u0001C\u0003Wu\u0002\u0007q\tC\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\u001fM,GOV1mS\u0012\fG/\u001a#bi\u0006$2!`A\u0003\u0011\u0015\u0019w\u00101\u0001H\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017\t1A];o)\r\t\u0013Q\u0002\u0005\b\u0003\u001f\t9\u00011\u0001?\u0003\u0015Ig\u000e];u\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+\t!\u0002\u001d:fa\u0016tGm\u00148f)\ry\u0017q\u0003\u0005\b\u00033\t\t\u00021\u0001p\u0003\u00191Xm\u0019;pe\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005uA#B\u0011\u0002 \u0005\u0005\u0002bBA\b\u00037\u0001\rA\u0010\u0005\b\u0003G\tY\u00021\u0001p\u00039Ig.\u001b;jC2<V-[4iiND3\u0001AA\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u00121\u0006\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b")
public abstract class GeneralizedLinearAlgorithm<M extends GeneralizedLinearModel>
implements Logging,
Serializable {
    private final Seq<Function1<RDD<LabeledPoint>, Object>> validators;
    private boolean addIntercept;
    private boolean validateData;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Seq<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    public abstract Optimizer optimizer();

    public boolean addIntercept() {
        return this.addIntercept;
    }

    public void addIntercept_$eq(boolean x$1) {
        this.addIntercept = x$1;
    }

    public boolean validateData() {
        return this.validateData;
    }

    public void validateData_$eq(boolean x$1) {
        this.validateData = x$1;
    }

    public abstract M createModel(Vector var1, double var2);

    public GeneralizedLinearAlgorithm<M> setIntercept(boolean addIntercept) {
        this.addIntercept_$eq(addIntercept);
        return this;
    }

    public GeneralizedLinearAlgorithm<M> setValidateData(boolean validateData) {
        this.validateData_$eq(validateData);
        return this;
    }

    public M run(RDD<LabeledPoint> input) {
        int numFeatures = ((LabeledPoint)input.first()).features().size();
        Vector initialWeights = Vectors$.MODULE$.dense(new double[numFeatures]);
        return this.run(input, initialWeights);
    }

    public Vector org$apache$spark$mllib$regression$GeneralizedLinearAlgorithm$$prependOne(Vector vector) {
        breeze.linalg.Vector<Object> vector2;
        block6: {
            DenseVector denseVector;
            block5: {
                block4: {
                    vector2 = vector.toBreeze();
                    if (!(vector2 instanceof DenseVector)) break block4;
                    DenseVector denseVector2 = (DenseVector)vector2;
                    denseVector = DenseVector$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DenseVector[]{DenseVector$.MODULE$.ones$mDc$sp(1, ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD()), denseVector2}), DenseVector$.MODULE$.canSetD(), ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
                    break block5;
                }
                if (!(vector2 instanceof SparseVector)) break block6;
                SparseVector sparseVector = (SparseVector)vector2;
                denseVector = SparseVector$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SparseVector[]{new SparseVector.mcD.sp(new int[]{0}, new double[]{1.0}, 1, (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$), sparseVector}), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$, ClassTag$.MODULE$.Double());
            }
            DenseVector vector1 = denseVector;
            return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)vector1);
        }
        if (vector2 != null) {
            breeze.linalg.Vector<Object> vector3 = vector2;
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector3.getClass()).toString());
        }
        throw new MatchError(vector2);
    }

    public M run(RDD<LabeledPoint> input, Vector initialWeights) {
        if (this.validateData() && !this.validators().forall((Function1)new Serializable(this, input){
            public static final long serialVersionUID = 0L;
            private final RDD input$1;

            public final boolean apply(Function1<RDD<LabeledPoint>, Object> func) {
                return BoxesRunTime.unboxToBoolean((Object)func.apply((Object)this.input$1));
            }
            {
                this.input$1 = input$1;
            }
        })) {
            throw new SparkException("Input validation failed.");
        }
        RDD data = this.addIntercept() ? input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneralizedLinearAlgorithm $outer;

            public final Tuple2<Object, Vector> apply(LabeledPoint labeledPoint) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)this.$outer.org$apache$spark$mllib$regression$GeneralizedLinearAlgorithm$$prependOne(labeledPoint.features()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)) : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint labeledPoint) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)labeledPoint.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Vector initialWeightsWithIntercept = this.addIntercept() ? this.org$apache$spark$mllib$regression$GeneralizedLinearAlgorithm$$prependOne(initialWeights) : initialWeights;
        Vector weightsWithIntercept = this.optimizer().optimize((RDD<Tuple2<Object, Vector>>)data, initialWeightsWithIntercept);
        double intercept = this.addIntercept() ? weightsWithIntercept.apply(0) : 0.0;
        Vector weights = this.addIntercept() ? Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(weightsWithIntercept.toArray()).slice(1, weightsWithIntercept.size())) : weightsWithIntercept;
        return this.createModel(weights, intercept);
    }

    public GeneralizedLinearAlgorithm() {
        Logging.class.$init$((Logging)this);
        this.validators = Nil$.MODULE$;
        this.addIntercept = false;
        this.validateData = true;
    }
}

