/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.LabeledPoint;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class SerDe$
implements Serializable {
    public static final SerDe$ MODULE$;
    private final byte DENSE_VECTOR_MAGIC;
    private final byte SPARSE_VECTOR_MAGIC;
    private final byte DENSE_MATRIX_MAGIC;
    private final byte LABELED_POINT_MAGIC;

    static {
        new SerDe$();
    }

    private byte DENSE_VECTOR_MAGIC() {
        return this.DENSE_VECTOR_MAGIC;
    }

    private byte SPARSE_VECTOR_MAGIC() {
        return this.SPARSE_VECTOR_MAGIC;
    }

    private byte DENSE_MATRIX_MAGIC() {
        return this.DENSE_MATRIX_MAGIC;
    }

    private byte LABELED_POINT_MAGIC() {
        return this.LABELED_POINT_MAGIC;
    }

    public Vector deserializeDoubleVector(byte[] bytes, int offset) {
        byte magic;
        block4: {
            Vector vector;
            block3: {
                block2: {
                    Predef$.MODULE$.require(bytes.length - offset >= 5, (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Byte array too short";
                        }
                    });
                    magic = bytes[offset];
                    if (magic != this.DENSE_VECTOR_MAGIC()) break block2;
                    vector = this.deserializeDenseVector(bytes, offset);
                    break block3;
                }
                if (magic != this.SPARSE_VECTOR_MAGIC()) break block4;
                vector = this.deserializeSparseVector(bytes, offset);
            }
            return vector;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Magic ").append((Object)BoxesRunTime.boxToByte((byte)magic)).append((Object)" is wrong.").toString());
    }

    public double deserializeDouble(byte[] bytes, int offset) {
        Predef$.MODULE$.require(bytes.length - offset == 8, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Wrong size byte array for Double";
            }
        });
        ByteBuffer bb = ByteBuffer.wrap(bytes, offset, bytes.length - offset);
        bb.order(ByteOrder.nativeOrder());
        return bb.getDouble();
    }

    public int deserializeDoubleVector$default$2() {
        return 0;
    }

    public int deserializeDouble$default$2() {
        return 0;
    }

    public Vector deserializeDenseVector(byte[] bytes, int offset) {
        int packetLength = bytes.length - offset;
        Predef$.MODULE$.require(packetLength >= 5, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Byte array too short";
            }
        });
        ByteBuffer bb = ByteBuffer.wrap(bytes, offset, bytes.length - offset);
        bb.order(ByteOrder.nativeOrder());
        byte magic = bb.get();
        Predef$.MODULE$.require(magic == this.DENSE_VECTOR_MAGIC(), (Function0)new Serializable(magic){
            public static final long serialVersionUID = 0L;
            private final byte magic$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid magic: ").append((Object)BoxesRunTime.boxToByte((byte)this.magic$1)).toString();
            }
            {
                this.magic$1 = magic$1;
            }
        });
        int length = bb.getInt();
        Predef$.MODULE$.require(packetLength == 5 + 8 * length, (Function0)new Serializable(packetLength){
            public static final long serialVersionUID = 0L;
            private final int packetLength$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid packet length: ").append((Object)BoxesRunTime.boxToInteger((int)this.packetLength$1)).toString();
            }
            {
                this.packetLength$1 = packetLength$1;
            }
        });
        DoubleBuffer db = bb.asDoubleBuffer();
        double[] ans = new double[length];
        db.get(ans);
        return Vectors$.MODULE$.dense(ans);
    }

    public int deserializeDenseVector$default$2() {
        return 0;
    }

    public Vector deserializeSparseVector(byte[] bytes, int offset) {
        int packetLength = bytes.length - offset;
        Predef$.MODULE$.require(packetLength >= 9, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Byte array too short";
            }
        });
        ByteBuffer bb = ByteBuffer.wrap(bytes, offset, bytes.length - offset);
        bb.order(ByteOrder.nativeOrder());
        byte magic = bb.get();
        Predef$.MODULE$.require(magic == this.SPARSE_VECTOR_MAGIC(), (Function0)new Serializable(magic){
            public static final long serialVersionUID = 0L;
            private final byte magic$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid magic: ").append((Object)BoxesRunTime.boxToByte((byte)this.magic$2)).toString();
            }
            {
                this.magic$2 = magic$2;
            }
        });
        int size = bb.getInt();
        int nonZeros = bb.getInt();
        Predef$.MODULE$.require(packetLength == 9 + 12 * nonZeros, (Function0)new Serializable(packetLength){
            public static final long serialVersionUID = 0L;
            private final int packetLength$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid packet length: ").append((Object)BoxesRunTime.boxToInteger((int)this.packetLength$2)).toString();
            }
            {
                this.packetLength$2 = packetLength$2;
            }
        });
        IntBuffer ib = bb.asIntBuffer();
        int[] indices = new int[nonZeros];
        ib.get(indices);
        bb.position(bb.position() + 4 * nonZeros);
        DoubleBuffer db = bb.asDoubleBuffer();
        double[] values = new double[nonZeros];
        db.get(values);
        return Vectors$.MODULE$.sparse(size, indices, values);
    }

    public int deserializeSparseVector$default$2() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serializeDouble(double d) {
        void var3_2;
        byte[] bytes = new byte[8];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.putDouble(d);
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serializeDenseVector(double[] doubles) {
        void var3_3;
        int len = doubles.length;
        byte[] bytes = new byte[5 + 8 * len];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.put(this.DENSE_VECTOR_MAGIC());
        bb.putInt(len);
        DoubleBuffer db = bb.asDoubleBuffer();
        db.put(doubles);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serializeSparseVector(SparseVector vector) {
        void var3_3;
        int nonZeros = vector.indices().length;
        byte[] bytes = new byte[9 + 12 * nonZeros];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.put(this.SPARSE_VECTOR_MAGIC());
        bb.putInt(vector.size());
        bb.putInt(nonZeros);
        IntBuffer ib = bb.asIntBuffer();
        ib.put(vector.indices());
        bb.position(bb.position() + 4 * nonZeros);
        DoubleBuffer db = bb.asDoubleBuffer();
        db.put(vector.values());
        return var3_3;
    }

    public byte[] serializeDoubleVector(Vector vector) {
        byte[] byArray;
        Vector vector2 = vector;
        if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            byArray = this.serializeSparseVector(sparseVector);
        } else {
            byArray = this.serializeDenseVector(vector.toArray());
        }
        return byArray;
    }

    public double[][] deserializeDoubleMatrix(byte[] bytes) {
        int cols;
        int packetLength = bytes.length;
        if (packetLength < 9) {
            throw new IllegalArgumentException("Byte array too short.");
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        byte magic = bb.get();
        if (magic != this.DENSE_MATRIX_MAGIC()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Magic ").append((Object)BoxesRunTime.boxToByte((byte)magic)).append((Object)" is wrong.").toString());
        }
        int rows = bb.getInt();
        if (packetLength != 9 + 8 * rows * (cols = bb.getInt())) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Size ").append((Object)BoxesRunTime.boxToInteger((int)rows)).append((Object)"x").append((Object)BoxesRunTime.boxToInteger((int)cols)).append((Object)" is wrong.").toString());
        }
        DoubleBuffer db = bb.asDoubleBuffer();
        double[][] ans = new double[rows][];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rows).foreach((Function1)new Serializable(cols, db, ans){
            public static final long serialVersionUID = 0L;
            private final int cols$1;
            private final DoubleBuffer db$1;
            private final double[][] ans$1;

            public final DoubleBuffer apply(int i) {
                this.ans$1[i] = new double[this.cols$1];
                return this.db$1.get(this.ans$1[i]);
            }
            {
                this.cols$1 = cols$1;
                this.db$1 = db$1;
                this.ans$1 = ans$1;
            }
        });
        return ans;
    }

    public byte[] serializeDoubleMatrix(double[][] doubles) {
        int rows = doubles.length;
        int cols = 0;
        if (rows > 0) {
            cols = doubles[0].length;
        }
        byte[] bytes = new byte[9 + 8 * rows * cols];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.put(this.DENSE_MATRIX_MAGIC());
        bb.putInt(rows);
        bb.putInt(cols);
        DoubleBuffer db = bb.asDoubleBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rows).foreach((Function1)new Serializable(doubles, db){
            public static final long serialVersionUID = 0L;
            private final double[][] doubles$1;
            private final DoubleBuffer db$2;

            public final DoubleBuffer apply(int i) {
                return this.db$2.put(this.doubles$1[i]);
            }
            {
                this.doubles$1 = doubles$1;
                this.db$2 = db$2;
            }
        });
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serializeLabeledPoint(LabeledPoint p) {
        void var3_3;
        byte[] fb = this.serializeDoubleVector(p.features());
        byte[] bytes = new byte[9 + fb.length];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.put(this.LABELED_POINT_MAGIC());
        bb.putDouble(p.label());
        bb.put(fb);
        return var3_3;
    }

    public LabeledPoint deserializeLabeledPoint(byte[] bytes) {
        Predef$.MODULE$.require(bytes.length >= 9, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Byte array too short";
            }
        });
        byte magic = bytes[0];
        if (magic != this.LABELED_POINT_MAGIC()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Magic ").append((Object)BoxesRunTime.boxToByte((byte)magic)).append((Object)" is wrong.").toString());
        }
        ByteBuffer labelBytes = ByteBuffer.wrap(bytes, 1, 8);
        labelBytes.order(ByteOrder.nativeOrder());
        double label = labelBytes.asDoubleBuffer().get(0);
        return new LabeledPoint(label, this.deserializeDoubleVector(bytes, 9));
    }

    public double[][] to2dArray(Matrix matrix) {
        double[] values = matrix.toArray();
        return (double[][])Array$.MODULE$.tabulate(matrix.numRows(), matrix.numCols(), (Function2)new Serializable(matrix, values){
            public static final long serialVersionUID = 0L;
            private final Matrix matrix$1;
            private final double[] values$1;

            public final double apply(int i, int j) {
                return this.apply$mcDII$sp(i, j);
            }

            public double apply$mcDII$sp(int i, int j) {
                return this.values$1[i + j * this.matrix$1.numRows()];
            }
            {
                this.matrix$1 = matrix$1;
                this.values$1 = values$1;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public Rating unpackRating(byte[] ratingBytes) {
        ByteBuffer bb = ByteBuffer.wrap(ratingBytes);
        bb.order(ByteOrder.nativeOrder());
        int user = bb.getInt();
        int product = bb.getInt();
        double rating = bb.getDouble();
        return new Rating(user, product, rating);
    }

    public Tuple2<Object, Object> unpackTuple(byte[] tupleBytes) {
        ByteBuffer bb = ByteBuffer.wrap(tupleBytes);
        bb.order(ByteOrder.nativeOrder());
        int v1 = bb.getInt();
        int v2 = bb.getInt();
        return new Tuple2.mcII.sp(v1, v2);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serializeRating(Rating rate) {
        void var3_3;
        int len = 3;
        byte[] bytes = new byte[4 + 8 * len];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        bb.putInt(len);
        DoubleBuffer db = bb.asDoubleBuffer();
        db.put(rate.user());
        db.put(rate.product());
        db.put(rate.rating());
        return var3_3;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SerDe$() {
        MODULE$ = this;
        this.DENSE_VECTOR_MAGIC = 1;
        this.SPARSE_VECTOR_MAGIC = (byte)2;
        this.DENSE_MATRIX_MAGIC = (byte)3;
        this.LABELED_POINT_MAGIC = (byte)4;
    }
}

