/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.DataValidators$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u00015\u0011\u0011\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]^KG\u000f[*H\t*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0019!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\u000be\u0016<'/Z:tS>t\u0017BA\n\u0011\u0005i9UM\\3sC2L'0\u001a3MS:,\u0017M]!mO>\u0014\u0018\u000e\u001e5n!\t)b#D\u0001\u0003\u0013\t9\"AA\fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\ta1+\u001a:jC2L'0\u00192mK\"Aq\u0004\u0001BA\u0002\u0013%\u0001%\u0001\u0005ti\u0016\u00048+\u001b>f+\u0005\t\u0003CA\r#\u0013\t\u0019#D\u0001\u0004E_V\u0014G.\u001a\u0005\tK\u0001\u0011\t\u0019!C\u0005M\u0005a1\u000f^3q'&TXm\u0018\u0013fcR\u0011qE\u000b\t\u00033!J!!\u000b\u000e\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0011\n\t\u00111\u0001\"\u0003\rAH%\r\u0005\t[\u0001\u0011\t\u0011)Q\u0005C\u0005I1\u000f^3q'&TX\r\t\u0005\t_\u0001\u0011\t\u0019!C\u0005a\u0005ia.^7Ji\u0016\u0014\u0018\r^5p]N,\u0012!\r\t\u00033IJ!a\r\u000e\u0003\u0007%sG\u000f\u0003\u00056\u0001\t\u0005\r\u0011\"\u00037\u0003EqW/\\%uKJ\fG/[8og~#S-\u001d\u000b\u0003O]Bqa\u000b\u001b\u0002\u0002\u0003\u0007\u0011\u0007\u0003\u0005:\u0001\t\u0005\t\u0015)\u00032\u00039qW/\\%uKJ\fG/[8og\u0002B\u0001b\u000f\u0001\u0003\u0002\u0004%I\u0001I\u0001\te\u0016<\u0007+\u0019:b[\"AQ\b\u0001BA\u0002\u0013%a(\u0001\u0007sK\u001e\u0004\u0016M]1n?\u0012*\u0017\u000f\u0006\u0002(\u007f!91\u0006PA\u0001\u0002\u0004\t\u0003\u0002C!\u0001\u0005\u0003\u0005\u000b\u0015B\u0011\u0002\u0013I,w\rU1sC6\u0004\u0003\u0002C\"\u0001\u0005\u0003\u0007I\u0011\u0002\u0011\u0002#5Lg.\u001b\"bi\u000eDgI]1di&|g\u000e\u0003\u0005F\u0001\t\u0005\r\u0011\"\u0003G\u0003Ui\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\\0%KF$\"aJ$\t\u000f-\"\u0015\u0011!a\u0001C!A\u0011\n\u0001B\u0001B\u0003&\u0011%\u0001\nnS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:\u0004\u0003\"B&\u0001\t\u0013a\u0015A\u0002\u001fj]&$h\bF\u0003N\u001d>\u0003\u0016\u000b\u0005\u0002\u0016\u0001!)qD\u0013a\u0001C!)qF\u0013a\u0001c!)1H\u0013a\u0001C!)1I\u0013a\u0001C!91\u000b\u0001b\u0001\n\u0013!\u0016\u0001C4sC\u0012LWM\u001c;\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001\u0017\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\n\u0005i;&\u0001\u0005'pO&\u001cH/[2He\u0006$\u0017.\u001a8u\u0011\u0019a\u0006\u0001)A\u0005+\u0006IqM]1eS\u0016tG\u000f\t\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0003\u001d)\b\u000fZ1uKJ,\u0012\u0001\u0019\t\u0003-\u0006L!AY,\u0003\u001bMKW\u000e\u001d7f+B$\u0017\r^3s\u0011\u0019!\u0007\u0001)A\u0005A\u0006AQ\u000f\u001d3bi\u0016\u0014\b\u0005C\u0004g\u0001\t\u0007I\u0011I4\u0002\u0013=\u0004H/[7ju\u0016\u0014X#\u00015\u0011\u0005YK\u0017B\u00016X\u0005=9%/\u00193jK:$H)Z:dK:$\bB\u00027\u0001A\u0003%\u0001.\u0001\u0006paRLW.\u001b>fe\u0002BqA\u001c\u0001C\u0002\u0013Es.\u0001\u0006wC2LG-\u0019;peN,\u0012\u0001\u001d\t\u0004cZDX\"\u0001:\u000b\u0005M$\u0018!C5n[V$\u0018M\u00197f\u0015\t)($\u0001\u0006d_2dWm\u0019;j_:L!a\u001e:\u0003\t1K7\u000f\u001e\t\u00063e\\\u0018\u0011B\u0005\u0003uj\u0011\u0011BR;oGRLwN\\\u0019\u0011\tq|\u00181A\u0007\u0002{*\u0011aPB\u0001\u0004e\u0012$\u0017bAA\u0001{\n\u0019!\u000b\u0012#\u0011\u0007=\t)!C\u0002\u0002\bA\u0011A\u0002T1cK2,G\rU8j]R\u00042!GA\u0006\u0013\r\tiA\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\u0002\u0001Q\u0001\nA\f1B^1mS\u0012\fGo\u001c:tA!11\n\u0001C\u0001\u0003+!\u0012!\u0014\u0005\b\u00033\u0001A\u0011KA\u000e\u0003-\u0019'/Z1uK6{G-\u001a7\u0015\u000bQ\ti\"!\f\t\u0011\u0005}\u0011q\u0003a\u0001\u0003C\tqa^3jO\"$8\u000f\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9\u0003B\u0001\u0007Y&t\u0017\r\\4\n\t\u0005-\u0012Q\u0005\u0002\u0007-\u0016\u001cGo\u001c:\t\u000f\u0005=\u0012q\u0003a\u0001C\u0005I\u0011N\u001c;fe\u000e,\u0007\u000f^\u0004\b\u0003g\u0011\u0001\u0012AA\u001b\u0003eaunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8XSRD7k\u0012#\u0011\u0007U\t9D\u0002\u0004\u0002\u0005!\u0005\u0011\u0011H\n\u0006\u0003o\tY\u0004\u0007\t\u00043\u0005u\u0012bAA 5\t1\u0011I\\=SK\u001aDqaSA\u001c\t\u0003\t\u0019\u0005\u0006\u0002\u00026!A\u0011qIA\u001c\t\u0003\tI%A\u0003ue\u0006Lg\u000eF\u0006\u0015\u0003\u0017\ny%!\u0015\u0002T\u0005U\u0003bBA'\u0003\u000b\u0002\ra_\u0001\u0006S:\u0004X\u000f\u001e\u0005\u0007_\u0005\u0015\u0003\u0019A\u0019\t\r}\t)\u00051\u0001\"\u0011\u0019\u0019\u0015Q\ta\u0001C!A\u0011qKA#\u0001\u0004\t\t#\u0001\bj]&$\u0018.\u00197XK&<\u0007\u000e^:\t\u0011\u0005\u001d\u0013q\u0007C\u0001\u00037\"\u0012\u0002FA/\u0003?\n\t'a\u0019\t\u000f\u00055\u0013\u0011\fa\u0001w\"1q&!\u0017A\u0002EBaaHA-\u0001\u0004\t\u0003BB\"\u0002Z\u0001\u0007\u0011\u0005\u0003\u0005\u0002H\u0005]B\u0011AA4)\u001d!\u0012\u0011NA6\u0003[Bq!!\u0014\u0002f\u0001\u00071\u0010\u0003\u00040\u0003K\u0002\r!\r\u0005\u0007?\u0005\u0015\u0004\u0019A\u0011\t\u0011\u0005\u001d\u0013q\u0007C\u0001\u0003c\"R\u0001FA:\u0003kBq!!\u0014\u0002p\u0001\u00071\u0010\u0003\u00040\u0003_\u0002\r!\r\u0005\u000b\u0003s\n9$!A\u0005\n\u0005m\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006!A.\u00198h\u0015\t\t9)\u0001\u0003kCZ\f\u0017\u0002BAF\u0003\u0003\u0013aa\u00142kK\u000e$\b")
public class LogisticRegressionWithSGD
extends GeneralizedLinearAlgorithm<LogisticRegressionModel>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final LogisticGradient gradient;
    private final SimpleUpdater updater;
    private final GradientDescent optimizer;
    private final List<Function1<RDD<LabeledPoint>, Object>> validators;

    public static LogisticRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return LogisticRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static LogisticRegressionModel train(RDD<LabeledPoint> rDD, int n, double d) {
        return LogisticRegressionWithSGD$.MODULE$.train(rDD, n, d);
    }

    public static LogisticRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return LogisticRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static LogisticRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, Vector vector) {
        return LogisticRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, vector);
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private LogisticGradient gradient() {
        return this.gradient;
    }

    private SimpleUpdater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    public List<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    @Override
    public LogisticRegressionModel createModel(Vector weights, double intercept) {
        return new LogisticRegressionModel(weights, intercept);
    }

    public LogisticRegressionWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new LogisticGradient();
        this.updater = new SimpleUpdater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
        this.validators = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{DataValidators$.MODULE$.binaryLabelValidator()}));
    }

    public LogisticRegressionWithSGD() {
        this(1.0, 100, 0.0, 1.0);
    }
}

