/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import breeze.linalg.DenseVector$;
import breeze.storage.Zero;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.rdd.RDDFunctions;
import org.apache.spark.mllib.rdd.RDDFunctions$;
import org.apache.spark.rdd.RDD;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u00015\u00111!\u0013#G\u0015\t\u0019A!A\u0004gK\u0006$XO]3\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012a\u00014jiR\u0011Ad\b\t\u00031uI!A\b\u0002\u0003\u0011%#e)T8eK2DQ\u0001I\rA\u0002\u0005\nq\u0001Z1uCN,G\u000fE\u0002#K\u001dj\u0011a\t\u0006\u0003I\u0019\t1A\u001d3e\u0013\t13EA\u0002S\t\u0012\u0003\"\u0001K\u0016\u000e\u0003%R!A\u000b\u0003\u0002\r1Lg.\u00197h\u0013\ta\u0013F\u0001\u0004WK\u000e$xN\u001d\u0005\u00065\u0001!\tA\f\u000b\u00039=BQ\u0001I\u0017A\u0002A\u00022!\r\u001c(\u001b\u0005\u0011$BA\u001a5\u0003\u0011Q\u0017M^1\u000b\u0005U2\u0011aA1qS&\u0011qG\r\u0002\b\u0015\u00064\u0018M\u0015#EQ\t\u0001\u0011\b\u0005\u0002;{5\t1H\u0003\u0002=\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005yZ$\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006dw!\u0002!\u0003\u0011\u0013\t\u0015aA%E\rB\u0011\u0001D\u0011\u0004\u0006\u0003\tAIaQ\n\u0003\u0005:AQ!\u0006\"\u0005\u0002\u0015#\u0012!\u0011\u0004\u0005\u000f\n\u0003\u0001JA\u000eE_\u000e,X.\u001a8u\rJ,\u0017/^3oGf\fum\u001a:fO\u0006$xN]\n\u0004\r:I\u0005CA\bK\u0013\tY\u0005C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u0016\r\u0012\u0005Q\nF\u0001O!\tye)D\u0001C\u0011\u001d\tf\t1A\u0005\nI\u000b\u0011!\\\u000b\u0002'B\u0011q\u0002V\u0005\u0003+B\u0011A\u0001T8oO\"9qK\u0012a\u0001\n\u0013A\u0016!B7`I\u0015\fHCA-]!\ty!,\u0003\u0002\\!\t!QK\\5u\u0011\u001dif+!AA\u0002M\u000b1\u0001\u001f\u00132\u0011\u0019yf\t)Q\u0005'\u0006\u0011Q\u000e\t\u0005\nC\u001a\u0003\r\u00111A\u0005\n\t\f!\u0001\u001a4\u0016\u0003\r\u00042\u0001\u001a5T\u001b\u0005)'B\u0001\u0016g\u0015\u00059\u0017A\u00022sK\u0016TX-\u0003\u0002jK\nYA)\u001a8tKZ+7\r^8s\u0011%Yg\t1AA\u0002\u0013%A.\u0001\u0004eM~#S-\u001d\u000b\u000336Dq!\u00186\u0002\u0002\u0003\u00071\r\u0003\u0004p\r\u0002\u0006KaY\u0001\u0004I\u001a\u0004\u0003\"B9G\t\u0003\u0011\u0018aA1eIR\u00111\u000f^\u0007\u0002\r\")Q\u000f\u001da\u0001O\u0005\u0019Am\\2\t\u000b]4E\u0011\u0001=\u0002\u000b5,'oZ3\u0015\u0005ML\b\"\u0002>w\u0001\u0004q\u0015!B8uQ\u0016\u0014\b\"\u0002?G\t\u0013i\u0018aB5t\u000b6\u0004H/_\u000b\u0002}B\u0011qb`\u0005\u0004\u0003\u0003\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u000b1E\u0011AA\u0004\u0003\rIGM\u001a\u000b\u0002O\u0001")
public class IDF {
    public IDFModel fit(RDD<Vector> dataset) {
        RDDFunctions<Vector> qual$1 = RDDFunctions$.MODULE$.fromRDD(dataset, ClassTag$.MODULE$.apply(Vector.class));
        DocumentFrequencyAggregator x$1 = new DocumentFrequencyAggregator();
        Serializable x$2 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DocumentFrequencyAggregator apply(DocumentFrequencyAggregator df, Vector v) {
                return df.add(v);
            }
        };
        Serializable x$3 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DocumentFrequencyAggregator apply(DocumentFrequencyAggregator df1, DocumentFrequencyAggregator df2) {
                return df1.merge(df2);
            }
        };
        int x$4 = qual$1.treeAggregate$default$4(x$1);
        Vector idf = qual$1.treeAggregate(x$1, x$2, x$3, x$4, ClassTag$.MODULE$.apply(DocumentFrequencyAggregator.class)).idf();
        return new IDFModel(idf);
    }

    public IDFModel fit(JavaRDD<Vector> dataset) {
        return this.fit((RDD<Vector>)dataset.rdd());
    }

    public static class DocumentFrequencyAggregator
    implements Serializable {
        private long m = 0L;
        private breeze.linalg.DenseVector<Object> df;

        private long m() {
            return this.m;
        }

        private void m_$eq(long x$1) {
            this.m = x$1;
        }

        private breeze.linalg.DenseVector<Object> df() {
            return this.df;
        }

        private void df_$eq(breeze.linalg.DenseVector<Object> x$1) {
            this.df = x$1;
        }

        public DocumentFrequencyAggregator add(Vector doc) {
            Vector vector;
            block8: {
                block7: {
                    block6: {
                        if (this.isEmpty()) {
                            this.df_$eq((breeze.linalg.DenseVector<Object>)DenseVector$.MODULE$.zeros(doc.size(), ClassTag$.MODULE$.Long(), (Zero)Zero.LongZero$.MODULE$));
                        }
                        if (!((vector = doc) instanceof SparseVector)) break block6;
                        SparseVector sparseVector = (SparseVector)vector;
                        int nnz = Predef$.MODULE$.intArrayOps(sparseVector.indices()).size();
                        for (int k = 0; k < nnz; ++k) {
                            if (!(sparseVector.values()[k] > 0.0)) continue;
                            breeze.linalg.DenseVector<Object> denseVector = this.df();
                            int n = sparseVector.indices()[k];
                            denseVector.update(n, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)denseVector.apply(n)) + 1L)));
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    if (!(vector instanceof DenseVector)) break block8;
                    DenseVector denseVector = (DenseVector)vector;
                    int n = denseVector.size();
                    for (int j = 0; j < n; ++j) {
                        if (!(denseVector.values()[j] > 0.0)) continue;
                        breeze.linalg.DenseVector<Object> denseVector2 = this.df();
                        int n2 = j;
                        denseVector2.update(n2, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)denseVector2.apply(n2)) + 1L)));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.m_$eq(this.m() + 1L);
                return this;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only sparse and dense vectors are supported but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vector.getClass()})));
        }

        public DocumentFrequencyAggregator merge(DocumentFrequencyAggregator other) {
            Object object;
            if (other.isEmpty()) {
                object = BoxedUnit.UNIT;
            } else {
                this.m_$eq(this.m() + other.m());
                if (this.df() == null) {
                    this.df_$eq((breeze.linalg.DenseVector<Object>)other.df().copy());
                    object = BoxedUnit.UNIT;
                } else {
                    object = this.df().$plus$eq(other.df(), DenseVector$.MODULE$.dv_dv_UpdateOp_Long_OpAdd());
                }
            }
            return this;
        }

        private boolean isEmpty() {
            return this.m() == 0L;
        }

        public Vector idf() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Haven't seen any document yet.");
            }
            int n = this.df().length();
            double[] inv = new double[n];
            for (int j = 0; j < n; ++j) {
                inv[j] = package$.MODULE$.log(((double)this.m() + 1.0) / ((double)BoxesRunTime.unboxToLong((Object)this.df().apply(j)) + 1.0));
            }
            return Vectors$.MODULE$.dense(inv);
        }
    }
}

