/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.F2jBLAS;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class BLAS$
implements Serializable {
    public static final BLAS$ MODULE$;
    private transient BLAS _f2jBLAS;

    static {
        new BLAS$();
    }

    private BLAS _f2jBLAS() {
        return this._f2jBLAS;
    }

    private void _f2jBLAS_$eq(BLAS x$1) {
        this._f2jBLAS = x$1;
    }

    private BLAS f2jBLAS() {
        if (this._f2jBLAS() == null) {
            this._f2jBLAS_$eq((BLAS)new F2jBLAS());
        }
        return this._f2jBLAS();
    }

    public void axpy(double a, Vector x, Vector y) {
        block2: {
            block5: {
                block4: {
                    Vector vector;
                    DenseVector denseVector;
                    block3: {
                        Predef$.MODULE$.require(x.size() == y.size());
                        Vector vector2 = y;
                        if (!(vector2 instanceof DenseVector)) break block2;
                        denseVector = (DenseVector)vector2;
                        vector = x;
                        if (!(vector instanceof SparseVector)) break block3;
                        SparseVector sparseVector = (SparseVector)vector;
                        this.axpy(a, sparseVector, denseVector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!(vector instanceof DenseVector)) break block5;
                    DenseVector denseVector2 = (DenseVector)vector;
                    this.axpy(a, denseVector2, denseVector);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"axpy doesn't support x type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass()})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"axpy only supports adding to a dense vector but got type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{y.getClass()})));
    }

    private void axpy(double a, DenseVector x, DenseVector y) {
        int n = x.size();
        this.f2jBLAS().daxpy(n, a, x.values(), 1, y.values(), 1);
    }

    private void axpy(double a, SparseVector x, DenseVector y) {
        int nnz = Predef$.MODULE$.intArrayOps(x.indices()).size();
        if (a == 1.0) {
            for (int k = 0; k < nnz; ++k) {
                int n = x.indices()[k];
                y.values()[n] = y.values()[n] + x.values()[k];
            }
        } else {
            for (int k = 0; k < nnz; ++k) {
                int n = x.indices()[k];
                y.values()[n] = y.values()[n] + a * x.values()[k];
            }
        }
    }

    public double dot(Vector x, Vector y) {
        block6: {
            double d;
            block3: {
                Tuple2 tuple2;
                block5: {
                    block4: {
                        block2: {
                            Predef$.MODULE$.require(x.size() == y.size());
                            tuple2 = new Tuple2((Object)x, (Object)y);
                            if (tuple2 == null) break block2;
                            Vector dx = (Vector)tuple2._1();
                            Vector dy = (Vector)tuple2._2();
                            if (!(dx instanceof DenseVector)) break block2;
                            DenseVector denseVector = (DenseVector)dx;
                            if (!(dy instanceof DenseVector)) break block2;
                            DenseVector denseVector2 = (DenseVector)dy;
                            d = this.dot(denseVector, denseVector2);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Vector sx = (Vector)tuple2._1();
                        Vector dy = (Vector)tuple2._2();
                        if (!(sx instanceof SparseVector)) break block4;
                        SparseVector sparseVector = (SparseVector)sx;
                        if (!(dy instanceof DenseVector)) break block4;
                        DenseVector denseVector = (DenseVector)dy;
                        d = this.dot(sparseVector, denseVector);
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    Vector dx = (Vector)tuple2._1();
                    Vector sy = (Vector)tuple2._2();
                    if (!(dx instanceof DenseVector)) break block5;
                    DenseVector denseVector = (DenseVector)dx;
                    if (!(sy instanceof SparseVector)) break block5;
                    SparseVector sparseVector = (SparseVector)sy;
                    d = this.dot(sparseVector, denseVector);
                    break block3;
                }
                if (tuple2 == null) break block6;
                Vector sx = (Vector)tuple2._1();
                Vector sy = (Vector)tuple2._2();
                if (!(sx instanceof SparseVector)) break block6;
                SparseVector sparseVector = (SparseVector)sx;
                if (!(sy instanceof SparseVector)) break block6;
                SparseVector sparseVector2 = (SparseVector)sy;
                d = this.dot(sparseVector, sparseVector2);
            }
            return d;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dot doesn't support (", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass(), y.getClass()})));
    }

    private double dot(DenseVector x, DenseVector y) {
        int n = x.size();
        return this.f2jBLAS().ddot(n, x.values(), 1, y.values(), 1);
    }

    private double dot(SparseVector x, DenseVector y) {
        int nnz = Predef$.MODULE$.intArrayOps(x.indices()).size();
        double sum = 0.0;
        for (int k = 0; k < nnz; ++k) {
            sum += x.values()[k] * y.values()[x.indices()[k]];
        }
        return sum;
    }

    private double dot(SparseVector x, SparseVector y) {
        int nnzx = Predef$.MODULE$.intArrayOps(x.indices()).size();
        int ky = 0;
        int nnzy = Predef$.MODULE$.intArrayOps(y.indices()).size();
        double sum = 0.0;
        for (int kx = 0; kx < nnzx && ky < nnzy; ++kx) {
            int ix = x.indices()[kx];
            while (ky < nnzy && y.indices()[ky] < ix) {
                ++ky;
            }
            if (ky >= nnzy || y.indices()[ky] != ix) continue;
            sum += x.values()[kx] * y.values()[ky];
            ++ky;
        }
        return sum;
    }

    public void copy(Vector x, Vector y) {
        block5: {
            Vector vector;
            block8: {
                block7: {
                    DenseVector denseVector;
                    int n;
                    block6: {
                        n = y.size();
                        Predef$.MODULE$.require(x.size() == n);
                        Vector vector2 = y;
                        if (!(vector2 instanceof DenseVector)) break block5;
                        denseVector = (DenseVector)vector2;
                        vector = x;
                        if (!(vector instanceof SparseVector)) break block6;
                        SparseVector sparseVector = (SparseVector)vector;
                        int i = 0;
                        int nnz = Predef$.MODULE$.intArrayOps(sparseVector.indices()).size();
                        for (int k = 0; k < nnz; ++k) {
                            int j = sparseVector.indices()[k];
                            while (i < j) {
                                denseVector.values()[i] = 0.0;
                                ++i;
                            }
                            denseVector.values()[i] = sparseVector.values()[k];
                            ++i;
                        }
                        while (i < n) {
                            denseVector.values()[i] = 0.0;
                            ++i;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    if (!(vector instanceof DenseVector)) break block8;
                    DenseVector denseVector2 = (DenseVector)vector;
                    Array$.MODULE$.copy((Object)denseVector2.values(), 0, (Object)denseVector.values(), 0, n);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new MatchError((Object)vector);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y must be dense in copy but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{y.getClass()})));
    }

    public void scal(double a, Vector x) {
        block4: {
            block3: {
                Vector vector;
                block2: {
                    vector = x;
                    if (!(vector instanceof SparseVector)) break block2;
                    SparseVector sparseVector = (SparseVector)vector;
                    this.f2jBLAS().dscal(Predef$.MODULE$.doubleArrayOps(sparseVector.values()).size(), a, sparseVector.values(), 1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(vector instanceof DenseVector)) break block4;
                DenseVector denseVector = (DenseVector)vector;
                this.f2jBLAS().dscal(Predef$.MODULE$.doubleArrayOps(denseVector.values()).size(), a, denseVector.values(), 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scal doesn't support vector type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass()})));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BLAS$() {
        MODULE$ = this;
    }
}

