/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.NumericOps;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.Vector$;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.util.Arrays;
import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.EigenValueDecomposition$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$SVDMode$2$;
import org.apache.spark.mllib.rdd.RDDFunctions;
import org.apache.spark.mllib.rdd.RDDFunctions$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001=\u0011\u0011BU8x\u001b\u0006$(/\u001b=\u000b\u0005\r!\u0011a\u00033jgR\u0014\u0018NY;uK\u0012T!!\u0002\u0004\u0002\r1Lg.\u00197h\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00175A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003#\u0011K7\u000f\u001e:jEV$X\rZ'biJL\u0007\u0010\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\t9Aj\\4hS:<\u0007\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\tI|wo]\u000b\u0002CA\u0019!%J\u0014\u000e\u0003\rR!\u0001\n\u0005\u0002\u0007I$G-\u0003\u0002'G\t\u0019!\u000b\u0012#\u0011\u0005!JS\"\u0001\u0003\n\u0005)\"!A\u0002,fGR|'\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003\"\u0003\u0015\u0011xn^:!\u0011!q\u0003A!a\u0001\n\u0013y\u0013!\u00028S_^\u001cX#\u0001\u0019\u0011\u0005E\t\u0014B\u0001\u001a\u0013\u0005\u0011auN\\4\t\u0011Q\u0002!\u00111A\u0005\nU\n\u0011B\u001c*poN|F%Z9\u0015\u0005YJ\u0004CA\t8\u0013\tA$C\u0001\u0003V]&$\bb\u0002\u001e4\u0003\u0003\u0005\r\u0001M\u0001\u0004q\u0012\n\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0019\u0002\r9\u0014vn^:!\u0011!q\u0004A!a\u0001\n\u0013y\u0014!\u00028D_2\u001cX#\u0001!\u0011\u0005E\t\u0015B\u0001\"\u0013\u0005\rIe\u000e\u001e\u0005\t\t\u0002\u0011\t\u0019!C\u0005\u000b\u0006IanQ8mg~#S-\u001d\u000b\u0003m\u0019CqAO\"\u0002\u0002\u0003\u0007\u0001\t\u0003\u0005I\u0001\t\u0005\t\u0015)\u0003A\u0003\u0019q7i\u001c7tA!)!\n\u0001C\u0001\u0017\u00061A(\u001b8jiz\"B\u0001T'O\u001fB\u0011q\u0003\u0001\u0005\u0006?%\u0003\r!\t\u0005\u0006]%\u0003\r\u0001\r\u0005\u0006}%\u0003\r\u0001\u0011\u0005\u0006\u0015\u0002!\t!\u0015\u000b\u0003\u0019JCQa\b)A\u0002\u0005BQ\u0001\u0016\u0001\u0005BU\u000bqA\\;n\u0007>d7\u000fF\u00011\u0011\u00159\u0006\u0001\"\u0011V\u0003\u001dqW/\u001c*poNDa!\u0017\u0001\u0005\u0002\u0019Q\u0016aF7vYRL\u0007\u000f\\=He\u0006l\u0017.\u00198NCR\u0014\u0018\u000e\u001f\"z)\tYV\rE\u0002]A\nl\u0011!\u0018\u0006\u0003\u000byS\u0011aX\u0001\u0007EJ,WM_3\n\u0005\u0005l&a\u0003#f]N,g+Z2u_J\u0004\"!E2\n\u0005\u0011\u0014\"A\u0002#pk\ndW\rC\u0003g1\u0002\u00071,A\u0001w\u0011\u0015A\u0007\u0001\"\u0001j\u0003Q\u0019w.\u001c9vi\u0016<%/Y7jC:l\u0015\r\u001e:jqR\t!\u000e\u0005\u0002)W&\u0011A\u000e\u0002\u0002\u0007\u001b\u0006$(/\u001b=\t\u000b9\u0004A\u0011A8\u0002\u0015\r|W\u000e];uKN3F\t\u0006\u0003qgVT\b\u0003\u0002\u0015r\u0019*L!A\u001d\u0003\u00035MKgnZ;mCJ4\u0016\r\\;f\t\u0016\u001cw.\u001c9pg&$\u0018n\u001c8\t\u000bQl\u0007\u0019\u0001!\u0002\u0003-DqA^7\u0011\u0002\u0003\u0007q/\u0001\u0005d_6\u0004X\u000f^3V!\t\t\u00020\u0003\u0002z%\t9!i\\8mK\u0006t\u0007bB>n!\u0003\u0005\rAY\u0001\u0006e\u000e{g\u000e\u001a\u0005\u0007]\u0002!\tAB?\u0015\u0017Atx0!\u0001\u0002\u0004\u0005\u001d\u00111\u0002\u0005\u0006ir\u0004\r\u0001\u0011\u0005\u0006mr\u0004\ra\u001e\u0005\u0006wr\u0004\rA\u0019\u0005\u0007\u0003\u000ba\b\u0019\u0001!\u0002\u000f5\f\u00070\u0013;fe\"1\u0011\u0011\u0002?A\u0002\t\f1\u0001^8m\u0011\u001d\ti\u0001 a\u0001\u0003\u001f\tA!\\8eKB!\u0011\u0011CA\f\u001d\r\t\u00121C\u0005\u0004\u0003+\u0011\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0005m!AB*ue&twMC\u0002\u0002\u0016IAa!a\b\u0001\t\u0003I\u0017!E2p[B,H/Z\"pm\u0006\u0014\u0018.\u00198dK\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012AG2p[B,H/\u001a)sS:\u001c\u0017\u000e]1m\u0007>l\u0007o\u001c8f]R\u001cHc\u00016\u0002(!1A/!\tA\u0002\u0001Cq!a\u000b\u0001\t\u0003\ti#\u0001\u0010d_6\u0004X\u000f^3D_2,XN\\*v[6\f'/_*uCRL7\u000f^5dgR\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u0004\u0002\tM$\u0018\r^\u0005\u0005\u0003s\t\u0019D\u0001\u0010Nk2$\u0018N^1sS\u0006$Xm\u0015;bi&\u001cH/[2bYN+X.\\1ss\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001C7vYRL\u0007\u000f\\=\u0015\u00071\u000b\t\u0005C\u0004\u0002D\u0005m\u0002\u0019\u00016\u0002\u0003\tC\u0001\"a\u0012\u0001\t\u00032\u0011\u0011J\u0001\ti>\u0014%/Z3{KR\u0011\u00111\n\t\u00059\u00065#-C\u0002\u0002Pu\u00131\u0002R3og\u0016l\u0015\r\u001e:jq\"9\u00111\u000b\u0001\u0005\n\u0005U\u0013!D;qI\u0006$XMT;n%><8\u000fF\u00027\u0003/Bq!!\u0017\u0002R\u0001\u0007\u0001'A\u0001n\u0011%\ti\u0006AI\u0001\n\u0003\ty&\u0001\u000bd_6\u0004X\u000f^3T-\u0012#C-\u001a4bk2$HEM\u000b\u0003\u0003CR3a^A2W\t\t)\u0007\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA8%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0014\u0011\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA<\u0001E\u0005I\u0011AA=\u0003Q\u0019w.\u001c9vi\u0016\u001cf\u000b\u0012\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0010\u0016\u0004E\u0006\r\u0004f\u0001\u0001\u0002\u0000A!\u0011\u0011QAC\u001b\t\t\u0019IC\u0002\u0002p!IA!a\"\u0002\u0004\naQ\t\u001f9fe&lWM\u001c;bY\u001e9\u00111\u0012\u0002\t\u0002\u00055\u0015!\u0003*po6\u000bGO]5y!\r9\u0012q\u0012\u0004\u0007\u0003\tA\t!!%\u0014\u000b\u0005=\u0005#a%\u0011\u0007E\t)*C\u0002\u0002\u0018J\u0011AbU3sS\u0006d\u0017N_1cY\u0016DqASAH\t\u0003\tY\n\u0006\u0002\u0002\u000e\"A\u0011qTAH\t\u0013\t\t+\u0001\u0003egB\u0014Hc\u0002\u001c\u0002$\u0006\u001d\u0016\u0011\u0016\u0005\b\u0003K\u000bi\n1\u0001c\u0003\u0015\tG\u000e\u001d5b\u0011\u00191\u0017Q\u0014a\u0001O!A\u00111VAO\u0001\u0004\ti+A\u0001V!\u0011\t\u0012q\u00162\n\u0007\u0005E&CA\u0003BeJ\f\u0017\u0010\u0003\u0005\u00026\u0006=E\u0011BA\\\u0003)!(/[;U_\u001a+H\u000e\u001c\u000b\u0006U\u0006e\u0016Q\u0018\u0005\b\u0003w\u000b\u0019\f1\u0001A\u0003\u0005q\u0007\u0002CAV\u0003g\u0003\r!!,\t\u0015\u0005\u0005\u0017qRA\u0001\n\u0013\t\u0019-A\u0006sK\u0006$'+Z:pYZ,GCAAc!\u0011\t9-!5\u000e\u0005\u0005%'\u0002BAf\u0003\u001b\fA\u0001\\1oO*\u0011\u0011qZ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002T\u0006%'AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002\u0010\u0006}\u0004\u0006BAE\u0003\u007f\u0002")
public class RowMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Vector> rows;
    private long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    private int nCols;
    private transient Logger org$apache$spark$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RowMatrix$SVDMode$2$ SVDMode$1$lzycompute(VolatileObjectRef x$1) {
        RowMatrix rowMatrix = this;
        synchronized (rowMatrix) {
            if (x$1.elem != null) return (RowMatrix$SVDMode$2$)((Object)x$1.elem);
            x$1.elem = new RowMatrix$SVDMode$2$(this);
            return (RowMatrix$SVDMode$2$)((Object)x$1.elem);
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Vector> rows() {
        return this.rows;
    }

    public long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() {
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    }

    private void org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(long x$1) {
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long numCols() {
        if (this.nCols() > 0) return this.nCols();
        try {
            this.nCols_$eq(((Vector)this.rows().first()).size());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw scala.sys.package$.MODULE$.error("Cannot determine the number of cols because it is not specified in the constructor and the rows RDD is empty.");
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(this.rows().count());
            if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == 0L) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of rows because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows();
    }

    public DenseVector<Object> multiplyGramianMatrixBy(DenseVector<Object> v) {
        int n = (int)this.numCols();
        Broadcast vbr = this.rows().context().broadcast(v, ClassTag$.MODULE$.apply(DenseVector.class));
        RDDFunctions<Vector> qual$1 = RDDFunctions$.MODULE$.fromRDD(this.rows(), ClassTag$.MODULE$.apply(Vector.class));
        DenseVector x$4 = DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Serializable x$5 = new Serializable(this, vbr){
            public static final long serialVersionUID = 0L;
            private final Broadcast vbr$1;

            /*
             * WARNING - void declaration
             */
            public final DenseVector<Object> apply(DenseVector<Object> U, Vector r) {
                void var3_3;
                block4: {
                    block3: {
                        breeze.linalg.Vector<Object> vector;
                        double a;
                        breeze.linalg.Vector<Object> rBrz;
                        block2: {
                            rBrz = r.toBreeze();
                            a = BoxesRunTime.unboxToDouble((Object)rBrz.dot(this.vbr$1.value(), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
                            vector = rBrz;
                            if (!(vector instanceof DenseVector)) break block2;
                            breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((DenseVector)rBrz), U, (UFunc.InPlaceImpl3)DenseVector.canDaxpy$.MODULE$);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(vector instanceof SparseVector)) break block4;
                        breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((SparseVector)rBrz), U, SparseVector$.MODULE$.implScaleAdd_DVT_T_SVT_InPlace_Double());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return U;
                }
                throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support vector operation from type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3.getClass().getName()})));
            }
            {
                this.vbr$1 = vbr$1;
            }
        };
        Serializable x$6 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(DenseVector<Object> U1, DenseVector<Object> U2) {
                return (DenseVector)U1.$plus$eq(U2, DenseVector$.MODULE$.canAddIntoD());
            }
        };
        int x$7 = qual$1.treeAggregate$default$4(x$4);
        return qual$1.treeAggregate(x$4, x$5, x$6, x$7, ClassTag$.MODULE$.apply(DenseVector.class));
    }

    public Matrix computeGramianMatrix() {
        int n = (int)this.numCols();
        int nt = n * (n + 1) / 2;
        RDDFunctions<Vector> qual$2 = RDDFunctions$.MODULE$.fromRDD(this.rows(), ClassTag$.MODULE$.apply(Vector.class));
        DenseVector.mcD.sp x$8 = new DenseVector.mcD.sp(new double[nt]);
        Serializable x$9 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(DenseVector<Object> U, Vector v) {
                RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$dspr(1.0, v, U.data$mcD$sp());
                return U;
            }
        };
        Serializable x$10 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(DenseVector<Object> U1, DenseVector<Object> U2) {
                return (DenseVector)U1.$plus$eq(U2, DenseVector$.MODULE$.canAddIntoD());
            }
        };
        int x$11 = qual$2.treeAggregate$default$4(x$8);
        DenseVector GU = (DenseVector)qual$2.treeAggregate(x$8, x$9, x$10, x$11, ClassTag$.MODULE$.apply(DenseVector.class));
        return RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, GU.data$mcD$sp());
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        int maxIter = package$.MODULE$.max(300, k * 3);
        double tol = 1.0E-10;
        return this.computeSVD(k, computeU, rCond, maxIter, tol, "auto");
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond, int maxIter, double tol, String mode) {
        block17: {
            Enumeration.Value value;
            block22: {
                Tuple2 tuple2;
                int n;
                block19: {
                    VolatileObjectRef SVDMode$module;
                    block20: {
                        svd.SVD sVD;
                        block21: {
                            Tuple2 tuple22;
                            block18: {
                                Enumeration.Value computeMode;
                                Enumeration.Value value2;
                                block14: {
                                    String string;
                                    block16: {
                                        block15: {
                                            block13: {
                                                SVDMode$module = new VolatileObjectRef(null);
                                                n = (int)this.numCols();
                                                Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
                                                    public static final long serialVersionUID = 0L;
                                                    private final int k$1;
                                                    private final int n$1;

                                                    public final String apply() {
                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request up to n singular values but got k=", " and n=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.n$1)}));
                                                    }
                                                    {
                                                        this.k$1 = k$1;
                                                        this.n$1 = n$1;
                                                    }
                                                });
                                                String string2 = string = mode;
                                                if ("auto" != null ? !"auto".equals(string2) : string2 != null) break block13;
                                                value2 = n < 100 || k > n / 2 ? (k < n / 3 ? this.SVDMode$1(SVDMode$module).LocalARPACK() : this.SVDMode$1(SVDMode$module).LocalLAPACK()) : this.SVDMode$1(SVDMode$module).DistARPACK();
                                                break block14;
                                            }
                                            String string3 = string;
                                            if ("local-svd" != null ? !"local-svd".equals(string3) : string3 != null) break block15;
                                            value2 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                                            break block14;
                                        }
                                        String string4 = string;
                                        if ("local-eigs" != null ? !"local-eigs".equals(string4) : string4 != null) break block16;
                                        value2 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                        break block14;
                                    }
                                    String string5 = string;
                                    if ("dist-eigs" != null ? !"dist-eigs".equals(string5) : string5 != null) break block17;
                                    value2 = this.SVDMode$1(SVDMode$module).DistARPACK();
                                }
                                value = computeMode = value2;
                                Enumeration.Value value3 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                Enumeration.Value value4 = value;
                                if (value3 != null ? !value3.equals(value4) : value4 != null) break block18;
                                Predef$.MODULE$.require(k < n, (Function0)new $anonfun$5(this, k, n));
                                breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
                                tuple2 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<DenseVector<Object>, DenseVector<Object>>)new $anonfun$6(this, G), n, k, tol, maxIter);
                                break block19;
                            }
                            Enumeration.Value value5 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                            Enumeration.Value value6 = value;
                            if (value5 != null ? !value5.equals(value6) : value6 != null) break block20;
                            breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
                            sVD = (svd.SVD)svd$.MODULE$.apply((Object)G, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                            if (sVD == null) break block21;
                            breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                            DenseVector sigmaSquaresFull = (DenseVector)sVD.singularValues();
                            if (uFull == null) break block21;
                            breeze.linalg.DenseMatrix denseMatrix = uFull;
                            if (sigmaSquaresFull == null) break block21;
                            DenseVector denseVector = sigmaSquaresFull;
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)denseMatrix, (Object)denseVector);
                            breeze.linalg.DenseMatrix uFull2 = (breeze.linalg.DenseMatrix)tuple23._1();
                            DenseVector sigmaSquaresFull2 = (DenseVector)tuple23._2();
                            tuple2 = new Tuple2((Object)sigmaSquaresFull2, (Object)uFull2);
                            break block19;
                        }
                        throw new MatchError((Object)sVD);
                    }
                    Enumeration.Value value7 = this.SVDMode$1(SVDMode$module).DistARPACK();
                    Enumeration.Value value8 = value;
                    if (value7 != null ? !value7.equals(value8) : value8 != null) break block22;
                    Predef$.MODULE$.require(k < n, (Function0)new $anonfun$7(this, k, n));
                    tuple2 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<DenseVector<Object>, DenseVector<Object>>)new $anonfun$8(this), n, k, tol, maxIter);
                }
                Tuple2 tuple24 = tuple2;
                if (tuple24 != null) {
                    DenseVector sigmaSquares = (DenseVector)tuple24._1();
                    breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)tuple24._2();
                    if (sigmaSquares != null) {
                        DenseVector denseVector = sigmaSquares;
                        if (u != null) {
                            SingularValueDecomposition<RowMatrix, Matrix> singularValueDecomposition;
                            Tuple2 tuple25;
                            breeze.linalg.DenseMatrix denseMatrix = u;
                            Tuple2 tuple26 = tuple25 = new Tuple2((Object)denseVector, (Object)denseMatrix);
                            DenseVector sigmaSquares2 = (DenseVector)tuple26._1();
                            breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple26._2();
                            DenseVector sigmas = (DenseVector)package.sqrt$.MODULE$.apply((Object)sigmaSquares2, package.sqrt$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())));
                            double sigma0 = sigmas.apply$mcD$sp(0);
                            double threshold = rCond * sigma0;
                            int i = 0;
                            if (sigmas.length() < k) {
                                this.logWarning((Function0<String>)new Serializable(this, k, sigmas){
                                    public static final long serialVersionUID = 0L;
                                    private final int k$1;
                                    private final DenseVector sigmas$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular values but only found ", " converged."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.sigmas$1.length())}));
                                    }
                                    {
                                        this.k$1 = k$1;
                                        this.sigmas$1 = sigmas$1;
                                    }
                                });
                            }
                            while (i < package$.MODULE$.min(k, sigmas.length()) && sigmas.apply$mcD$sp(i) >= threshold) {
                                ++i;
                            }
                            int sk = i;
                            if (sk < k) {
                                this.logWarning((Function0<String>)new Serializable(this, k, sk){
                                    public static final long serialVersionUID = 0L;
                                    private final int k$1;
                                    private final int sk$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular values but only found ", " nonzeros."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.sk$1)}));
                                    }
                                    {
                                        this.k$1 = k$1;
                                        this.sk$1 = sk$1;
                                    }
                                });
                            }
                            Vector s = Vectors$.MODULE$.dense(Arrays.copyOfRange(sigmas.data$mcD$sp(), 0, sk));
                            Matrix V = Matrices$.MODULE$.dense(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
                            if (computeU) {
                                DenseMatrix.mcD.sp N = new DenseMatrix.mcD.sp(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
                                int i2 = 0;
                                for (int j = 0; j < sk; ++j) {
                                    i2 = 0;
                                    double sigma = sigmas.apply$mcD$sp(j);
                                    while (i2 < n) {
                                        int n2 = i2++;
                                        int n3 = j;
                                        N.update$mcD$sp(n2, n3, N.apply$mcD$sp(n2, n3) / sigma);
                                    }
                                }
                                RowMatrix U = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)N));
                                singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(U, s, V);
                            } else {
                                singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(null, s, V);
                            }
                            return singularValueDecomposition;
                        }
                    }
                }
                throw new MatchError(tuple24);
            }
            throw new MatchError((Object)value);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support mode ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mode})));
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    public Matrix computeCovariance() {
        int x$15;
        Serializable x$14;
        Serializable x$13;
        Tuple2 x$12;
        RDDFunctions<Vector> qual$3;
        Tuple2 tuple2;
        int n = (int)this.numCols();
        if (n > 10000) {
            int mem = n * n * 64 / 8;
            this.logWarning((Function0<String>)new Serializable(this, n, mem){
                public static final long serialVersionUID = 0L;
                private final int n$2;
                private final int mem$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of columns ", " is greater than 10000! "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We need at least ", " bytes of memory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mem$1)}))).toString();
                }
                {
                    this.n$2 = n$2;
                    this.mem$1 = mem$1;
                }
            });
        }
        if ((tuple2 = (qual$3 = RDDFunctions$.MODULE$.fromRDD(this.rows(), ClassTag$.MODULE$.apply(Vector.class))).treeAggregate(x$12 = new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$)), x$13 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, DenseVector<Object>> apply(Tuple2<Object, DenseVector<Object>> s, Vector v) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(s._1$mcJ$sp() + 1L)), ((NumericOps)s._2()).$plus$eq(v.toBreeze(), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd()));
            }
        }, x$14 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, DenseVector<Object>> apply(Tuple2<Object, DenseVector<Object>> s1, Tuple2<Object, DenseVector<Object>> s2) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(s1._1$mcJ$sp() + s2._1$mcJ$sp())), ((NumericOps)s1._2()).$plus$eq(s2._2(), DenseVector$.MODULE$.canAddIntoD()));
            }
        }, x$15 = qual$3.treeAggregate$default$4(x$12), ClassTag$.MODULE$.apply(Tuple2.class))) != null) {
            Tuple2 tuple22;
            long m = tuple2._1$mcJ$sp();
            DenseVector mean2 = (DenseVector)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)m), (Object)mean2);
            long m2 = tuple23._1$mcJ$sp();
            DenseVector mean3 = (DenseVector)tuple23._2();
            if (m2 <= 1L) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RowMatrix.computeCovariance called on matrix with only ", " rows."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m2)}))).append((Object)"  Cannot compute the covariance of a RowMatrix with <= 1 row.").toString());
            }
            this.updateNumRows(m2);
            mean3.$colon$div$eq((Object)BoxesRunTime.boxToDouble((double)m2), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpDiv());
            breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
            int j = 0;
            double m1 = (double)m2 - 1.0;
            double alpha = 0.0;
            for (int i = 0; i < n; ++i) {
                alpha = (double)m2 / m1 * mean3.apply$mcD$sp(i);
                for (j = 0; j < n; ++j) {
                    G.update$mcD$sp(i, j, G.apply$mcD$sp(i, j) / m1 - alpha * mean3.apply$mcD$sp(j));
                }
            }
            return Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)G);
        }
        throw new MatchError((Object)tuple2);
    }

    public Matrix computePrincipalComponents(int k) {
        breeze.linalg.DenseMatrix u;
        int n = (int)this.numCols();
        Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
            public static final long serialVersionUID = 0L;
            private final int k$2;
            private final int n$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k = ", " out of range (0, n = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.n$3)}));
            }
            {
                this.k$2 = k$2;
                this.n$3 = n$3;
            }
        });
        breeze.linalg.DenseMatrix Cov = (breeze.linalg.DenseMatrix)this.computeCovariance().toBreeze();
        svd.SVD sVD = (svd.SVD)svd$.MODULE$.apply((Object)Cov, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
        if (sVD != null && (u = (breeze.linalg.DenseMatrix)sVD.leftVectors()) != null) {
            breeze.linalg.DenseMatrix denseMatrix;
            breeze.linalg.DenseMatrix denseMatrix2;
            breeze.linalg.DenseMatrix u2 = denseMatrix2 = (denseMatrix = u);
            return k == n ? Matrices$.MODULE$.dense(n, k, u2.data$mcD$sp()) : Matrices$.MODULE$.dense(n, k, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * k));
        }
        throw new MatchError((Object)sVD);
    }

    /*
     * WARNING - void declaration
     */
    public MultivariateStatisticalSummary computeColumnSummaryStatistics() {
        void var1_6;
        RDDFunctions<Vector> qual$4 = RDDFunctions$.MODULE$.fromRDD(this.rows(), ClassTag$.MODULE$.apply(Vector.class));
        MultivariateOnlineSummarizer x$16 = new MultivariateOnlineSummarizer();
        Serializable x$17 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator, Vector data) {
                return aggregator.add(data);
            }
        };
        Serializable x$18 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator1, MultivariateOnlineSummarizer aggregator2) {
                return aggregator1.merge(aggregator2);
            }
        };
        int x$19 = qual$4.treeAggregate$default$4(x$16);
        MultivariateOnlineSummarizer summary = qual$4.treeAggregate(x$16, x$17, x$18, x$19, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        this.updateNumRows(summary.count());
        return var1_6;
    }

    public RowMatrix multiply(Matrix B) {
        int n = (int)this.numCols();
        int k = B.numCols();
        Predef$.MODULE$.require(n == B.numRows(), (Function0)new Serializable(this, B, n){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;
            private final int n$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch: ", " vs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$4), BoxesRunTime.boxToInteger((int)this.B$1.numRows())}));
            }
            {
                this.B$1 = B$1;
                this.n$4 = n$4;
            }
        });
        Predef$.MODULE$.require(B instanceof DenseMatrix, (Function0)new Serializable(this, B){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only support dense matrix at this time but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.B$1.getClass().getName()}));
            }
            {
                this.B$1 = B$1;
            }
        });
        Broadcast Bb = this.rows().context().broadcast((Object)((breeze.linalg.DenseMatrix)B.toBreeze()).toDenseVector$mcD$sp().toArray$mcD$sp(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD AB = this.rows().mapPartitions((Function1)new Serializable(this, n, k, Bb){
            public static final long serialVersionUID = 0L;
            public final int n$4;
            public final int k$3;
            private final Broadcast Bb$1;

            public final Iterator<Vector> apply(Iterator<Vector> iter) {
                double[] Bi = (double[])this.Bb$1.value();
                return iter.map((Function1)new Serializable(this, Bi){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;
                    private final double[] Bi$1;

                    public final Vector apply(Vector row) {
                        DenseVector v = DenseVector$.MODULE$.zeros$mDc$sp(this.$outer.k$3, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                        for (int i = 0; i < this.$outer.k$3; ++i) {
                            v.update$mcD$sp(i, BoxesRunTime.unboxToDouble((Object)row.toBreeze().dot((Object)new DenseVector.mcD.sp(this.Bi$1, i * this.$outer.n$4, 1, this.$outer.n$4), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()))));
                        }
                        return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)v);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.Bi$1 = Bi$1;
                    }
                });
            }
            {
                this.n$4 = n$4;
                this.k$3 = k$3;
                this.Bb$1 = Bb$1;
            }
        }, this.rows().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
        return new RowMatrix((RDD<Vector>)AB, this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows(), B.numCols());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        breeze.linalg.DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        IntRef i = new IntRef(0);
        Predef$.MODULE$.refArrayOps((Object[])this.rows().collect()).foreach((Function1)new Serializable(this, mat, i){
            public static final long serialVersionUID = 0L;
            public final breeze.linalg.DenseMatrix mat$1;
            public final IntRef i$1;

            public final void apply(Vector v) {
                v.toBreeze().activeIterator().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$toBreeze$1 $outer;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int j = tuple2._1$mcI$sp();
                            double v = tuple2._2$mcD$sp();
                            this.$outer.mat$1.update$mcD$sp(this.$outer.i$1.elem, j, v);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                ++this.i$1.elem;
            }
            {
                this.mat$1 = mat$1;
                this.i$1 = i$1;
            }
        });
        return var3_3;
    }

    private void updateNumRows(long m) {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(m);
        } else {
            Predef$.MODULE$.require(this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == m, (Function0)new Serializable(this, m){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RowMatrix $outer;
                private final long m$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of rows ", " is different from what specified or previously computed: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.m$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                }
            });
        }
    }

    private final RowMatrix$SVDMode$2$ SVDMode$1(VolatileObjectRef SVDMode$module$1) {
        return SVDMode$module$1.elem == null ? this.SVDMode$1$lzycompute(SVDMode$module$1) : (RowMatrix$SVDMode$2$)((Object)SVDMode$module$1.elem);
    }

    public RowMatrix(RDD<Vector> rows, long nRows, int nCols) {
        this.rows = rows;
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = nRows;
        this.nCols = nCols;
        Logging.class.$init$((Logging)this);
    }

    public RowMatrix(RDD<Vector> rows) {
        this(rows, 0L, 0);
    }
}

