/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.mllib.api.python.SerDe$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u001b\tAR*\u0019;sSb4\u0015m\u0019;pe&T\u0018\r^5p]6{G-\u001a7\u000b\u0005\r!\u0011A\u0004:fG>lW.\u001a8eCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=)\u0012B\u0001\f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0002A!b\u0001\n\u0003I\u0012\u0001\u0002:b].,\u0012A\u0007\t\u0003\u001fmI!\u0001\b\t\u0003\u0007%sG\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0015\u0011\u0018M\\6!\u0011!\u0001\u0003A!b\u0001\n\u0003\t\u0013\u0001D;tKJ4U-\u0019;ve\u0016\u001cX#\u0001\u0012\u0011\u0007\r2\u0003&D\u0001%\u0015\t)c!A\u0002sI\u0012L!a\n\u0013\u0003\u0007I#E\t\u0005\u0003\u0010SiY\u0013B\u0001\u0016\u0011\u0005\u0019!V\u000f\u001d7feA\u0019q\u0002\f\u0018\n\u00055\u0002\"!B!se\u0006L\bCA\b0\u0013\t\u0001\u0004C\u0001\u0004E_V\u0014G.\u001a\u0005\te\u0001\u0011\t\u0011)A\u0005E\u0005iQo]3s\r\u0016\fG/\u001e:fg\u0002B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!I\u0001\u0010aJ|G-^2u\r\u0016\fG/\u001e:fg\"Aa\u0007\u0001B\u0001B\u0003%!%\u0001\tqe>$Wo\u0019;GK\u0006$XO]3tA!1\u0001\b\u0001C\u0001\te\na\u0001P5oSRtD\u0003\u0002\u001e={y\u0002\"a\u000f\u0001\u000e\u0003\tAQ\u0001G\u001cA\u0002iAQ\u0001I\u001cA\u0002\tBQ\u0001N\u001cA\u0002\tBQ\u0001\u0011\u0001\u0005\u0002\u0005\u000bq\u0001\u001d:fI&\u001cG\u000fF\u0002/\u0005\u0012CQaQ A\u0002i\tA!^:fe\")Qi\u0010a\u00015\u00059\u0001O]8ek\u000e$\b\"\u0002!\u0001\t\u00039EC\u0001%M!\r\u0019c%\u0013\t\u0003w)K!a\u0013\u0002\u0003\rI\u000bG/\u001b8h\u0011\u0015ie\t1\u0001O\u00035)8/\u001a:t!J|G-^2ugB\u00191EJ(\u0011\t=I#D\u0007\u0005\u0006#\u0002!\tAU\u0001\u0012e\u0016\u001cw.\\7f]\u0012\u0004&o\u001c3vGR\u001cHcA*U+B\u0019q\u0002L%\t\u000b\r\u0003\u0006\u0019\u0001\u000e\t\u000bY\u0003\u0006\u0019\u0001\u000e\u0002\u00079,X\u000eC\u0003Y\u0001\u0011\u0005\u0011,\u0001\bsK\u000e|W.\\3oIV\u001bXM]:\u0015\u0007MS6\fC\u0003F/\u0002\u0007!\u0004C\u0003W/\u0002\u0007!\u0004C\u0003^\u0001\u0011%a,A\u0005sK\u000e|W.\\3oIR!q,Y2f!\ryA\u0006\u0019\t\u0005\u001f%Rb\u0006C\u0003c9\u0002\u00071&A\nsK\u000e|W.\\3oIR{g)Z1ukJ,7\u000fC\u0003e9\u0002\u0007!%A\u000bsK\u000e|W.\\3oI\u0006\u0014G.\u001a$fCR,(/Z:\t\u000bYc\u0006\u0019\u0001\u000e\t\u000b\u0001\u0003A\u0011A4\u0015\u0005!$\bcA5oa6\t!N\u0003\u0002lY\u0006!!.\u0019<b\u0015\tig!A\u0002ba&L!a\u001c6\u0003\u000f)\u000bg/\u0019*E\tB\u0019q\u0002L9\u0011\u0005=\u0011\u0018BA:\u0011\u0005\u0011\u0011\u0015\u0010^3\t\u000bU4\u0007\u0019\u00015\u0002#U\u001cXM]:Qe>$Wo\u0019;t\u0015J#E\t\u000b\u0002goB\u0011\u0001p_\u0007\u0002s*\u0011!PB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001?z\u00051!UM^3m_B,'/\u00119j\u0001")
public class MatrixFactorizationModel
implements Serializable {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    public double predict(int user, int product) {
        DoubleMatrix userVector = new DoubleMatrix((double[])SparkContext$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head());
        DoubleMatrix productVector = new DoubleMatrix((double[])SparkContext$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head());
        return userVector.dot(productVector);
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        RDD users = SparkContext$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, double[]>> apply(Tuple2<Object, Tuple2<double[], Object>> x0$1) {
                Tuple2<Object, Tuple2<double[], Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        double[] uFeatures = (double[])tuple22._1();
                        int product = tuple22._2$mcI$sp();
                        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                        return tuple23;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return SparkContext$.MODULE$.rddToPairRDDFunctions(users, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rating apply(Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> x0$2) {
                Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int product = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        double[] pFeatures = (double[])tuple22._2();
                        if (tuple23 != null) {
                            int user = tuple23._1$mcI$sp();
                            double[] uFeatures = (double[])tuple23._2();
                            DoubleMatrix userVector = new DoubleMatrix(uFeatures);
                            DoubleMatrix productVector = new DoubleMatrix(pFeatures);
                            Rating rating = new Rating(user, product, userVector.dot(productVector));
                            return rating;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
    }

    public Rating[] recommendProducts(int user, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])this.recommend((double[])SparkContext$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head(), this.productFeatures(), num)).map((Function1)new Serializable(this, user){
            public static final long serialVersionUID = 0L;
            private final int user$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(this.user$1, t._1$mcI$sp(), t._2$mcD$sp());
            }
            {
                this.user$1 = user$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    public Rating[] recommendUsers(int product, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])this.recommend((double[])SparkContext$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head(), this.userFeatures(), num)).map((Function1)new Serializable(this, product){
            public static final long serialVersionUID = 0L;
            private final int product$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(t._1$mcI$sp(), this.product$1, t._2$mcD$sp());
            }
            {
                this.product$1 = product$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    private Tuple2<Object, Object>[] recommend(double[] recommendToFeatures, RDD<Tuple2<Object, double[]>> recommendableFeatures, int num) {
        DoubleMatrix recommendToVector = new DoubleMatrix(recommendToFeatures);
        RDD scored = recommendableFeatures.map((Function1)new Serializable(this, recommendToVector){
            public static final long serialVersionUID = 0L;
            private final DoubleMatrix recommendToVector$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, double[]> x0$3) {
                Tuple2<Object, double[]> tuple2 = x0$3;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    double[] features = (double[])tuple2._2();
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(id, this.recommendToVector$1.dot(new DoubleMatrix(features)));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.recommendToVector$1 = recommendToVector$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return (Tuple2[])scored.top(num, package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$1) {
                return x$1._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$));
    }

    @DeveloperApi
    public JavaRDD<byte[]> predict(JavaRDD<byte[]> usersProductsJRDD) {
        RDD usersProducts = usersProductsJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(byte[] xBytes) {
                return SerDe$.MODULE$.unpackTuple(xBytes);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return JavaRDD$.MODULE$.fromRDD(this.predict((RDD<Tuple2<Object, Object>>)usersProducts).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Rating rate) {
                return SerDe$.MODULE$.serializeRating(rate);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
    }
}

