/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.util.Map;
import org.apache.spark.Logging;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.rdd.RDDFunctions;
import org.apache.spark.mllib.rdd.RDDFunctions$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impl.TimeTracker;
import org.apache.spark.mllib.tree.impl.TreePoint;
import org.apache.spark.mllib.tree.impurity.Impurities$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.DummyCategoricalSplit;
import org.apache.spark.mllib.tree.model.DummyHighSplit;
import org.apache.spark.mllib.tree.model.DummyLowSplit;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.InformationGainStats$;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Double$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class DecisionTree$
implements Serializable,
Logging {
    public static final DecisionTree$ MODULE$;
    private final int InvalidBinIndex;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new DecisionTree$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Strategy strategy) {
        return new DecisionTree(strategy).train(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, Strategy$.MODULE$.$lessinit$greater$default$4(), Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8());
        return new DecisionTree(strategy).train(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth, int numClassesForClassification) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, numClassesForClassification, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8());
        return new DecisionTree(strategy).train(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth, int numClassesForClassification, int maxBins, Enumeration.Value quantileCalculationStrategy, scala.collection.immutable.Map<Object, Object> categoricalFeaturesInfo) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, numClassesForClassification, maxBins, quantileCalculationStrategy, categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$8());
        return new DecisionTree(strategy).train(input);
    }

    public DecisionTreeModel trainClassifier(RDD<LabeledPoint> input, int numClassesForClassification, scala.collection.immutable.Map<Object, Object> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        return this.train(input, Algo$.MODULE$.Classification(), impurityType, maxDepth, numClassesForClassification, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo);
    }

    public DecisionTreeModel trainClassifier(JavaRDD<LabeledPoint> input, int numClassesForClassification, Map<Integer, Integer> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        return this.trainClassifier((RDD<LabeledPoint>)input.rdd(), numClassesForClassification, (scala.collection.immutable.Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms()), impurity, maxDepth, maxBins);
    }

    public DecisionTreeModel trainRegressor(RDD<LabeledPoint> input, scala.collection.immutable.Map<Object, Object> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        return this.train(input, Algo$.MODULE$.Regression(), impurityType, maxDepth, 0, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo);
    }

    public DecisionTreeModel trainRegressor(JavaRDD<LabeledPoint> input, Map<Integer, Integer> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        return this.trainRegressor((RDD<LabeledPoint>)input.rdd(), (scala.collection.immutable.Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms()), impurity, maxDepth, maxBins);
    }

    private int InvalidBinIndex() {
        return this.InvalidBinIndex;
    }

    public Tuple2<Split, InformationGainStats>[] findBestSplits(RDD<TreePoint> input, double[] parentImpurities, DecisionTreeMetadata metadata, int level, Node[] nodes, Split[][] splits, Bin[][] bins, int maxLevelForSingleGroup, TimeTracker timer) {
        Tuple2<Split, InformationGainStats>[] tuple2Array;
        if (level > maxLevelForSingleGroup) {
            int numGroups = 1 << level - maxLevelForSingleGroup;
            this.logDebug((Function0<String>)new Serializable(numGroups){
                public static final long serialVersionUID = 0L;
                private final int numGroups$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"numGroups = ").append((Object)BoxesRunTime.boxToInteger((int)this.numGroups$1)).toString();
                }
                {
                    this.numGroups$1 = numGroups$1;
                }
            });
            Tuple2[] bestSplits = new Tuple2[]{};
            for (int groupIndex = 0; groupIndex < numGroups; ++groupIndex) {
                Tuple2<Split, InformationGainStats>[] bestSplitsForGroup = this.findBestSplitsPerGroup(input, parentImpurities, metadata, level, nodes, splits, bins, timer, numGroups, groupIndex);
                bestSplits = (Tuple2[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[][]{bestSplits, bestSplitsForGroup}), ClassTag$.MODULE$.apply(Tuple2.class));
            }
            tuple2Array = bestSplits;
        } else {
            tuple2Array = this.findBestSplitsPerGroup(input, parentImpurities, metadata, level, nodes, splits, bins, timer, this.findBestSplitsPerGroup$default$9(), this.findBestSplitsPerGroup$default$10());
        }
        return tuple2Array;
    }

    public TimeTracker findBestSplits$default$9() {
        return new TimeTracker();
    }

    private Tuple2<Split, InformationGainStats>[] findBestSplitsPerGroup(RDD<TreePoint> input, double[] parentImpurities, DecisionTreeMetadata metadata, int level, Node[] nodes, Split[][] splits, Bin[][] bins, TimeTracker timer, int numGroups, int groupIndex) {
        int numNodes = (1 << level) / numGroups;
        this.logDebug((Function0<String>)new Serializable(numNodes){
            public static final long serialVersionUID = 0L;
            private final int numNodes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numNodes = ").append((Object)BoxesRunTime.boxToInteger((int)this.numNodes$1)).toString();
            }
            {
                this.numNodes$1 = numNodes$1;
            }
        });
        int numFeatures = metadata.numFeatures();
        this.logDebug((Function0<String>)new Serializable(numFeatures){
            public static final long serialVersionUID = 0L;
            private final int numFeatures$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numFeatures = ").append((Object)BoxesRunTime.boxToInteger((int)this.numFeatures$1)).toString();
            }
            {
                this.numFeatures$1 = numFeatures$1;
            }
        });
        int numBins = bins[0].length;
        this.logDebug((Function0<String>)new Serializable(numBins){
            public static final long serialVersionUID = 0L;
            private final int numBins$2;

            public final String apply() {
                return new StringBuilder().append((Object)"numBins = ").append((Object)BoxesRunTime.boxToInteger((int)this.numBins$2)).toString();
            }
            {
                this.numBins$2 = numBins$2;
            }
        });
        int numClasses = metadata.numClasses();
        this.logDebug((Function0<String>)new Serializable(numClasses){
            public static final long serialVersionUID = 0L;
            private final int numClasses$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numClasses = ").append((Object)BoxesRunTime.boxToInteger((int)this.numClasses$1)).toString();
            }
            {
                this.numClasses$1 = numClasses$1;
            }
        });
        boolean isMulticlass = metadata.isMulticlass();
        this.logDebug((Function0<String>)new Serializable(isMulticlass){
            public static final long serialVersionUID = 0L;
            private final boolean isMulticlass$1;

            public final String apply() {
                return new StringBuilder().append((Object)"isMulticlass = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isMulticlass$1)).toString();
            }
            {
                this.isMulticlass$1 = isMulticlass$1;
            }
        });
        boolean isMulticlassWithCategoricalFeatures = metadata.isMulticlassWithCategoricalFeatures();
        this.logDebug((Function0<String>)new Serializable(isMulticlassWithCategoricalFeatures){
            public static final long serialVersionUID = 0L;
            private final boolean isMulticlassWithCategoricalFeatures$1;

            public final String apply() {
                return new StringBuilder().append((Object)"isMultiClassWithCategoricalFeatures = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isMulticlassWithCategoricalFeatures$1)).toString();
            }
            {
                this.isMulticlassWithCategoricalFeatures$1 = isMulticlassWithCategoricalFeatures$1;
            }
        });
        int groupShift = numNodes * groupIndex;
        int levelOffset = (1 << level) - 1;
        int rightChildShift = numClasses * numBins * numFeatures * numNodes;
        int binAggregateLength = numNodes * this.org$apache$spark$mllib$tree$DecisionTree$$getElementsPerNode(metadata, numBins);
        this.logDebug((Function0<String>)new Serializable(binAggregateLength){
            public static final long serialVersionUID = 0L;
            private final int binAggregateLength$1;

            public final String apply() {
                return new StringBuilder().append((Object)"binAggregateLength = ").append((Object)BoxesRunTime.boxToInteger((int)this.binAggregateLength$1)).toString();
            }
            {
                this.binAggregateLength$1 = binAggregateLength$1;
            }
        });
        timer.start("aggregation");
        RDDFunctions<TreePoint> qual$1 = RDDFunctions$.MODULE$.fromRDD(input, ClassTag$.MODULE$.apply(TreePoint.class));
        double[] x$15 = (double[])Array$.MODULE$.fill(binAggregateLength, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        Serializable x$16 = new Serializable(metadata, level, nodes, bins, numNodes, numFeatures, numBins, numClasses, isMulticlassWithCategoricalFeatures, groupShift, levelOffset, rightChildShift){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$2;
            private final int level$2;
            private final Node[] nodes$2;
            private final Bin[][] bins$1;
            private final int numNodes$1;
            private final int numFeatures$1;
            private final int numBins$2;
            private final int numClasses$1;
            private final boolean isMulticlassWithCategoricalFeatures$1;
            private final int groupShift$1;
            private final int levelOffset$1;
            private final int rightChildShift$1;

            public final double[] apply(double[] agg, TreePoint treePoint) {
                return DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$binSeqOp$1(agg, treePoint, this.metadata$2, this.level$2, this.nodes$2, this.bins$1, this.numNodes$1, this.numFeatures$1, this.numBins$2, this.numClasses$1, this.isMulticlassWithCategoricalFeatures$1, this.groupShift$1, this.levelOffset$1, this.rightChildShift$1);
            }
            {
                this.metadata$2 = metadata$2;
                this.level$2 = level$2;
                this.nodes$2 = nodes$2;
                this.bins$1 = bins$1;
                this.numNodes$1 = numNodes$1;
                this.numFeatures$1 = numFeatures$1;
                this.numBins$2 = numBins$2;
                this.numClasses$1 = numClasses$1;
                this.isMulticlassWithCategoricalFeatures$1 = isMulticlassWithCategoricalFeatures$1;
                this.groupShift$1 = groupShift$1;
                this.levelOffset$1 = levelOffset$1;
                this.rightChildShift$1 = rightChildShift$1;
            }
        };
        Serializable x$17 = new Serializable(binAggregateLength){
            public static final long serialVersionUID = 0L;
            private final int binAggregateLength$1;

            public final double[] apply(double[] agg1, double[] agg2) {
                return DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$binCombOp$1(agg1, agg2, this.binAggregateLength$1);
            }
            {
                this.binAggregateLength$1 = binAggregateLength$1;
            }
        };
        int x$18 = qual$1.treeAggregate$default$4(x$15);
        double[] binAggregates = qual$1.treeAggregate(x$15, x$16, x$17, x$18, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        timer.stop("aggregation");
        this.logDebug((Function0<String>)new Serializable(binAggregates){
            public static final long serialVersionUID = 0L;
            private final double[] binAggregates$1;

            public final String apply() {
                return new StringBuilder().append((Object)"binAggregates.length = ").append((Object)BoxesRunTime.boxToInteger((int)this.binAggregates$1.length)).toString();
            }
            {
                this.binAggregates$1 = binAggregates$1;
            }
        });
        timer.start("chooseSplits");
        Tuple2[] bestSplits = new Tuple2[numNodes];
        for (int node = 0; node < numNodes; ++node) {
            int nodeImpurityIndex = (1 << level) - 1 + node + groupShift;
            double[] binsForNode = this.getBinDataForNode$1(node, metadata, numNodes, numFeatures, numBins, numClasses, isMulticlassWithCategoricalFeatures, binAggregates);
            this.logDebug((Function0<String>)new Serializable(nodeImpurityIndex){
                public static final long serialVersionUID = 0L;
                private final int nodeImpurityIndex$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"nodeImpurityIndex = ").append((Object)BoxesRunTime.boxToInteger((int)this.nodeImpurityIndex$1)).toString();
                }
                {
                    this.nodeImpurityIndex$1 = nodeImpurityIndex$1;
                }
            });
            double parentNodeImpurity = parentImpurities[nodeImpurityIndex];
            this.logDebug((Function0<String>)new Serializable(parentNodeImpurity){
                public static final long serialVersionUID = 0L;
                private final double parentNodeImpurity$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"parent node impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.parentNodeImpurity$1)).toString();
                }
                {
                    this.parentNodeImpurity$1 = parentNodeImpurity$1;
                }
            });
            bestSplits[node] = this.binsToBestSplit$1(binsForNode, parentNodeImpurity, metadata, level, splits, bins, numFeatures, numBins, numClasses);
        }
        timer.stop("chooseSplits");
        return bestSplits;
    }

    private int findBestSplitsPerGroup$default$9() {
        return 1;
    }

    private int findBestSplitsPerGroup$default$10() {
        return 0;
    }

    public int org$apache$spark$mllib$tree$DecisionTree$$getElementsPerNode(DecisionTreeMetadata metadata, int numBins) {
        return metadata.isClassification() ? (metadata.isMulticlassWithCategoricalFeatures() ? 2 * metadata.numClasses() * numBins * metadata.numFeatures() : metadata.numClasses() * numBins * metadata.numFeatures()) : 3 * numBins * metadata.numFeatures();
    }

    public Tuple2<Split[][], Bin[][]> findSplitsBins(RDD<LabeledPoint> input, DecisionTreeMetadata metadata) {
        int requiredSamples;
        long count = input.count();
        int numFeatures = ((LabeledPoint[])input.take(1))[0].features().size();
        int maxBins = metadata.maxBins();
        int numBins = (long)maxBins <= count ? maxBins : (int)count;
        this.logDebug((Function0<String>)new Serializable(numBins){
            public static final long serialVersionUID = 0L;
            private final int numBins$3;

            public final String apply() {
                return new StringBuilder().append((Object)"numBins = ").append((Object)BoxesRunTime.boxToInteger((int)this.numBins$3)).toString();
            }
            {
                this.numBins$3 = numBins$3;
            }
        });
        boolean isMulticlass = metadata.isMulticlass();
        this.logDebug((Function0<String>)new Serializable(isMulticlass){
            public static final long serialVersionUID = 0L;
            private final boolean isMulticlass$2;

            public final String apply() {
                return new StringBuilder().append((Object)"isMulticlass = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isMulticlass$2)).toString();
            }
            {
                this.isMulticlass$2 = isMulticlass$2;
            }
        });
        if (metadata.featureArity().size() > 0) {
            int maxCategoriesForFeatures = ((Tuple2)metadata.featureArity().maxBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x$6) {
                    return x$6._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$))._2$mcI$sp();
            Predef$.MODULE$.require(numBins > maxCategoriesForFeatures, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "numBins should be greater than max categories in categorical features";
                }
            });
        }
        double fraction = (long)(requiredSamples = numBins * numBins) < count ? (double)requiredSamples / (double)count : 1.0;
        this.logDebug((Function0<String>)new Serializable(fraction){
            public static final long serialVersionUID = 0L;
            private final double fraction$1;

            public final String apply() {
                return new StringBuilder().append((Object)"fraction of data used for calculating quantiles = ").append((Object)BoxesRunTime.boxToDouble((double)this.fraction$1)).toString();
            }
            {
                this.fraction$1 = fraction$1;
            }
        });
        LabeledPoint[] sampledInput = (LabeledPoint[])input.sample(false, fraction, (long)new XORShiftRandom().nextInt()).collect();
        int numSamples = sampledInput.length;
        double stride = (double)numSamples / (double)numBins;
        this.logDebug((Function0<String>)new Serializable(stride){
            public static final long serialVersionUID = 0L;
            private final double stride$1;

            public final String apply() {
                return new StringBuilder().append((Object)"stride = ").append((Object)BoxesRunTime.boxToDouble((double)this.stride$1)).toString();
            }
            {
                this.stride$1 = stride$1;
            }
        });
        Enumeration.Value value = metadata.quantileStrategy();
        Enumeration.Value value2 = QuantileStrategy$.MODULE$.Sort();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Split[][] splits = (Split[][])Array$.MODULE$.ofDim(numFeatures, numBins - 1, ClassTag$.MODULE$.apply(Split.class));
            Bin[][] bins = (Bin[][])Array$.MODULE$.ofDim(numFeatures, numBins, ClassTag$.MODULE$.apply(Bin.class));
            IntRef featureIndex = new IntRef(0);
            while (featureIndex.elem < numFeatures) {
                boolean isFeatureContinuous = metadata.isContinuous(featureIndex.elem);
                if (isFeatureContinuous) {
                    double[] featureSamples = (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])sampledInput).map((Function1)new Serializable(featureIndex){
                        public static final long serialVersionUID = 0L;
                        private final IntRef featureIndex$1;

                        public final double apply(LabeledPoint lp) {
                            return lp.features().apply(this.featureIndex$1.elem);
                        }
                        {
                            this.featureIndex$1 = featureIndex$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sorted((Ordering)Ordering.Double$.MODULE$);
                    double stride2 = (double)numSamples / (double)numBins;
                    this.logDebug((Function0<String>)new Serializable(stride2){
                        public static final long serialVersionUID = 0L;
                        private final double stride$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"stride = ").append((Object)BoxesRunTime.boxToDouble((double)this.stride$2)).toString();
                        }
                        {
                            this.stride$2 = stride$2;
                        }
                    });
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBins - 1).foreach$mVc$sp((Function1)new Serializable(splits, featureIndex, featureSamples, stride2){
                        public static final long serialVersionUID = 0L;
                        private final Split[][] splits$2;
                        private final IntRef featureIndex$1;
                        private final double[] featureSamples$1;
                        private final double stride$2;

                        public final void apply(int index) {
                            this.apply$mcVI$sp(index);
                        }

                        public void apply$mcVI$sp(int index) {
                            Split split;
                            int sampleIndex = index * (int)this.stride$2;
                            double threshold = (this.featureSamples$1[sampleIndex] + this.featureSamples$1[sampleIndex + 1]) / 2.0;
                            this.splits$2[this.featureIndex$1.elem][index] = split = new Split(this.featureIndex$1.elem, threshold, FeatureType$.MODULE$.Continuous(), (List<Object>)Nil$.MODULE$);
                        }
                        {
                            this.splits$2 = splits$2;
                            this.featureIndex$1 = featureIndex$1;
                            this.featureSamples$1 = featureSamples$1;
                            this.stride$2 = stride$2;
                        }
                    });
                } else {
                    int featureCategories = BoxesRunTime.unboxToInt((Object)metadata.featureArity().apply((Object)BoxesRunTime.boxToInteger((int)featureIndex.elem)));
                    if (metadata.isUnordered(featureIndex.elem)) {
                        for (int index = 0; index < (1 << featureCategories - 1) - 1; ++index) {
                            List<Object> categories = this.extractMultiClassCategories(index + 1, featureCategories);
                            splits[featureIndex.elem][index] = new Split(featureIndex.elem, Double$.MODULE$.MinValue(), FeatureType$.MODULE$.Categorical(), categories);
                            bins[featureIndex.elem][index] = index == 0 ? new Bin(new DummyCategoricalSplit(featureIndex.elem, FeatureType$.MODULE$.Categorical()), splits[featureIndex.elem][0], FeatureType$.MODULE$.Categorical(), Double$.MODULE$.MinValue()) : new Bin(splits[featureIndex.elem][index - 1], splits[featureIndex.elem][index], FeatureType$.MODULE$.Categorical(), Double$.MODULE$.MinValue());
                        }
                    } else {
                        scala.collection.immutable.Map centroidForCategories = isMulticlass ? (scala.collection.immutable.Map)((TraversableLike)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sampledInput).map((Function1)new Serializable(featureIndex){
                            public static final long serialVersionUID = 0L;
                            private final IntRef featureIndex$1;

                            public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                                return new Tuple2.mcDD.sp(lp.features().apply(this.featureIndex$1.elem), lp.label());
                            }
                            {
                                this.featureIndex$1 = featureIndex$1;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).groupBy((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple2<Object, Object> x$7) {
                                return x$7._1$mcD$sp();
                            }
                        }).mapValues((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final scala.collection.immutable.Map<Object, Object> apply(Tuple2<Object, Object>[] x) {
                                return Predef$.MODULE$.refArrayOps((Object[])x).groupBy((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(Tuple2<Object, Object> x$8) {
                                        return x$8._2$mcD$sp();
                                    }
                                }).mapValues((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(Tuple2<Object, Object>[] x) {
                                        return Predef$.MODULE$.refArrayOps((Object[])x).size();
                                    }
                                });
                            }
                        }).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, double[]> apply(Tuple2<Object, scala.collection.immutable.Map<Object, Object>> x) {
                                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)x._1$mcD$sp()), ((MapLike)x._2()).values().toArray(ClassTag$.MODULE$.Double()));
                            }
                        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).map((Function1)new Serializable(metadata){
                            public static final long serialVersionUID = 0L;
                            private final DecisionTreeMetadata metadata$1;

                            public final Tuple2<Object, Object> apply(Tuple2<Object, double[]> x) {
                                return new Tuple2.mcDD.sp(x._1$mcD$sp(), this.metadata$1.impurity().calculate((double[])x._2(), BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])x._2()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))));
                            }
                            {
                                this.metadata$1 = metadata$1;
                            }
                        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()) : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sampledInput).map((Function1)new Serializable(featureIndex){
                            public static final long serialVersionUID = 0L;
                            private final IntRef featureIndex$1;

                            public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                                return new Tuple2.mcDD.sp(lp.features().apply(this.featureIndex$1.elem), lp.label());
                            }
                            {
                                this.featureIndex$1 = featureIndex$1;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).groupBy((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple2<Object, Object> x$9) {
                                return x$9._1$mcD$sp();
                            }
                        }).mapValues((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple2<Object, Object>[] x) {
                                return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])x).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(Tuple2<Object, Object> x$10) {
                                        return x$10._2$mcD$sp();
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)((double[])Predef$.MODULE$.refArrayOps((Object[])x).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(Tuple2<Object, Object> x$11) {
                                        return x$11._1$mcD$sp();
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).length;
                            }
                        });
                        this.logDebug((Function0<String>)new Serializable(centroidForCategories){
                            public static final long serialVersionUID = 0L;
                            private final scala.collection.immutable.Map centroidForCategories$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"centroid for categories = ").append((Object)this.centroidForCategories$1.mkString(",")).toString();
                            }
                            {
                                this.centroidForCategories$1 = centroidForCategories$1;
                            }
                        });
                        scala.collection.mutable.Map fullCentroidForCategories = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), featureCategories).foreach$mVc$sp((Function1)new Serializable(centroidForCategories, fullCentroidForCategories){
                            public static final long serialVersionUID = 0L;
                            private final scala.collection.immutable.Map centroidForCategories$1;
                            private final scala.collection.mutable.Map fullCentroidForCategories$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                if (this.centroidForCategories$1.contains((Object)BoxesRunTime.boxToDouble((double)i))) {
                                    this.fullCentroidForCategories$1.update((Object)BoxesRunTime.boxToDouble((double)i), this.centroidForCategories$1.apply((Object)BoxesRunTime.boxToDouble((double)i)));
                                } else {
                                    this.fullCentroidForCategories$1.update((Object)BoxesRunTime.boxToDouble((double)i), (Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE));
                                }
                            }
                            {
                                this.centroidForCategories$1 = centroidForCategories$1;
                                this.fullCentroidForCategories$1 = fullCentroidForCategories$1;
                            }
                        });
                        List categoriesSortedByCentroid = (List)fullCentroidForCategories.toList().sortBy((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple2<Object, Object> x$12) {
                                return x$12._2$mcD$sp();
                            }
                        }, (Ordering)Ordering.Double$.MODULE$);
                        this.logDebug((Function0<String>)new Serializable(categoriesSortedByCentroid){
                            public static final long serialVersionUID = 0L;
                            private final List categoriesSortedByCentroid$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"centroid for categorical variable = ").append((Object)this.categoriesSortedByCentroid$1).toString();
                            }
                            {
                                this.categoriesSortedByCentroid$1 = categoriesSortedByCentroid$1;
                            }
                        });
                        ObjectRef categoriesForSplit = new ObjectRef((Object)Nil$.MODULE$);
                        categoriesSortedByCentroid.iterator().zipWithIndex().foreach((Function1)new Serializable(splits, bins, featureIndex, categoriesForSplit){
                            public static final long serialVersionUID = 0L;
                            private final Split[][] splits$2;
                            private final Bin[][] bins$2;
                            private final IntRef featureIndex$1;
                            private final ObjectRef categoriesForSplit$1;

                            public final void apply(Tuple2<Tuple2<Object, Object>, Object> x0$3) {
                                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                                    int index = tuple2._2$mcI$sp();
                                    if (tuple22 != null) {
                                        double key;
                                        double d = key = tuple22._1$mcD$sp();
                                        this.categoriesForSplit$1.elem = ((List)this.categoriesForSplit$1.elem).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d));
                                        this.splits$2[this.featureIndex$1.elem][index] = new Split(this.featureIndex$1.elem, Double$.MODULE$.MinValue(), FeatureType$.MODULE$.Categorical(), (List<Object>)((List)this.categoriesForSplit$1.elem));
                                        this.bins$2[this.featureIndex$1.elem][index] = index == 0 ? new Bin(new DummyCategoricalSplit(this.featureIndex$1.elem, FeatureType$.MODULE$.Categorical()), this.splits$2[this.featureIndex$1.elem][0], FeatureType$.MODULE$.Categorical(), key) : new Bin(this.splits$2[this.featureIndex$1.elem][index - 1], this.splits$2[this.featureIndex$1.elem][index], FeatureType$.MODULE$.Categorical(), key);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.splits$2 = splits$2;
                                this.bins$2 = bins$2;
                                this.featureIndex$1 = featureIndex$1;
                                this.categoriesForSplit$1 = categoriesForSplit$1;
                            }
                        });
                    }
                }
                ++featureIndex.elem;
            }
            featureIndex.elem = 0;
            while (featureIndex.elem < numFeatures) {
                boolean isFeatureContinuous = metadata.isContinuous(featureIndex.elem);
                if (isFeatureContinuous) {
                    bins[featureIndex.elem][0] = new Bin(new DummyLowSplit(featureIndex.elem, FeatureType$.MODULE$.Continuous()), splits[featureIndex.elem][0], FeatureType$.MODULE$.Continuous(), Double$.MODULE$.MinValue());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), numBins - 1).foreach$mVc$sp((Function1)new Serializable(splits, bins, featureIndex){
                        public static final long serialVersionUID = 0L;
                        private final Split[][] splits$2;
                        private final Bin[][] bins$2;
                        private final IntRef featureIndex$1;

                        public final void apply(int index) {
                            this.apply$mcVI$sp(index);
                        }

                        public void apply$mcVI$sp(int index) {
                            Bin bin;
                            this.bins$2[this.featureIndex$1.elem][index] = bin = new Bin(this.splits$2[this.featureIndex$1.elem][index - 1], this.splits$2[this.featureIndex$1.elem][index], FeatureType$.MODULE$.Continuous(), Double$.MODULE$.MinValue());
                        }
                        {
                            this.splits$2 = splits$2;
                            this.bins$2 = bins$2;
                            this.featureIndex$1 = featureIndex$1;
                        }
                    });
                    bins[featureIndex.elem][numBins - 1] = new Bin(splits[featureIndex.elem][numBins - 2], new DummyHighSplit(featureIndex.elem, FeatureType$.MODULE$.Continuous()), FeatureType$.MODULE$.Continuous(), Double$.MODULE$.MinValue());
                }
                ++featureIndex.elem;
            }
            Tuple2 tuple2 = new Tuple2((Object)splits, (Object)bins);
            return tuple2;
        }
        Enumeration.Value value4 = QuantileStrategy$.MODULE$.MinMax();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            throw new UnsupportedOperationException("minmax not supported yet.");
        }
        Enumeration.Value value6 = QuantileStrategy$.MODULE$.ApproxHist();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            throw new UnsupportedOperationException("approximate histogram not supported yet.");
        }
        throw new MatchError((Object)value);
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> extractMultiClassCategories(int input, int maxFeatureValue) {
        void var3_3;
        Nil$ categories = Nil$.MODULE$;
        int bitShiftedInput = input;
        for (int j = 0; j < maxFeatureValue; ++j) {
            if (bitShiftedInput % 2 != 0) {
                double d = j;
                categories = categories.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d));
            }
            bitShiftedInput >>= 1;
        }
        return var3_3;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final int predictNodeIndex$1(Node node, int[] binnedFeatures, DecisionTreeMetadata metadata$2, Bin[][] bins$1) {
        while (true) {
            boolean splitLeft;
            block11: {
                int n;
                block10: {
                    boolean bl;
                    block9: {
                        if (!node.isLeaf()) break block9;
                        n = node.id();
                        break block10;
                    }
                    int featureIndex = ((Split)node.split().get()).feature();
                    Enumeration.Value value = ((Split)node.split().get()).featureType();
                    Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        int binIndex = binnedFeatures[featureIndex];
                        double featureValueUpperBound = bins$1[featureIndex][binIndex].highSplit().threshold();
                        bl = featureValueUpperBound <= ((Split)node.split().get()).threshold();
                    } else {
                        double d;
                        Enumeration.Value value4 = FeatureType$.MODULE$.Categorical();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break;
                        if (metadata$2.isUnordered(featureIndex)) {
                            d = binnedFeatures[featureIndex];
                        } else {
                            int binIndex = binnedFeatures[featureIndex];
                            d = bins$1[featureIndex][binIndex].category();
                        }
                        double featureValue = d;
                        bl = ((Split)node.split().get()).categories().contains((Object)BoxesRunTime.boxToDouble((double)featureValue));
                    }
                    splitLeft = bl;
                    if (!node.leftNode().isEmpty() && !node.rightNode().isEmpty()) break block11;
                    n = splitLeft ? node.id() * 2 + 1 : node.id() * 2 + 2;
                }
                return n;
            }
            if (splitLeft) {
                node = (Node)node.leftNode().get();
                continue;
            }
            node = (Node)node.rightNode().get();
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"predictNodeIndex failed for unknown reason."})).s((Seq)Nil$.MODULE$));
    }

    private final int nodeIndexToLevel$1(int idx) {
        return idx == 0 ? 0 : (int)package$.MODULE$.floor(package$.MODULE$.log((double)idx) / package$.MODULE$.log(2.0));
    }

    private final int treePointToNodeIndex$1(TreePoint treePoint, DecisionTreeMetadata metadata$2, int level$2, Node[] nodes$2, Bin[][] bins$1, int groupShift$1, int levelOffset$1) {
        int n;
        if (level$2 == 0) {
            n = 0;
        } else {
            int globalNodeIndex = this.predictNodeIndex$1(nodes$2[0], treePoint.binnedFeatures(), metadata$2, bins$1);
            n = globalNodeIndex - levelOffset$1 - groupShift$1;
        }
        return n;
    }

    private final void updateBinForOrderedFeature$1(TreePoint treePoint, double[] agg, int nodeIndex, int featureIndex, int numFeatures$1, int numBins$2, int numClasses$1) {
        int aggIndex = numClasses$1 * numBins$2 * numFeatures$1 * nodeIndex + numClasses$1 * numBins$2 * featureIndex + numClasses$1 * treePoint.binnedFeatures()[featureIndex] + (int)treePoint.label();
        agg[aggIndex] = agg[aggIndex] + 1.0;
    }

    private final void updateBinForUnorderedFeature$1(int nodeIndex, int featureIndex, TreePoint treePoint, double[] agg, int rightChildShift, DecisionTreeMetadata metadata$2, Bin[][] bins$1, int numFeatures$1, int numBins$2, int numClasses$1) {
        int featureValue = treePoint.binnedFeatures()[featureIndex];
        int aggShift = numClasses$1 * numBins$2 * numFeatures$1 * nodeIndex + numClasses$1 * numBins$2 * featureIndex + (int)treePoint.label();
        int featureCategories = BoxesRunTime.unboxToInt((Object)metadata$2.featureArity().apply((Object)BoxesRunTime.boxToInteger((int)featureIndex)));
        int numCategoricalBins = (1 << featureCategories - 1) - 1;
        for (int binIndex = 0; binIndex < numCategoricalBins; ++binIndex) {
            int aggIndex = aggShift + binIndex * numClasses$1;
            if (bins$1[featureIndex][binIndex].highSplit().categories().contains((Object)BoxesRunTime.boxToInteger((int)featureValue))) {
                agg[aggIndex] = agg[aggIndex] + 1.0;
                continue;
            }
            int n = rightChildShift + aggIndex;
            agg[n] = agg[n] + 1.0;
        }
    }

    private final void binaryOrNotCategoricalBinSeqOp$1(double[] agg, TreePoint treePoint, int nodeIndex, int numFeatures$1, int numBins$2, int numClasses$1) {
        for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
            this.updateBinForOrderedFeature$1(treePoint, agg, nodeIndex, featureIndex, numFeatures$1, numBins$2, numClasses$1);
        }
    }

    private final void multiclassWithCategoricalBinSeqOp$1(double[] agg, TreePoint treePoint, int nodeIndex, DecisionTreeMetadata metadata$2, Bin[][] bins$1, int numFeatures$1, int numBins$2, int numClasses$1, int rightChildShift$1) {
        double label = treePoint.label();
        for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
            if (metadata$2.isUnordered(featureIndex)) {
                this.updateBinForUnorderedFeature$1(nodeIndex, featureIndex, treePoint, agg, rightChildShift$1, metadata$2, bins$1, numFeatures$1, numBins$2, numClasses$1);
                continue;
            }
            this.updateBinForOrderedFeature$1(treePoint, agg, nodeIndex, featureIndex, numFeatures$1, numBins$2, numClasses$1);
        }
    }

    private final void regressionBinSeqOp$1(double[] agg, TreePoint treePoint, int nodeIndex, int numFeatures$1, int numBins$2) {
        double label = treePoint.label();
        for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
            int binIndex = treePoint.binnedFeatures()[featureIndex];
            int aggIndex = 3 * numBins$2 * numFeatures$1 * nodeIndex + 3 * numBins$2 * featureIndex + 3 * binIndex;
            agg[aggIndex] = agg[aggIndex] + 1.0;
            int n = aggIndex + 1;
            agg[n] = agg[n] + label;
            int n2 = aggIndex + 2;
            agg[n2] = agg[n2] + label * label;
        }
    }

    public final double[] org$apache$spark$mllib$tree$DecisionTree$$binSeqOp$1(double[] agg, TreePoint treePoint, DecisionTreeMetadata metadata$2, int level$2, Node[] nodes$2, Bin[][] bins$1, int numNodes$1, int numFeatures$1, int numBins$2, int numClasses$1, boolean isMulticlassWithCategoricalFeatures$1, int groupShift$1, int levelOffset$1, int rightChildShift$1) {
        int nodeIndex = this.treePointToNodeIndex$1(treePoint, metadata$2, level$2, nodes$2, bins$1, groupShift$1, levelOffset$1);
        if (nodeIndex >= 0 && nodeIndex < numNodes$1) {
            if (metadata$2.isClassification()) {
                if (isMulticlassWithCategoricalFeatures$1) {
                    this.multiclassWithCategoricalBinSeqOp$1(agg, treePoint, nodeIndex, metadata$2, bins$1, numFeatures$1, numBins$2, numClasses$1, rightChildShift$1);
                } else {
                    this.binaryOrNotCategoricalBinSeqOp$1(agg, treePoint, nodeIndex, numFeatures$1, numBins$2, numClasses$1);
                }
            } else {
                this.regressionBinSeqOp$1(agg, treePoint, nodeIndex, numFeatures$1, numBins$2);
            }
        }
        return agg;
    }

    public final double[] org$apache$spark$mllib$tree$DecisionTree$$binCombOp$1(double[] agg1, double[] agg2, int binAggregateLength$1) {
        double[] combinedAggregate = new double[binAggregateLength$1];
        for (int index = 0; index < binAggregateLength$1; ++index) {
            combinedAggregate[index] = agg1[index] + agg2[index];
        }
        return combinedAggregate;
    }

    private final int indexOfLargestArrayElement$1(double[] array) {
        Tuple3 result = (Tuple3)Predef$.MODULE$.doubleArrayOps(array).foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x0$2, double x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$2, (Object)BoxesRunTime.boxToDouble((double)x1$1));
                if (tuple2 != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    double currentValue = tuple2._2$mcD$sp();
                    if (tuple3 != null) {
                        int maxIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        double maxValue = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        int currentIndex = BoxesRunTime.unboxToInt((Object)tuple3._3());
                        Tuple3 tuple32 = currentValue > maxValue ? new Tuple3((Object)BoxesRunTime.boxToInteger((int)currentIndex), (Object)BoxesRunTime.boxToDouble((double)currentValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1))) : new Tuple3((Object)BoxesRunTime.boxToInteger((int)maxIndex), (Object)BoxesRunTime.boxToDouble((double)maxValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1)));
                        return tuple32;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
        if (BoxesRunTime.unboxToInt((Object)result._1()) < 0) {
            throw new RuntimeException("DecisionTree internal error: calculateGainForSplit failed in indexOfLargestArrayElement");
        }
        return BoxesRunTime.unboxToInt((Object)result._1());
    }

    private final InformationGainStats calculateGainForSplit$1(double[] leftNodeAgg, double[] rightNodeAgg, double topImpurity, DecisionTreeMetadata metadata$2, int level$2, int numClasses$1) {
        InformationGainStats informationGainStats;
        if (metadata$2.isClassification()) {
            double d;
            double leftTotalCount = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(leftNodeAgg).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double rightTotalCount = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(rightNodeAgg).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            if (level$2 > 0) {
                d = topImpurity;
            } else {
                double[] rootNodeCounts = new double[numClasses$1];
                for (int classIndex = 0; classIndex < numClasses$1; ++classIndex) {
                    rootNodeCounts[classIndex] = leftNodeAgg[classIndex] + rightNodeAgg[classIndex];
                }
                d = metadata$2.impurity().calculate(rootNodeCounts, leftTotalCount + rightTotalCount);
            }
            double impurity = d;
            double totalCount = leftTotalCount + rightTotalCount;
            if (totalCount == 0.0) {
                return new InformationGainStats(0.0, topImpurity, topImpurity, topImpurity, 0.0, InformationGainStats$.MODULE$.$lessinit$greater$default$6());
            }
            double[] leftrightNodeAgg = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(leftNodeAgg).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(rightNodeAgg), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        double leftCount = tuple2._1$mcD$sp();
                        double rightCount = tuple2._2$mcD$sp();
                        double d = leftCount + rightCount;
                        return d;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            int predict2 = this.indexOfLargestArrayElement$1(leftrightNodeAgg);
            double prob = leftrightNodeAgg[predict2] / totalCount;
            double leftImpurity = leftTotalCount == 0.0 ? topImpurity : metadata$2.impurity().calculate(leftNodeAgg, leftTotalCount);
            double rightImpurity = rightTotalCount == 0.0 ? topImpurity : metadata$2.impurity().calculate(rightNodeAgg, rightTotalCount);
            double leftWeight = leftTotalCount / totalCount;
            double rightWeight = rightTotalCount / totalCount;
            double gain = impurity - leftWeight * leftImpurity - rightWeight * rightImpurity;
            informationGainStats = new InformationGainStats(gain, impurity, leftImpurity, rightImpurity, predict2, prob);
        } else {
            double impurity;
            double d;
            double leftCount = leftNodeAgg[0];
            double leftSum = leftNodeAgg[1];
            double leftSumSquares = leftNodeAgg[2];
            double rightCount = rightNodeAgg[0];
            double rightSum = rightNodeAgg[1];
            double rightSumSquares = rightNodeAgg[2];
            if (level$2 > 0) {
                d = topImpurity;
            } else {
                double count = leftCount + rightCount;
                double sum = leftSum + rightSum;
                double sumSquares = leftSumSquares + rightSumSquares;
                d = impurity = metadata$2.impurity().calculate(count, sum, sumSquares);
            }
            if (leftCount == 0.0) {
                return new InformationGainStats(0.0, topImpurity, Double$.MODULE$.MinValue(), topImpurity, rightSum / rightCount, InformationGainStats$.MODULE$.$lessinit$greater$default$6());
            }
            if (rightCount == 0.0) {
                return new InformationGainStats(0.0, topImpurity, topImpurity, Double$.MODULE$.MinValue(), leftSum / leftCount, InformationGainStats$.MODULE$.$lessinit$greater$default$6());
            }
            double leftImpurity = metadata$2.impurity().calculate(leftCount, leftSum, leftSumSquares);
            double rightImpurity = metadata$2.impurity().calculate(rightCount, rightSum, rightSumSquares);
            double leftWeight = leftCount / (leftCount + rightCount);
            double rightWeight = rightCount / (leftCount + rightCount);
            double gain = impurity - leftWeight * leftImpurity - rightWeight * rightImpurity;
            double predict3 = (leftSum + rightSum) / (leftCount + rightCount);
            informationGainStats = new InformationGainStats(gain, impurity, leftImpurity, rightImpurity, predict3, InformationGainStats$.MODULE$.$lessinit$greater$default$6());
        }
        return informationGainStats;
    }

    private final void findAggForOrderedFeatureClassification$1(double[][][] leftNodeAgg, double[][][] rightNodeAgg, int featureIndex, int numBins$2, int numClasses$1, double[] binData$1) {
        int shift = numClasses$1 * featureIndex * numBins$2;
        for (int classIndex = 0; classIndex < numClasses$1; ++classIndex) {
            leftNodeAgg[featureIndex][0][classIndex] = binData$1[shift + classIndex];
            rightNodeAgg[featureIndex][numBins$2 - 2][classIndex] = binData$1[shift + numClasses$1 * (numBins$2 - 1) + classIndex];
        }
        for (int splitIndex = 1; splitIndex < numBins$2 - 1; ++splitIndex) {
            for (int innerClassIndex = 0; innerClassIndex < numClasses$1; ++innerClassIndex) {
                leftNodeAgg[featureIndex][splitIndex][innerClassIndex] = binData$1[shift + numClasses$1 * splitIndex + innerClassIndex] + leftNodeAgg[featureIndex][splitIndex - 1][innerClassIndex];
                rightNodeAgg[featureIndex][numBins$2 - 2 - splitIndex][innerClassIndex] = binData$1[shift + (numClasses$1 * (numBins$2 - 1 - splitIndex) + innerClassIndex)] + rightNodeAgg[featureIndex][numBins$2 - 1 - splitIndex][innerClassIndex];
            }
        }
    }

    private final void findAggForUnorderedFeatureClassification$1(double[][][] leftNodeAgg, double[][][] rightNodeAgg, int featureIndex, int numFeatures$1, int numBins$2, int numClasses$1, double[] binData$1) {
        int rightChildShift = numClasses$1 * numBins$2 * numFeatures$1;
        for (int splitIndex = 0; splitIndex < numBins$2 - 1; ++splitIndex) {
            for (int classIndex = 0; classIndex < numClasses$1; ++classIndex) {
                int shift = numClasses$1 * featureIndex * numBins$2 + splitIndex * numClasses$1;
                double leftBinValue = binData$1[shift + classIndex];
                double rightBinValue = binData$1[rightChildShift + shift + classIndex];
                leftNodeAgg[featureIndex][splitIndex][classIndex] = leftBinValue;
                rightNodeAgg[featureIndex][splitIndex][classIndex] = rightBinValue;
            }
        }
    }

    private final void findAggForRegression$1(double[][][] leftNodeAgg, double[][][] rightNodeAgg, int featureIndex, int numBins$2, double[] binData$1) {
        int shift = 3 * featureIndex * numBins$2;
        leftNodeAgg[featureIndex][0][0] = binData$1[shift + 0];
        leftNodeAgg[featureIndex][0][1] = binData$1[shift + 1];
        leftNodeAgg[featureIndex][0][2] = binData$1[shift + 2];
        rightNodeAgg[featureIndex][numBins$2 - 2][0] = binData$1[shift + 3 * (numBins$2 - 1)];
        rightNodeAgg[featureIndex][numBins$2 - 2][1] = binData$1[shift + 3 * (numBins$2 - 1) + 1];
        rightNodeAgg[featureIndex][numBins$2 - 2][2] = binData$1[shift + 3 * (numBins$2 - 1) + 2];
        for (int splitIndex = 1; splitIndex < numBins$2 - 1; ++splitIndex) {
            for (int i = 0; i < 3; ++i) {
                leftNodeAgg[featureIndex][splitIndex][i] = binData$1[shift + 3 * splitIndex + i] + leftNodeAgg[featureIndex][splitIndex - 1][i];
                rightNodeAgg[featureIndex][numBins$2 - 2 - splitIndex][i] = binData$1[shift + (3 * (numBins$2 - 1 - splitIndex) + i)] + rightNodeAgg[featureIndex][numBins$2 - 1 - splitIndex][i];
            }
        }
    }

    private final Tuple2 extractLeftRightNodeAggregates$1(double[] binData, DecisionTreeMetadata metadata$2, int numFeatures$1, int numBins$2, int numClasses$1) {
        Tuple2 tuple2;
        if (metadata$2.isClassification()) {
            double[][][] leftNodeAgg = (double[][][])Array$.MODULE$.ofDim(numFeatures$1, numBins$2 - 1, numClasses$1, ClassTag$.MODULE$.Double());
            double[][][] rightNodeAgg = (double[][][])Array$.MODULE$.ofDim(numFeatures$1, numBins$2 - 1, numClasses$1, ClassTag$.MODULE$.Double());
            for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
                if (metadata$2.isUnordered(featureIndex)) {
                    this.findAggForUnorderedFeatureClassification$1(leftNodeAgg, rightNodeAgg, featureIndex, numFeatures$1, numBins$2, numClasses$1, binData);
                    continue;
                }
                this.findAggForOrderedFeatureClassification$1(leftNodeAgg, rightNodeAgg, featureIndex, numBins$2, numClasses$1, binData);
            }
            tuple2 = new Tuple2((Object)leftNodeAgg, (Object)rightNodeAgg);
        } else {
            double[][][] leftNodeAgg = (double[][][])Array$.MODULE$.ofDim(numFeatures$1, numBins$2 - 1, 3, ClassTag$.MODULE$.Double());
            double[][][] rightNodeAgg = (double[][][])Array$.MODULE$.ofDim(numFeatures$1, numBins$2 - 1, 3, ClassTag$.MODULE$.Double());
            for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
                this.findAggForRegression$1(leftNodeAgg, rightNodeAgg, featureIndex, numBins$2, binData);
            }
            tuple2 = new Tuple2((Object)leftNodeAgg, (Object)rightNodeAgg);
        }
        return tuple2;
    }

    private final InformationGainStats[][] calculateGainsForAllNodeSplits$1(double[][][] leftNodeAgg, double[][][] rightNodeAgg, double nodeImpurity, DecisionTreeMetadata metadata$2, int level$2, int numFeatures$1, int numBins$2, int numClasses$1) {
        InformationGainStats[][] gains = (InformationGainStats[][])Array$.MODULE$.ofDim(numFeatures$1, numBins$2 - 1, ClassTag$.MODULE$.apply(InformationGainStats.class));
        for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
            int numSplitsForFeature = this.getNumSplitsForFeature$1(featureIndex, metadata$2, numBins$2);
            for (int splitIndex = 0; splitIndex < numSplitsForFeature; ++splitIndex) {
                gains[featureIndex][splitIndex] = this.calculateGainForSplit$1(leftNodeAgg[featureIndex][splitIndex], rightNodeAgg[featureIndex][splitIndex], nodeImpurity, metadata$2, level$2, numClasses$1);
            }
        }
        return gains;
    }

    private final int getNumSplitsForFeature$1(int featureIndex, DecisionTreeMetadata metadata$2, int numBins$2) {
        int n;
        if (metadata$2.isContinuous(featureIndex)) {
            n = numBins$2 - 1;
        } else {
            int featureCategories = BoxesRunTime.unboxToInt((Object)metadata$2.featureArity().apply((Object)BoxesRunTime.boxToInteger((int)featureIndex)));
            n = metadata$2.isUnordered(featureIndex) ? (1 << featureCategories - 1) - 1 : featureCategories;
        }
        return n;
    }

    private final Tuple2 binsToBestSplit$1(double[] binData, double nodeImpurity, DecisionTreeMetadata metadata$2, int level$2, Split[][] splits$1, Bin[][] bins$1, int numFeatures$1, int numBins$2, int numClasses$1) {
        this.logDebug((Function0<String>)new Serializable(nodeImpurity){
            public static final long serialVersionUID = 0L;
            private final double nodeImpurity$1;

            public final String apply() {
                return new StringBuilder().append((Object)"node impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.nodeImpurity$1)).toString();
            }
            {
                this.nodeImpurity$1 = nodeImpurity$1;
            }
        });
        Tuple2 tuple2 = this.extractLeftRightNodeAggregates$1(binData, metadata$2, numFeatures$1, numBins$2, numClasses$1);
        if (tuple2 != null) {
            Tuple2 tuple22;
            double[][][] leftNodeAgg = (double[][][])tuple2._1();
            double[][][] rightNodeAgg = (double[][][])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftNodeAgg, (Object)rightNodeAgg);
            double[][][] leftNodeAgg2 = (double[][][])tuple23._1();
            double[][][] rightNodeAgg2 = (double[][][])tuple23._2();
            InformationGainStats[][] gains = this.calculateGainsForAllNodeSplits$1(leftNodeAgg2, rightNodeAgg2, nodeImpurity, metadata$2, level$2, numFeatures$1, numBins$2, numClasses$1);
            int bestFeatureIndex = Integer.MIN_VALUE;
            int bestSplitIndex = Integer.MIN_VALUE;
            InformationGainStats bestGainStats = new InformationGainStats(Double$.MODULE$.MinValue(), -1.0, -1.0, -1.0, -1.0, InformationGainStats$.MODULE$.$lessinit$greater$default$6());
            for (int featureIndex = 0; featureIndex < numFeatures$1; ++featureIndex) {
                int numSplitsForFeature = this.getNumSplitsForFeature$1(featureIndex, metadata$2, numBins$2);
                for (int splitIndex = 0; splitIndex < numSplitsForFeature; ++splitIndex) {
                    InformationGainStats gainStats = gains[featureIndex][splitIndex];
                    if (!(gainStats.gain() > bestGainStats.gain())) continue;
                    bestGainStats = gainStats;
                    bestFeatureIndex = featureIndex;
                    bestSplitIndex = splitIndex;
                }
            }
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)bestFeatureIndex), (Object)BoxesRunTime.boxToInteger((int)bestSplitIndex), (Object)bestGainStats);
            if (tuple3 != null) {
                Tuple3 tuple32;
                int bestFeatureIndex2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int bestSplitIndex2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                InformationGainStats gainStats = (InformationGainStats)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)bestFeatureIndex2), (Object)BoxesRunTime.boxToInteger((int)bestSplitIndex2), (Object)gainStats);
                int bestFeatureIndex3 = BoxesRunTime.unboxToInt((Object)tuple33._1());
                int bestSplitIndex3 = BoxesRunTime.unboxToInt((Object)tuple33._2());
                InformationGainStats gainStats2 = (InformationGainStats)tuple33._3();
                this.logDebug((Function0<String>)new Serializable(splits$1, bestFeatureIndex3, bestSplitIndex3){
                    public static final long serialVersionUID = 0L;
                    private final Split[][] splits$1;
                    private final int bestFeatureIndex$1;
                    private final int bestSplitIndex$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"best split = ").append((Object)this.splits$1[this.bestFeatureIndex$1][this.bestSplitIndex$1]).toString();
                    }
                    {
                        this.splits$1 = splits$1;
                        this.bestFeatureIndex$1 = bestFeatureIndex$1;
                        this.bestSplitIndex$1 = bestSplitIndex$1;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(bins$1, bestFeatureIndex3, bestSplitIndex3){
                    public static final long serialVersionUID = 0L;
                    private final Bin[][] bins$1;
                    private final int bestFeatureIndex$1;
                    private final int bestSplitIndex$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"best split bin = ").append((Object)this.bins$1[this.bestFeatureIndex$1][this.bestSplitIndex$1]).toString();
                    }
                    {
                        this.bins$1 = bins$1;
                        this.bestFeatureIndex$1 = bestFeatureIndex$1;
                        this.bestSplitIndex$1 = bestSplitIndex$1;
                    }
                });
                return new Tuple2((Object)splits$1[bestFeatureIndex3][bestSplitIndex3], (Object)gainStats2);
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    private final double[] getBinDataForNode$1(int node, DecisionTreeMetadata metadata$2, int numNodes$1, int numFeatures$1, int numBins$2, int numClasses$1, boolean isMulticlassWithCategoricalFeatures$1, double[] binAggregates$1) {
        double[] dArray;
        if (metadata$2.isClassification()) {
            if (isMulticlassWithCategoricalFeatures$1) {
                double[] binsForNode;
                int shift = numClasses$1 * node * numBins$2 * numFeatures$1;
                int rightChildShift = numClasses$1 * numBins$2 * numFeatures$1 * numNodes$1;
                double[] leftChildData = (double[])Predef$.MODULE$.doubleArrayOps(binAggregates$1).slice(shift, shift + numClasses$1 * numBins$2 * numFeatures$1);
                double[] rightChildData = (double[])Predef$.MODULE$.doubleArrayOps(binAggregates$1).slice(rightChildShift + shift, rightChildShift + shift + numClasses$1 * numBins$2 * numFeatures$1);
                dArray = binsForNode = (double[])Predef$.MODULE$.doubleArrayOps(leftChildData).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(rightChildData), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            } else {
                double[] binsForNode;
                int shift = numClasses$1 * node * numBins$2 * numFeatures$1;
                dArray = binsForNode = (double[])Predef$.MODULE$.doubleArrayOps(binAggregates$1).slice(shift, shift + numClasses$1 * numBins$2 * numFeatures$1);
            }
        } else {
            double[] binsForNode;
            int shift = 3 * node * numBins$2 * numFeatures$1;
            dArray = binsForNode = (double[])Predef$.MODULE$.doubleArrayOps(binAggregates$1).slice(shift, shift + 3 * numBins$2 * numFeatures$1);
        }
        return dArray;
    }

    private DecisionTree$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.InvalidBinIndex = -1;
    }
}

