/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.util.Map;
import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.mllib.tree.impl.TimeTracker;
import org.apache.spark.mllib.tree.impl.TreePoint;
import org.apache.spark.mllib.tree.impl.TreePoint$;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableViewLike;
import scala.collection.mutable.IndexedSeqView$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u0001\u0003\u00015\u0011A\u0002R3dSNLwN\u001c+sK\u0016T!a\u0001\u0003\u0002\tQ\u0014X-\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001$G\u0007\u0002\r%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!b\u0001\n\u0013i\u0012\u0001C:ue\u0006$XmZ=\u0016\u0003y\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0002\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\t\u0019\u0003E\u0001\u0005TiJ\fG/Z4z\u0011!)\u0003A!A!\u0002\u0013q\u0012!C:ue\u0006$XmZ=!\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0011\u0011f\u000b\t\u0003U\u0001i\u0011A\u0001\u0005\u00069\u0019\u0002\rA\b\u0005\u0006[\u0001!\tAL\u0001\u0006iJ\f\u0017N\u001c\u000b\u0003_U\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0002\u0002\u000b5|G-\u001a7\n\u0005Q\n$!\u0005#fG&\u001c\u0018n\u001c8Ue\u0016,Wj\u001c3fY\")a\u0007\fa\u0001o\u0005)\u0011N\u001c9viB\u0019\u0001hO\u001f\u000e\u0003eR!A\u000f\u0004\u0002\u0007I$G-\u0003\u0002=s\t\u0019!\u000b\u0012#\u0011\u0005y\nU\"A \u000b\u0005\u0001#\u0011A\u0003:fOJ,7o]5p]&\u0011!i\u0010\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\u0006\t\u0002!I!R\u0001\u0010Kb$(/Y2u\u001d>$W-\u00138g_R)a)\u0013+Z7B\u0011qbR\u0005\u0003\u0011B\u0011A!\u00168ji\")!j\u0011a\u0001\u0017\u0006qan\u001c3f'Bd\u0017\u000e^*uCR\u001c\b\u0003B\bM\u001dFK!!\u0014\t\u0003\rQ+\b\u000f\\33!\t\u0001t*\u0003\u0002Qc\t)1\u000b\u001d7jiB\u0011\u0001GU\u0005\u0003'F\u0012A#\u00138g_Jl\u0017\r^5p]\u001e\u000b\u0017N\\*uCR\u001c\b\"B+D\u0001\u00041\u0016!\u00027fm\u0016d\u0007CA\bX\u0013\tA\u0006CA\u0002J]RDQAW\"A\u0002Y\u000bQ!\u001b8eKbDQ\u0001X\"A\u0002u\u000bQA\\8eKN\u00042a\u00040a\u0013\ty\u0006CA\u0003BeJ\f\u0017\u0010\u0005\u00021C&\u0011!-\r\u0002\u0005\u001d>$W\rC\u0003e\u0001\u0011%Q-A\rfqR\u0014\u0018m\u0019;J]\u001a|gi\u001c:M_^,'\u000fT3wK2\u001cHC\u0002$gO\"T7\u000eC\u0003VG\u0002\u0007a\u000bC\u0003[G\u0002\u0007a\u000bC\u0003jG\u0002\u0007a+\u0001\u0005nCb$U\r\u001d;i\u0011\u0015Q5\r1\u0001L\u0011\u0015a7\r1\u0001n\u0003A\u0001\u0018M]3oi&k\u0007/\u001e:ji&,7\u000fE\u0002\u0010=:\u0004\"aD8\n\u0005A\u0004\"A\u0002#pk\ndW\r\u000b\u0002\u0001eB\u00111O^\u0007\u0002i*\u0011QOB\u0001\u000bC:tw\u000e^1uS>t\u0017BA<u\u00051)\u0005\u0010]3sS6,g\u000e^1m\u000f\u0015I(\u0001#\u0001{\u00031!UmY5tS>tGK]3f!\tQ3PB\u0003\u0002\u0005!\u0005Ap\u0005\u0003|\u001dQ9\u0002\"B\u0014|\t\u0003qH#\u0001>\t\r5ZH\u0011AA\u0001)\u0015y\u00131AA\u0003\u0011\u00151t\u00101\u00018\u0011\u0015ar\u00101\u0001\u001f\u0011\u0019i3\u0010\"\u0001\u0002\nQIq&a\u0003\u0002\u000e\u0005u\u00121\n\u0005\u0007m\u0005\u001d\u0001\u0019A\u001c\t\u0011\u0005=\u0011q\u0001a\u0001\u0003#\tA!\u00197h_B!\u00111CA\u001c\u001d\u0011\t)\"a\r\u000f\t\u0005]\u0011\u0011\u0007\b\u0005\u00033\tyC\u0004\u0003\u0002\u001c\u00055b\u0002BA\u000f\u0003WqA!a\b\u0002*9!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t%\u0011\u0011EA\u0005\u0004\u0003k\u0001\u0013\u0001B!mO>LA!!\u000f\u0002<\t!\u0011\t\\4p\u0015\r\t)\u0004\t\u0005\t\u0003\u007f\t9\u00011\u0001\u0002B\u0005A\u0011.\u001c9ve&$\u0018\u0010\u0005\u0003\u0002D\u0005\u001dSBAA#\u0015\r\tyDA\u0005\u0005\u0003\u0013\n)E\u0001\u0005J[B,(/\u001b;z\u0011\u0019I\u0017q\u0001a\u0001-\"1Qf\u001fC\u0001\u0003\u001f\"2bLA)\u0003'\n)&a\u0016\u0002Z!1a'!\u0014A\u0002]B\u0001\"a\u0004\u0002N\u0001\u0007\u0011\u0011\u0003\u0005\t\u0003\u007f\ti\u00051\u0001\u0002B!1\u0011.!\u0014A\u0002YCq!a\u0017\u0002N\u0001\u0007a+A\u000eok6\u001cE.Y:tKN4uN]\"mCN\u001c\u0018NZ5dCRLwN\u001c\u0005\u0007[m$\t!a\u0018\u0015#=\n\t'a\u0019\u0002f\u0005\u001d\u0014\u0011NA6\u0003_\n\t\t\u0003\u00047\u0003;\u0002\ra\u000e\u0005\t\u0003\u001f\ti\u00061\u0001\u0002\u0012!A\u0011qHA/\u0001\u0004\t\t\u0005\u0003\u0004j\u0003;\u0002\rA\u0016\u0005\b\u00037\ni\u00061\u0001W\u0011\u001d\ti'!\u0018A\u0002Y\u000bq!\\1y\u0005&t7\u000f\u0003\u0005\u0002r\u0005u\u0003\u0019AA:\u0003m\tX/\u00198uS2,7)\u00197dk2\fG/[8o'R\u0014\u0018\r^3hsB!\u0011QOA>\u001d\u0011\t)\"a\u001e\n\u0007\u0005e\u0004%\u0001\tRk\u0006tG/\u001b7f'R\u0014\u0018\r^3hs&!\u0011QPA@\u0005A\tV/\u00198uS2,7\u000b\u001e:bi\u0016<\u0017PC\u0002\u0002z\u0001B\u0001\"a!\u0002^\u0001\u0007\u0011QQ\u0001\u0018G\u0006$XmZ8sS\u000e\fGNR3biV\u0014Xm]%oM>\u0004b!a\"\u0002\u000eZ3fbA\b\u0002\n&\u0019\u00111\u0012\t\u0002\rA\u0013X\rZ3g\u0013\u0011\ty)!%\u0003\u00075\u000b\u0007OC\u0002\u0002\fBAq!!&|\t\u0003\t9*A\bue\u0006Lgn\u00117bgNLg-[3s)5y\u0013\u0011TAN\u0003;\u000by*a*\u0002*\"1a'a%A\u0002]Bq!a\u0017\u0002\u0014\u0002\u0007a\u000b\u0003\u0005\u0002\u0004\u0006M\u0005\u0019AAC\u0011!\ty$a%A\u0002\u0005\u0005\u0006\u0003BAD\u0003GKA!!*\u0002\u0012\n11\u000b\u001e:j]\u001eDa![AJ\u0001\u00041\u0006bBA7\u0003'\u0003\rA\u0016\u0005\b\u0003+[H\u0011AAW)5y\u0013qVAa\u0003\u0007\fi.a8\u0002b\"9a'a+A\u0002\u0005E\u0006#BAZ\u0003{kTBAA[\u0015\u0011\t9,!/\u0002\t)\fg/\u0019\u0006\u0004\u0003w3\u0011aA1qS&!\u0011qXA[\u0005\u001dQ\u0015M^1S\t\u0012Cq!a\u0017\u0002,\u0002\u0007a\u000b\u0003\u0005\u0002\u0004\u0006-\u0006\u0019AAc!!\t9-a4\u0002R\u0006EWBAAe\u0015\u0011\tY-!4\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003oKA!a$\u0002JB!\u00111[Am\u001b\t\t)N\u0003\u0003\u0002X\u00065\u0017\u0001\u00027b]\u001eLA!a7\u0002V\n9\u0011J\u001c;fO\u0016\u0014\b\u0002CA \u0003W\u0003\r!!)\t\r%\fY\u000b1\u0001W\u0011\u001d\ti'a+A\u0002YCq!!:|\t\u0003\t9/\u0001\bue\u0006LgNU3he\u0016\u001c8o\u001c:\u0015\u0017=\nI/a;\u0002n\u0006=\u0018\u0011\u001f\u0005\u0007m\u0005\r\b\u0019A\u001c\t\u0011\u0005\r\u00151\u001da\u0001\u0003\u000bC\u0001\"a\u0010\u0002d\u0002\u0007\u0011\u0011\u0015\u0005\u0007S\u0006\r\b\u0019\u0001,\t\u000f\u00055\u00141\u001da\u0001-\"9\u0011Q]>\u0005\u0002\u0005UHcC\u0018\u0002x\u0006e\u00181`A\u007f\u0003\u007fDqANAz\u0001\u0004\t\t\f\u0003\u0005\u0002\u0004\u0006M\b\u0019AAc\u0011!\ty$a=A\u0002\u0005\u0005\u0006BB5\u0002t\u0002\u0007a\u000bC\u0004\u0002n\u0005M\b\u0019\u0001,\t\u0013\t\r1P1A\u0005\n\t\u0015\u0011aD%om\u0006d\u0017\u000e\u001a\"j]&sG-\u001a=\u0016\u0003YCqA!\u0003|A\u0003%a+\u0001\tJ]Z\fG.\u001b3CS:Le\u000eZ3yA!A!QB>\u0005\u0012\t\u0011y!\u0001\bgS:$')Z:u'Bd\u0017\u000e^:\u0015)\tE!1\u0003B\u0012\u0005K\u0011yC!\r\u00034\tm\"\u0011\nB'!\ryal\u0013\u0005\bm\t-\u0001\u0019\u0001B\u000b!\u0011A4Ha\u0006\u0011\t\te!qD\u0007\u0003\u00057Q1A!\b\u0003\u0003\u0011IW\u000e\u001d7\n\t\t\u0005\"1\u0004\u0002\n)J,W\rU8j]RDa\u0001\u001cB\u0006\u0001\u0004i\u0007\u0002\u0003B\u0014\u0005\u0017\u0001\rA!\u000b\u0002\u00115,G/\u00193bi\u0006\u0004BA!\u0007\u0003,%!!Q\u0006B\u000e\u0005Q!UmY5tS>tGK]3f\u001b\u0016$\u0018\rZ1uC\"1QKa\u0003A\u0002YCa\u0001\u0018B\u0006\u0001\u0004i\u0006\u0002\u0003B\u001b\u0005\u0017\u0001\rAa\u000e\u0002\rM\u0004H.\u001b;t!\u0011yaL!\u000f\u0011\u0007=qf\n\u0003\u0005\u0003>\t-\u0001\u0019\u0001B \u0003\u0011\u0011\u0017N\\:\u0011\t=q&\u0011\t\t\u0005\u001fy\u0013\u0019\u0005E\u00021\u0005\u000bJ1Aa\u00122\u0005\r\u0011\u0015N\u001c\u0005\b\u0005\u0017\u0012Y\u00011\u0001W\u0003Yi\u0017\r\u001f'fm\u0016dgi\u001c:TS:<G.Z$s_V\u0004\bB\u0003B(\u0005\u0017\u0001\n\u00111\u0001\u0003R\u0005)A/[7feB!!\u0011\u0004B*\u0013\u0011\u0011)Fa\u0007\u0003\u0017QKW.\u001a+sC\u000e\\WM\u001d\u0005\b\u00053ZH\u0011\u0002B.\u0003Y1\u0017N\u001c3CKN$8\u000b\u001d7jiN\u0004VM]$s_V\u0004HC\u0006B\t\u0005;\u0012yF!\u0019\u0003d\t\u0015$q\rB5\u0005W\u0012iG!\u001d\t\u000fY\u00129\u00061\u0001\u0003\u0016!1ANa\u0016A\u00025D\u0001Ba\n\u0003X\u0001\u0007!\u0011\u0006\u0005\u0007+\n]\u0003\u0019\u0001,\t\rq\u00139\u00061\u0001^\u0011!\u0011)Da\u0016A\u0002\t]\u0002\u0002\u0003B\u001f\u0005/\u0002\rAa\u0010\t\u0011\t=#q\u000ba\u0001\u0005#B\u0011Ba\u001c\u0003XA\u0005\t\u0019\u0001,\u0002\u00139,Xn\u0012:pkB\u001c\b\"\u0003B:\u0005/\u0002\n\u00111\u0001W\u0003)9'o\\;q\u0013:$W\r\u001f\u0005\b\u0005oZH\u0011\u0002B=\u0003I9W\r^#mK6,g\u000e^:QKJtu\u000eZ3\u0015\u000bY\u0013YH! \t\u0011\t\u001d\"Q\u000fa\u0001\u0005SAqAa \u0003v\u0001\u0007a+A\u0004ok6\u0014\u0015N\\:\t\u0011\t\r5\u0010\"\u0005\u0003\u0005\u000b\u000baBZ5oIN\u0003H.\u001b;t\u0005&t7\u000f\u0006\u0004\u0003\b\n%%1\u0012\t\u0007\u001f1\u00139Da\u0010\t\rY\u0012\t\t1\u00018\u0011!\u00119C!!A\u0002\t%\u0002\u0002\u0003BHw\u0012\u0005!A!%\u00027\u0015DHO]1di6+H\u000e^5DY\u0006\u001c8oQ1uK\u001e|'/[3t)\u0019\u0011\u0019J!*\u0003(B)!Q\u0013BP]:!!q\u0013BN\u001d\u0011\t\tC!'\n\u0003EI1A!(\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LAA!)\u0003$\n!A*[:u\u0015\r\u0011i\n\u0005\u0005\u0007m\t5\u0005\u0019\u0001,\t\u000f\t%&Q\u0012a\u0001-\u0006yQ.\u0019=GK\u0006$XO]3WC2,X\rC\u0005\u0003.n\f\n\u0011\"\u0005\u00030\u0006Ab-\u001b8e\u0005\u0016\u001cHo\u00159mSR\u001cH\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\tE&\u0006\u0002B)\u0005g[#A!.\u0011\t\t]&qX\u0007\u0003\u0005sSAAa/\u0003>\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003kBIAA!1\u0003:\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\u001570%A\u0005\n\t\u001d\u0017\u0001\t4j]\u0012\u0014Um\u001d;Ta2LGo\u001d)fe\u001e\u0013x.\u001e9%I\u00164\u0017-\u001e7uIe*\"A!3+\u0007Y\u0013\u0019\fC\u0005\u0003Nn\f\n\u0011\"\u0003\u0003H\u0006\tc-\u001b8e\u0005\u0016\u001cHo\u00159mSR\u001c\b+\u001a:He>,\b\u000f\n3fM\u0006,H\u000e\u001e\u00132a!I!\u0011[>\u0002\u0002\u0013%!1[\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003VB!\u00111\u001bBl\u0013\u0011\u0011I.!6\u0003\r=\u0013'.Z2u\u0001")
public class DecisionTree
implements Serializable,
Logging {
    private final Strategy org$apache$spark$mllib$tree$DecisionTree$$strategy;
    private transient Logger org$apache$spark$Logging$$log_;

    public static DecisionTreeModel trainRegressor(JavaRDD<LabeledPoint> javaRDD, Map<Integer, Integer> map, String string, int n, int n2) {
        return DecisionTree$.MODULE$.trainRegressor(javaRDD, map, string, n, n2);
    }

    public static DecisionTreeModel trainRegressor(RDD<LabeledPoint> rDD, scala.collection.immutable.Map<Object, Object> map, String string, int n, int n2) {
        return DecisionTree$.MODULE$.trainRegressor(rDD, map, string, n, n2);
    }

    public static DecisionTreeModel trainClassifier(JavaRDD<LabeledPoint> javaRDD, int n, Map<Integer, Integer> map, String string, int n2, int n3) {
        return DecisionTree$.MODULE$.trainClassifier(javaRDD, n, map, string, n2, n3);
    }

    public static DecisionTreeModel trainClassifier(RDD<LabeledPoint> rDD, int n, scala.collection.immutable.Map<Object, Object> map, String string, int n2, int n3) {
        return DecisionTree$.MODULE$.trainClassifier(rDD, n, map, string, n2, n3);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Strategy org$apache$spark$mllib$tree$DecisionTree$$strategy() {
        return this.org$apache$spark$mllib$tree$DecisionTree$$strategy;
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input) {
        TimeTracker timer = new TimeTracker();
        timer.start("total");
        timer.start("init");
        RDD retaggedInput = input.retag(LabeledPoint.class);
        DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata((RDD<LabeledPoint>)retaggedInput, this.org$apache$spark$mllib$tree$DecisionTree$$strategy());
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTree $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"algo = ").append((Object)this.$outer.org$apache$spark$mllib$tree$DecisionTree$$strategy().algo()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        timer.start("findSplitsBins");
        Tuple2<Split[][], Bin[][]> tuple2 = DecisionTree$.MODULE$.findSplitsBins((RDD<LabeledPoint>)retaggedInput, metadata);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Split[][] splits = (Split[][])tuple2._1();
            Bin[][] bins = (Bin[][])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
            Split[][] splits2 = (Split[][])tuple23._1();
            Bin[][] bins2 = (Bin[][])tuple23._2();
            int numBins = bins2[0].length;
            timer.stop("findSplitsBins");
            this.logDebug((Function0<String>)new Serializable(this, numBins){
                public static final long serialVersionUID = 0L;
                private final int numBins$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"numBins = ").append((Object)BoxesRunTime.boxToInteger((int)this.numBins$1)).toString();
                }
                {
                    this.numBins$1 = numBins$1;
                }
            });
            RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD((RDD<LabeledPoint>)retaggedInput, bins2, metadata).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            int numFeatures = metadata.numFeatures();
            int maxDepth = this.org$apache$spark$mllib$tree$DecisionTree$$strategy().maxDepth();
            int maxNumNodes = (2 << maxDepth) - 1;
            double[] parentImpurities = new double[maxNumNodes];
            Node[] nodes = new Node[maxNumNodes];
            int maxMemoryUsage = this.org$apache$spark$mllib$tree$DecisionTree$$strategy().maxMemoryInMB() * 1024 * 1024;
            this.logDebug((Function0<String>)new Serializable(this, maxMemoryUsage){
                public static final long serialVersionUID = 0L;
                private final int maxMemoryUsage$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"max memory usage for aggregates = ").append((Object)BoxesRunTime.boxToInteger((int)this.maxMemoryUsage$1)).append((Object)" bytes.").toString();
                }
                {
                    this.maxMemoryUsage$1 = maxMemoryUsage$1;
                }
            });
            int numElementsPerNode = DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$getElementsPerNode(metadata, numBins);
            this.logDebug((Function0<String>)new Serializable(this, numElementsPerNode){
                public static final long serialVersionUID = 0L;
                private final int numElementsPerNode$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"numElementsPerNode = ").append((Object)BoxesRunTime.boxToInteger((int)this.numElementsPerNode$1)).toString();
                }
                {
                    this.numElementsPerNode$1 = numElementsPerNode$1;
                }
            });
            int arraySizePerNode = 8 * numElementsPerNode;
            int maxNumberOfNodesPerGroup = package$.MODULE$.max(maxMemoryUsage / arraySizePerNode, 1);
            this.logDebug((Function0<String>)new Serializable(this, maxNumberOfNodesPerGroup){
                public static final long serialVersionUID = 0L;
                private final int maxNumberOfNodesPerGroup$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"maxNumberOfNodesPerGroup = ").append((Object)BoxesRunTime.boxToInteger((int)this.maxNumberOfNodesPerGroup$1)).toString();
                }
                {
                    this.maxNumberOfNodesPerGroup$1 = maxNumberOfNodesPerGroup$1;
                }
            });
            int maxLevelForSingleGroup = package$.MODULE$.max((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)maxNumberOfNodesPerGroup) / package$.MODULE$.log(2.0))), 0);
            this.logDebug((Function0<String>)new Serializable(this, maxLevelForSingleGroup){
                public static final long serialVersionUID = 0L;
                private final int maxLevelForSingleGroup$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"max level for single group = ").append((Object)BoxesRunTime.boxToInteger((int)this.maxLevelForSingleGroup$1)).toString();
                }
                {
                    this.maxLevelForSingleGroup$1 = maxLevelForSingleGroup$1;
                }
            });
            timer.stop("init");
            IntRef level = new IntRef(0);
            boolean bl = false;
            while (level.elem <= maxDepth && !bl) {
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "#####################################";
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this, level){
                    public static final long serialVersionUID = 0L;
                    private final IntRef level$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"level = ").append((Object)BoxesRunTime.boxToInteger((int)this.level$1.elem)).toString();
                    }
                    {
                        this.level$1 = level$1;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "#####################################";
                    }
                });
                timer.start("findBestSplits");
                Tuple2<Split, InformationGainStats>[] splitsStatsForLevel = DecisionTree$.MODULE$.findBestSplits((RDD<TreePoint>)treeInput, parentImpurities, metadata, level.elem, nodes, splits2, bins2, maxLevelForSingleGroup, timer);
                timer.stop("findBestSplits");
                int levelNodeIndexOffset = (1 << level.elem) - 1;
                ((IterableLike)((TraversableViewLike)Predef$.MODULE$.refArrayOps((Object[])splitsStatsForLevel).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Tuple2<Split, InformationGainStats>, Object> check$ifrefutable$1) {
                        Tuple2<Tuple2<Split, InformationGainStats>, Object> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                })).foreach((Function1)new Serializable(this, timer, maxDepth, parentImpurities, nodes, level, levelNodeIndexOffset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DecisionTree $outer;
                    private final TimeTracker timer$1;
                    private final int maxDepth$1;
                    private final double[] parentImpurities$1;
                    private final Node[] nodes$1;
                    private final IntRef level$1;
                    private final int levelNodeIndexOffset$1;

                    public final void apply(Tuple2<Tuple2<Split, InformationGainStats>, Object> x$2) {
                        Tuple2<Tuple2<Split, InformationGainStats>, Object> tuple2 = x$2;
                        if (tuple2 != null) {
                            Tuple2 nodeSplitStats = (Tuple2)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            int nodeIndex = this.levelNodeIndexOffset$1 + index;
                            boolean isLeftChild = this.level$1.elem != 0 && nodeIndex % 2 == 1;
                            int parentNodeIndex = isLeftChild ? (nodeIndex - 1) / 2 : (nodeIndex - 2) / 2;
                            this.timer$1.start("extractNodeInfo");
                            this.$outer.org$apache$spark$mllib$tree$DecisionTree$$extractNodeInfo((Tuple2<Split, InformationGainStats>)nodeSplitStats, this.level$1.elem, index, this.nodes$1);
                            this.timer$1.stop("extractNodeInfo");
                            if (this.level$1.elem != 0) {
                                if (isLeftChild) {
                                    this.nodes$1[parentNodeIndex].leftNode_$eq((Option<Node>)new Some((Object)this.nodes$1[nodeIndex]));
                                } else {
                                    this.nodes$1[parentNodeIndex].rightNode_$eq((Option<Node>)new Some((Object)this.nodes$1[nodeIndex]));
                                }
                            }
                            this.timer$1.start("extractInfoForLowerLevels");
                            this.$outer.org$apache$spark$mllib$tree$DecisionTree$$extractInfoForLowerLevels(this.level$1.elem, index, this.maxDepth$1, (Tuple2<Split, InformationGainStats>)nodeSplitStats, this.parentImpurities$1);
                            this.timer$1.stop("extractInfoForLowerLevels");
                            this.$outer.logDebug((Function0<String>)new Serializable(this, nodeSplitStats){
                                public static final long serialVersionUID = 0L;
                                private final Tuple2 nodeSplitStats$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"final best split = ").append(this.nodeSplitStats$1._1()).toString();
                                }
                                {
                                    this.nodeSplitStats$1 = nodeSplitStats$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.timer$1 = timer$1;
                        this.maxDepth$1 = maxDepth$1;
                        this.parentImpurities$1 = parentImpurities$1;
                        this.nodes$1 = nodes$1;
                        this.level$1 = level$1;
                        this.levelNodeIndexOffset$1 = levelNodeIndexOffset$1;
                    }
                });
                Predef$.MODULE$.require(1 << level.elem == splitsStatsForLevel.length);
                boolean allLeaf = Predef$.MODULE$.refArrayOps((Object[])splitsStatsForLevel).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Split, InformationGainStats> x$3) {
                        return ((InformationGainStats)x$3._2()).gain() <= 0.0;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this, allLeaf){
                    public static final long serialVersionUID = 0L;
                    private final boolean allLeaf$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"all leaf = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.allLeaf$1)).toString();
                    }
                    {
                        this.allLeaf$1 = allLeaf$1;
                    }
                });
                if (allLeaf) {
                    bl = true;
                    continue;
                }
                ++level.elem;
            }
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "#####################################";
                }
            });
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Extracting tree model";
                }
            });
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "#####################################";
                }
            });
            Node topNode = nodes[0];
            topNode.build(nodes);
            timer.stop("total");
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Internal timing for DecisionTree:";
                }
            });
            this.logInfo((Function0<String>)new Serializable(this, timer){
                public static final long serialVersionUID = 0L;
                private final TimeTracker timer$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timer$1}));
                }
                {
                    this.timer$1 = timer$1;
                }
            });
            return new DecisionTreeModel(topNode, this.org$apache$spark$mllib$tree$DecisionTree$$strategy().algo());
        }
        throw new MatchError(tuple2);
    }

    public void org$apache$spark$mllib$tree$DecisionTree$$extractNodeInfo(Tuple2<Split, InformationGainStats> nodeSplitStats, int level, int index, Node[] nodes) {
        Split split = (Split)nodeSplitStats._1();
        InformationGainStats stats = (InformationGainStats)nodeSplitStats._2();
        int nodeIndex = (1 << level) - 1 + index;
        boolean isLeaf = stats.gain() <= 0.0 || level == this.org$apache$spark$mllib$tree$DecisionTree$$strategy().maxDepth();
        Node node = new Node(nodeIndex, stats.predict(), isLeaf, (Option<Split>)new Some((Object)split), (Option<Node>)None$.MODULE$, (Option<Node>)None$.MODULE$, (Option<InformationGainStats>)new Some((Object)stats));
        this.logDebug((Function0<String>)new Serializable(this, node){
            public static final long serialVersionUID = 0L;
            private final Node node$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Node = ").append((Object)this.node$1).toString();
            }
            {
                this.node$1 = node$1;
            }
        });
        nodes[nodeIndex] = node;
    }

    public void org$apache$spark$mllib$tree$DecisionTree$$extractInfoForLowerLevels(int level, int index, int maxDepth, Tuple2<Split, InformationGainStats> nodeSplitStats, double[] parentImpurities) {
        if (level >= maxDepth) {
            return;
        }
        int leftNodeIndex = (2 << level) - 1 + 2 * index;
        double leftImpurity = ((InformationGainStats)nodeSplitStats._2()).leftImpurity();
        this.logDebug((Function0<String>)new Serializable(this, leftNodeIndex, leftImpurity){
            public static final long serialVersionUID = 0L;
            private final int leftNodeIndex$1;
            private final double leftImpurity$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leftNodeIndex = ").append((Object)BoxesRunTime.boxToInteger((int)this.leftNodeIndex$1)).append((Object)", impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.leftImpurity$1)).toString();
            }
            {
                this.leftNodeIndex$1 = leftNodeIndex$1;
                this.leftImpurity$1 = leftImpurity$1;
            }
        });
        parentImpurities[leftNodeIndex] = leftImpurity;
        int rightNodeIndex = leftNodeIndex + 1;
        double rightImpurity = ((InformationGainStats)nodeSplitStats._2()).rightImpurity();
        this.logDebug((Function0<String>)new Serializable(this, rightNodeIndex, rightImpurity){
            public static final long serialVersionUID = 0L;
            private final int rightNodeIndex$1;
            private final double rightImpurity$1;

            public final String apply() {
                return new StringBuilder().append((Object)"rightNodeIndex = ").append((Object)BoxesRunTime.boxToInteger((int)this.rightNodeIndex$1)).append((Object)", impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.rightImpurity$1)).toString();
            }
            {
                this.rightNodeIndex$1 = rightNodeIndex$1;
                this.rightImpurity$1 = rightImpurity$1;
            }
        });
        parentImpurities[rightNodeIndex] = rightImpurity;
    }

    public DecisionTree(Strategy strategy) {
        this.org$apache$spark$mllib$tree$DecisionTree$$strategy = strategy;
        Logging.class.$init$((Logging)this);
        strategy.assertValid();
    }
}

