/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.api.python.SerDe$;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.feature.IDF;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.feature.Normalizer;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.feature.Word2Vec;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoWithSGD;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.correlation.CorrelationNames$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurities$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0011\u001dc\u0001B\u0001\u0003\u0001=\u0011a\u0002U=uQ>tW\n\u0014'jE\u0006\u0003\u0016J\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)Q\u000e\u001c7jE*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003#]I!\u0001\u0007\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"B\u0010\u0001\t\u0003\u0001\u0013!\u00057pC\u0012d\u0015MY3mK\u0012\u0004v.\u001b8ugR!\u0011EL\u001a=!\r\u0011c\u0005K\u0007\u0002G)\u0011A%J\u0001\u0005U\u00064\u0018M\u0003\u0002\u0006\u0011%\u0011qe\t\u0002\b\u0015\u00064\u0018M\u0015#E!\tIC&D\u0001+\u0015\tYc!\u0001\u0006sK\u001e\u0014Xm]:j_:L!!\f\u0016\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\t\u000b=r\u0002\u0019\u0001\u0019\u0002\u0007)\u001c8\r\u0005\u0002#c%\u0011!g\t\u0002\u0011\u0015\u00064\u0018m\u00159be.\u001cuN\u001c;fqRDQ\u0001\u000e\u0010A\u0002U\nA\u0001]1uQB\u0011a'\u000f\b\u0003#]J!\u0001\u000f\n\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qIAQ!\u0010\u0010A\u0002y\nQ\"\\5o!\u0006\u0014H/\u001b;j_:\u001c\bCA\t@\u0013\t\u0001%CA\u0002J]RDQA\u0011\u0001\u0005\n\r\u000bA\u0003\u001e:bS:\u0014Vm\u001a:fgNLwN\\'pI\u0016dG\u0003\u0002#RE\u0012\u00042!R%L\u001b\u00051%BA$I\u0003\u0011)H/\u001b7\u000b\u0003\u0011J!A\u0013$\u0003\t1K7\u000f\u001e\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\"\u000bA\u0001\\1oO&\u0011\u0001+\u0014\u0002\u0007\u001f\nTWm\u0019;\t\u000bI\u000b\u0005\u0019A*\u0002\u000f1,\u0017M\u001d8feB\u0012A+\u0017\t\u0004SU;\u0016B\u0001,+\u0005i9UM\\3sC2L'0\u001a3MS:,\u0017M]!mO>\u0014\u0018\u000e\u001e5n!\tA\u0016\f\u0004\u0001\u0005\u0013i\u000b\u0016\u0011!A\u0001\u0006\u0003Y&aA0%cE\u0011Al\u0018\t\u0003#uK!A\u0018\n\u0003\u000f9{G\u000f[5oOB\u0011\u0011\u0006Y\u0005\u0003C*\u0012acR3oKJ\fG.\u001b>fI2Kg.Z1s\u001b>$W\r\u001c\u0005\u0006G\u0006\u0003\r!I\u0001\u0005I\u0006$\u0018\rC\u0003f\u0003\u0002\u0007a-\u0001\bj]&$\u0018.\u00197XK&<\u0007\u000e^:\u0011\u0005\u001dTW\"\u00015\u000b\u0005%4\u0011A\u00027j]\u0006dw-\u0003\u0002lQ\n1a+Z2u_JDQ!\u001c\u0001\u0005\u00029\fAcZ3u+B$\u0017\r^3s\rJ|Wn\u0015;sS:<GCA8v!\t\u00018/D\u0001r\u0015\t\u0011h!\u0001\u0007paRLW.\u001b>bi&|g.\u0003\u0002uc\n9Q\u000b\u001d3bi\u0016\u0014\b\"\u0002<m\u0001\u0004)\u0014a\u0002:fORK\b/\u001a\u0005\u0006q\u0002!\t!_\u0001\"iJ\f\u0017N\u001c'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\\,ji\"\u001cv\t\u0012\u000b\u000f\tj\\X0!\u0002\u0002\n\u0005-\u0011qBA\t\u0011\u0015\u0019w\u000f1\u0001\"\u0011\u0015ax\u000f1\u0001?\u00035qW/\\%uKJ\fG/[8og\")ap\u001ea\u0001\u007f\u0006A1\u000f^3q'&TX\rE\u0002\u0012\u0003\u0003I1!a\u0001\u0013\u0005\u0019!u.\u001e2mK\"1\u0011qA<A\u0002}\f\u0011#\\5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8o\u0011\u0015)w\u000f1\u0001g\u0011\u0019\tia\u001ea\u0001\u007f\u0006A!/Z4QCJ\fW\u000eC\u0003wo\u0002\u0007Q\u0007C\u0004\u0002\u0014]\u0004\r!!\u0006\u0002\u0013%tG/\u001a:dKB$\bcA\t\u0002\u0018%\u0019\u0011\u0011\u0004\n\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0011A\u0006;sC&tG*Y:t_6{G-\u001a7XSRD7k\u0012#\u0015\u001b\u0011\u000b\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0011\u0019\u0019\u00171\u0004a\u0001C!1A0a\u0007A\u0002yBaA`A\u000e\u0001\u0004y\bbBA\u0007\u00037\u0001\ra \u0005\b\u0003\u000f\tY\u00021\u0001\u0000\u0011\u0019)\u00171\u0004a\u0001M\"9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0012A\u0006;sC&t'+\u001b3hK6{G-\u001a7XSRD7k\u0012#\u0015\u001b\u0011\u000b\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0011\u0019\u0019\u0017Q\u0006a\u0001C!1A0!\fA\u0002yBaA`A\u0017\u0001\u0004y\bbBA\u0007\u0003[\u0001\ra \u0005\b\u0003\u000f\ti\u00031\u0001\u0000\u0011\u0019)\u0017Q\u0006a\u0001M\"9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0013\u0001\u0006;sC&t7KV'N_\u0012,GnV5uQN;E\tF\tE\u0003\u000b\n9%!\u0013\u0002L\u00055\u0013qJA)\u0003'BaaYA \u0001\u0004\t\u0003B\u0002?\u0002@\u0001\u0007a\b\u0003\u0004\u007f\u0003\u007f\u0001\ra \u0005\b\u0003\u001b\ty\u00041\u0001\u0000\u0011\u001d\t9!a\u0010A\u0002}Da!ZA \u0001\u00041\u0007B\u0002<\u0002@\u0001\u0007Q\u0007\u0003\u0005\u0002\u0014\u0005}\u0002\u0019AA\u000b\u0011\u001d\t9\u0006\u0001C\u0001\u00033\n1\u0005\u001e:bS:dunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,GnV5uQN;E\tF\tE\u00037\ni&a\u0018\u0002b\u0005\r\u0014QMA4\u0003SBaaYA+\u0001\u0004\t\u0003B\u0002?\u0002V\u0001\u0007a\b\u0003\u0004\u007f\u0003+\u0002\ra \u0005\b\u0003\u000f\t)\u00061\u0001\u0000\u0011\u0019)\u0017Q\u000ba\u0001M\"9\u0011QBA+\u0001\u0004y\bB\u0002<\u0002V\u0001\u0007Q\u0007\u0003\u0005\u0002\u0014\u0005U\u0003\u0019AA\u000b\u0011\u001d\ti\u0007\u0001C\u0001\u0003_\nQ\u0005\u001e:bS:dunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,GnV5uQ2\u0013eiR*\u0015#\u0011\u000b\t(a\u001d\u0002v\u0005]\u0014\u0011PA>\u0003{\n\t\t\u0003\u0004d\u0003W\u0002\r!\t\u0005\u0007y\u0006-\u0004\u0019\u0001 \t\r\u0015\fY\u00071\u0001g\u0011\u001d\ti!a\u001bA\u0002}DaA^A6\u0001\u0004)\u0004\u0002CA\n\u0003W\u0002\r!!\u0006\t\u000f\u0005}\u00141\u000ea\u0001}\u0005Y1m\u001c:sK\u000e$\u0018n\u001c8t\u0011\u001d\t\u0019)a\u001bA\u0002}\f\u0011\u0002^8mKJ\fgnY3\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006yAO]1j]:\u000b\u0017N^3CCf,7\u000fF\u0003E\u0003\u0017\u000bi\t\u0003\u0004d\u0003\u000b\u0003\r!\t\u0005\b\u0003\u001f\u000b)\t1\u0001\u0000\u0003\u0019a\u0017-\u001c2eC\"9\u00111\u0013\u0001\u0005\u0002\u0005U\u0015\u0001\u0005;sC&t7*T3b]Nlu\u000eZ3m)1\t9*a)\u0002(\u0006-\u0016qVAZ!\u0011\tI*a(\u000e\u0005\u0005m%bAAO\r\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\n\t\u0005\u0005\u00161\u0014\u0002\f\u00176+\u0017M\\:N_\u0012,G\u000eC\u0004d\u0003#\u0003\r!!*\u0011\u0007\t2c\rC\u0004\u0002*\u0006E\u0005\u0019\u0001 \u0002\u0003-Dq!!,\u0002\u0012\u0002\u0007a(A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\b\u0003c\u000b\t\n1\u0001?\u0003\u0011\u0011XO\\:\t\u000f\u0005U\u0016\u0011\u0013a\u0001k\u0005\u0011\u0012N\\5uS\u0006d\u0017N_1uS>tWj\u001c3f\r\u001d\tI\f\u0001\u0001\u0003\u0003w\u0013q$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m/J\f\u0007\u000f]3s'\u0011\t9,!0\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1\u0007\u00039\u0011XmY8n[\u0016tG-\u0019;j_:LA!a2\u0002B\nAR*\u0019;sSb4\u0015m\u0019;pe&T\u0018\r^5p]6{G-\u001a7\t\u0017\u0005-\u0017q\u0017B\u0001B\u0003%\u0011QX\u0001\u0006[>$W\r\u001c\u0005\b5\u0005]F\u0011AAh)\u0011\t\t.!6\u0011\t\u0005M\u0017qW\u0007\u0002\u0001!A\u00111ZAg\u0001\u0004\ti\f\u0003\u0005\u0002Z\u0006]F\u0011AAn\u0003\u001d\u0001(/\u001a3jGR$B!!8\u0002pB1\u0011q\\As\u0003Sl!!!9\u000b\u0007\u0005\r\b\"A\u0002sI\u0012LA!a:\u0002b\n\u0019!\u000b\u0012#\u0011\t\u0005}\u00161^\u0005\u0005\u0003[\f\tM\u0001\u0004SCRLgn\u001a\u0005\t\u0003c\f9\u000e1\u0001\u0002t\u0006yQo]3s\u0003:$\u0007K]8ek\u000e$8\u000f\u0005\u0003#M\u0005U\b#B\t\u0002x\u0006m\u0018bAA}%\t)\u0011I\u001d:bsB\u0019\u0011#!@\n\u0007\u0005}(CA\u0002B]fD\u0001Ba\u0001\u00028\u0012\u0005!QA\u0001\u0010O\u0016$Xk]3s\r\u0016\fG/\u001e:fgV\u0011!q\u0001\t\u0007\u0003?\f)/!>\t\u0011\t-\u0011q\u0017C\u0001\u0005\u000b\t!cZ3u!J|G-^2u\r\u0016\fG/\u001e:fg\"9!q\u0002\u0001\u0005\u0002\tE\u0011!\u0004;sC&t\u0017\tT*N_\u0012,G\u000e\u0006\t\u0002>\nM!\u0011\u0004B\u000f\u0005C\u0011\u0019Ca\n\u0003,!A!Q\u0003B\u0007\u0001\u0004\u00119\"A\u0006sCRLgnZ:K%\u0012#\u0005\u0003\u0002\u0012'\u0003SDqAa\u0007\u0003\u000e\u0001\u0007a(\u0001\u0003sC:\\\u0007b\u0002B\u0010\u0005\u001b\u0001\rAP\u0001\u000bSR,'/\u0019;j_:\u001c\bbBAH\u0005\u001b\u0001\ra \u0005\b\u0005K\u0011i\u00011\u0001?\u0003\u0019\u0011Gn\\2lg\"A!\u0011\u0006B\u0007\u0001\u0004\t)\"A\u0006o_:tWmZ1uSZ,\u0007\u0002\u0003B\u0017\u0005\u001b\u0001\rAa\f\u0002\tM,W\r\u001a\t\u0004\u0019\nE\u0012b\u0001B\u001a\u001b\n!Aj\u001c8h\u0011\u001d\u00119\u0004\u0001C\u0001\u0005s\tQ\u0003\u001e:bS:LU\u000e\u001d7jG&$\u0018\tT*N_\u0012,G\u000e\u0006\n\u0002>\nm\"Q\bB \u0005\u0003\u0012\u0019E!\u0012\u0003J\t-\u0003\u0002\u0003B\u000b\u0005k\u0001\rAa\u0006\t\u000f\tm!Q\u0007a\u0001}!9!q\u0004B\u001b\u0001\u0004q\u0004bBAH\u0005k\u0001\ra \u0005\b\u0005K\u0011)\u00041\u0001?\u0011\u001d\u00119E!\u000eA\u0002}\fQ!\u00197qQ\u0006D\u0001B!\u000b\u00036\u0001\u0007\u0011Q\u0003\u0005\t\u0005[\u0011)\u00041\u0001\u00030!9!q\n\u0001\u0005\u0002\tE\u0013a\u00048pe6\fG.\u001b>f-\u0016\u001cGo\u001c:\u0015\u000b\u0019\u0014\u0019Fa\u0016\t\u000f\tU#Q\na\u0001\u007f\u0006\t\u0001\u000fC\u0004\u0003Z\t5\u0003\u0019\u00014\u0002\rY,7\r^8s\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005;\"b!!*\u0003`\t\u0005\u0004b\u0002B+\u00057\u0002\ra \u0005\t\u0003G\u0014Y\u00061\u0001\u0002&\"9!Q\r\u0001\u0005\u0002\t\u001d\u0014!\u00054jiN#\u0018M\u001c3be\u0012\u001c6-\u00197feRA!\u0011\u000eB;\u0005s\u0012i\b\u0005\u0003\u0003l\tETB\u0001B7\u0015\r\u0011yGB\u0001\bM\u0016\fG/\u001e:f\u0013\u0011\u0011\u0019H!\u001c\u0003'M#\u0018M\u001c3be\u0012\u001c6-\u00197fe6{G-\u001a7\t\u0011\t]$1\ra\u0001\u0003+\t\u0001b^5uQ6+\u0017M\u001c\u0005\t\u0005w\u0012\u0019\u00071\u0001\u0002\u0016\u00059q/\u001b;i'R$\u0007bB2\u0003d\u0001\u0007\u0011Q\u0015\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0003\u00191\u0017\u000e^%E\rR1!Q\u0011BF\u0005\u001f\u0003BAa\u001b\u0003\b&!!\u0011\u0012B7\u0005!IEIR'pI\u0016d\u0007b\u0002BG\u0005\u007f\u0002\rAP\u0001\u000b[&tGi\\2Ge\u0016\f\b\u0002\u0003BI\u0005\u007f\u0002\r!!*\u0002\u000f\u0011\fG/Y:fi\"9!Q\u0013\u0001\u0005\u0002\t]\u0015!\u0004;sC&twk\u001c:eeY+7\r\u0006\b\u0003\u001a\nU'\u0011\u001dBs\u0005S\u0014iOa<\u0011\t\u0005M'1\u0014\u0004\b\u0005;\u0003\u0001A\u0001BP\u0005Q9vN\u001d33-\u0016\u001cWj\u001c3fY^\u0013\u0018\r\u001d9feN\u0019!1\u0014\t\t\u0017\u0005-'1\u0014B\u0001B\u0003%!1\u0015\t\u0005\u0005W\u0012)+\u0003\u0003\u0003(\n5$!D,pe\u0012\u0014d+Z2N_\u0012,G\u000eC\u0004\u001b\u00057#\tAa+\u0015\t\te%Q\u0016\u0005\t\u0003\u0017\u0014I\u000b1\u0001\u0003$\"A!\u0011\u0017BN\t\u0003\u0011\u0019,A\u0005ue\u0006t7OZ8s[R\u0019aM!.\t\u000f\t]&q\u0016a\u0001k\u0005!qo\u001c:e\u0011!\u0011\tLa'\u0005\u0002\tmF\u0003BAS\u0005{C\u0001\"a9\u0003:\u0002\u0007!q\u0018\t\u0004E\u0019*\u0004\u0002\u0003Bb\u00057#\tA!2\u0002\u0019\u0019Lg\u000eZ*z]>t\u00170\\:\u0015\u000b\u0011\u00139M!3\t\u000f\t]&\u0011\u0019a\u0001k!9!1\u001aBa\u0001\u0004q\u0014a\u00018v[\"A!1\u0019BN\t\u0003\u0011y\rF\u0003E\u0005#\u0014\u0019\u000eC\u0004\u0003Z\t5\u0007\u0019\u00014\t\u000f\t-'Q\u001aa\u0001}!A!q\u001bBJ\u0001\u0004\u0011I.\u0001\u0005eCR\f'J\u0015#E!\u0011\u0011cEa7\u0011\t\u0015\u0013i.N\u0005\u0004\u0005?4%!C!se\u0006LH*[:u\u0011\u001d\u0011\u0019Oa%A\u0002y\n!B^3di>\u00148+\u001b>f\u0011\u001d\u00119Oa%A\u0002}\fA\u0002\\3be:Lgn\u001a*bi\u0016DqAa;\u0003\u0014\u0002\u0007a(A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007y\nM\u0005\u0019\u0001 \t\u0011\t5\"1\u0013a\u0001\u0005c\u00042!\u0005Bz\u0013\r\u0011\u0019D\u0005\u0005\b\u0005o\u0004A\u0011\u0001B}\u0003Y!(/Y5o\t\u0016\u001c\u0017n]5p]R\u0013X-Z'pI\u0016dG\u0003\u0006B~\u0007\u0013\u0019Yaa\u0004\u0004\u0014\ru1\u0011EB\u0013\u0007S\u0019i\u0003\u0005\u0003\u0003~\u000e\u0015QB\u0001B\u0000\u0015\u0011\tYm!\u0001\u000b\u0007\r\ra!\u0001\u0003ue\u0016,\u0017\u0002BB\u0004\u0005\u007f\u0014\u0011\u0003R3dSNLwN\u001c+sK\u0016lu\u000eZ3m\u0011\u0019\u0019'Q\u001fa\u0001C!91Q\u0002B{\u0001\u0004)\u0014aB1mO>\u001cFO\u001d\u0005\b\u0007#\u0011)\u00101\u0001?\u0003)qW/\\\"mCN\u001cXm\u001d\u0005\t\u0007+\u0011)\u00101\u0001\u0004\u0018\u000592-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fg&sgm\u001c\t\u0006\u000b\u000eeaHP\u0005\u0004\u000771%aA'ba\"91q\u0004B{\u0001\u0004)\u0014aC5naV\u0014\u0018\u000e^=TiJDqaa\t\u0003v\u0002\u0007a(\u0001\u0005nCb$U\r\u001d;i\u0011\u001d\u00199C!>A\u0002y\nq!\\1y\u0005&t7\u000fC\u0004\u0004,\tU\b\u0019\u0001 \u0002'5Lg.\u00138ti\u0006t7-Z:QKJtu\u000eZ3\t\u000f\r=\"Q\u001fa\u0001\u007f\u0006YQ.\u001b8J]\u001a|w)Y5o\u0011\u001d\u0019\u0019\u0004\u0001C\u0001\u0007k\ta\u0003\u001e:bS:\u0014\u0016M\u001c3p[\u001a{'/Z:u\u001b>$W\r\u001c\u000b\u0017\u0007o\u0019ida\u0010\u0004B\r\r3QIB%\u0007\u001b\u001aye!\u0015\u0004TA!!Q`B\u001d\u0013\u0011\u0019YDa@\u0003#I\u000bg\u000eZ8n\r>\u0014Xm\u001d;N_\u0012,G\u000e\u0003\u0004d\u0007c\u0001\r!\t\u0005\b\u0007\u001b\u0019\t\u00041\u00016\u0011\u001d\u0019\tb!\rA\u0002yB\u0001b!\u0006\u00042\u0001\u00071q\u0003\u0005\b\u0007\u000f\u001a\t\u00041\u0001?\u0003!qW/\u001c+sK\u0016\u001c\bbBB&\u0007c\u0001\r!N\u0001\u0016M\u0016\fG/\u001e:f'V\u00147/\u001a;TiJ\fG/Z4z\u0011\u001d\u0019yb!\rA\u0002UBqaa\t\u00042\u0001\u0007a\bC\u0004\u0004(\rE\u0002\u0019\u0001 \t\u000f\t52\u0011\u0007a\u0001}!91q\u000b\u0001\u0005\u0002\re\u0013\u0001C2pYN#\u0018\r^:\u0015\t\rm3q\r\t\u0005\u0007;\u001a\u0019'\u0004\u0002\u0004`)\u00191\u0011\r\u0004\u0002\tM$\u0018\r^\u0005\u0005\u0007K\u001ayF\u0001\u0010Nk2$\u0018N^1sS\u0006$Xm\u0015;bi&\u001cH/[2bYN+X.\\1ss\"A\u00111]B+\u0001\u0004\t)\u000bC\u0004\u0004l\u0001!\ta!\u001c\u0002\t\r|'O\u001d\u000b\u0007\u0007_\u001a)h!\u001f\u0011\u0007\u001d\u001c\t(C\u0002\u0004t!\u0014a!T1ue&D\b\u0002CB<\u0007S\u0002\r!!*\u0002\u0003aDqaa\u001f\u0004j\u0001\u0007Q'\u0001\u0004nKRDw\u000e\u001a\u0005\b\u0007W\u0002A\u0011AB@)\u001dy8\u0011QBC\u0007\u0013C\u0001ba\u001e\u0004~\u0001\u000711\u0011\t\u0004E\u0019z\b\u0002CBD\u0007{\u0002\raa!\u0002\u0003eDqaa\u001f\u0004~\u0001\u0007Q\u0007C\u0004\u0004\u000e\u0002!\taa$\u0002\u0013\rD\u0017nU9UKN$HCBBI\u0007;\u001b\t\u000b\u0005\u0003\u0004\u0014\u000eeUBABK\u0015\u0011\u00199ja\u0018\u0002\tQ,7\u000f^\u0005\u0005\u00077\u001b)JA\bDQ&\u001c\u0016\u000fV3tiJ+7/\u001e7u\u0011\u001d\u0019yja#A\u0002\u0019\f\u0001b\u001c2tKJ4X\r\u001a\u0005\b\u0007G\u001bY\t1\u0001g\u0003!)\u0007\u0010]3di\u0016$\u0007bBBG\u0001\u0011\u00051q\u0015\u000b\u0005\u0007#\u001bI\u000b\u0003\u0005\u0004 \u000e\u0015\u0006\u0019AB8\u0011\u001d\u0019i\t\u0001C\u0001\u0007[#Baa,\u00042B)\u0011#a>\u0004\u0012\"11ma+A\u0002\u0005Bqa!.\u0001\t\u0013\u00199,\u0001\u000bhKR\u001cuN\u001d:OC6,wJ\u001d#fM\u0006,H\u000e\u001e\u000b\u0004k\re\u0006bBB>\u0007g\u0003\r!\u000e\u0005\b\u0007{\u0003A\u0011BB`\u0003A9W\r^*fK\u0012|%\u000fR3gCVdG\u000f\u0006\u0003\u0003r\u000e\u0005\u0007\u0002\u0003B\u0017\u0007w\u0003\rAa\f\t\u000f\r\u0015\u0007\u0001\"\u0003\u0004H\u0006Ir-\u001a;Ok6\u0004\u0016M\u001d;ji&|gn](s\t\u00164\u0017-\u001e7u)\u0015q4\u0011ZBi\u0011!\u0011Yoa1A\u0002\r-\u0007c\u0001'\u0004N&\u00191qZ'\u0003\u000f%sG/Z4fe\"1qfa1A\u0002ABqa!6\u0001\t\u0003\u00199.\u0001\u0006v]&4wN]7S\t\u0012#\"ba!\u0004Z\u000em7q\\Bq\u0011\u0019y31\u001ba\u0001a!A1Q\\Bj\u0001\u0004\u0011\t0\u0001\u0003tSj,\u0007\u0002\u0003Bv\u0007'\u0004\raa3\t\u0011\t521\u001ba\u0001\u0005_Aqa!:\u0001\t\u0003\u00199/A\u0005o_Jl\u0017\r\u001c*E\tRQ11QBu\u0007W\u001cioa<\t\r=\u001a\u0019\u000f1\u00011\u0011!\u0019ina9A\u0002\tE\b\u0002\u0003Bv\u0007G\u0004\raa3\t\u0011\t521\u001da\u0001\u0005_Aqaa=\u0001\t\u0003\u0019)0\u0001\u0006q_&\u001c8o\u001c8S\t\u0012#Bba!\u0004x\u000ee8Q`B\u0000\t\u0003AaaLBy\u0001\u0004\u0001\u0004bBB~\u0007c\u0004\ra`\u0001\u0005[\u0016\fg\u000e\u0003\u0005\u0004^\u000eE\b\u0019\u0001By\u0011!\u0011Yo!=A\u0002\r-\u0007\u0002\u0003B\u0017\u0007c\u0004\rAa\f\t\u000f\u0011\u0015\u0001\u0001\"\u0001\u0005\b\u0005\u0001RO\\5g_Jlg+Z2u_J\u0014F\t\u0012\u000b\r\u0003K#I\u0001b\u0003\u0005\u0010\u0011MAQ\u0003\u0005\u0007_\u0011\r\u0001\u0019\u0001\u0019\t\u0011\u00115A1\u0001a\u0001\u0005c\fqA\\;n%><8\u000fC\u0004\u0005\u0012\u0011\r\u0001\u0019\u0001 \u0002\u000f9,XnQ8mg\"A!1\u001eC\u0002\u0001\u0004\u0019Y\r\u0003\u0005\u0003.\u0011\r\u0001\u0019\u0001B\u0018\u0011\u001d!I\u0002\u0001C\u0001\t7\tqB\\8s[\u0006dg+Z2u_J\u0014F\t\u0012\u000b\r\u0003K#i\u0002b\b\u0005\"\u0011\rBQ\u0005\u0005\u0007_\u0011]\u0001\u0019\u0001\u0019\t\u0011\u00115Aq\u0003a\u0001\u0005cDq\u0001\"\u0005\u0005\u0018\u0001\u0007a\b\u0003\u0005\u0003l\u0012]\u0001\u0019ABf\u0011!\u0011i\u0003b\u0006A\u0002\t=\u0002b\u0002C\u0015\u0001\u0011\u0005A1F\u0001\u0011a>L7o]8o-\u0016\u001cGo\u001c:S\t\u0012#b\"!*\u0005.\u0011=B\u0011\u0007C\u001a\tk!9\u0004\u0003\u00040\tO\u0001\r\u0001\r\u0005\b\u0007w$9\u00031\u0001\u0000\u0011!!i\u0001b\nA\u0002\tE\bb\u0002C\t\tO\u0001\rA\u0010\u0005\t\u0005W$9\u00031\u0001\u0004L\"A!Q\u0006C\u0014\u0001\u0004\u0011y\u0003K\u0002\u0001\tw\u0001B\u0001\"\u0010\u0005D5\u0011Aq\b\u0006\u0004\t\u0003B\u0011AC1o]>$\u0018\r^5p]&!AQ\tC \u00051!UM^3m_B,'/\u00119j\u0001")
public class PythonMLLibAPI
implements Serializable {
    public JavaRDD<LabeledPoint> loadLabeledPoints(JavaSparkContext jsc, String path, int minPartitions) {
        return JavaRDD$.MODULE$.fromRDD(MLUtils$.MODULE$.loadLabeledPoints(jsc.sc(), path, minPartitions), ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    private List<Object> trainRegressionModel(GeneralizedLinearAlgorithm<? extends GeneralizedLinearModel> learner, JavaRDD<LabeledPoint> data, Vector initialWeights) {
        try {
            GeneralizedLinearModel model = learner.run((RDD<LabeledPoint>)data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()), initialWeights);
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{model.weights(), BoxesRunTime.boxToDouble((double)model.intercept())})).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object x$1) {
                    return x$1;
                }
            }, List$.MODULE$.canBuildFrom())).asJava();
        }
        finally {
            data.rdd().unpersist(false);
        }
    }

    public Updater getUpdaterFromString(String regType) {
        block6: {
            Updater updater;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            String string = regType;
                            String string2 = "l2";
                            if (string != null ? !string.equals(string2) : string2 != null) break block2;
                            updater = new SquaredL2Updater();
                            break block3;
                        }
                        String string = regType;
                        String string3 = "l1";
                        if (string != null ? !string.equals(string3) : string3 != null) break block4;
                        updater = new L1Updater();
                        break block3;
                    }
                    if (regType == null) break block5;
                    String string = regType;
                    String string4 = "none";
                    if (string != null ? !string.equals(string4) : string4 != null) break block6;
                }
                updater = new SimpleUpdater();
            }
            return updater;
        }
        throw new IllegalArgumentException("Invalid value for 'regType' parameter. Can only be initialized using the following string values: ['l1', 'l2', None].");
    }

    public List<Object> trainLinearRegressionModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double miniBatchFraction, Vector initialWeights, double regParam, String regType, boolean intercept) {
        LinearRegressionWithSGD lrAlg = new LinearRegressionWithSGD();
        lrAlg.setIntercept(intercept);
        lrAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        lrAlg.optimizer().setUpdater(this.getUpdaterFromString(regType));
        return this.trainRegressionModel(lrAlg, data, initialWeights);
    }

    public List<Object> trainLassoModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double regParam, double miniBatchFraction, Vector initialWeights) {
        LassoWithSGD lassoAlg = new LassoWithSGD();
        lassoAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        return this.trainRegressionModel(lassoAlg, data, initialWeights);
    }

    public List<Object> trainRidgeModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double regParam, double miniBatchFraction, Vector initialWeights) {
        RidgeRegressionWithSGD ridgeAlg = new RidgeRegressionWithSGD();
        ridgeAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        return this.trainRegressionModel(ridgeAlg, data, initialWeights);
    }

    public List<Object> trainSVMModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double regParam, double miniBatchFraction, Vector initialWeights, String regType, boolean intercept) {
        SVMWithSGD SVMAlg = new SVMWithSGD();
        SVMAlg.setIntercept(intercept);
        SVMAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        SVMAlg.optimizer().setUpdater(this.getUpdaterFromString(regType));
        return this.trainRegressionModel(SVMAlg, data, initialWeights);
    }

    public List<Object> trainLogisticRegressionModelWithSGD(JavaRDD<LabeledPoint> data, int numIterations, double stepSize, double miniBatchFraction, Vector initialWeights, double regParam, String regType, boolean intercept) {
        LogisticRegressionWithSGD LogRegAlg = new LogisticRegressionWithSGD();
        LogRegAlg.setIntercept(intercept);
        LogRegAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
        LogRegAlg.optimizer().setUpdater(this.getUpdaterFromString(regType));
        return this.trainRegressionModel(LogRegAlg, data, initialWeights);
    }

    public List<Object> trainLogisticRegressionModelWithLBFGS(JavaRDD<LabeledPoint> data, int numIterations, Vector initialWeights, double regParam, String regType, boolean intercept, int corrections, double tolerance) {
        LogisticRegressionWithLBFGS LogRegAlg = new LogisticRegressionWithLBFGS();
        LogRegAlg.setIntercept(intercept);
        LogRegAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setNumCorrections(corrections).setConvergenceTol(tolerance);
        LogRegAlg.optimizer().setUpdater(this.getUpdaterFromString(regType));
        return this.trainRegressionModel(LogRegAlg, data, initialWeights);
    }

    public List<Object> trainNaiveBayes(JavaRDD<LabeledPoint> data, double lambda) {
        NaiveBayesModel model = NaiveBayes$.MODULE$.train((RDD<LabeledPoint>)data.rdd(), lambda);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{Vectors$.MODULE$.dense(model.labels()), Vectors$.MODULE$.dense(model.pi()), model.theta()})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x$2) {
                return x$2;
            }
        }, List$.MODULE$.canBuildFrom())).asJava();
    }

    public KMeansModel trainKMeansModel(JavaRDD<Vector> data, int k, int maxIterations, int runs, String initializationMode) {
        KMeans kMeansAlg = new KMeans().setK(k).setMaxIterations(maxIterations).setRuns(runs).setInitializationMode(initializationMode);
        try {
            return kMeansAlg.run((RDD<Vector>)data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()));
        }
        finally {
            data.rdd().unpersist(false);
        }
    }

    public MatrixFactorizationModel trainALSModel(JavaRDD<Rating> ratingsJRDD, int rank, int iterations, double lambda, int blocks, boolean nonnegative, Long seed) {
        ALS als = new ALS().setRank(rank).setIterations(iterations).setLambda(lambda).setBlocks(blocks).setNonnegative(nonnegative);
        Object object = seed == null ? BoxedUnit.UNIT : als.setSeed(Predef$.MODULE$.Long2long(seed));
        MatrixFactorizationModel model = als.run((RDD<Rating>)ratingsJRDD.rdd());
        return new MatrixFactorizationModelWrapper(model);
    }

    public MatrixFactorizationModel trainImplicitALSModel(JavaRDD<Rating> ratingsJRDD, int rank, int iterations, double lambda, int blocks, double alpha, boolean nonnegative, Long seed) {
        ALS als = new ALS().setImplicitPrefs(true).setRank(rank).setIterations(iterations).setLambda(lambda).setBlocks(blocks).setAlpha(alpha).setNonnegative(nonnegative);
        Object object = seed == null ? BoxedUnit.UNIT : als.setSeed(Predef$.MODULE$.Long2long(seed));
        MatrixFactorizationModel model = als.run((RDD<Rating>)ratingsJRDD.rdd());
        return new MatrixFactorizationModelWrapper(model);
    }

    public Vector normalizeVector(double p, Vector vector) {
        return new Normalizer(p).transform(vector);
    }

    public JavaRDD<Vector> normalizeVector(double p, JavaRDD<Vector> rdd) {
        return new Normalizer(p).transform(rdd);
    }

    public StandardScalerModel fitStandardScaler(boolean withMean, boolean withStd, JavaRDD<Vector> data) {
        return new StandardScaler(withMean, withStd).fit((RDD<Vector>)data.rdd());
    }

    public IDFModel fitIDF(int minDocFreq, JavaRDD<Vector> dataset) {
        return new IDF(minDocFreq).fit(dataset);
    }

    public Word2VecModelWrapper trainWord2Vec(JavaRDD<ArrayList<String>> dataJRDD, int vectorSize, double learningRate, int numPartitions, int numIterations, long seed) {
        Word2Vec word2vec = new Word2Vec().setVectorSize(vectorSize).setLearningRate(learningRate).setNumPartitions(numPartitions).setNumIterations(numIterations).setSeed(seed);
        try {
            Word2VecModel model = word2vec.fit(JavaRDD$.MODULE$.fromRDD(dataJRDD.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER()), ClassTag$.MODULE$.apply(ArrayList.class)));
            return new Word2VecModelWrapper(this, model);
        }
        finally {
            dataJRDD.rdd().unpersist(false);
        }
    }

    public DecisionTreeModel trainDecisionTreeModel(JavaRDD<LabeledPoint> data, String algoStr, int numClasses, Map<Object, Object> categoricalFeaturesInfo, String impurityStr, int maxDepth, int maxBins, int minInstancesPerNode, double minInfoGain) {
        Enumeration.Value algo = Algo$.MODULE$.fromString(algoStr);
        Impurity impurity = Impurities$.MODULE$.fromString(impurityStr);
        Enumeration.Value x$6 = algo;
        Impurity x$7 = impurity;
        int x$8 = maxDepth;
        int x$9 = numClasses;
        int x$10 = maxBins;
        scala.collection.immutable.Map x$11 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms());
        int x$12 = minInstancesPerNode;
        double x$13 = minInfoGain;
        Enumeration.Value x$14 = Strategy$.MODULE$.$lessinit$greater$default$6();
        int x$15 = Strategy$.MODULE$.$lessinit$greater$default$10();
        double x$16 = Strategy$.MODULE$.$lessinit$greater$default$11();
        boolean x$17 = Strategy$.MODULE$.$lessinit$greater$default$12();
        Option<String> x$18 = Strategy$.MODULE$.$lessinit$greater$default$13();
        int x$19 = Strategy$.MODULE$.$lessinit$greater$default$14();
        Strategy strategy = new Strategy(x$6, x$7, x$8, x$9, x$10, x$14, (scala.collection.immutable.Map<Object, Object>)x$11, x$12, x$13, x$15, x$16, x$17, x$18, x$19);
        try {
            return DecisionTree$.MODULE$.train((RDD<LabeledPoint>)data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()), strategy);
        }
        finally {
            data.rdd().unpersist(false);
        }
    }

    public RandomForestModel trainRandomForestModel(JavaRDD<LabeledPoint> data, String algoStr, int numClasses, Map<Object, Object> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurityStr, int maxDepth, int maxBins, int seed) {
        Enumeration.Value algo = Algo$.MODULE$.fromString(algoStr);
        Impurity impurity = Impurities$.MODULE$.fromString(impurityStr);
        Enumeration.Value x$20 = algo;
        Impurity x$21 = impurity;
        int x$22 = maxDepth;
        int x$23 = numClasses;
        int x$24 = maxBins;
        scala.collection.immutable.Map x$25 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms());
        Enumeration.Value x$26 = Strategy$.MODULE$.$lessinit$greater$default$6();
        int x$27 = Strategy$.MODULE$.$lessinit$greater$default$8();
        double x$28 = Strategy$.MODULE$.$lessinit$greater$default$9();
        int x$29 = Strategy$.MODULE$.$lessinit$greater$default$10();
        double x$30 = Strategy$.MODULE$.$lessinit$greater$default$11();
        boolean x$31 = Strategy$.MODULE$.$lessinit$greater$default$12();
        Option<String> x$32 = Strategy$.MODULE$.$lessinit$greater$default$13();
        int x$33 = Strategy$.MODULE$.$lessinit$greater$default$14();
        Strategy strategy = new Strategy(x$20, x$21, x$22, x$23, x$24, x$26, (scala.collection.immutable.Map<Object, Object>)x$25, x$27, x$28, x$29, x$30, x$31, x$32, x$33);
        RDD cached = data.rdd().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        try {
            Enumeration.Value value = algo;
            Enumeration.Value value2 = Algo$.MODULE$.Classification();
            RandomForestModel randomForestModel = !(value != null ? !value.equals(value2) : value2 != null) ? RandomForest$.MODULE$.trainClassifier((RDD<LabeledPoint>)cached, strategy, numTrees, featureSubsetStrategy, seed) : RandomForest$.MODULE$.trainRegressor((RDD<LabeledPoint>)cached, strategy, numTrees, featureSubsetStrategy, seed);
            return randomForestModel;
        }
        finally {
            cached.unpersist(false);
        }
    }

    public MultivariateStatisticalSummary colStats(JavaRDD<Vector> rdd) {
        return Statistics$.MODULE$.colStats((RDD<Vector>)rdd.rdd());
    }

    public Matrix corr(JavaRDD<Vector> x, String method) {
        return Statistics$.MODULE$.corr((RDD<Vector>)x.rdd(), this.getCorrNameOrDefault(method));
    }

    public double corr(JavaRDD<Object> x, JavaRDD<Object> y, String method) {
        return Statistics$.MODULE$.corr((RDD<Object>)x.rdd(), (RDD<Object>)y.rdd(), this.getCorrNameOrDefault(method));
    }

    public ChiSqTestResult chiSqTest(Vector observed, Vector expected) {
        return expected == null ? Statistics$.MODULE$.chiSqTest(observed) : Statistics$.MODULE$.chiSqTest(observed, expected);
    }

    public ChiSqTestResult chiSqTest(Matrix observed) {
        return Statistics$.MODULE$.chiSqTest(observed);
    }

    public ChiSqTestResult[] chiSqTest(JavaRDD<LabeledPoint> data) {
        return Statistics$.MODULE$.chiSqTest((RDD<LabeledPoint>)data.rdd());
    }

    private String getCorrNameOrDefault(String method) {
        return method == null ? CorrelationNames$.MODULE$.defaultCorrName() : method;
    }

    private long getSeedOrDefault(Long seed) {
        return seed == null ? Utils$.MODULE$.random().nextLong() : Predef$.MODULE$.Long2long(seed);
    }

    private int getNumPartitionsOrDefault(Integer numPartitions, JavaSparkContext jsc) {
        return numPartitions == null ? jsc.sc().defaultParallelism() : Predef$.MODULE$.Integer2int(numPartitions);
    }

    public JavaRDD<Object> uniformRDD(JavaSparkContext jsc, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.uniformRDD(jsc.sc(), size, parts, s), ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Object> normalRDD(JavaSparkContext jsc, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.normalRDD(jsc.sc(), size, parts, s), ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Object> poissonRDD(JavaSparkContext jsc, double mean2, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.poissonRDD(jsc.sc(), mean2, size, parts, s), ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Vector> uniformVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.uniformVectorRDD(jsc.sc(), numRows2, numCols, parts, s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public JavaRDD<Vector> normalVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.normalVectorRDD(jsc.sc(), numRows2, numCols, parts, s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public JavaRDD<Vector> poissonVectorRDD(JavaSparkContext jsc, double mean2, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.poissonVectorRDD(jsc.sc(), mean2, numRows2, numCols, parts, s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public class Word2VecModelWrapper {
        public final Word2VecModel org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model;
        public final /* synthetic */ PythonMLLibAPI $outer;

        public Vector transform(String word) {
            return this.org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model.transform(word);
        }

        public JavaRDD<Vector> transform(JavaRDD<String> rdd) {
            return JavaRDD$.MODULE$.fromRDD(rdd.rdd().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Word2VecModelWrapper $outer;

                public final Vector apply(String word) {
                    return this.$outer.org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model.transform(word);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, ClassTag$.MODULE$.apply(Vector.class)), ClassTag$.MODULE$.apply(Vector.class));
        }

        public List<Object> findSynonyms(String word, int num) {
            Vector vec = this.transform(word);
            return this.findSynonyms(vec, num);
        }

        public List<Object> findSynonyms(Vector vector, int num) {
            Tuple2<String, Object>[] result = this.org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model.findSynonyms(vector, num);
            Vector similarity = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])result).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<String, Object> x$3) {
                    return x$3._2$mcD$sp();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            String[] words = (String[])Predef$.MODULE$.refArrayOps((Object[])result).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x$4) {
                    return (String)x$4._1();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{words, similarity})).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object x$5) {
                    return x$5;
                }
            }, List$.MODULE$.canBuildFrom())).asJava();
        }

        public /* synthetic */ PythonMLLibAPI org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$$outer() {
            return this.$outer;
        }

        public Word2VecModelWrapper(PythonMLLibAPI $outer, Word2VecModel model) {
            this.org$apache$spark$mllib$api$python$PythonMLLibAPI$Word2VecModelWrapper$$model = model;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }

    public class MatrixFactorizationModelWrapper
    extends MatrixFactorizationModel {
        public RDD<Rating> predict(JavaRDD<Object[]> userAndProducts) {
            return this.predict(SerDe$.MODULE$.asTupleRDD((RDD<Object[]>)userAndProducts.rdd()));
        }

        public RDD<Object[]> getUserFeatures() {
            return SerDe$.MODULE$.fromTuple2RDD(this.userFeatures());
        }

        public RDD<Object[]> getProductFeatures() {
            return SerDe$.MODULE$.fromTuple2RDD(this.productFeatures());
        }

        public /* synthetic */ PythonMLLibAPI org$apache$spark$mllib$api$python$PythonMLLibAPI$MatrixFactorizationModelWrapper$$$outer() {
            return PythonMLLibAPI.this;
        }

        public MatrixFactorizationModelWrapper(MatrixFactorizationModel model) {
            if (PythonMLLibAPI.this == null) {
                throw new NullPointerException();
            }
            super(model.rank(), model.userFeatures(), model.productFeatures());
        }
    }
}

