/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.IObjectPickler;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;
import net.razorvine.pickle.Pickler;
import net.razorvine.pickle.Unpickler;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.api.python.SerDe$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]uAB\u0001\u0003\u0011\u0003Aa\"A\u0003TKJ$UM\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)Q\u000e\u001c7jE*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014x\r\u0005\u0002\u0010!5\t!A\u0002\u0004\u0012\u0005!\u0005\u0001B\u0005\u0002\u0006'\u0016\u0014H)Z\n\u0004!MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u00155%\u00111$\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006;A!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\ta\u0002C\u0004\"!\t\u0007I\u0011\u0001\u0012\u0002\u001fAK6\u000bU!S\u0017~\u0003\u0016iQ&B\u000f\u0016+\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019\u0019FO]5oO\"1A\u0006\u0005Q\u0001\n\r\n\u0001\u0003U-T!\u0006\u00136j\u0018)B\u0007.\u000bu)\u0012\u0011\t\u000f9\u0002\"\u0019!C\u0001E\u00051A*\u0011+J\u001dFBa\u0001\r\t!\u0002\u0013\u0019\u0013a\u0002'B)&s\u0015\u0007\t\u0004\u0007eA\t\tAA\u001a\u0003\u0017\t\u000b7/\u001a)jG.dWM]\u000b\u0003i=\u001bB!M\u001b9\u0005B\u0011AEN\u0005\u0003o\u0015\u0012aa\u00142kK\u000e$\bCA\u001dA\u001b\u0005Q$BA\u001e=\u0003\u0019\u0001\u0018nY6mK*\u0011QHP\u0001\ne\u0006TxN\u001d<j]\u0016T\u0011aP\u0001\u0004]\u0016$\u0018BA!;\u00059IuJ\u00196fGR\u0004\u0016nY6mKJ\u0004\"!O\"\n\u0005\u0011S$AE%PE*,7\r^\"p]N$(/^2u_JD\u0001BR\u0019\u0003\u0004\u0003\u0006YaR\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u0001%L\u001b6\t\u0011J\u0003\u0002K+\u00059!/\u001a4mK\u000e$\u0018B\u0001'J\u0005!\u0019E.Y:t)\u0006<\u0007C\u0001(P\u0019\u0001!Q\u0001U\u0019C\u0002E\u0013\u0011\u0001V\t\u0003%V\u0003\"\u0001F*\n\u0005Q+\"a\u0002(pi\"Lgn\u001a\t\u0003)YK!aV\u000b\u0003\u0007\u0005s\u0017\u0010C\u0003\u001ec\u0011\u0005\u0011\fF\u0001[)\tYV\fE\u0002]c5k\u0011\u0001\u0005\u0005\u0006\rb\u0003\u001da\u0012\u0005\b?F\u0012\r\u0011\"\u0003a\u0003\r\u0019Gn]\u000b\u0002CB\u0012!M\u001a\t\u0004I\r,\u0017B\u00013&\u0005\u0015\u0019E.Y:t!\tqe\rB\u0005hQ\u0006\u0005\t\u0011!B\u0001#\n\u0019q\fJ\u0019\t\r%\f\u0004\u0015!\u0003b\u0003\u0011\u0019Gn\u001d\u0011\t\u000f-\f$\u0019!C\u0005E\u00051Qn\u001c3vY\u0016Da!\\\u0019!\u0002\u0013\u0019\u0013aB7pIVdW\r\t\u0005\b_F\u0012\r\u0011\"\u0003#\u0003\u0011q\u0017-\\3\t\rE\f\u0004\u0015!\u0003$\u0003\u0015q\u0017-\\3!\u0011\u0015\u0019\u0018\u0007\"\u0001u\u0003!\u0011XmZ5ti\u0016\u0014H#A;\u0011\u0005Q1\u0018BA<\u0016\u0005\u0011)f.\u001b;\t\u000bm\nD\u0011A=\u0015\u000bUTH0!\u0003\t\u000bmD\b\u0019A\u001b\u0002\u0007=\u0014'\u000eC\u0003~q\u0002\u0007a0A\u0002pkR\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u001d\n!![8\n\t\u0005\u001d\u0011\u0011\u0001\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003\u0017A\b\u0019AA\u0007\u0003\u001d\u0001\u0018nY6mKJ\u00042!OA\b\u0013\r\t\tB\u000f\u0002\b!&\u001c7\u000e\\3s\u0011!\t)\"\rC\u0001\u0005\u0005]\u0011aC:bm\u0016|%M[3diN$r!^A\r\u00037\ti\u0002\u0003\u0004~\u0003'\u0001\rA \u0005\t\u0003\u0017\t\u0019\u00021\u0001\u0002\u000e!A\u0011qDA\n\u0001\u0004\t\t#A\u0004pE*,7\r^:\u0011\tQ\t\u0019#V\u0005\u0004\u0003K)\"A\u0003\u001fsKB,\u0017\r^3e}!A\u0011\u0011F\u0019\u0007\u0002\t\tY#A\u0005tCZ,7\u000b^1uKR9Q/!\f\u00020\u0005E\u0002BB>\u0002(\u0001\u0007Q\u0007\u0003\u0004~\u0003O\u0001\rA \u0005\t\u0003\u0017\t9\u00031\u0001\u0002\u000e\u00199\u0011Q\u0007\t\u0001\u0005\u0005]\"A\u0005#f]N,g+Z2u_J\u0004\u0016nY6mKJ\u001cB!a\r\u0002:A!A,MA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!\r\u00051A.\u001b8bY\u001eLA!!\u0012\u0002@\tYA)\u001a8tKZ+7\r^8s\u0011\u001di\u00121\u0007C\u0001\u0003\u0013\"\"!a\u0013\u0011\u0007q\u000b\u0019\u0004\u0003\u0005\u0002*\u0005MB\u0011AA()\u001d)\u0018\u0011KA*\u0003+Baa_A'\u0001\u0004)\u0004BB?\u0002N\u0001\u0007a\u0010\u0003\u0005\u0002\f\u00055\u0003\u0019AA\u0007\u0011!\tI&a\r\u0005\u0002\u0005m\u0013!C2p]N$(/^2u)\r)\u0014Q\f\u0005\t\u0003?\n9\u00061\u0001\u0002b\u0005!\u0011M]4t!\u0011!\u00121M\u001b\n\u0007\u0005\u0015TCA\u0003BeJ\f\u0017PB\u0004\u0002jA\u0001!!a\u001b\u0003%\u0011+gn]3NCR\u0014\u0018\u000e\u001f)jG.dWM]\n\u0005\u0003O\ni\u0007\u0005\u0003]c\u0005=\u0004\u0003BA\u001f\u0003cJA!a\u001d\u0002@\tYA)\u001a8tK6\u000bGO]5y\u0011\u001di\u0012q\rC\u0001\u0003o\"\"!!\u001f\u0011\u0007q\u000b9\u0007\u0003\u0005\u0002*\u0005\u001dD\u0011AA?)\u001d)\u0018qPAA\u0003\u0007Caa_A>\u0001\u0004)\u0004BB?\u0002|\u0001\u0007a\u0010\u0003\u0005\u0002\f\u0005m\u0004\u0019AA\u0007\u0011!\tI&a\u001a\u0005\u0002\u0005\u001dEcA\u001b\u0002\n\"A\u0011qLAC\u0001\u0004\t\tGB\u0004\u0002\u000eB\u0001!!a$\u0003'M\u0003\u0018M]:f-\u0016\u001cGo\u001c:QS\u000e\\G.\u001a:\u0014\t\u0005-\u0015\u0011\u0013\t\u00059F\n\u0019\n\u0005\u0003\u0002>\u0005U\u0015\u0002BAL\u0003\u007f\u0011Ab\u00159beN,g+Z2u_JDq!HAF\t\u0003\tY\n\u0006\u0002\u0002\u001eB\u0019A,a#\t\u0011\u0005%\u00121\u0012C\u0001\u0003C#r!^AR\u0003K\u000b9\u000b\u0003\u0004|\u0003?\u0003\r!\u000e\u0005\u0007{\u0006}\u0005\u0019\u0001@\t\u0011\u0005-\u0011q\u0014a\u0001\u0003\u001bA\u0001\"!\u0017\u0002\f\u0012\u0005\u00111\u0016\u000b\u0004k\u00055\u0006\u0002CA0\u0003S\u0003\r!!\u0019\u0007\u000f\u0005E\u0006\u0003\u0001\u0002\u00024\n\u0019B*\u00192fY\u0016$\u0007k\\5oiBK7m\u001b7feN!\u0011qVA[!\u0011a\u0016'a.\u0011\t\u0005e\u0016qX\u0007\u0003\u0003wS1!!0\u0007\u0003)\u0011Xm\u001a:fgNLwN\\\u0005\u0005\u0003\u0003\fYL\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fC\u0004\u001e\u0003_#\t!!2\u0015\u0005\u0005\u001d\u0007c\u0001/\u00020\"A\u0011\u0011FAX\t\u0003\tY\rF\u0004v\u0003\u001b\fy-!5\t\rm\fI\r1\u00016\u0011\u0019i\u0018\u0011\u001aa\u0001}\"A\u00111BAe\u0001\u0004\ti\u0001\u0003\u0005\u0002Z\u0005=F\u0011AAk)\r)\u0014q\u001b\u0005\t\u0003?\n\u0019\u000e1\u0001\u0002b\u00199\u00111\u001c\t\u0001\u0005\u0005u'!\u0004*bi&tw\rU5dW2,'o\u0005\u0003\u0002Z\u0006}\u0007\u0003\u0002/2\u0003C\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003O4\u0011A\u0004:fG>lW.\u001a8eCRLwN\\\u0005\u0005\u0003W\f)O\u0001\u0004SCRLgn\u001a\u0005\b;\u0005eG\u0011AAx)\t\t\t\u0010E\u0002]\u00033D\u0001\"!\u000b\u0002Z\u0012\u0005\u0011Q\u001f\u000b\bk\u0006]\u0018\u0011`A~\u0011\u0019Y\u00181\u001fa\u0001k!1Q0a=A\u0002yD\u0001\"a\u0003\u0002t\u0002\u0007\u0011Q\u0002\u0005\t\u00033\nI\u000e\"\u0001\u0002\u0000R\u0019QG!\u0001\t\u0011\u0005}\u0013Q a\u0001\u0003CB\u0011B!\u0002\u0011\u0001\u0004%\tAa\u0002\u0002\u0017%t\u0017\u000e^5bY&TX\rZ\u000b\u0003\u0005\u0013\u00012\u0001\u0006B\u0006\u0013\r\u0011i!\u0006\u0002\b\u0005>|G.Z1o\u0011%\u0011\t\u0002\u0005a\u0001\n\u0003\u0011\u0019\"A\bj]&$\u0018.\u00197ju\u0016$w\fJ3r)\r)(Q\u0003\u0005\u000b\u0005/\u0011y!!AA\u0002\t%\u0011a\u0001=%c!A!1\u0004\t!B\u0013\u0011I!\u0001\u0007j]&$\u0018.\u00197ju\u0016$\u0007\u0005\u0003\u0004\u0003 A!\t\u0001^\u0001\u000bS:LG/[1mSj,\u0007b\u0002B\u0012!\u0011\u0005!QE\u0001\u0006IVl\u0007o\u001d\u000b\u0005\u0005O\u0011y\u0003E\u0003\u0015\u0003G\u0012I\u0003E\u0002\u0015\u0005WI1A!\f\u0016\u0005\u0011\u0011\u0015\u0010^3\t\rm\u0014\t\u00031\u0001\u0014\u0011\u001d\u0011\u0019\u0004\u0005C\u0001\u0005k\tQ\u0001\\8bIN$2a\u0005B\u001c\u0011!\u0011ID!\rA\u0002\t\u001d\u0012!\u00022zi\u0016\u001c\bb\u0002B\u001f!\u0011\u0005!qH\u0001\u000bCN$V\u000f\u001d7f%\u0012#E\u0003\u0002B!\u00053\u0002bAa\u0011\u0003J\t5SB\u0001B#\u0015\r\u00119\u0005C\u0001\u0004e\u0012$\u0017\u0002\u0002B&\u0005\u000b\u00121A\u0015#E!\u001d!\"q\nB*\u0005'J1A!\u0015\u0016\u0005\u0019!V\u000f\u001d7feA\u0019AC!\u0016\n\u0007\t]SCA\u0002J]RD\u0001Ba\u0012\u0003<\u0001\u0007!1\f\t\u0007\u0005\u0007\u0012IE!\u0018\u0011\tQ\t\u0019'\u0016\u0005\b\u0005C\u0002B\u0011\u0001B2\u000351'o\\7UkBdWM\r*E\tR!!1\fB3\u0011!\u00119Ea\u0018A\u0002\t\u001d\u0004C\u0002B\"\u0005\u0013\u0012I\u0007E\u0003\u0015\u0005\u001f*V\u000bC\u0004\u0003nA!\tAa\u001c\u0002\u0019)\fg/\u0019+p!f$\bn\u001c8\u0015\t\tE$Q\u0010\t\u0007\u0005g\u0012IHa\n\u000e\u0005\tU$b\u0001\u0015\u0003x)\u0011Q\u0001C\u0005\u0005\u0005w\u0012)HA\u0004KCZ\f'\u000b\u0012#\t\u0011\t}$1\u000ea\u0001\u0005\u0003\u000bAA\u001b*E\tB)!1\u000fB=+\"9!Q\u0011\t\u0005\u0002\t\u001d\u0015\u0001\u00049zi\"|g\u000eV8KCZ\fGC\u0002BA\u0005\u0013\u0013i\t\u0003\u0005\u0003\f\n\r\u0005\u0019\u0001B9\u0003\u0015\u0001\u0018P\u0015#E\u0011!\u0011yIa!A\u0002\t%\u0011a\u00022bi\u000eDW\r\u001a\u0005\n\u0005'\u0003\u0012\u0011!C\u0005\u0005+\u000b1B]3bIJ+7o\u001c7wKR\tQ\u0007")
public final class SerDe {
    public static JavaRDD<Object> pythonToJava(JavaRDD<byte[]> javaRDD, boolean bl) {
        return SerDe$.MODULE$.pythonToJava(javaRDD, bl);
    }

    public static JavaRDD<byte[]> javaToPython(JavaRDD<Object> javaRDD) {
        return SerDe$.MODULE$.javaToPython(javaRDD);
    }

    public static RDD<Object[]> fromTuple2RDD(RDD<Tuple2<Object, Object>> rDD) {
        return SerDe$.MODULE$.fromTuple2RDD(rDD);
    }

    public static RDD<Tuple2<Object, Object>> asTupleRDD(RDD<Object[]> rDD) {
        return SerDe$.MODULE$.asTupleRDD(rDD);
    }

    public static Object loads(byte[] byArray) {
        return SerDe$.MODULE$.loads(byArray);
    }

    public static byte[] dumps(Object object) {
        return SerDe$.MODULE$.dumps(object);
    }

    public static void initialize() {
        SerDe$.MODULE$.initialize();
    }

    public static void initialized_$eq(boolean bl) {
        SerDe$.MODULE$.initialized_$eq(bl);
    }

    public static boolean initialized() {
        return SerDe$.MODULE$.initialized();
    }

    public static String LATIN1() {
        return SerDe$.MODULE$.LATIN1();
    }

    public static String PYSPARK_PACKAGE() {
        return SerDe$.MODULE$.PYSPARK_PACKAGE();
    }

    public static abstract class BasePickler<T>
    implements IObjectPickler,
    IObjectConstructor {
        private final Class<?> cls;
        private final String module;
        private final String name;

        private Class<?> cls() {
            return this.cls;
        }

        private String module() {
            return this.module;
        }

        private String name() {
            return this.name;
        }

        public void register() {
            Pickler.registerCustomPickler(this.getClass(), (IObjectPickler)this);
            Pickler.registerCustomPickler(this.cls(), (IObjectPickler)this);
            Unpickler.registerConstructor((String)this.module(), (String)this.name(), (IObjectConstructor)this);
        }

        public void pickle(Object obj, OutputStream out, Pickler pickler) {
            Object object = obj;
            BasePickler basePickler = this;
            if (!(object != null ? !object.equals(basePickler) : basePickler != null)) {
                out.write(99);
                out.write(new StringBuilder().append((Object)this.module()).append((Object)"\n").append((Object)this.name()).append((Object)"\n").toString().getBytes());
            } else {
                pickler.save((Object)this);
                this.saveState(obj, out, pickler);
                out.write(82);
            }
        }

        public void saveObjects(OutputStream out, Pickler pickler, Seq<Object> objects) {
            int n;
            if (objects.length() == 0 || objects.length() > 3) {
                out.write(40);
            }
            objects.foreach((Function1)new Serializable(this, pickler){
                public static final long serialVersionUID = 0L;
                private final Pickler pickler$1;

                public final void apply(Object x$1) {
                    this.pickler$1.save(x$1);
                }
                {
                    this.pickler$1 = pickler$1;
                }
            });
            int n2 = objects.length();
            switch (n2) {
                default: {
                    n = 116;
                    break;
                }
                case 3: {
                    n = 135;
                    break;
                }
                case 2: {
                    n = 134;
                    break;
                }
                case 1: {
                    n = 133;
                }
            }
            int code = n;
            out.write(code);
        }

        public abstract void saveState(Object var1, OutputStream var2, Pickler var3);

        public BasePickler(ClassTag<T> evidence$1) {
            this.cls = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
            this.module = new StringBuilder().append((Object)SerDe$.MODULE$.PYSPARK_PACKAGE()).append((Object)".").append((Object)new StringOps(Predef$.MODULE$.augmentString(this.cls().getName())).split('.')[4]).toString();
            this.name = this.cls().getSimpleName();
        }
    }

    public static class RatingPickler
    extends BasePickler<Rating> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            Rating rating = (Rating)obj;
            this.saveObjects(out, pickler, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rating.user()), BoxesRunTime.boxToInteger((int)rating.product()), BoxesRunTime.boxToDouble((double)rating.rating())}));
        }

        public Object construct(Object[] args) {
            if (args.length != 3) {
                throw new PickleException("should be 3");
            }
            return new Rating(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), BoxesRunTime.unboxToDouble((Object)args[2]));
        }

        public RatingPickler() {
            super(ClassTag$.MODULE$.apply(Rating.class));
        }
    }

    public static class DenseVectorPickler
    extends BasePickler<DenseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseVector vector = (DenseVector)obj;
            byte[] bytes = new byte[8 * vector.size()];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            db.put(vector.values());
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(133);
        }

        public Object construct(Object[] args) {
            Predef$.MODULE$.require(args.length == 1);
            if (args.length != 1) {
                throw new PickleException("should be 1");
            }
            byte[] bytes = ((String)args[0]).getBytes(SerDe$.MODULE$.LATIN1());
            ByteBuffer bb = ByteBuffer.wrap(bytes, 0, bytes.length);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            double[] ans = new double[bytes.length / 8];
            db.get(ans);
            return Vectors$.MODULE$.dense(ans);
        }

        public DenseVectorPickler() {
            super(ClassTag$.MODULE$.apply(DenseVector.class));
        }
    }

    public static class DenseMatrixPickler
    extends BasePickler<DenseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseMatrix m = (DenseMatrix)obj;
            byte[] bytes = new byte[8 * Predef$.MODULE$.doubleArrayOps(m.values()).size()];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().put(m.values());
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(135);
        }

        public Object construct(Object[] args) {
            if (args.length != 3) {
                throw new PickleException("should be 3");
            }
            byte[] bytes = ((String)args[2]).getBytes(SerDe$.MODULE$.LATIN1());
            int n = bytes.length / 8;
            double[] values = new double[n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().get(values);
            return new DenseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), values);
        }

        public DenseMatrixPickler() {
            super(ClassTag$.MODULE$.apply(DenseMatrix.class));
        }
    }

    public static class SparseVectorPickler
    extends BasePickler<SparseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseVector v = (SparseVector)obj;
            int n = Predef$.MODULE$.intArrayOps(v.indices()).size();
            byte[] indiceBytes = new byte[4 * n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().put(v.indices());
            byte[] valueBytes = new byte[8 * n];
            ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().put(v.values());
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)v.size()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indiceBytes.length));
            out.write(indiceBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valueBytes.length));
            out.write(valueBytes);
            out.write(135);
        }

        public Object construct(Object[] args) {
            Object object;
            if (args.length != 3) {
                throw new PickleException("should be 3");
            }
            int size = BoxesRunTime.unboxToInt((Object)args[0]);
            byte[] indiceBytes = ((String)args[1]).getBytes(SerDe$.MODULE$.LATIN1());
            byte[] valueBytes = ((String)args[2]).getBytes(SerDe$.MODULE$.LATIN1());
            int n = indiceBytes.length / 4;
            int[] indices = new int[n];
            double[] values = new double[n];
            if (n > 0) {
                ByteOrder order = ByteOrder.nativeOrder();
                ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().get(indices);
                object = ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().get(values);
            } else {
                object = BoxedUnit.UNIT;
            }
            return new SparseVector(size, indices, values);
        }

        public SparseVectorPickler() {
            super(ClassTag$.MODULE$.apply(SparseVector.class));
        }
    }

    public static class LabeledPointPickler
    extends BasePickler<LabeledPoint> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            LabeledPoint point = (LabeledPoint)obj;
            this.saveObjects(out, pickler, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)point.label()), point.features()}));
        }

        public Object construct(Object[] args) {
            if (args.length != 2) {
                throw new PickleException("should be 2");
            }
            return new LabeledPoint(BoxesRunTime.unboxToDouble((Object)args[0]), (Vector)args[1]);
        }

        public LabeledPointPickler() {
            super(ClassTag$.MODULE$.apply(LabeledPoint.class));
        }
    }
}

