/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.Accumulable;
import org.apache.spark.Accumulator;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeans$$anonfun$11$;
import org.apache.spark.mllib.clustering.KMeans$$anonfun$17$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u00015\u0011aaS'fC:\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001$G\u0007\u0002\r%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!a\u0001\n\u0013i\u0012!A6\u0016\u0003y\u0001\"aD\u0010\n\u0005\u0001\u0002\"aA%oi\"A!\u0005\u0001BA\u0002\u0013%1%A\u0003l?\u0012*\u0017\u000f\u0006\u0002%OA\u0011q\"J\u0005\u0003MA\u0011A!\u00168ji\"9\u0001&IA\u0001\u0002\u0004q\u0012a\u0001=%c!A!\u0006\u0001B\u0001B\u0003&a$\u0001\u0002lA!AA\u0006\u0001BA\u0002\u0013%Q$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\t]\u0001\u0011\t\u0019!C\u0005_\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0011\u0002\u0004b\u0002\u0015.\u0003\u0003\u0005\rA\b\u0005\te\u0001\u0011\t\u0011)Q\u0005=\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0007I\u0011B\u000f\u0002\tI,hn\u001d\u0005\tm\u0001\u0011\t\u0019!C\u0005o\u0005A!/\u001e8t?\u0012*\u0017\u000f\u0006\u0002%q!9\u0001&NA\u0001\u0002\u0004q\u0002\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0010\u0002\u000bI,hn\u001d\u0011\t\u0011q\u0002!\u00111A\u0005\nu\n!#\u001b8ji&\fG.\u001b>bi&|g.T8eKV\ta\b\u0005\u0002@\u0005:\u0011q\u0002Q\u0005\u0003\u0003B\ta\u0001\u0015:fI\u00164\u0017BA\"E\u0005\u0019\u0019FO]5oO*\u0011\u0011\t\u0005\u0005\t\r\u0002\u0011\t\u0019!C\u0005\u000f\u00061\u0012N\\5uS\u0006d\u0017N_1uS>tWj\u001c3f?\u0012*\u0017\u000f\u0006\u0002%\u0011\"9\u0001&RA\u0001\u0002\u0004q\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0015\u0002 \u0002'%t\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u0011\t\u00111\u0003!\u00111A\u0005\nu\t1#\u001b8ji&\fG.\u001b>bi&|gn\u0015;faND\u0001B\u0014\u0001\u0003\u0002\u0004%IaT\u0001\u0018S:LG/[1mSj\fG/[8o'R,\u0007o]0%KF$\"\u0001\n)\t\u000f!j\u0015\u0011!a\u0001=!A!\u000b\u0001B\u0001B\u0003&a$\u0001\u000bj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000f\t\u0005\t)\u0002\u0011\t\u0019!C\u0005+\u00069Q\r]:jY>tW#\u0001,\u0011\u0005=9\u0016B\u0001-\u0011\u0005\u0019!u.\u001e2mK\"A!\f\u0001BA\u0002\u0013%1,A\u0006faNLGn\u001c8`I\u0015\fHC\u0001\u0013]\u0011\u001dA\u0013,!AA\u0002YC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006KAV\u0001\tKB\u001c\u0018\u000e\\8oA!)\u0001\r\u0001C\u0005C\u00061A(\u001b8jiz\"rA\u00193fM\u001eD\u0017\u000e\u0005\u0002d\u00015\t!\u0001C\u0003\u001d?\u0002\u0007a\u0004C\u0003-?\u0002\u0007a\u0004C\u00035?\u0002\u0007a\u0004C\u0003=?\u0002\u0007a\bC\u0003M?\u0002\u0007a\u0004C\u0003U?\u0002\u0007a\u000bC\u0003a\u0001\u0011\u00051\u000eF\u0001c\u0011\u0015i\u0007\u0001\"\u0001o\u0003\u0011\u0019X\r^&\u0015\u0005=\u0004X\"\u0001\u0001\t\u000bqa\u0007\u0019\u0001\u0010\t\u000bI\u0004A\u0011A:\u0002!M,G/T1y\u0013R,'/\u0019;j_:\u001cHCA8u\u0011\u0015a\u0013\u000f1\u0001\u001f\u0011\u00151\b\u0001\"\u0001x\u0003U\u0019X\r^%oSRL\u0017\r\\5{CRLwN\\'pI\u0016$\"a\u001c=\t\u000bq*\b\u0019\u0001 \t\u000bi\u0004A\u0011A>\u0002\u000fM,GOU;ogR\u0011q\u000e \u0005\u0006ie\u0004\rA\b\u0015\u0003sz\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9!!\u0001\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u000512/\u001a;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000fF\u0002p\u0003\u001fAa\u0001TA\u0005\u0001\u0004q\u0002bBA\n\u0001\u0011\u0005\u0011QC\u0001\u000bg\u0016$X\t]:jY>tGcA8\u0002\u0018!1A+!\u0005A\u0002YCq!a\u0007\u0001\t\u0003\ti\"A\u0002sk:$B!a\b\u0002&A\u00191-!\t\n\u0007\u0005\r\"AA\u0006L\u001b\u0016\fgn]'pI\u0016d\u0007\u0002CA\u0014\u00033\u0001\r!!\u000b\u0002\t\u0011\fG/\u0019\t\u0007\u0003W\t\t$!\u000e\u000e\u0005\u00055\"bAA\u0018\r\u0005\u0019!\u000f\u001a3\n\t\u0005M\u0012Q\u0006\u0002\u0004%\u0012#\u0005\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mB!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003\u007f\tID\u0001\u0004WK\u000e$xN\u001d\u0005\b\u0003\u0007\u0002A\u0011BA#\u00031\u0011XO\\!mO>\u0014\u0018\u000e\u001e5n)\u0011\ty\"a\u0012\t\u0011\u0005\u001d\u0012\u0011\ta\u0001\u0003\u0013\u0002b!a\u000b\u00022\u0005-\u0003cA2\u0002N%\u0019\u0011q\n\u0002\u0003\u001dY+7\r^8s/&$\bNT8s[\"9\u00111\u000b\u0001\u0005\n\u0005U\u0013AC5oSR\u0014\u0016M\u001c3p[R!\u0011qKA0!\u0015y\u0011\u0011LA/\u0013\r\tY\u0006\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0006\u001f\u0005e\u00131\n\u0005\t\u0003O\t\t\u00061\u0001\u0002J!9\u00111\r\u0001\u0005\n\u0005\u0015\u0014AE5oSR\\U*Z1ogB\u000b'/\u00197mK2$B!a\u0016\u0002h!A\u0011qEA1\u0001\u0004\tIeB\u0004\u0002l\tA\t!!\u001c\u0002\r-kU-\u00198t!\r\u0019\u0017q\u000e\u0004\u0007\u0003\tA\t!!\u001d\u0014\t\u0005=d\u0002\u0006\u0005\bA\u0006=D\u0011AA;)\t\ti\u0007\u0003\u0006\u0002z\u0005=$\u0019!C\u0001\u0003w\naAU!O\t>kUCAA?!\u0011\ty(!#\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000bA\u0001\\1oO*\u0011\u0011qQ\u0001\u0005U\u00064\u0018-C\u0002D\u0003\u0003C\u0011\"!$\u0002p\u0001\u0006I!! \u0002\u000fI\u000be\nR(NA!Q\u0011\u0011SA8\u0005\u0004%\t!a\u001f\u0002!-{V*R!O'~\u0003\u0016IU!M\u0019\u0016c\u0005\"CAK\u0003_\u0002\u000b\u0011BA?\u0003EYu,T#B\u001dN{\u0006+\u0011*B\u00192+E\n\t\u0005\t\u00033\u000by\u0007\"\u0001\u0002\u001c\u0006)AO]1j]Ra\u0011qDAO\u0003?\u000b\t+a)\u0002&\"A\u0011qEAL\u0001\u0004\tI\u0003\u0003\u0004\u001d\u0003/\u0003\rA\b\u0005\u0007Y\u0005]\u0005\u0019\u0001\u0010\t\rQ\n9\n1\u0001\u001f\u0011\u0019a\u0014q\u0013a\u0001}!A\u0011\u0011TA8\t\u0003\tI\u000b\u0006\u0005\u0002 \u0005-\u0016QVAX\u0011!\t9#a*A\u0002\u0005%\u0002B\u0002\u000f\u0002(\u0002\u0007a\u0004\u0003\u0004-\u0003O\u0003\rA\b\u0005\t\u00033\u000by\u0007\"\u0001\u00024RQ\u0011qDA[\u0003o\u000bI,a/\t\u0011\u0005\u001d\u0012\u0011\u0017a\u0001\u0003SAa\u0001HAY\u0001\u0004q\u0002B\u0002\u0017\u00022\u0002\u0007a\u0004\u0003\u00045\u0003c\u0003\rA\b\u0005\n\u0003\u007f\u000by\u0007\"\u0001\u0005\u0003\u0003\f1BZ5oI\u000ecwn]3tiR1\u00111YAe\u0003K\u0004RaDAc=YK1!a2\u0011\u0005\u0019!V\u000f\u001d7fe!A\u00111ZA_\u0001\u0004\ti-A\u0004dK:$XM]:\u0011\r\u0005=\u0017q\\A&\u001d\u0011\t\t.a7\u000f\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6\r\u0003\u0019a$o\\8u}%\t\u0011#C\u0002\u0002^B\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002b\u0006\r(a\u0004+sCZ,'o]1cY\u0016|enY3\u000b\u0007\u0005u\u0007\u0003\u0003\u0005\u0002h\u0006u\u0006\u0019AA&\u0003\u0015\u0001x.\u001b8u\u0011%\tY/a\u001c\u0005\u0002\u0011\ti/A\u0005q_&tGoQ8tiR)a+a<\u0002r\"A\u00111ZAu\u0001\u0004\ti\r\u0003\u0005\u0002h\u0006%\b\u0019AA&\u0011%\t)0a\u001c\u0005\u0002\t\t90A\ngCN$8+];be\u0016$G)[:uC:\u001cW\rF\u0003W\u0003s\fi\u0010\u0003\u0005\u0002|\u0006M\b\u0019AA&\u0003\t1\u0018\u0007\u0003\u0005\u0002\u0000\u0006M\b\u0019AA&\u0003\t1(\u0007\u0003\u0006\u0003\u0004\u0005=\u0014\u0011!C\u0005\u0005\u000b\t1B]3bIJ+7o\u001c7wKR\u0011!q\u0001\t\u0005\u0003\u007f\u0012I!\u0003\u0003\u0003\f\u0005\u0005%AB(cU\u0016\u001cG\u000f")
public class KMeans
implements Serializable,
Logging {
    private int org$apache$spark$mllib$clustering$KMeans$$k;
    private int org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    private int org$apache$spark$mllib$clustering$KMeans$$runs;
    private String org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    private int initializationSteps;
    private double org$apache$spark$mllib$clustering$KMeans$$epsilon;
    private transient Logger org$apache$spark$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int org$apache$spark$mllib$clustering$KMeans$$k() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$maxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$runs() {
        return this.org$apache$spark$mllib$clustering$KMeans$$runs;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$runs_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$runs = x$1;
    }

    public String org$apache$spark$mllib$clustering$KMeans$$initializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(String x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    public double org$apache$spark$mllib$clustering$KMeans$$epsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(double x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = x$1;
    }

    public KMeans setK(int k) {
        this.org$apache$spark$mllib$clustering$KMeans$$k_$eq(k);
        return this;
    }

    public KMeans setMaxIterations(int maxIterations) {
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(maxIterations);
        return this;
    }

    public KMeans setInitializationMode(String initializationMode) {
        block3: {
            block2: {
                String string = initializationMode;
                String string2 = KMeans$.MODULE$.RANDOM();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = initializationMode;
                String string4 = KMeans$.MODULE$.K_MEANS_PARALLEL();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            this.org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(initializationMode);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid initialization mode: ").append((Object)initializationMode).toString());
    }

    @Experimental
    public KMeans setRuns(int runs) {
        if (runs <= 0) {
            throw new IllegalArgumentException("Number of runs must be positive");
        }
        this.org$apache$spark$mllib$clustering$KMeans$$runs_$eq(runs);
        return this;
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        if (initializationSteps <= 0) {
            throw new IllegalArgumentException("Number of initialization steps must be positive");
        }
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public KMeans setEpsilon(double epsilon) {
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(epsilon);
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        RDD norms = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Vector x$1) {
                return Vectors$.MODULE$.norm(x$1, 2.0);
            }
        }, ClassTag$.MODULE$.Double());
        norms.persist();
        RDD zippedData = data.zip(norms, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector v = (Vector)tuple2._1();
                    double norm = tuple2._2$mcD$sp();
                    VectorWithNorm vectorWithNorm = new VectorWithNorm(v, norm);
                    return vectorWithNorm;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        KMeansModel model = this.runAlgorithm((RDD<VectorWithNorm>)zippedData);
        norms.unpersist(norms.unpersist$default$1());
        StorageLevel storageLevel3 = data.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        return model;
    }

    private KMeansModel runAlgorithm(RDD<VectorWithNorm> data) {
        SparkContext sc = data.sparkContext();
        long initStartTime = System.nanoTime();
        String string = this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
        String string2 = KMeans$.MODULE$.RANDOM();
        VectorWithNorm[][] centers = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data);
        double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
        this.logInfo((Function0<String>)new Serializable(this, initTimeInSeconds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final double initTimeInSeconds$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialization with ", " took "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$clustering$KMeans$$initializationMode()}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("%.3f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.initTimeInSeconds$1)}))).append((Object)" seconds.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.initTimeInSeconds$1 = initTimeInSeconds$1;
            }
        });
        boolean[] active = (boolean[])Array$.MODULE$.fill(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }, ClassTag$.MODULE$.Boolean());
        double[] costs = (double[])Array$.MODULE$.fill(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        ArrayBuffer activeRuns = (ArrayBuffer)new ArrayBuffer().$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.org$apache$spark$mllib$clustering$KMeans$$runs()));
        IntRef iteration = new IntRef(0);
        long iterationStartTime = System.nanoTime();
        while (iteration.elem < this.org$apache$spark$mllib$clustering$KMeans$$maxIterations() && !activeRuns.isEmpty()) {
            VectorWithNorm[][] activeCenters = (VectorWithNorm[][])((TraversableOnce)activeRuns.map((Function1)new Serializable(this, centers){
                public static final long serialVersionUID = 0L;
                private final VectorWithNorm[][] centers$1;

                public final VectorWithNorm[] apply(int r) {
                    return this.centers$1[r];
                }
                {
                    this.centers$1 = centers$1;
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            ArrayBuffer costAccums = (ArrayBuffer)activeRuns.map((Function1)new Serializable(this, sc){
                public static final long serialVersionUID = 0L;
                private final SparkContext sc$1;

                public final Accumulator<Object> apply(int x$2) {
                    return this.sc$1.accumulator((Object)BoxesRunTime.boxToDouble((double)0.0), (AccumulatorParam)SparkContext.DoubleAccumulatorParam$.MODULE$);
                }
                {
                    this.sc$1 = sc$1;
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom());
            Broadcast bcActiveCenters = sc.broadcast((Object)activeCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class))));
            Map totalContribs = SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1)new Serializable(this, costAccums, bcActiveCenters){
                public static final long serialVersionUID = 0L;
                public final ArrayBuffer costAccums$1;
                private final Broadcast bcActiveCenters$1;

                public final Iterator<Tuple2<Tuple2<Object, Object>, Tuple2<Vector, Object>>> apply(Iterator<VectorWithNorm> points) {
                    VectorWithNorm[][] thisActiveCenters = (VectorWithNorm[][])this.bcActiveCenters$1.value();
                    int runs = thisActiveCenters.length;
                    int k = thisActiveCenters[0].length;
                    int dims = thisActiveCenters[0][0].vector().size();
                    Vector[][] sums = (Vector[][])Array$.MODULE$.fill(runs, k, (Function0)new Serializable(this, dims){
                        public static final long serialVersionUID = 0L;
                        private final int dims$1;

                        public final Vector apply() {
                            return Vectors$.MODULE$.zeros(this.dims$1);
                        }
                        {
                            this.dims$1 = dims$1;
                        }
                    }, ClassTag$.MODULE$.apply(Vector.class));
                    long[][] counts = (long[][])Array$.MODULE$.fill(runs, k, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }, ClassTag$.MODULE$.Long());
                    points.foreach((Function1)new Serializable(this, thisActiveCenters, runs, sums, counts){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$11 $outer;
                        public final VectorWithNorm[][] thisActiveCenters$1;
                        private final int runs$1;
                        public final Vector[][] sums$1;
                        public final long[][] counts$1;

                        public final void apply(VectorWithNorm point) {
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.runs$1).foreach$mVc$sp((Function1)new Serializable(this, point){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$11$$anonfun$apply$3 $outer;
                                private final VectorWithNorm point$1;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    Tuple2<Object, Object> tuple2 = KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)Predef$.MODULE$.refArrayOps((Object[])this.$outer.thisActiveCenters$1[i]), this.point$1);
                                    if (tuple2 != null) {
                                        Tuple2.mcID.sp sp2;
                                        int bestCenter = tuple2._1$mcI$sp();
                                        double cost = tuple2._2$mcD$sp();
                                        Tuple2.mcID.sp sp3 = sp2 = new Tuple2.mcID.sp(bestCenter, cost);
                                        int bestCenter2 = sp3._1$mcI$sp();
                                        double cost2 = sp3._2$mcD$sp();
                                        ((Accumulable)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().costAccums$1.apply(i)).$plus$eq((Object)BoxesRunTime.boxToDouble((double)cost2));
                                        Vector sum = this.$outer.sums$1[i][bestCenter2];
                                        BLAS$.MODULE$.axpy(1.0, this.point$1.vector(), sum);
                                        long[] lArray = this.$outer.counts$1[i];
                                        lArray[bestCenter2] = lArray[bestCenter2] + 1L;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.point$1 = point$1;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$11 org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.thisActiveCenters$1 = thisActiveCenters$1;
                            this.runs$1 = runs$1;
                            this.sums$1 = sums$1;
                            this.counts$1 = counts$1;
                        }
                    });
                    IndexedSeq contribs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), runs).flatMap((Function1)new Serializable(this, k, sums, counts){
                        public static final long serialVersionUID = 0L;
                        private final int k$1;
                        public final Vector[][] sums$1;
                        public final long[][] counts$1;

                        public final IndexedSeq<Tuple2<Tuple2<Object, Object>, Tuple2<Vector, Object>>> apply(int i) {
                            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.k$1).map((Function1)new Serializable(this, i){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$11$$anonfun$13 $outer;
                                private final int i$1;

                                public final Tuple2<Tuple2<Object, Object>, Tuple2<Vector, Object>> apply(int j) {
                                    return new Tuple2((Object)new Tuple2.mcII.sp(this.i$1, j), (Object)new Tuple2((Object)this.$outer.sums$1[this.i$1][j], (Object)BoxesRunTime.boxToLong((long)this.$outer.counts$1[this.i$1][j])));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.i$1 = i$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                        }
                        {
                            this.k$1 = k$1;
                            this.sums$1 = sums$1;
                            this.counts$1 = counts$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return contribs.iterator();
                }
                {
                    this.costAccums$1 = costAccums$1;
                    this.bcActiveCenters$1 = bcActiveCenters$1;
                }
            }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;

                public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> x, Tuple2<Vector, Object> y) {
                    return this.$outer.org$apache$spark$mllib$clustering$KMeans$$mergeContribs$1(x, y);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).collectAsMap();
            ((TraversableLike)activeRuns.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, centers, active, costs, iteration, costAccums, totalContribs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final VectorWithNorm[][] centers$1;
                private final boolean[] active$1;
                private final double[] costs$1;
                public final IntRef iteration$1;
                private final ArrayBuffer costAccums$1;
                private final Map totalContribs$1;

                public final void apply(Tuple2<Object, Object> x$5) {
                    Tuple2<Object, Object> tuple2 = x$5;
                    if (tuple2 != null) {
                        int run2 = tuple2._1$mcI$sp();
                        int i = tuple2._2$mcI$sp();
                        boolean changed = false;
                        for (int j = 0; j < this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(); ++j) {
                            Tuple2 tuple22 = (Tuple2)this.totalContribs$1.apply((Object)new Tuple2.mcII.sp(i, j));
                            if (tuple22 != null) {
                                Tuple2 tuple23;
                                Vector sum = (Vector)tuple22._1();
                                long count = tuple22._2$mcJ$sp();
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)sum, (Object)BoxesRunTime.boxToLong((long)count));
                                Vector sum2 = (Vector)tuple24._1();
                                long count2 = tuple24._2$mcJ$sp();
                                if (count2 == 0L) continue;
                                BLAS$.MODULE$.scal(1.0 / (double)count2, sum2);
                                VectorWithNorm newCenter = new VectorWithNorm(sum2);
                                if (KMeans$.MODULE$.fastSquaredDistance(newCenter, this.centers$1[run2][j]) > this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon() * this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon()) {
                                    changed = true;
                                }
                                this.centers$1[run2][j] = newCenter;
                                continue;
                            }
                            throw new MatchError((Object)tuple22);
                        }
                        if (!changed) {
                            this.active$1[run2] = false;
                            this.$outer.logInfo((Function0<String>)new Serializable(this, run2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$runAlgorithm$4 $outer;
                                private final int run$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Run ").append((Object)BoxesRunTime.boxToInteger((int)this.run$1)).append((Object)" finished in ").append((Object)BoxesRunTime.boxToInteger((int)(this.$outer.iteration$1.elem + 1))).append((Object)" iterations").toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.run$1 = run$1;
                                }
                            });
                        }
                        this.costs$1[run2] = BoxesRunTime.unboxToDouble((Object)((Accumulable)this.costAccums$1.apply(i)).value());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.centers$1 = centers$1;
                    this.active$1 = active$1;
                    this.costs$1 = costs$1;
                    this.iteration$1 = iteration$1;
                    this.costAccums$1 = costAccums$1;
                    this.totalContribs$1 = totalContribs$1;
                }
            });
            activeRuns = (ArrayBuffer)activeRuns.filter((Function1)new Serializable(this, active){
                public static final long serialVersionUID = 0L;
                private final boolean[] active$1;

                public final boolean apply(int x$6) {
                    return this.apply$mcZI$sp(x$6);
                }

                public boolean apply$mcZI$sp(int x$6) {
                    return this.active$1[x$6];
                }
                {
                    this.active$1 = active$1;
                }
            });
            ++iteration.elem;
        }
        double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
        this.logInfo((Function0<String>)new Serializable(this, iterationTimeInSeconds){
            public static final long serialVersionUID = 0L;
            private final double iterationTimeInSeconds$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iterations took "})).s((Seq)Nil$.MODULE$)).append((Object)new StringOps(Predef$.MODULE$.augmentString("%.3f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.iterationTimeInSeconds$1)}))).append((Object)" seconds.").toString();
            }
            {
                this.iterationTimeInSeconds$1 = iterationTimeInSeconds$1;
            }
        });
        if (iteration.elem == this.org$apache$spark$mllib$clustering$KMeans$$maxIterations()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans reached the max number of iterations: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$clustering$KMeans$$maxIterations())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(this, iteration){
                public static final long serialVersionUID = 0L;
                private final IntRef iteration$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem)}));
                }
                {
                    this.iteration$1 = iteration$1;
                }
            });
        }
        Tuple2 tuple2 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(costs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).min(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        if (tuple2 != null) {
            Tuple2.mcDI.sp sp2;
            double minCost = tuple2._1$mcD$sp();
            int bestRun = tuple2._2$mcI$sp();
            Tuple2.mcDI.sp sp3 = sp2 = new Tuple2.mcDI.sp(minCost, bestRun);
            double minCost2 = sp3._1$mcD$sp();
            int bestRun2 = sp3._2$mcI$sp();
            this.logInfo((Function0<String>)new Serializable(this, minCost2){
                public static final long serialVersionUID = 0L;
                private final double minCost$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cost for the best run is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minCost$1)}));
                }
                {
                    this.minCost$1 = minCost$1;
                }
            });
            return new KMeansModel((Vector[])Predef$.MODULE$.refArrayOps((Object[])centers[bestRun2]).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Vector apply(VectorWithNorm x$8) {
                    return x$8.vector();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))));
        }
        throw new MatchError((Object)tuple2);
    }

    private VectorWithNorm[][] initRandom(RDD<VectorWithNorm> data) {
        Seq sample = Predef$.MODULE$.refArrayOps((Object[])data.takeSample(true, this.org$apache$spark$mllib$clustering$KMeans$$runs() * this.org$apache$spark$mllib$clustering$KMeans$$k(), (long)new XORShiftRandom().nextInt())).toSeq();
        return (VectorWithNorm[][])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final Seq sample$1;

            public final VectorWithNorm[] apply(int r) {
                return (VectorWithNorm[])((TraversableOnce)((TraversableLike)this.sample$1.slice(r * this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(), (r + 1) * this.$outer.org$apache$spark$mllib$clustering$KMeans$$k())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final VectorWithNorm apply(VectorWithNorm v) {
                        return new VectorWithNorm(Vectors$.MODULE$.dense(v.vector().toArray()), v.norm());
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sample$1 = sample$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
    }

    private VectorWithNorm[][] initKMeansParallel(RDD<VectorWithNorm> data) {
        int seed = new XORShiftRandom().nextInt();
        Seq sample = Predef$.MODULE$.refArrayOps((Object[])data.takeSample(true, this.org$apache$spark$mllib$clustering$KMeans$$runs(), (long)seed)).toSeq();
        ArrayBuffer[] centers = (ArrayBuffer[])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final Seq sample$2;

            public final ArrayBuffer<VectorWithNorm> apply(int r) {
                return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VectorWithNorm[]{((VectorWithNorm)this.sample$2.apply(r)).toDense()}));
            }
            {
                this.sample$2 = sample$2;
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class));
        IntRef step = new IntRef(0);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcCenters = data.context().broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ArrayBuffer.class)));
            Map sumCosts = SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(this, bcCenters){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                public final Broadcast bcCenters$2;

                public final IndexedSeq<Tuple2<Object, Object>> apply(VectorWithNorm point) {
                    return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs()).map((Function1)new Serializable(this, point){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$16 $outer;
                        private final VectorWithNorm point$3;

                        public final Tuple2<Object, Object> apply(int r) {
                            return new Tuple2.mcID.sp(r, KMeans$.MODULE$.pointCost((TraversableOnce<VectorWithNorm>)((ArrayBuffer[])this.$outer.bcCenters$2.value())[r], this.point$3));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.point$3 = point$3;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.bcCenters$2 = bcCenters$2;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x$9, double x$10) {
                    return this.apply$mcDDD$sp(x$9, x$10);
                }

                public double apply$mcDDD$sp(double x$9, double x$10) {
                    return x$9 + x$10;
                }
            }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            Tuple2[] chosen = (Tuple2[])data.mapPartitionsWithIndex((Function2)new Serializable(this, seed, step, bcCenters, sumCosts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final int seed$1;
                private final IntRef step$1;
                public final Broadcast bcCenters$2;
                public final Map sumCosts$1;

                public final Iterator<Tuple2<Object, VectorWithNorm>> apply(int index, Iterator<VectorWithNorm> points) {
                    XORShiftRandom rand2 = new XORShiftRandom((long)(this.seed$1 ^ this.step$1.elem << 16 ^ index));
                    return points.flatMap((Function1)new Serializable(this, rand2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$17 $outer;
                        public final XORShiftRandom rand$1;

                        public final IndexedSeq<Tuple2<Object, VectorWithNorm>> apply(VectorWithNorm p) {
                            return (IndexedSeq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$runs()).filter((Function1)new Serializable(this, p){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$17$$anonfun$apply$8 $outer;
                                private final VectorWithNorm p$1;

                                public final boolean apply(int r) {
                                    return this.apply$mcZI$sp(r);
                                }

                                public boolean apply$mcZI$sp(int r) {
                                    return this.$outer.rand$1.nextDouble() < 2.0 * KMeans$.MODULE$.pointCost((TraversableOnce<VectorWithNorm>)((ArrayBuffer[])this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().bcCenters$2.value())[r], this.p$1) * (double)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$k() / BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().sumCosts$1.apply((Object)BoxesRunTime.boxToInteger((int)r)));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.p$1 = p$1;
                                }
                            })).map((Function1)new Serializable(this, p){
                                public static final long serialVersionUID = 0L;
                                private final VectorWithNorm p$1;

                                public final Tuple2<Object, VectorWithNorm> apply(int x$11) {
                                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)x$11), (Object)this.p$1);
                                }
                                {
                                    this.p$1 = p$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                        }

                        public /* synthetic */ $anonfun$17 org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.rand$1 = rand$1;
                        }
                    });
                }

                public /* synthetic */ KMeans org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.seed$1 = seed$1;
                    this.step$1 = step$1;
                    this.bcCenters$2 = bcCenters$2;
                    this.sumCosts$1 = sumCosts$1;
                }
            }, data.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
            Predef$.MODULE$.refArrayOps((Object[])chosen).foreach((Function1)new Serializable(this, centers){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer[] centers$2;

                public final ArrayBuffer<VectorWithNorm> apply(Tuple2<Object, VectorWithNorm> x0$2) {
                    Tuple2<Object, VectorWithNorm> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int r = tuple2._1$mcI$sp();
                        VectorWithNorm p = (VectorWithNorm)tuple2._2();
                        ArrayBuffer arrayBuffer = this.centers$2[r].$plus$eq((Object)p.toDense());
                        return arrayBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.centers$2 = centers$2;
                }
            });
            ++step.elem;
        }
        Broadcast bcCenters = data.context().broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ArrayBuffer.class)));
        Map weightMap = SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(this, bcCenters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            public final Broadcast bcCenters$1;

            public final IndexedSeq<Tuple2<Tuple2<Object, Object>, Object>> apply(VectorWithNorm p) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs()).map((Function1)new Serializable(this, p){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;
                    private final VectorWithNorm p$2;

                    public final Tuple2<Tuple2<Object, Object>, Object> apply(int r) {
                        return new Tuple2((Object)new Tuple2.mcII.sp(r, KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)((ArrayBuffer[])this.$outer.bcCenters$1.value())[r], this.p$2)._1$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)1.0));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.p$2 = p$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bcCenters$1 = bcCenters$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$12, double x$13) {
                return this.apply$mcDDD$sp(x$12, x$13);
            }

            public double apply$mcDDD$sp(double x$12, double x$13) {
                return x$12 + x$13;
            }
        }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).collectAsMap();
        IndexedSeq finalCenters = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.org$apache$spark$mllib$clustering$KMeans$$runs()).map((Function1)new Serializable(this, centers, weightMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final ArrayBuffer[] centers$2;
            public final Map weightMap$1;

            public final VectorWithNorm[] apply(int r) {
                VectorWithNorm[] myCenters = (VectorWithNorm[])this.centers$2[r].toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
                double[] myWeights = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), myCenters.length).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;
                    private final int r$1;

                    public final double apply(int i) {
                        return this.apply$mcDI$sp(i);
                    }

                    public double apply$mcDI$sp(int i) {
                        return BoxesRunTime.unboxToDouble((Object)this.$outer.weightMap$1.getOrElse((Object)new Tuple2.mcII.sp(this.r$1, i), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 0.0;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                return LocalKMeans$.MODULE$.kMeansPlusPlus(r, myCenters, myWeights, this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(), 30);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.centers$2 = centers$2;
                this.weightMap$1 = weightMap$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return (VectorWithNorm[][])finalCenters.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
    }

    public final Tuple2 org$apache$spark$mllib$clustering$KMeans$$mergeContribs$1(Tuple2 x, Tuple2 y) {
        BLAS$.MODULE$.axpy(1.0, (Vector)x._1(), (Vector)y._1());
        return new Tuple2(y._1(), (Object)BoxesRunTime.boxToLong((long)(x._2$mcJ$sp() + y._2$mcJ$sp())));
    }

    private KMeans(int k, int maxIterations, int runs, String initializationMode, int initializationSteps, double epsilon) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = k;
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = maxIterations;
        this.org$apache$spark$mllib$clustering$KMeans$$runs = runs;
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = epsilon;
        Logging.class.$init$((Logging)this);
    }

    public KMeans() {
        this(2, 20, 1, KMeans$.MODULE$.K_MEANS_PARALLEL(), 5, 1.0E-4);
    }
}

