/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.CSCMatrix;
import breeze.storage.Zero;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Matrix$class;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u001b\ta1\u000b]1sg\u0016l\u0015\r\u001e:jq*\u00111\u0001B\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0005\t3\u0001\u0011)\u0019!C\u00015\u00059a.^7S_^\u001cX#A\u000e\u0011\u0005=a\u0012BA\u000f\u0011\u0005\rIe\u000e\u001e\u0005\t?\u0001\u0011\t\u0011)A\u00057\u0005Aa.^7S_^\u001c\b\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\u001dqW/\\\"pYND\u0001b\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\t]Vl7i\u001c7tA!AQ\u0005\u0001BC\u0002\u0013\u0005a%A\u0004d_2\u0004FO]:\u0016\u0003\u001d\u00022a\u0004\u0015\u001c\u0013\tI\u0003CA\u0003BeJ\f\u0017\u0010\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003(\u0003!\u0019w\u000e\u001c)ueN\u0004\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\u0002\u0015I|w/\u00138eS\u000e,7\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u0003(\u0003-\u0011xn^%oI&\u001cWm\u001d\u0011\t\u0011E\u0002!Q1A\u0005\u0002I\naA^1mk\u0016\u001cX#A\u001a\u0011\u0007=AC\u0007\u0005\u0002\u0010k%\u0011a\u0007\u0005\u0002\u0007\t>,(\r\\3\t\u0011a\u0002!\u0011!Q\u0001\nM\nqA^1mk\u0016\u001c\b\u0005C\u0003;\u0001\u0011\u00051(\u0001\u0004=S:LGO\u0010\u000b\u0007yurt\bQ!\u0011\u0005U\u0001\u0001\"B\r:\u0001\u0004Y\u0002\"B\u0011:\u0001\u0004Y\u0002\"B\u0013:\u0001\u00049\u0003\"B\u0017:\u0001\u00049\u0003\"B\u0019:\u0001\u0004\u0019\u0004\"B\"\u0001\t\u0003\u0012\u0014a\u0002;p\u0003J\u0014\u0018-\u001f\u0005\u0007\u000b\u0002!\t\u0001\u0002$\u0002\u0011Q|'I]3fu\u0016,\u0012a\u0012\t\u0004\u00112#T\"A%\u000b\u0005\rQ%\"A&\u0002\r\t\u0014X-\u001a>f\u0013\t9\u0012\n\u0003\u0004O\u0001\u0011\u0005AaT\u0001\u0006CB\u0004H.\u001f\u000b\u0004iA\u0013\u0006\"B)N\u0001\u0004Y\u0012!A5\t\u000bMk\u0005\u0019A\u000e\u0002\u0003)Da!\u0016\u0001\u0005\u0002\u00111\u0016!B5oI\u0016DHcA\u000eX1\")\u0011\u000b\u0016a\u00017!)1\u000b\u0016a\u00017!1!\f\u0001C\u0001\tm\u000ba!\u001e9eCR,G\u0003\u0002/`A\u0006\u0004\"aD/\n\u0005y\u0003\"\u0001B+oSRDQ!U-A\u0002mAQaU-A\u0002mAQAY-A\u0002Q\n\u0011A\u001e\u0005\u0006I\u0002!\t%Z\u0001\u0005G>\u0004\u00180F\u0001=\u0001")
public class SparseMatrix
implements Matrix {
    private final int numRows;
    private final int numCols;
    private final int[] colPtrs;
    private final int[] rowIndices;
    private final double[] values;

    @Override
    public DenseMatrix multiply(DenseMatrix y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(DenseVector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseMatrix transposeMultiply(DenseMatrix y) {
        return Matrix$class.transposeMultiply((Matrix)this, y);
    }

    @Override
    public DenseVector transposeMultiply(DenseVector y) {
        return Matrix$class.transposeMultiply((Matrix)this, y);
    }

    @Override
    public String toString() {
        return Matrix$class.toString(this);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    public int[] colPtrs() {
        return this.colPtrs;
    }

    public int[] rowIndices() {
        return this.rowIndices;
    }

    public double[] values() {
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] arr = new double[this.numRows() * this.numCols()];
        for (int j = 0; j < this.numCols(); ++j) {
            int indEnd = this.colPtrs()[j + 1];
            int offset = j * this.numRows();
            for (int i = this.colPtrs()[j]; i < indEnd; ++i) {
                int rowIndex = this.rowIndices()[i];
                arr[offset + rowIndex] = this.values()[i];
            }
        }
        return var1_1;
    }

    @Override
    public breeze.linalg.Matrix<Object> toBreeze() {
        return new CSCMatrix.mcD.sp(this.values(), this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public double apply(int i, int j) {
        int ind = this.index(i, j);
        return ind < 0 ? 0.0 : this.values()[ind];
    }

    @Override
    public int index(int i, int j) {
        return Arrays.binarySearch(this.rowIndices(), this.colPtrs()[j], this.colPtrs()[j + 1], i);
    }

    @Override
    public void update(int i, int j, double v) {
        int ind = this.index(i, j);
        if (ind == -1) {
            throw new NoSuchElementException("The given row and column indices correspond to a zero value. Only non-zero elements in Sparse Matrices can be updated.");
        }
        this.values()[this.index((int)i, (int)j)] = v;
    }

    @Override
    public SparseMatrix copy() {
        return new SparseMatrix(this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (double[])this.values().clone());
    }

    public SparseMatrix(int numRows2, int numCols, int[] colPtrs, int[] rowIndices, double[] values) {
        this.numRows = numRows2;
        this.numCols = numCols;
        this.colPtrs = colPtrs;
        this.rowIndices = rowIndices;
        this.values = values;
        Matrix$class.$init$(this);
        Predef$.MODULE$.require(values.length == rowIndices.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of row indices and values don't match! ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"values.length: ", ", rowIndices.length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length), BoxesRunTime.boxToInteger((int)this.$outer.rowIndices().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(colPtrs.length == numCols + 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The length of the column indices should be the ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of columns + 1. Currently, colPointers.length: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.colPtrs().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numCols())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

