/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.random;

import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaDoubleRDD$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.PoissonGenerator;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.random.StandardNormalGenerator;
import org.apache.spark.mllib.random.UniformGenerator;
import org.apache.spark.mllib.rdd.RandomRDD;
import org.apache.spark.mllib.rdd.RandomVectorRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

@Experimental
public final class RandomRDDs$ {
    public static final RandomRDDs$ MODULE$;

    static {
        new RandomRDDs$();
    }

    public RDD<Object> uniformRDD(SparkContext sc, long size, int numPartitions, long seed) {
        UniformGenerator uniform = new UniformGenerator();
        return this.randomRDD(sc, uniform, size, this.numPartitionsOrDefault(sc, numPartitions), seed, ClassTag$.MODULE$.Double());
    }

    public int uniformRDD$default$3() {
        return 0;
    }

    public long uniformRDD$default$4() {
        return Utils$.MODULE$.random().nextLong();
    }

    public JavaDoubleRDD uniformJavaRDD(JavaSparkContext jsc, long size, int numPartitions, long seed) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.uniformRDD(jsc.sc(), size, numPartitions, seed));
    }

    public JavaDoubleRDD uniformJavaRDD(JavaSparkContext jsc, long size, int numPartitions) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.uniformRDD(jsc.sc(), size, numPartitions, this.uniformRDD$default$4()));
    }

    public JavaDoubleRDD uniformJavaRDD(JavaSparkContext jsc, long size) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.uniformRDD(jsc.sc(), size, this.uniformRDD$default$3(), this.uniformRDD$default$4()));
    }

    public RDD<Object> normalRDD(SparkContext sc, long size, int numPartitions, long seed) {
        StandardNormalGenerator normal = new StandardNormalGenerator();
        return this.randomRDD(sc, normal, size, this.numPartitionsOrDefault(sc, numPartitions), seed, ClassTag$.MODULE$.Double());
    }

    public int normalRDD$default$3() {
        return 0;
    }

    public long normalRDD$default$4() {
        return Utils$.MODULE$.random().nextLong();
    }

    public JavaDoubleRDD normalJavaRDD(JavaSparkContext jsc, long size, int numPartitions, long seed) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.normalRDD(jsc.sc(), size, numPartitions, seed));
    }

    public JavaDoubleRDD normalJavaRDD(JavaSparkContext jsc, long size, int numPartitions) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.normalRDD(jsc.sc(), size, numPartitions, this.normalRDD$default$4()));
    }

    public JavaDoubleRDD normalJavaRDD(JavaSparkContext jsc, long size) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.normalRDD(jsc.sc(), size, this.normalRDD$default$3(), this.normalRDD$default$4()));
    }

    public RDD<Object> poissonRDD(SparkContext sc, double mean2, long size, int numPartitions, long seed) {
        PoissonGenerator poisson = new PoissonGenerator(mean2);
        return this.randomRDD(sc, poisson, size, this.numPartitionsOrDefault(sc, numPartitions), seed, ClassTag$.MODULE$.Double());
    }

    public int poissonRDD$default$4() {
        return 0;
    }

    public long poissonRDD$default$5() {
        return Utils$.MODULE$.random().nextLong();
    }

    public JavaDoubleRDD poissonJavaRDD(JavaSparkContext jsc, double mean2, long size, int numPartitions, long seed) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.poissonRDD(jsc.sc(), mean2, size, numPartitions, seed));
    }

    public JavaDoubleRDD poissonJavaRDD(JavaSparkContext jsc, double mean2, long size, int numPartitions) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.poissonRDD(jsc.sc(), mean2, size, numPartitions, this.poissonRDD$default$5()));
    }

    public JavaDoubleRDD poissonJavaRDD(JavaSparkContext jsc, double mean2, long size) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.poissonRDD(jsc.sc(), mean2, size, this.poissonRDD$default$4(), this.poissonRDD$default$5()));
    }

    @DeveloperApi
    public <T> RDD<T> randomRDD(SparkContext sc, RandomDataGenerator<T> generator, long size, int numPartitions, long seed, ClassTag<T> evidence$1) {
        return new RandomRDD<T>(sc, size, this.numPartitionsOrDefault(sc, numPartitions), generator, seed, evidence$1);
    }

    public <T> int randomRDD$default$4() {
        return 0;
    }

    public <T> long randomRDD$default$5() {
        return Utils$.MODULE$.random().nextLong();
    }

    public RDD<Vector> uniformVectorRDD(SparkContext sc, long numRows2, int numCols, int numPartitions, long seed) {
        UniformGenerator uniform = new UniformGenerator();
        return this.randomVectorRDD(sc, uniform, numRows2, numCols, this.numPartitionsOrDefault(sc, numPartitions), seed);
    }

    public int uniformVectorRDD$default$4() {
        return 0;
    }

    public long uniformVectorRDD$default$5() {
        return Utils$.MODULE$.random().nextLong();
    }

    public JavaRDD<Vector> uniformJavaVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, int numPartitions, long seed) {
        return this.uniformVectorRDD(jsc.sc(), numRows2, numCols, numPartitions, seed).toJavaRDD();
    }

    public JavaRDD<Vector> uniformJavaVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, int numPartitions) {
        return this.uniformVectorRDD(jsc.sc(), numRows2, numCols, numPartitions, this.uniformVectorRDD$default$5()).toJavaRDD();
    }

    public JavaRDD<Vector> uniformJavaVectorRDD(JavaSparkContext jsc, long numRows2, int numCols) {
        return this.uniformVectorRDD(jsc.sc(), numRows2, numCols, this.uniformVectorRDD$default$4(), this.uniformVectorRDD$default$5()).toJavaRDD();
    }

    public RDD<Vector> normalVectorRDD(SparkContext sc, long numRows2, int numCols, int numPartitions, long seed) {
        StandardNormalGenerator normal = new StandardNormalGenerator();
        return this.randomVectorRDD(sc, normal, numRows2, numCols, this.numPartitionsOrDefault(sc, numPartitions), seed);
    }

    public int normalVectorRDD$default$4() {
        return 0;
    }

    public long normalVectorRDD$default$5() {
        return Utils$.MODULE$.random().nextLong();
    }

    public JavaRDD<Vector> normalJavaVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, int numPartitions, long seed) {
        return this.normalVectorRDD(jsc.sc(), numRows2, numCols, numPartitions, seed).toJavaRDD();
    }

    public JavaRDD<Vector> normalJavaVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, int numPartitions) {
        return this.normalVectorRDD(jsc.sc(), numRows2, numCols, numPartitions, this.normalVectorRDD$default$5()).toJavaRDD();
    }

    public JavaRDD<Vector> normalJavaVectorRDD(JavaSparkContext jsc, long numRows2, int numCols) {
        return this.normalVectorRDD(jsc.sc(), numRows2, numCols, this.normalVectorRDD$default$4(), this.normalVectorRDD$default$5()).toJavaRDD();
    }

    public RDD<Vector> poissonVectorRDD(SparkContext sc, double mean2, long numRows2, int numCols, int numPartitions, long seed) {
        PoissonGenerator poisson = new PoissonGenerator(mean2);
        return this.randomVectorRDD(sc, poisson, numRows2, numCols, this.numPartitionsOrDefault(sc, numPartitions), seed);
    }

    public int poissonVectorRDD$default$5() {
        return 0;
    }

    public long poissonVectorRDD$default$6() {
        return Utils$.MODULE$.random().nextLong();
    }

    public JavaRDD<Vector> poissonJavaVectorRDD(JavaSparkContext jsc, double mean2, long numRows2, int numCols, int numPartitions, long seed) {
        return this.poissonVectorRDD(jsc.sc(), mean2, numRows2, numCols, numPartitions, seed).toJavaRDD();
    }

    public JavaRDD<Vector> poissonJavaVectorRDD(JavaSparkContext jsc, double mean2, long numRows2, int numCols, int numPartitions) {
        return this.poissonVectorRDD(jsc.sc(), mean2, numRows2, numCols, numPartitions, this.poissonVectorRDD$default$6()).toJavaRDD();
    }

    public JavaRDD<Vector> poissonJavaVectorRDD(JavaSparkContext jsc, double mean2, long numRows2, int numCols) {
        return this.poissonVectorRDD(jsc.sc(), mean2, numRows2, numCols, this.poissonVectorRDD$default$5(), this.poissonVectorRDD$default$6()).toJavaRDD();
    }

    @DeveloperApi
    public RDD<Vector> randomVectorRDD(SparkContext sc, RandomDataGenerator<Object> generator, long numRows2, int numCols, int numPartitions, long seed) {
        return new RandomVectorRDD(sc, numRows2, numCols, this.numPartitionsOrDefault(sc, numPartitions), generator, seed);
    }

    public int randomVectorRDD$default$5() {
        return 0;
    }

    public long randomVectorRDD$default$6() {
        return Utils$.MODULE$.random().nextLong();
    }

    private int numPartitionsOrDefault(SparkContext sc, int numPartitions) {
        return numPartitions > 0 ? numPartitions : sc.defaultMinPartitions();
    }

    private RandomRDDs$() {
        MODULE$ = this;
    }
}

