/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.rdd.RDDFunctions$;
import org.apache.spark.mllib.rdd.SlidingRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u00015\u0011AB\u0015#E\rVt7\r^5p]NT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0016\u00059\t3c\u0001\u0001\u0010+A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"\u0001\u0005\f\n\u0005]\t\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\tM,GN\u001a\t\u00047uyR\"\u0001\u000f\u000b\u0005\r1\u0011B\u0001\u0010\u001d\u0005\r\u0011F\t\u0012\t\u0003A\u0005b\u0001\u0001B\u0003#\u0001\t\u00071EA\u0001U#\t!s\u0005\u0005\u0002\u0011K%\u0011a%\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0001\u0002&\u0003\u0002*#\t\u0019\u0011I\\=\t\u0011-\u0002!1!Q\u0001\f1\n!\"\u001a<jI\u0016t7-\u001a\u00132!\ri\u0003gH\u0007\u0002])\u0011q&E\u0001\be\u00164G.Z2u\u0013\t\tdF\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q\u0011Q'\u000f\u000b\u0003ma\u00022a\u000e\u0001 \u001b\u0005\u0011\u0001\"B\u00163\u0001\ba\u0003\"B\r3\u0001\u0004Q\u0002\"B\u001e\u0001\t\u0003a\u0014aB:mS\u0012Lgn\u001a\u000b\u0003{\u0005\u00032aG\u000f?!\r\u0001rhH\u0005\u0003\u0001F\u0011Q!\u0011:sCfDQA\u0011\u001eA\u0002\r\u000b!b^5oI><8+\u001b>f!\t\u0001B)\u0003\u0002F#\t\u0019\u0011J\u001c;\t\u000b\u001d\u0003A\u0011\u0001%\u0002\u0015Q\u0014X-\u001a*fIV\u001cW\rF\u0002 \u0013:CQA\u0013$A\u0002-\u000b\u0011A\u001a\t\u0006!1{rdH\u0005\u0003\u001bF\u0011\u0011BR;oGRLwN\u001c\u001a\t\u000f=3\u0005\u0013!a\u0001\u0007\u0006)A-\u001a9uQ\")\u0011\u000b\u0001C\u0001%\u0006iAO]3f\u0003\u001e<'/Z4bi\u0016,\"aU,\u0015\u0005Q\u001bG\u0003B+]?\n$\"AV-\u0011\u0005\u0001:F!\u0002-Q\u0005\u0004\u0019#!A+\t\u000fi\u0003\u0016\u0011!a\u00027\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\u00075\u0002d\u000bC\u0003^!\u0002\u0007a,A\u0003tKF|\u0005\u000fE\u0003\u0011\u0019Z{b\u000bC\u0003a!\u0002\u0007\u0011-\u0001\u0004d_6\u0014w\n\u001d\t\u0006!13fK\u0016\u0005\b\u001fB\u0003\n\u00111\u0001D\u0011\u0015!\u0007\u000b1\u0001W\u0003%QXM]8WC2,X\rC\u0004g\u0001E\u0005I\u0011A4\u0002/Q\u0014X-Z!hOJ,w-\u0019;fI\u0011,g-Y;mi\u0012\"TC\u00015v)\tI7O\u000b\u0002DU.\n1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003aF\t!\"\u00198o_R\fG/[8o\u0013\t\u0011XNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DQ\u0001Z3A\u0002Q\u0004\"\u0001I;\u0005\u000ba+'\u0019A\u0012\t\u000f]\u0004\u0011\u0013!C\u0001q\u0006!BO]3f%\u0016$WoY3%I\u00164\u0017-\u001e7uII*\u0012!\u001b\u0015\u0003\u0001i\u0004\"a_?\u000e\u0003qT!\u0001\u001d\u0004\n\u0005yd(\u0001\u0004#fm\u0016dw\u000e]3s\u0003BLwaBA\u0001\u0005!\u0005\u00111A\u0001\r%\u0012#e)\u001e8di&|gn\u001d\t\u0004o\u0005\u0015aAB\u0001\u0003\u0011\u0003\t9a\u0005\u0003\u0002\u0006=)\u0002bB\u001a\u0002\u0006\u0011\u0005\u00111\u0002\u000b\u0003\u0003\u0007A\u0001\"a\u0004\u0002\u0006\u0011\r\u0011\u0011C\u0001\bMJ|WN\u0015#E+\u0011\t\u0019\"a\u0007\u0015\t\u0005U\u00111\u0005\u000b\u0005\u0003/\ti\u0002\u0005\u00038\u0001\u0005e\u0001c\u0001\u0011\u0002\u001c\u00111!%!\u0004C\u0002\rB!\"a\b\u0002\u000e\u0005\u0005\t9AA\u0011\u0003))g/\u001b3f]\u000e,Ge\r\t\u0005[A\nI\u0002C\u0004\u0004\u0003\u001b\u0001\r!!\n\u0011\tmi\u0012\u0011\u0004\u0005\u000b\u0003S\t)!!A\u0005\n\u0005-\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005!A.\u00198h\u0015\t\t9$\u0001\u0003kCZ\f\u0017\u0002BA\u001e\u0003c\u0011aa\u00142kK\u000e$\bfAA\u0003u\"\u0012qP\u001f")
public class RDDFunctions<T>
implements Serializable {
    private final RDD<T> self;
    public final ClassTag<T> org$apache$spark$mllib$rdd$RDDFunctions$$evidence$1;

    public static <T> RDDFunctions<T> fromRDD(RDD<T> rDD, ClassTag<T> classTag) {
        return RDDFunctions$.MODULE$.fromRDD(rDD, classTag);
    }

    public RDD<Object> sliding(int windowSize) {
        Predef$.MODULE$.require(windowSize > 0, (Function0)new Serializable(this, windowSize){
            public static final long serialVersionUID = 0L;
            private final int windowSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sliding window size must be positive, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.windowSize$1)}));
            }
            {
                this.windowSize$1 = windowSize$1;
            }
        });
        return windowSize == 1 ? this.self.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RDDFunctions $outer;

            public final Object apply(T x$1) {
                return Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$1}), this.$outer.org$apache$spark$mllib$rdd$RDDFunctions$$evidence$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(this.org$apache$spark$mllib$rdd$RDDFunctions$$evidence$1.runtimeClass()))) : new SlidingRDD(this.self, windowSize, this.org$apache$spark$mllib$rdd$RDDFunctions$$evidence$1);
    }

    public T treeReduce(Function2<T, T, T> f, int depth) {
        Predef$.MODULE$.require(depth >= 1, (Function0)new Serializable(this, depth){
            public static final long serialVersionUID = 0L;
            private final int depth$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Depth must be greater than or equal to 1 but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.depth$2)}));
            }
            {
                this.depth$2 = depth$2;
            }
        });
        SparkContext qual$1 = this.self.context();
        Function2<T, T, T> x$3 = f;
        boolean x$4 = qual$1.clean$default$2();
        Function2 cleanF = (Function2)qual$1.clean(x$3, x$4);
        Serializable reducePartition = new Serializable(this, cleanF){
            public static final long serialVersionUID = 0L;
            private final Function2 cleanF$1;

            public final Option<T> apply(Iterator<T> iter) {
                return iter.hasNext() ? new Some(iter.reduceLeft(this.cleanF$1)) : None$.MODULE$;
            }
            {
                this.cleanF$1 = cleanF$1;
            }
        };
        RDD partiallyReduced = this.self.mapPartitions((Function1)new Serializable(this, (Function1)reducePartition){
            public static final long serialVersionUID = 0L;
            private final Function1 reducePartition$1;

            public final Iterator<Option<T>> apply(Iterator<T> it) {
                return scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{(Option)this.reducePartition$1.apply(it)}));
            }
            {
                this.reducePartition$1 = reducePartition$1;
            }
        }, this.self.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Option.class));
        Serializable op = new Serializable(this, cleanF){
            public static final long serialVersionUID = 0L;
            private final Function2 cleanF$1;

            public final Option<T> apply(Option<T> c, Option<T> x) {
                return c.isDefined() && x.isDefined() ? new Some(this.cleanF$1.apply(c.get(), x.get())) : (c.isDefined() ? c : (x.isDefined() ? x : None$.MODULE$));
            }
            {
                this.cleanF$1 = cleanF$1;
            }
        };
        return (T)RDDFunctions$.MODULE$.fromRDD(partiallyReduced, ClassTag$.MODULE$.apply(Option.class)).treeAggregate((U)Option$.MODULE$.empty(), (Function2<U, T, U>)op, (Function2<U, U, U>)((Function2)op), depth, (ClassTag<U>)ClassTag$.MODULE$.apply(Option.class)).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new UnsupportedOperationException("empty collection");
            }
        });
    }

    public int treeReduce$default$2() {
        return 2;
    }

    public <U> U treeAggregate(U zeroValue, Function2<U, T, U> seqOp, Function2<U, U, U> combOp, int depth, ClassTag<U> evidence$2) {
        Predef$.MODULE$.require(depth >= 1, (Function0)new Serializable(this, depth){
            public static final long serialVersionUID = 0L;
            private final int depth$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Depth must be greater than or equal to 1 but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.depth$1)}));
            }
            {
                this.depth$1 = depth$1;
            }
        });
        if (Predef$.MODULE$.refArrayOps((Object[])this.self.partitions()).size() == 0) {
            return (U)Utils$.MODULE$.clone(zeroValue, this.self.context().env().closureSerializer().newInstance(), evidence$2);
        }
        SparkContext qual$2 = this.self.context();
        Function2<U, T, U> x$5 = seqOp;
        boolean x$6 = qual$2.clean$default$2();
        Function2 cleanSeqOp = (Function2)qual$2.clean(x$5, x$6);
        SparkContext qual$3 = this.self.context();
        Function2<U, U, U> x$7 = combOp;
        boolean x$8 = qual$3.clean$default$2();
        Function2 cleanCombOp = (Function2)qual$3.clean(x$7, x$8);
        Serializable aggregatePartition = new Serializable(this, zeroValue, cleanSeqOp, cleanCombOp){
            public static final long serialVersionUID = 0L;
            private final Object zeroValue$1;
            private final Function2 cleanSeqOp$1;
            private final Function2 cleanCombOp$1;

            public final U apply(Iterator<T> it) {
                return (U)it.aggregate(this.zeroValue$1, this.cleanSeqOp$1, this.cleanCombOp$1);
            }
            {
                void var4_4;
                void var3_3;
                this.zeroValue$1 = zeroValue$1;
                this.cleanSeqOp$1 = var3_3;
                this.cleanCombOp$1 = var4_4;
            }
        };
        RDD partiallyAggregated = this.self.mapPartitions((Function1)new Serializable(this, (Function1)aggregatePartition){
            public static final long serialVersionUID = 0L;
            private final Function1 aggregatePartition$1;

            public final Iterator<U> apply(Iterator<T> it) {
                return scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.aggregatePartition$1.apply(it)}));
            }
            {
                this.aggregatePartition$1 = aggregatePartition$1;
            }
        }, this.self.mapPartitions$default$2(), evidence$2);
        int numPartitions = Predef$.MODULE$.refArrayOps((Object[])partiallyAggregated.partitions()).size();
        int scale = package$.MODULE$.max((int)package$.MODULE$.ceil(package$.MODULE$.pow((double)numPartitions, 1.0 / (double)depth)), 2);
        while (numPartitions > scale + numPartitions / scale) {
            int curNumPartitions = numPartitions /= scale;
            RDD qual$4 = partiallyAggregated;
            Serializable x$9 = new Serializable(this, curNumPartitions){
                public static final long serialVersionUID = 0L;
                public final int curNumPartitions$1;

                public final Iterator<Tuple2<Object, U>> apply(int i, Iterator<U> iter) {
                    return iter.map((Function1)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$6 $outer;
                        private final int i$1;

                        public final Tuple2<Object, U> apply(U x$2) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.i$1 % this.$outer.curNumPartitions$1)), x$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.i$1 = i$1;
                        }
                    });
                }
                {
                    this.curNumPartitions$1 = curNumPartitions$1;
                }
            };
            boolean x$10 = qual$4.mapPartitionsWithIndex$default$2();
            partiallyAggregated = SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(qual$4.mapPartitionsWithIndex((Function2)x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), evidence$2, (Ordering)Ordering.Int$.MODULE$).reduceByKey((Partitioner)new HashPartitioner(curNumPartitions), cleanCombOp), ClassTag$.MODULE$.Int(), evidence$2, (Ordering)Ordering.Int$.MODULE$).values();
        }
        return (U)partiallyAggregated.reduce(cleanCombOp);
    }

    public <U> int treeAggregate$default$4(U zeroValue) {
        return 2;
    }

    public RDDFunctions(RDD<T> self, ClassTag<T> evidence$1) {
        this.self = self;
        this.org$apache$spark$mllib$rdd$RDDFunctions$$evidence$1 = evidence$1;
    }
}

