/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.Logging;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree;
import org.apache.spark.mllib.tree.GradientBoostedTrees;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impl.TimeTracker;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class GradientBoostedTrees$
implements Logging,
Serializable {
    public static final GradientBoostedTrees$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new GradientBoostedTrees$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public GradientBoostedTreesModel train(RDD<LabeledPoint> input, BoostingStrategy boostingStrategy) {
        return new GradientBoostedTrees(boostingStrategy).run(input);
    }

    public GradientBoostedTreesModel train(JavaRDD<LabeledPoint> input, BoostingStrategy boostingStrategy) {
        return this.train((RDD<LabeledPoint>)input.rdd(), boostingStrategy);
    }

    public GradientBoostedTreesModel org$apache$spark$mllib$tree$GradientBoostedTrees$$boost(RDD<LabeledPoint> input, BoostingStrategy boostingStrategy) {
        DecisionTreeModel firstTreeModel;
        TimeTracker timer = new TimeTracker();
        timer.start("total");
        timer.start("init");
        boostingStrategy.assertValid();
        int numIterations = boostingStrategy.numIterations();
        DecisionTreeModel[] baseLearners = new DecisionTreeModel[numIterations];
        double[] baseLearnerWeights = new double[numIterations];
        Loss loss = boostingStrategy.loss();
        double learningRate = boostingStrategy.learningRate();
        Strategy treeStrategy = boostingStrategy.treeStrategy().copy();
        treeStrategy.algo_$eq(Algo$.MODULE$.Regression());
        treeStrategy.impurity_$eq(Variance$.MODULE$);
        treeStrategy.assertValid();
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        Object object = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null) ? input.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        timer.stop("init");
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "##########";
            }
        });
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Building tree 0";
            }
        });
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "##########";
            }
        });
        RDD data = input;
        timer.start("building tree 0");
        baseLearners[0] = firstTreeModel = new DecisionTree(treeStrategy).run(data);
        baseLearnerWeights[0] = 1.0;
        GradientBoostedTreesModel startingModel = new GradientBoostedTreesModel(Algo$.MODULE$.Regression(), (DecisionTreeModel[])((Object[])new DecisionTreeModel[]{firstTreeModel}), new double[]{1.0});
        this.logDebug((Function0<String>)new Serializable(input, loss, startingModel){
            public static final long serialVersionUID = 0L;
            private final RDD input$1;
            private final Loss loss$1;
            private final GradientBoostedTreesModel startingModel$1;

            public final String apply() {
                return new StringBuilder().append((Object)"error of gbt = ").append((Object)BoxesRunTime.boxToDouble((double)this.loss$1.computeError(this.startingModel$1, (RDD<LabeledPoint>)this.input$1))).toString();
            }
            {
                this.input$1 = input$1;
                this.loss$1 = loss$1;
                this.startingModel$1 = startingModel$1;
            }
        });
        timer.stop("building tree 0");
        data = input.map((Function1)new Serializable(loss, startingModel){
            public static final long serialVersionUID = 0L;
            private final Loss loss$1;
            private final GradientBoostedTreesModel startingModel$1;

            public final LabeledPoint apply(LabeledPoint point) {
                return new LabeledPoint(this.loss$1.gradient(this.startingModel$1, point), point.features());
            }
            {
                this.loss$1 = loss$1;
                this.startingModel$1 = startingModel$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        IntRef m = new IntRef(1);
        while (m.elem < numIterations) {
            timer.start(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"building tree ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m.elem)})));
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "###################################################";
                }
            });
            this.logDebug((Function0<String>)new Serializable(m){
                public static final long serialVersionUID = 0L;
                private final IntRef m$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Gradient boosting tree iteration ").append((Object)BoxesRunTime.boxToInteger((int)this.m$1.elem)).toString();
                }
                {
                    this.m$1 = m$1;
                }
            });
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "###################################################";
                }
            });
            DecisionTreeModel model = new DecisionTree(treeStrategy).run((RDD<LabeledPoint>)data);
            timer.stop(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"building tree ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m.elem)})));
            baseLearners[m.elem] = model;
            baseLearnerWeights[m.elem] = learningRate;
            GradientBoostedTreesModel partialModel = new GradientBoostedTreesModel(Algo$.MODULE$.Regression(), (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])baseLearners).slice(0, m.elem + 1), (double[])Predef$.MODULE$.doubleArrayOps(baseLearnerWeights).slice(0, m.elem + 1));
            this.logDebug((Function0<String>)new Serializable(input, loss, partialModel){
                public static final long serialVersionUID = 0L;
                private final RDD input$1;
                private final Loss loss$1;
                private final GradientBoostedTreesModel partialModel$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"error of gbt = ").append((Object)BoxesRunTime.boxToDouble((double)this.loss$1.computeError(this.partialModel$1, (RDD<LabeledPoint>)this.input$1))).toString();
                }
                {
                    this.input$1 = input$1;
                    this.loss$1 = loss$1;
                    this.partialModel$1 = partialModel$1;
                }
            });
            data = input.map((Function1)new Serializable(loss, partialModel){
                public static final long serialVersionUID = 0L;
                private final Loss loss$1;
                private final GradientBoostedTreesModel partialModel$1;

                public final LabeledPoint apply(LabeledPoint point) {
                    return new LabeledPoint(-this.loss$1.gradient(this.partialModel$1, point), point.features());
                }
                {
                    this.loss$1 = loss$1;
                    this.partialModel$1 = partialModel$1;
                }
            }, ClassTag$.MODULE$.apply(LabeledPoint.class));
            ++m.elem;
        }
        timer.stop("total");
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Internal timing for DecisionTree:";
            }
        });
        this.logInfo((Function0<String>)new Serializable(timer){
            public static final long serialVersionUID = 0L;
            private final TimeTracker timer$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timer$1}));
            }
            {
                this.timer$1 = timer$1;
            }
        });
        return new GradientBoostedTreesModel(boostingStrategy.treeStrategy().algo(), baseLearners, baseLearnerWeights);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GradientBoostedTrees$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

