/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u001b\t!rI]1eS\u0016tGOQ8pgR,G\r\u0016:fKNT!a\u0001\u0003\u0002\tQ\u0014X-\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001$G\u0007\u0002\r%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!b\u0001\n\u0013i\u0012\u0001\u00052p_N$\u0018N\\4TiJ\fG/Z4z+\u0005q\u0002CA\u0010#\u001b\u0005\u0001#BA\u0011\u0003\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u00111\u0005\t\u0002\u0011\u0005>|7\u000f^5oON#(/\u0019;fOfD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0012E>|7\u000f^5oON#(/\u0019;fOf\u0004\u0003\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002*WA\u0011!\u0006A\u0007\u0002\u0005!)AD\na\u0001=!)Q\u0006\u0001C\u0001]\u0005\u0019!/\u001e8\u0015\u0005=*\u0004C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0003\u0003\u0015iw\u000eZ3m\u0013\t!\u0014GA\rHe\u0006$\u0017.\u001a8u\u0005>|7\u000f^3e)J,Wm]'pI\u0016d\u0007\"\u0002\u001c-\u0001\u00049\u0014!B5oaV$\bc\u0001\u001d<{5\t\u0011H\u0003\u0002;\r\u0005\u0019!\u000f\u001a3\n\u0005qJ$a\u0001*E\tB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tB\u0001\u000be\u0016<'/Z:tS>t\u0017B\u0001\"@\u00051a\u0015MY3mK\u0012\u0004v.\u001b8u\u0011\u0015i\u0003\u0001\"\u0001E)\tyS\tC\u00037\u0007\u0002\u0007a\tE\u0002H\u0019vj\u0011\u0001\u0013\u0006\u0003\u0013*\u000bAA[1wC*\u00111JB\u0001\u0004CBL\u0017BA'I\u0005\u001dQ\u0015M^1S\t\u0012C#\u0001A(\u0011\u0005A\u001bV\"A)\u000b\u0005I3\u0011AC1o]>$\u0018\r^5p]&\u0011A+\u0015\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\\\u0004\u0006-\nA\taV\u0001\u0015\u000fJ\fG-[3oi\n{wn\u001d;fIR\u0013X-Z:\u0011\u0005)Bf!B\u0001\u0003\u0011\u0003I6\u0003\u0002-\u000f/QAQa\n-\u0005\u0002m#\u0012a\u0016\u0005\u0006;b#\tAX\u0001\u0006iJ\f\u0017N\u001c\u000b\u0004_}\u0003\u0007\"\u0002\u001c]\u0001\u00049\u0004\"\u0002\u000f]\u0001\u0004q\u0002\"B/Y\t\u0003\u0011GcA\u0018dI\")a'\u0019a\u0001\r\")A$\u0019a\u0001=!)a\r\u0017C\u0005O\u0006)!m\\8tiR\u0019q\u0006[5\t\u000bY*\u0007\u0019A\u001c\t\u000bq)\u0007\u0019\u0001\u0010\t\u000f-D\u0016\u0011!C\u0005Y\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005i\u0007C\u00018s\u001b\u0005y'B\u00019r\u0003\u0011a\u0017M\\4\u000b\u0003%K!a]8\u0003\r=\u0013'.Z2u\u0001")
public class GradientBoostedTrees
implements Serializable,
Logging {
    private final BoostingStrategy boostingStrategy;
    private transient Logger org$apache$spark$Logging$$log_;

    public static GradientBoostedTreesModel train(JavaRDD<LabeledPoint> javaRDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(javaRDD, boostingStrategy);
    }

    public static GradientBoostedTreesModel train(RDD<LabeledPoint> rDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(rDD, boostingStrategy);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private BoostingStrategy boostingStrategy() {
        return this.boostingStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public GradientBoostedTreesModel run(RDD<LabeledPoint> input) {
        void var2_2;
        block4: {
            GradientBoostedTreesModel gradientBoostedTreesModel;
            block3: {
                Enumeration.Value value;
                block2: {
                    Enumeration.Value algo;
                    value = algo = this.boostingStrategy().treeStrategy().algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Regression();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost(input, this.boostingStrategy());
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Classification();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                RDD remappedInput = input.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost((RDD<LabeledPoint>)remappedInput, this.boostingStrategy());
            }
            return gradientBoostedTreesModel;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported by the gradient boosting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})));
    }

    public GradientBoostedTreesModel run(JavaRDD<LabeledPoint> input) {
        return this.run((RDD<LabeledPoint>)input.rdd());
    }

    public GradientBoostedTrees(BoostingStrategy boostingStrategy) {
        this.boostingStrategy = boostingStrategy;
        Logging.class.$init$((Logging)this);
    }
}

