/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impl;

import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impl.TreePoint;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class TreePoint$
implements Serializable {
    public static final TreePoint$ MODULE$;

    static {
        new TreePoint$();
    }

    public RDD<TreePoint> convertToTreeRDD(RDD<LabeledPoint> input, Bin[][] bins, DecisionTreeMetadata metadata) {
        int[] featureArity = new int[metadata.numFeatures()];
        boolean[] isUnordered = new boolean[metadata.numFeatures()];
        for (int featureIndex = 0; featureIndex < metadata.numFeatures(); ++featureIndex) {
            featureArity[featureIndex] = BoxesRunTime.unboxToInt((Object)metadata.featureArity().getOrElse((Object)BoxesRunTime.boxToInteger((int)featureIndex), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return 0;
                }
            }));
            isUnordered[featureIndex] = metadata.isUnordered(featureIndex);
        }
        return input.map((Function1)new Serializable(bins, featureArity, isUnordered){
            public static final long serialVersionUID = 0L;
            private final Bin[][] bins$1;
            private final int[] featureArity$1;
            private final boolean[] isUnordered$1;

            public final TreePoint apply(LabeledPoint x) {
                return TreePoint$.MODULE$.org$apache$spark$mllib$tree$impl$TreePoint$$labeledPointToTreePoint(x, this.bins$1, this.featureArity$1, this.isUnordered$1);
            }
            {
                this.bins$1 = bins$1;
                this.featureArity$1 = featureArity$1;
                this.isUnordered$1 = isUnordered$1;
            }
        }, ClassTag$.MODULE$.apply(TreePoint.class));
    }

    public TreePoint org$apache$spark$mllib$tree$impl$TreePoint$$labeledPointToTreePoint(LabeledPoint labeledPoint, Bin[][] bins, int[] featureArity, boolean[] isUnordered) {
        int numFeatures = labeledPoint.features().size();
        int[] arr = new int[numFeatures];
        for (int featureIndex = 0; featureIndex < numFeatures; ++featureIndex) {
            arr[featureIndex] = this.findBin(featureIndex, labeledPoint, featureArity[featureIndex], isUnordered[featureIndex], bins);
        }
        return new TreePoint(labeledPoint.label(), arr);
    }

    private int findBin(int featureIndex, LabeledPoint labeledPoint, int featureArity, boolean isUnorderedFeature, Bin[][] bins) {
        int n;
        if (featureArity == 0) {
            int binIndex = this.binarySearchForBins$1(featureIndex, labeledPoint, bins);
            if (binIndex == -1) {
                throw new RuntimeException(new StringBuilder().append((Object)"No bin was found for continuous feature. This error can occur when given invalid data values (such as NaN).").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Feature index: ", ".  Feature value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureIndex), BoxesRunTime.boxToDouble((double)labeledPoint.features().apply(featureIndex))}))).toString());
            }
            n = binIndex;
        } else {
            double featureValue = labeledPoint.features().apply(featureIndex);
            if (featureValue < 0.0 || featureValue >= (double)featureArity) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree given invalid data:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Feature ", " is categorical with values in"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureIndex)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" {0,...,", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(featureArity - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but a data point gives it value ", ".\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)featureValue)}))).append((Object)"  Bad data point: ").append((Object)labeledPoint.toString()).toString());
            }
            n = (int)featureValue;
        }
        return n;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final int binarySearchForBins$1(int featureIndex$1, LabeledPoint labeledPoint$1, Bin[][] bins$2) {
        Bin[] binForFeatures = bins$2[featureIndex$1];
        double feature = labeledPoint$1.features().apply(featureIndex$1);
        int left = 0;
        int right = binForFeatures.length - 1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            Bin bin = binForFeatures[mid];
            double lowThreshold = bin.lowSplit().threshold();
            double highThreshold = bin.highSplit().threshold();
            if (lowThreshold < feature && highThreshold >= feature) {
                return mid;
            }
            if (lowThreshold >= feature) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return -1;
    }

    private TreePoint$() {
        MODULE$ = this;
    }
}

