/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.model;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.rdd.RDD;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003R3dSNLwN\u001c+sK\u0016lu\u000eZ3m\u0015\t\u0019A!A\u0003n_\u0012,GN\u0003\u0002\u0006\r\u0005!AO]3f\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011\u0011cF\u0005\u00031I\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\bi>\u0004hj\u001c3f+\u0005a\u0002CA\u000f\u001f\u001b\u0005\u0011\u0011BA\u0010\u0003\u0005\u0011qu\u000eZ3\t\u0011\u0005\u0002!\u0011!Q\u0001\nq\t\u0001\u0002^8q\u001d>$W\r\t\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005!\u0011\r\\4p+\u0005)\u0003C\u0001\u0014;\u001d\t9sG\u0004\u0002)k9\u0011\u0011\u0006\u000e\b\u0003UMr!a\u000b\u001a\u000f\u00051\ndBA\u00171\u001b\u0005q#BA\u0018\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005Y\"\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u00029s\u0005!\u0011\t\\4p\u0015\t1D!\u0003\u0002<y\t!\u0011\t\\4p\u0015\tA\u0014\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003&\u0003\u0015\tGnZ8!\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q\u0019!i\u0011#\u0011\u0005u\u0001\u0001\"\u0002\u000e@\u0001\u0004a\u0002\"B\u0012@\u0001\u0004)\u0003\"\u0002$\u0001\t\u00039\u0015a\u00029sK\u0012L7\r\u001e\u000b\u0003\u0011.\u0003\"!E%\n\u0005)\u0013\"A\u0002#pk\ndW\rC\u0003M\u000b\u0002\u0007Q*\u0001\u0005gK\u0006$XO]3t!\tq\u0015+D\u0001P\u0015\t\u0001f!\u0001\u0004mS:\fGnZ\u0005\u0003%>\u0013aAV3di>\u0014\b\"\u0002$\u0001\t\u0003!FCA+\\!\r1\u0016\fS\u0007\u0002/*\u0011\u0001\fC\u0001\u0004e\u0012$\u0017B\u0001.X\u0005\r\u0011F\t\u0012\u0005\u0006\u0019N\u0003\r\u0001\u0018\t\u0004-fk\u0005\"\u0002$\u0001\t\u0003qFCA0h!\r\u0001W\rS\u0007\u0002C*\u0011!mY\u0001\u0005U\u00064\u0018M\u0003\u0002e\u0011\u0005\u0019\u0011\r]5\n\u0005\u0019\f'a\u0002&bm\u0006\u0014F\t\u0012\u0005\u0006\u0019v\u0003\r\u0001\u001b\t\u0004A\u0016l\u0005\"\u00026\u0001\t\u0003Y\u0017\u0001\u00038v[:{G-Z:\u0016\u00031\u0004\"!E7\n\u00059\u0014\"aA%oi\")\u0001\u000f\u0001C\u0001W\u0006)A-\u001a9uQ\")!\u000f\u0001C!g\u0006AAo\\*ue&tw\rF\u0001u!\t)\bP\u0004\u0002\u0012m&\u0011qOE\u0001\u0007!J,G-\u001a4\n\u0005eT(AB*ue&twM\u0003\u0002x%!)A\u0010\u0001C\u0001{\u0006iAo\u001c#fEV<7\u000b\u001e:j]\u001e,\u0012\u0001\u001e\u0015\u0003\u0001}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bA\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011BA\u0002\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public class DecisionTreeModel
implements Serializable {
    private final Node topNode;
    private final Enumeration.Value algo;

    public Node topNode() {
        return this.topNode;
    }

    public Enumeration.Value algo() {
        return this.algo;
    }

    public double predict(Vector features) {
        return this.topNode().predict(features);
    }

    public RDD<Object> predict(RDD<Vector> features) {
        return features.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeModel $outer;

            public final double apply(Vector x) {
                return this.$outer.predict(x);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Object> predict(JavaRDD<Vector> features) {
        return JavaRDD$.MODULE$.fromRDD(this.predict((RDD<Vector>)features.rdd()), ClassTag$.MODULE$.Double());
    }

    public int numNodes() {
        return 1 + this.topNode().numDescendants();
    }

    public int depth() {
        return this.topNode().subtreeDepth();
    }

    public String toString() {
        block4: {
            String string;
            block3: {
                Enumeration.Value value;
                block2: {
                    value = this.algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Classification();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeModel classifier of depth ", " with ", " nodes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.depth()), BoxesRunTime.boxToInteger((int)this.numNodes())}));
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Regression();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeModel regressor of depth ", " with ", " nodes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.depth()), BoxesRunTime.boxToInteger((int)this.numNodes())}));
            }
            return string;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeModel given unknown algo parameter: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.algo()})));
    }

    public String toDebugString() {
        String header = new StringBuilder().append((Object)this.toString()).append((Object)"\n").toString();
        return new StringBuilder().append((Object)header).append((Object)this.topNode().subtreeToString(2)).toString();
    }

    public DecisionTreeModel(Node topNode, Enumeration.Value algo) {
        this.topNode = topNode;
        this.algo = algo;
    }
}

