/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.HasFeaturesCol$class;
import org.apache.spark.ml.param.HasLabelCol$class;
import org.apache.spark.ml.param.HasMaxIter$class;
import org.apache.spark.ml.param.HasPredictionCol$class;
import org.apache.spark.ml.param.HasRegParam$class;
import org.apache.spark.ml.param.HasScoreCol$class;
import org.apache.spark.ml.param.HasThreshold$class;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params$;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SchemaRDD;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.types.StructType;
import org.apache.spark.sql.package$;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001b\t\u0011Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u000191\u0002cA\b\u0011%5\tA!\u0003\u0002\u0012\t\tIQi\u001d;j[\u0006$xN\u001d\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u0011\u0005M9\u0012B\u0001\r\u0003\u0005aaunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8QCJ\fWn\u001d\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"a\u0005\u0001\t\u000by\u0001A\u0011A\u0010\u0002\u0017M,GOU3h!\u0006\u0014\u0018-\u001c\u000b\u0003A\u0005j\u0011\u0001\u0001\u0005\u0006Eu\u0001\raI\u0001\u0006m\u0006dW/\u001a\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\t>,(\r\\3\t\u000b)\u0002A\u0011A\u0016\u0002\u0015M,G/T1y\u0013R,'\u000f\u0006\u0002!Y!)!%\u000ba\u0001[A\u0011AEL\u0005\u0003_\u0015\u00121!\u00138u\u0011\u0015\t\u0004\u0001\"\u00013\u0003-\u0019X\r\u001e'bE\u0016d7i\u001c7\u0015\u0005\u0001\u001a\u0004\"\u0002\u00121\u0001\u0004!\u0004CA\u001b9\u001d\t!c'\u0003\u00028K\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t9T\u0005C\u0003=\u0001\u0011\u0005Q(\u0001\u0007tKR$\u0006N]3tQ>dG\r\u0006\u0002!}!)!e\u000fa\u0001G!)\u0001\t\u0001C\u0001\u0003\u0006q1/\u001a;GK\u0006$XO]3t\u0007>dGC\u0001\u0011C\u0011\u0015\u0011s\b1\u00015\u0011\u0015!\u0005\u0001\"\u0001F\u0003-\u0019X\r^*d_J,7i\u001c7\u0015\u0005\u00012\u0005\"\u0002\u0012D\u0001\u0004!\u0004\"\u0002%\u0001\t\u0003I\u0015\u0001E:fiB\u0013X\rZ5di&|gnQ8m)\t\u0001#\nC\u0003#\u000f\u0002\u0007A\u0007C\u0003M\u0001\u0011\u0005S*A\u0002gSR$2A\u0005(W\u0011\u0015y5\n1\u0001Q\u0003\u001d!\u0017\r^1tKR\u0004\"!\u0015+\u000e\u0003IS!a\u0015\u0004\u0002\u0007M\fH.\u0003\u0002V%\nI1k\u00195f[\u0006\u0014F\t\u0012\u0005\u0006/.\u0003\r\u0001W\u0001\ta\u0006\u0014\u0018-\\'baB\u0011\u0011\fX\u0007\u00025*\u00111\fB\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003;j\u0013\u0001\u0002U1sC6l\u0015\r\u001d\u0005\u0007?\u0002!\t\u0005\u00021\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$2!Y:v!\t\u0011\u0007O\u0004\u0002d]:\u0011A-\u001c\b\u0003K2t!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%d\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u00111KB\u0005\u0003_J\u000bq\u0001]1dW\u0006<W-\u0003\u0002re\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u000b\u0005=\u0014\u0006\"\u0002;_\u0001\u0004\t\u0017AB:dQ\u0016l\u0017\rC\u0003X=\u0002\u0007\u0001\f")
public class LogisticRegression
extends Estimator<LogisticRegressionModel>
implements LogisticRegressionParams {
    private final Param<String> predictionCol;
    private final Param<String> scoreCol;
    private final Param<String> featuresCol;
    private final DoubleParam threshold;
    private final Param<String> labelCol;
    private final IntParam maxIter;
    private final DoubleParam regParam;

    @Override
    public StructType validateAndTransformSchema(StructType schema, ParamMap paramMap, boolean fitting) {
        return LogisticRegressionParams$class.validateAndTransformSchema(this, schema, paramMap, fitting);
    }

    @Override
    public Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public Param<String> scoreCol() {
        return this.scoreCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasScoreCol$_setter_$scoreCol_$eq(Param x$1) {
        this.scoreCol = x$1;
    }

    @Override
    public String getScoreCol() {
        return HasScoreCol$class.getScoreCol(this);
    }

    @Override
    public Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public double getThreshold() {
        return HasThreshold$class.getThreshold(this);
    }

    @Override
    public Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public void org$apache$spark$ml$param$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public void org$apache$spark$ml$param$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setLabelCol(String value) {
        return (LogisticRegression)this.set(this.labelCol(), value);
    }

    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFeaturesCol(String value) {
        return (LogisticRegression)this.set(this.featuresCol(), value);
    }

    public LogisticRegression setScoreCol(String value) {
        return (LogisticRegression)this.set(this.scoreCol(), value);
    }

    public LogisticRegression setPredictionCol(String value) {
        return (LogisticRegression)this.set(this.predictionCol(), value);
    }

    @Override
    public LogisticRegressionModel fit(SchemaRDD dataset, ParamMap paramMap) {
        this.transformSchema(dataset.schema(), paramMap, true);
        ParamMap map = this.paramMap().$plus$plus(paramMap);
        RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{dataset.sqlContext().DslString(map.apply(this.labelCol())).attr(), dataset.sqlContext().DslString(map.apply(this.featuresCol())).attr()})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(Row x0$1) {
                Row row = x0$1;
                Some some = package$.MODULE$.Row().unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object features = ((SeqLike)some.get()).apply(1);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (features instanceof Vector) {
                            Vector vector = (Vector)features;
                            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
                            return labeledPoint;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        LogisticRegressionWithLBFGS lr = new LogisticRegressionWithLBFGS();
        lr.optimizer().setRegParam(BoxesRunTime.unboxToDouble((Object)map.apply(this.regParam()))).setNumIterations(BoxesRunTime.unboxToInt((Object)map.apply(this.maxIter())));
        LogisticRegressionModel lrm = new LogisticRegressionModel(this, map, ((org.apache.spark.mllib.classification.LogisticRegressionModel)lr.run((RDD<LabeledPoint>)instances)).weights());
        instances.unpersist(instances.unpersist$default$1());
        Params$.MODULE$.inheritValues(map, this, lrm);
        return lrm;
    }

    @Override
    public StructType transformSchema(StructType schema, ParamMap paramMap) {
        return this.validateAndTransformSchema(schema, paramMap, true);
    }

    public LogisticRegression() {
        HasRegParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasLabelCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        HasScoreCol$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        this.setRegParam(0.1);
        this.setMaxIter(100);
        this.setThreshold(0.5);
    }
}

