/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.VectorTransformer;
import org.apache.spark.mllib.feature.VectorTransformer$class;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u001b\t\u00192\u000b^1oI\u0006\u0014HmU2bY\u0016\u0014Xj\u001c3fY*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0012-\u0016\u001cGo\u001c:Ue\u0006t7OZ8s[\u0016\u0014\b\u0002C\r\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u0011]LG\u000f['fC:,\u0012a\u0007\t\u0003\u001fqI!!\b\t\u0003\u000f\t{w\u000e\\3b]\"Aq\u0004\u0001B\u0001B\u0003%1$A\u0005xSRDW*Z1oA!A\u0011\u0005\u0001BC\u0002\u0013\u0005!$A\u0004xSRD7\u000b\u001e3\t\u0011\r\u0002!\u0011!Q\u0001\nm\t\u0001b^5uQN#H\r\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005!Q.Z1o+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0005\u0003\u0019a\u0017N\\1mO&\u0011A&\u000b\u0002\u0007-\u0016\u001cGo\u001c:\t\u00119\u0002!\u0011!Q\u0001\n\u001d\nQ!\\3b]\u0002B\u0001\u0002\r\u0001\u0003\u0006\u0004%\tAJ\u0001\tm\u0006\u0014\u0018.\u00198dK\"A!\u0007\u0001B\u0001B\u0003%q%A\u0005wCJL\u0017M\\2fA!1A\u0007\u0001C\u0001\tU\na\u0001P5oSRtD#\u0002\u001c8qeR\u0004CA\u000b\u0001\u0011\u0015I2\u00071\u0001\u001c\u0011\u0015\t3\u00071\u0001\u001c\u0011\u0015)3\u00071\u0001(\u0011\u0015\u00014\u00071\u0001(\u0011!a\u0004\u0001#b\u0001\n\u0013i\u0014A\u00024bGR|'/F\u0001?!\ryq(Q\u0005\u0003\u0001B\u0011Q!\u0011:sCf\u0004\"a\u0004\"\n\u0005\r\u0003\"A\u0002#pk\ndW\r\u0003\u0005F\u0001!\u0005\t\u0015)\u0003?\u0003\u001d1\u0017m\u0019;pe\u0002B\u0001b\u0012\u0001\t\u0006\u0004%I!P\u0001\u0006g\"Lg\r\u001e\u0005\t\u0013\u0002A\t\u0011)Q\u0005}\u000511\u000f[5gi\u0002BQa\u0013\u0001\u0005B1\u000b\u0011\u0002\u001e:b]N4wN]7\u0015\u0005\u001dj\u0005\"\u0002(K\u0001\u00049\u0013A\u0002<fGR|'\u000f\u000b\u0002\u0001!B\u0011\u0011\u000bV\u0007\u0002%*\u00111KB\u0001\u000bC:tw\u000e^1uS>t\u0017BA+S\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public class StandardScalerModel
implements VectorTransformer {
    private final boolean withMean;
    private final boolean withStd;
    private final Vector mean;
    private final Vector variance;
    private double[] factor;
    private double[] shift;
    private volatile byte bitmap$0;

    /*
     * WARNING - void declaration
     */
    private double[] factor$lzycompute() {
        StandardScalerModel standardScalerModel = this;
        synchronized (standardScalerModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                double[] f = (double[])Array$.MODULE$.ofDim(this.variance().size(), ClassTag$.MODULE$.Double());
                for (int i = 0; i < Predef$.MODULE$.doubleArrayOps(f).size(); ++i) {
                    f[i] = this.variance().apply(i) != 0.0 ? 1.0 / package$.MODULE$.sqrt(this.variance().apply(i)) : 0.0;
                }
                this.factor = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.factor;
        }
    }

    private double[] shift$lzycompute() {
        StandardScalerModel standardScalerModel = this;
        synchronized (standardScalerModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.shift = this.mean().toArray();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.shift;
        }
    }

    @Override
    public RDD<Vector> transform(RDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    @Override
    public JavaRDD<Vector> transform(JavaRDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    public boolean withMean() {
        return this.withMean;
    }

    public boolean withStd() {
        return this.withStd;
    }

    public Vector mean() {
        return this.mean;
    }

    public Vector variance() {
        return this.variance;
    }

    private double[] factor() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.factor$lzycompute() : this.factor;
    }

    private double[] shift() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.shift$lzycompute() : this.shift;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Vector transform(Vector vector) {
        Vector vector2;
        Predef$.MODULE$.require(this.mean().size() == vector.size());
        if (this.withMean()) {
            Vector vector3;
            double[] localShift = this.shift();
            Vector vector4 = vector;
            if (!(vector4 instanceof DenseVector)) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector4.getClass()).toString());
            DenseVector denseVector = (DenseVector)vector4;
            double[] values = (double[])denseVector.values().clone();
            int size = Predef$.MODULE$.doubleArrayOps(values).size();
            if (this.withStd()) {
                double[] localFactor = this.factor();
                for (int i = 0; i < size; ++i) {
                    values[i] = (values[i] - localShift[i]) * localFactor[i];
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    int n = i;
                    values[n] = values[n] - localShift[i];
                }
            }
            vector2 = vector3 = Vectors$.MODULE$.dense(values);
            return vector2;
        }
        if (this.withStd()) {
            Vector vector5;
            double[] localFactor = this.factor();
            Vector vector6 = vector;
            if (vector6 instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)vector6;
                double[] values = (double[])denseVector.values().clone();
                int size = Predef$.MODULE$.doubleArrayOps(values).size();
                for (int i = 0; i < size; ++i) {
                    int n = i;
                    values[n] = values[n] * localFactor[i];
                }
                vector5 = Vectors$.MODULE$.dense(values);
            } else {
                if (!(vector6 instanceof SparseVector)) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector6.getClass()).toString());
                SparseVector sparseVector = (SparseVector)vector6;
                int[] indices = sparseVector.indices();
                double[] values = (double[])sparseVector.values().clone();
                int nnz = Predef$.MODULE$.doubleArrayOps(values).size();
                for (int i = 0; i < nnz; ++i) {
                    int n = i;
                    values[n] = values[n] * localFactor[indices[i]];
                }
                vector5 = Vectors$.MODULE$.sparse(sparseVector.size(), indices, values);
            }
            vector2 = vector5;
            return vector2;
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public StandardScalerModel(boolean withMean, boolean withStd, Vector mean2, Vector variance2) {
        this.withMean = withMean;
        this.withStd = withStd;
        this.mean = mean2;
        this.variance = variance2;
        VectorTransformer$class.$init$(this);
        Predef$.MODULE$.require(mean2.size() == variance2.size());
    }
}

