/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.F2jBLAS;
import org.apache.spark.Logging;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BLAS$
implements Serializable,
Logging {
    public static final BLAS$ MODULE$;
    private transient BLAS _f2jBLAS;
    private transient BLAS _nativeBLAS;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new BLAS$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private BLAS _f2jBLAS() {
        return this._f2jBLAS;
    }

    private void _f2jBLAS_$eq(BLAS x$1) {
        this._f2jBLAS = x$1;
    }

    private BLAS _nativeBLAS() {
        return this._nativeBLAS;
    }

    private void _nativeBLAS_$eq(BLAS x$1) {
        this._nativeBLAS = x$1;
    }

    private BLAS f2jBLAS() {
        if (this._f2jBLAS() == null) {
            this._f2jBLAS_$eq((BLAS)new F2jBLAS());
        }
        return this._f2jBLAS();
    }

    public void axpy(double a, Vector x, Vector y) {
        block2: {
            block5: {
                block4: {
                    Vector vector;
                    DenseVector denseVector;
                    block3: {
                        Predef$.MODULE$.require(x.size() == y.size());
                        Vector vector2 = y;
                        if (!(vector2 instanceof DenseVector)) break block2;
                        denseVector = (DenseVector)vector2;
                        vector = x;
                        if (!(vector instanceof SparseVector)) break block3;
                        SparseVector sparseVector = (SparseVector)vector;
                        this.axpy(a, sparseVector, denseVector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!(vector instanceof DenseVector)) break block5;
                    DenseVector denseVector2 = (DenseVector)vector;
                    this.axpy(a, denseVector2, denseVector);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"axpy doesn't support x type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass()})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"axpy only supports adding to a dense vector but got type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{y.getClass()})));
    }

    private void axpy(double a, DenseVector x, DenseVector y) {
        int n = x.size();
        this.f2jBLAS().daxpy(n, a, x.values(), 1, y.values(), 1);
    }

    private void axpy(double a, SparseVector x, DenseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int nnz = Predef$.MODULE$.intArrayOps(xIndices).size();
        if (a == 1.0) {
            for (int k = 0; k < nnz; ++k) {
                int n = xIndices[k];
                yValues[n] = yValues[n] + xValues[k];
            }
        } else {
            for (int k = 0; k < nnz; ++k) {
                int n = xIndices[k];
                yValues[n] = yValues[n] + a * xValues[k];
            }
        }
    }

    public double dot(Vector x, Vector y) {
        block6: {
            double d;
            block3: {
                Tuple2 tuple2;
                block5: {
                    block4: {
                        block2: {
                            Predef$.MODULE$.require(x.size() == y.size(), (Function0)new Serializable(x, y){
                                public static final long serialVersionUID = 0L;
                                private final Vector x$1;
                                private final Vector y$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"BLAS.dot(x: Vector, y:Vector) was given Vectors with non-matching sizes: x.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.x$1.size())).append((Object)", y.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.y$1.size())).toString();
                                }
                                {
                                    this.x$1 = x$1;
                                    this.y$1 = y$1;
                                }
                            });
                            tuple2 = new Tuple2((Object)x, (Object)y);
                            if (tuple2 == null) break block2;
                            Vector dx = (Vector)tuple2._1();
                            Vector dy = (Vector)tuple2._2();
                            if (!(dx instanceof DenseVector)) break block2;
                            DenseVector denseVector = (DenseVector)dx;
                            if (!(dy instanceof DenseVector)) break block2;
                            DenseVector denseVector2 = (DenseVector)dy;
                            d = this.dot(denseVector, denseVector2);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Vector sx = (Vector)tuple2._1();
                        Vector dy = (Vector)tuple2._2();
                        if (!(sx instanceof SparseVector)) break block4;
                        SparseVector sparseVector = (SparseVector)sx;
                        if (!(dy instanceof DenseVector)) break block4;
                        DenseVector denseVector = (DenseVector)dy;
                        d = this.dot(sparseVector, denseVector);
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    Vector dx = (Vector)tuple2._1();
                    Vector sy = (Vector)tuple2._2();
                    if (!(dx instanceof DenseVector)) break block5;
                    DenseVector denseVector = (DenseVector)dx;
                    if (!(sy instanceof SparseVector)) break block5;
                    SparseVector sparseVector = (SparseVector)sy;
                    d = this.dot(sparseVector, denseVector);
                    break block3;
                }
                if (tuple2 == null) break block6;
                Vector sx = (Vector)tuple2._1();
                Vector sy = (Vector)tuple2._2();
                if (!(sx instanceof SparseVector)) break block6;
                SparseVector sparseVector = (SparseVector)sx;
                if (!(sy instanceof SparseVector)) break block6;
                SparseVector sparseVector2 = (SparseVector)sy;
                d = this.dot(sparseVector, sparseVector2);
            }
            return d;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dot doesn't support (", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass(), y.getClass()})));
    }

    private double dot(DenseVector x, DenseVector y) {
        int n = x.size();
        return this.f2jBLAS().ddot(n, x.values(), 1, y.values(), 1);
    }

    private double dot(SparseVector x, DenseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int nnz = Predef$.MODULE$.intArrayOps(xIndices).size();
        double sum = 0.0;
        for (int k = 0; k < nnz; ++k) {
            sum += xValues[k] * yValues[xIndices[k]];
        }
        return sum;
    }

    private double dot(SparseVector x, SparseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int[] yIndices = y.indices();
        int nnzx = Predef$.MODULE$.intArrayOps(xIndices).size();
        int nnzy = Predef$.MODULE$.intArrayOps(yIndices).size();
        int ky = 0;
        double sum = 0.0;
        for (int kx = 0; kx < nnzx && ky < nnzy; ++kx) {
            int ix = xIndices[kx];
            while (ky < nnzy && yIndices[ky] < ix) {
                ++ky;
            }
            if (ky >= nnzy || yIndices[ky] != ix) continue;
            sum += xValues[kx] * yValues[ky];
            ++ky;
        }
        return sum;
    }

    public void copy(Vector x, Vector y) {
        block5: {
            Vector vector;
            block8: {
                block7: {
                    DenseVector denseVector;
                    int n;
                    block6: {
                        n = y.size();
                        Predef$.MODULE$.require(x.size() == n);
                        Vector vector2 = y;
                        if (!(vector2 instanceof DenseVector)) break block5;
                        denseVector = (DenseVector)vector2;
                        vector = x;
                        if (!(vector instanceof SparseVector)) break block6;
                        SparseVector sparseVector = (SparseVector)vector;
                        int[] sxIndices = sparseVector.indices();
                        double[] sxValues = sparseVector.values();
                        double[] dyValues = denseVector.values();
                        int nnz = Predef$.MODULE$.intArrayOps(sxIndices).size();
                        int i = 0;
                        for (int k = 0; k < nnz; ++k) {
                            int j = sxIndices[k];
                            while (i < j) {
                                dyValues[i] = 0.0;
                                ++i;
                            }
                            dyValues[i] = sxValues[k];
                            ++i;
                        }
                        while (i < n) {
                            dyValues[i] = 0.0;
                            ++i;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    if (!(vector instanceof DenseVector)) break block8;
                    DenseVector denseVector2 = (DenseVector)vector;
                    Array$.MODULE$.copy((Object)denseVector2.values(), 0, (Object)denseVector.values(), 0, n);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new MatchError((Object)vector);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y must be dense in copy but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{y.getClass()})));
    }

    public void scal(double a, Vector x) {
        block4: {
            block3: {
                Vector vector;
                block2: {
                    vector = x;
                    if (!(vector instanceof SparseVector)) break block2;
                    SparseVector sparseVector = (SparseVector)vector;
                    this.f2jBLAS().dscal(Predef$.MODULE$.doubleArrayOps(sparseVector.values()).size(), a, sparseVector.values(), 1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(vector instanceof DenseVector)) break block4;
                DenseVector denseVector = (DenseVector)vector;
                this.f2jBLAS().dscal(Predef$.MODULE$.doubleArrayOps(denseVector.values()).size(), a, denseVector.values(), 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scal doesn't support vector type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass()})));
    }

    private BLAS nativeBLAS() {
        if (this._nativeBLAS() == null) {
            this._nativeBLAS_$eq(BLAS.getInstance());
        }
        return this._nativeBLAS();
    }

    public void gemm(boolean transA, boolean transB, double alpha, Matrix A, DenseMatrix B, double beta, DenseMatrix C) {
        block5: {
            block3: {
                Matrix matrix;
                block4: {
                    block2: {
                        if (alpha != 0.0) break block2;
                        this.logDebug((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "gemm: alpha is equal to 0. Returning C.";
                            }
                        });
                        break block3;
                    }
                    matrix = A;
                    if (!(matrix instanceof SparseMatrix)) break block4;
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    this.gemm(transA, transB, alpha, sparseMatrix, B, beta, C);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(matrix instanceof DenseMatrix)) break block5;
                DenseMatrix denseMatrix = (DenseMatrix)matrix;
                this.gemm(transA, transB, alpha, denseMatrix, B, beta, C);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gemm doesn't support matrix type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A.getClass()})));
    }

    public void gemm(double alpha, Matrix A, DenseMatrix B, double beta, DenseMatrix C) {
        this.gemm(false, false, alpha, A, B, beta, C);
    }

    private void gemm(boolean transA, boolean transB, double alpha, DenseMatrix A, DenseMatrix B, double beta, DenseMatrix C) {
        int mA = transA ? A.numCols() : A.numRows();
        int nB = transB ? B.numRows() : B.numCols();
        int kA = transA ? A.numRows() : A.numCols();
        int kB = transB ? B.numCols() : B.numRows();
        String tAstr = transA ? "T" : "N";
        String tBstr = transB ? "T" : "N";
        Predef$.MODULE$.require(kA == kB, (Function0)new Serializable(kA, kB){
            public static final long serialVersionUID = 0L;
            private final int kA$1;
            private final int kB$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of A don't match the rows of B. A: ", ", B: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kA$1), BoxesRunTime.boxToInteger((int)this.kB$1)}));
            }
            {
                this.kA$1 = kA$1;
                this.kB$1 = kB$1;
            }
        });
        Predef$.MODULE$.require(mA == C.numRows(), (Function0)new Serializable(C, mA){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix C$2;
            private final int mA$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The rows of C don't match the rows of A. C: ", ", A: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.C$2.numRows()), BoxesRunTime.boxToInteger((int)this.mA$1)}));
            }
            {
                this.C$2 = C$2;
                this.mA$1 = mA$1;
            }
        });
        Predef$.MODULE$.require(nB == C.numCols(), (Function0)new Serializable(C, nB){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix C$2;
            private final int nB$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of C don't match the columns of B. C: ", ", A: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.C$2.numCols()), BoxesRunTime.boxToInteger((int)this.nB$1)}));
            }
            {
                this.C$2 = C$2;
                this.nB$1 = nB$1;
            }
        });
        this.nativeBLAS().dgemm(tAstr, tBstr, mA, nB, kA, alpha, A.values(), A.numRows(), B.values(), B.numRows(), beta, C.values(), C.numRows());
    }

    private void gemm(boolean transA, boolean transB, double alpha, SparseMatrix A, DenseMatrix B, double beta, DenseMatrix C) {
        int[] Acols;
        int mA = transA ? A.numCols() : A.numRows();
        int nB = transB ? B.numRows() : B.numCols();
        int kA = transA ? A.numRows() : A.numCols();
        int kB = transB ? B.numCols() : B.numRows();
        Predef$.MODULE$.require(kA == kB, (Function0)new Serializable(kA, kB){
            public static final long serialVersionUID = 0L;
            private final int kA$2;
            private final int kB$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of A don't match the rows of B. A: ", ", B: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kA$2), BoxesRunTime.boxToInteger((int)this.kB$2)}));
            }
            {
                this.kA$2 = kA$2;
                this.kB$2 = kB$2;
            }
        });
        Predef$.MODULE$.require(mA == C.numRows(), (Function0)new Serializable(C, mA){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix C$1;
            private final int mA$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The rows of C don't match the rows of A. C: ", ", A: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.C$1.numRows()), BoxesRunTime.boxToInteger((int)this.mA$2)}));
            }
            {
                this.C$1 = C$1;
                this.mA$2 = mA$2;
            }
        });
        Predef$.MODULE$.require(nB == C.numCols(), (Function0)new Serializable(C, nB){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix C$1;
            private final int nB$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of C don't match the columns of B. C: ", ", A: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.C$1.numCols()), BoxesRunTime.boxToInteger((int)this.nB$2)}));
            }
            {
                this.C$1 = C$1;
                this.nB$2 = nB$2;
            }
        });
        double[] Avals = A.values();
        double[] Bvals = B.values();
        double[] Cvals = C.values();
        int[] Arows = transA ? A.colPtrs() : A.rowIndices();
        int[] nArray = Acols = transA ? A.rowIndices() : A.colPtrs();
        if (transA) {
            int colCounterForB;
            if (transB) {
                for (colCounterForB = 0; colCounterForB < nB; ++colCounterForB) {
                    int Cstart = colCounterForB * mA;
                    for (int rowCounter = 0; rowCounter < mA; ++rowCounter) {
                        int indEnd = Arows[rowCounter + 1];
                        double sum = 0.0;
                        for (int i = Arows[rowCounter]; i < indEnd; ++i) {
                            sum += Avals[i] * B.apply(colCounterForB, Acols[i]);
                        }
                        int Cindex = Cstart + rowCounter;
                        Cvals[Cindex] = beta * Cvals[Cindex] + sum * alpha;
                    }
                }
            } else {
                while (colCounterForB < nB) {
                    int Cstart = colCounterForB * mA;
                    int Bstart = colCounterForB * kA;
                    for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                        int indEnd = Arows[rowCounterForA + 1];
                        double sum = 0.0;
                        for (int i = Arows[rowCounterForA]; i < indEnd; ++i) {
                            sum += Avals[i] * Bvals[Bstart + Acols[i]];
                        }
                        int Cindex = Cstart + rowCounterForA;
                        Cvals[Cindex] = beta * Cvals[Cindex] + sum * alpha;
                    }
                    ++colCounterForB;
                }
            }
        } else {
            int colCounterForB;
            if (beta != 0.0) {
                this.f2jBLAS().dscal(C.values().length, beta, C.values(), 1);
            }
            if (transB) {
                for (colCounterForB = 0; colCounterForB < nB; ++colCounterForB) {
                    int Cstart = colCounterForB * mA;
                    for (int colCounterForA = 0; colCounterForA < kA; ++colCounterForA) {
                        int indEnd = Acols[colCounterForA + 1];
                        double Bval = B.apply(colCounterForB, colCounterForA) * alpha;
                        for (int i = Acols[colCounterForA]; i < indEnd; ++i) {
                            int n = Cstart + Arows[i];
                            Cvals[n] = Cvals[n] + Avals[i] * Bval;
                        }
                    }
                }
            } else {
                while (colCounterForB < nB) {
                    int Bstart = colCounterForB * kB;
                    int Cstart = colCounterForB * mA;
                    for (int colCounterForA = 0; colCounterForA < kA; ++colCounterForA) {
                        int indEnd = Acols[colCounterForA + 1];
                        double Bval = Bvals[Bstart + colCounterForA] * alpha;
                        for (int i = Acols[colCounterForA]; i < indEnd; ++i) {
                            int n = Cstart + Arows[i];
                            Cvals[n] = Cvals[n] + Avals[i] * Bval;
                        }
                    }
                    ++colCounterForB;
                }
            }
        }
    }

    public void gemv(boolean trans, double alpha, Matrix A, DenseVector x, double beta, DenseVector y) {
        block5: {
            block3: {
                Matrix matrix;
                block4: {
                    block2: {
                        int mA = trans ? A.numCols() : A.numRows();
                        int nx = x.size();
                        int nA = trans ? A.numRows() : A.numCols();
                        Predef$.MODULE$.require(nA == nx, (Function0)new Serializable(nx, nA){
                            public static final long serialVersionUID = 0L;
                            private final int nx$1;
                            private final int nA$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of A don't match the number of elements of x. A: ", ", x: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.nA$1), BoxesRunTime.boxToInteger((int)this.nx$1)}));
                            }
                            {
                                this.nx$1 = nx$1;
                                this.nA$1 = nA$1;
                            }
                        });
                        Predef$.MODULE$.require(mA == y.size(), (Function0)new Serializable(y, mA){
                            public static final long serialVersionUID = 0L;
                            private final DenseVector y$2;
                            private final int mA$3;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The rows of A don't match the number of elements of y. A: ", ", y:", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mA$3), BoxesRunTime.boxToInteger((int)this.y$2.size())}));
                            }
                            {
                                this.y$2 = y$2;
                                this.mA$3 = mA$3;
                            }
                        });
                        if (alpha != 0.0) break block2;
                        this.logDebug((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "gemv: alpha is equal to 0. Returning y.";
                            }
                        });
                        break block3;
                    }
                    matrix = A;
                    if (!(matrix instanceof SparseMatrix)) break block4;
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    this.gemv(trans, alpha, sparseMatrix, x, beta, y);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(matrix instanceof DenseMatrix)) break block5;
                DenseMatrix denseMatrix = (DenseMatrix)matrix;
                this.gemv(trans, alpha, denseMatrix, x, beta, y);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gemv doesn't support matrix type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A.getClass()})));
    }

    public void gemv(double alpha, Matrix A, DenseVector x, double beta, DenseVector y) {
        this.gemv(false, alpha, A, x, beta, y);
    }

    private void gemv(boolean trans, double alpha, DenseMatrix A, DenseVector x, double beta, DenseVector y) {
        String tStrA = trans ? "T" : "N";
        this.nativeBLAS().dgemv(tStrA, A.numRows(), A.numCols(), alpha, A.values(), A.numRows(), x.values(), 1, beta, y.values(), 1);
    }

    private void gemv(boolean trans, double alpha, SparseMatrix A, DenseVector x, double beta, DenseVector y) {
        int[] Acols;
        double[] xValues = x.values();
        double[] yValues = y.values();
        int mA = trans ? A.numCols() : A.numRows();
        int nA = trans ? A.numRows() : A.numCols();
        double[] Avals = A.values();
        int[] Arows = trans ? A.colPtrs() : A.rowIndices();
        int[] nArray = Acols = trans ? A.rowIndices() : A.colPtrs();
        if (trans) {
            for (int rowCounter = 0; rowCounter < mA; ++rowCounter) {
                int indEnd = Arows[rowCounter + 1];
                double sum = 0.0;
                for (int i = Arows[rowCounter]; i < indEnd; ++i) {
                    sum += Avals[i] * xValues[Acols[i]];
                }
                yValues[rowCounter] = beta * yValues[rowCounter] + sum * alpha;
            }
        } else {
            if (beta != 0.0) {
                this.scal(beta, y);
            }
            for (int colCounterForA = 0; colCounterForA < nA; ++colCounterForA) {
                int indEnd = Acols[colCounterForA + 1];
                double xVal = xValues[colCounterForA] * alpha;
                for (int i = Acols[colCounterForA]; i < indEnd; ++i) {
                    int rowIndex = Arows[i];
                    yValues[rowIndex] = yValues[rowIndex] + Avals[i] * xVal;
                }
            }
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BLAS$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

