/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.CSCMatrix;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;

public final class Matrices$ {
    public static final Matrices$ MODULE$;

    static {
        new Matrices$();
    }

    public Matrix dense(int numRows2, int numCols, double[] values) {
        return new DenseMatrix(numRows2, numCols, values);
    }

    public Matrix sparse(int numRows2, int numCols, int[] colPtrs, int[] rowIndices, double[] values) {
        return new SparseMatrix(numRows2, numCols, colPtrs, rowIndices, values);
    }

    public Matrix fromBreeze(breeze.linalg.Matrix<Object> breeze) {
        block4: {
            Matrix matrix;
            block3: {
                breeze.linalg.Matrix<Object> matrix2;
                block2: {
                    matrix2 = breeze;
                    if (!(matrix2 instanceof breeze.linalg.DenseMatrix)) break block2;
                    breeze.linalg.DenseMatrix denseMatrix = (breeze.linalg.DenseMatrix)matrix2;
                    Predef$.MODULE$.require(denseMatrix.majorStride() == denseMatrix.rows(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Do not support stride size different from the number of rows.";
                        }
                    });
                    matrix = new DenseMatrix(denseMatrix.rows(), denseMatrix.cols(), denseMatrix.data$mcD$sp());
                    break block3;
                }
                if (!(matrix2 instanceof CSCMatrix)) break block4;
                CSCMatrix cSCMatrix = (CSCMatrix)matrix2;
                matrix = new SparseMatrix(cSCMatrix.rows(), cSCMatrix.cols(), cSCMatrix.colPtrs(), cSCMatrix.rowIndices(), cSCMatrix.data$mcD$sp());
            }
            return matrix;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support conversion from type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{breeze.getClass().getName()})));
    }

    public Matrix zeros(int numRows2, int numCols) {
        return new DenseMatrix(numRows2, numCols, new double[numRows2 * numCols]);
    }

    public Matrix ones(int numRows2, int numCols) {
        return new DenseMatrix(numRows2, numCols, (double[])Array$.MODULE$.fill(numRows2 * numCols, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0;
            }
        }, ClassTag$.MODULE$.Double()));
    }

    /*
     * WARNING - void declaration
     */
    public Matrix eye(int n) {
        void var2_2;
        Matrix identity = this.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            identity.update(i, i, 1.0);
        }
        return var2_2;
    }

    public Matrix rand(int numRows2, int numCols, Random rng) {
        return new DenseMatrix(numRows2, numCols, (double[])Array$.MODULE$.fill(numRows2 * numCols, (Function0)new Serializable(rng){
            public static final long serialVersionUID = 0L;
            private final Random rng$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.rng$1.nextDouble();
            }
            {
                this.rng$1 = rng$1;
            }
        }, ClassTag$.MODULE$.Double()));
    }

    public Matrix randn(int numRows2, int numCols, Random rng) {
        return new DenseMatrix(numRows2, numCols, (double[])Array$.MODULE$.fill(numRows2 * numCols, (Function0)new Serializable(rng){
            public static final long serialVersionUID = 0L;
            private final Random rng$2;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.rng$2.nextGaussian();
            }
            {
                this.rng$2 = rng$2;
            }
        }, ClassTag$.MODULE$.Double()));
    }

    /*
     * WARNING - void declaration
     */
    public Matrix diag(Vector vector) {
        void var3_3;
        int n = vector.size();
        Matrix matrix = this.eye(n);
        double[] values = vector.toArray();
        for (int i = 0; i < n; ++i) {
            matrix.update(i, i, values[i]);
        }
        return var3_3;
    }

    private Matrices$() {
        MODULE$ = this;
    }
}

