/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.Gradient;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001b\t\u0001Bj\\4jgRL7m\u0012:bI&,g\u000e\u001e\u0006\u0003\u0007\u0011\tAb\u001c9uS6L'0\u0019;j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\t\u000fJ\fG-[3oi\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003\u001f\u0001AQa\u0006\u0001\u0005Ba\tqaY8naV$X\r\u0006\u0003\u001aQ)b\u0003\u0003\u0002\u000e\u001e?\u0015j\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\"\u0011A\u00027j]\u0006dw-\u0003\u0002%C\t1a+Z2u_J\u0004\"A\u0007\u0014\n\u0005\u001dZ\"A\u0002#pk\ndW\rC\u0003*-\u0001\u0007q$\u0001\u0003eCR\f\u0007\"B\u0016\u0017\u0001\u0004)\u0013!\u00027bE\u0016d\u0007\"B\u0017\u0017\u0001\u0004y\u0012aB<fS\u001eDGo\u001d\u0005\u0006/\u0001!\te\f\u000b\u0006KA\n$g\r\u0005\u0006S9\u0002\ra\b\u0005\u0006W9\u0002\r!\n\u0005\u0006[9\u0002\ra\b\u0005\u0006i9\u0002\raH\u0001\fGVlwI]1eS\u0016tG\u000f\u000b\u0002\u0001mA\u0011qGO\u0007\u0002q)\u0011\u0011HB\u0001\u000bC:tw\u000e^1uS>t\u0017BA\u001e9\u00051!UM^3m_B,'/\u00119j\u0001")
public class LogisticGradient
extends Gradient {
    @Override
    public Tuple2<Vector, Object> compute(Vector data, double label, Vector weights) {
        double margin = -1.0 * BLAS$.MODULE$.dot(data, weights);
        double gradientMultiplier = 1.0 / (1.0 + package$.MODULE$.exp(margin)) - label;
        Vector gradient = data.copy();
        BLAS$.MODULE$.scal(gradientMultiplier, gradient);
        double loss = label > 0.0 ? package$.MODULE$.log1p(package$.MODULE$.exp(margin)) : package$.MODULE$.log1p(package$.MODULE$.exp(margin)) - margin;
        return new Tuple2((Object)gradient, (Object)BoxesRunTime.boxToDouble((double)loss));
    }

    @Override
    public double compute(Vector data, double label, Vector weights, Vector cumGradient) {
        double margin = -1.0 * BLAS$.MODULE$.dot(data, weights);
        double gradientMultiplier = 1.0 / (1.0 + package$.MODULE$.exp(margin)) - label;
        BLAS$.MODULE$.axpy(gradientMultiplier, data, cumGradient);
        return label > 0.0 ? package$.MODULE$.log1p(package$.MODULE$.exp(margin)) : package$.MODULE$.log1p(package$.MODULE$.exp(margin)) - margin;
    }
}

